/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import java.util.Arrays;
import java.util.Set;
import java.util.function.IntConsumer;
import org.bidib.jbidibc.messages.enums.IoBehaviourInputEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.InputPortStatus;
import org.bidib.wizard.mvc.main.model.listener.InputPortModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputPortTableModel
extends SimpleHierarchicalPortTableModel<InputPortStatus, InputPort, InputPortModelListener> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(InputPortTableModel.class);
    public static final int COLUMN_IO_BEHAVIOUR = 1;
    public static final int COLUMN_PORT_IDENTIFIER = 2;
    public static final int COLUMN_STATUS = 3;
    public static final int COLUMN_PORT_INSTANCE = 4;

    public int getColumnPortInstance() {
        return 4;
    }

    protected void initialize() {
        this.columnNames = new String[]{Resources.getString(((Object)((Object)this)).getClass(), (String)"label"), Resources.getString(((Object)((Object)this)).getClass(), (String)"ioBehaviour"), Resources.getString(((Object)((Object)this)).getClass(), (String)"portIdentifier"), Resources.getString(((Object)((Object)this)).getClass(), (String)"status"), null};
    }

    public void addRow(InputPort port) {
        if (port != null) {
            Object[] rowData = new Object[this.columnNames.length];
            rowData[0] = port.getLabel();
            rowData[1] = port.getInputBehaviour();
            rowData[2] = port.getPortIdentifier();
            rowData[3] = port.getStatus();
            rowData[4] = port;
            this.addRow(rowData);
        }
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return IoBehaviourInputEnum.class;
            }
        }
        return Object.class;
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                column = 4;
                break;
            }
        }
        return super.getValueAt(row, column);
    }

    public void setValueAt(Object value, int row, int column) {
        Object o = this.getValueAt(row, 4);
        if (o instanceof InputPort) {
            InputPort port = (InputPort)o;
            switch (column) {
                case 0: {
                    port.setLabel((String)value);
                    super.setValueAt((Object)port.toString(), row, column);
                    this.fireLabelChanged((Port)port, port.getLabel());
                    break;
                }
                case 1: {
                    IoBehaviourInputEnum ioBehaviour = (IoBehaviourInputEnum)value;
                    if (ioBehaviour != port.getInputBehaviour()) {
                        port.setInputBehaviour(ioBehaviour);
                        super.setValueAt(value, row, column);
                        this.fireConfigValuesChanged(port, PortConfigKeys.BIDIB_PCFG_INPUT_CTRL);
                        break;
                    }
                    LOGGER.debug("The IOBehaviour has not been changed.");
                    break;
                }
                case 3: {
                    LOGGER.debug("Status of input port is updated: {}, port: {}", value, (Object)port);
                    if (value instanceof InputPortStatus) {
                        super.setValueAt(value, row, column);
                        break;
                    }
                    LOGGER.warn("Set an invalid value: {}", value);
                    super.setValueAt(value, row, column);
                    break;
                }
                default: {
                    super.setValueAt(value, row, column);
                    break;
                }
            }
        } else {
            super.setValueAt(value, row, column);
        }
    }

    public void notifyPortStatusChanged(InputPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 4))) continue;
            super.setValueAt((Object)port.getStatus(), row, 3);
            break;
        }
    }

    public void notifyPortConfigChanged(InputPort port) {
        LOGGER.info("The port config was changed for port: {}", (Object)port.getDebugString());
        this.notifyPortStatusChanged(port);
    }

    public void notifyPortLabelChanged(InputPort port) {
        LOGGER.info("The port label was changed for port: {}", (Object)port);
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 4))) continue;
            super.setValueAt((Object)port.toString(), row, 0);
            break;
        }
    }

    public void refreshRow(InputPort port, IntConsumer rowConsumer) {
        int row = this.findRow(port);
        rowConsumer.accept(row);
    }

    private int findRow(InputPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            InputPort current = (InputPort)this.getValueAt(row, 4);
            if (!port.equals((Object)current)) continue;
            return row;
        }
        return -1;
    }

    public void updatePortConfig(InputPort port) {
        LOGGER.info("The config of the port has changed: {}", (Object)port.getDebugString());
        PortConfigKeys[] keys = PortConfigKeys.valueOf((Set)port.getKnownPortConfigKeys());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("prepared keys: {}", Arrays.asList(keys));
        }
        this.fireConfigValuesChanged(port, keys);
        int row = this.findRow(port);
        if (row > -1) {
            this.setValueAt(port.getLabel(), row, 0);
        }
    }

    private void fireConfigValuesChanged(InputPort servoPort, PortConfigKeys ... portConfigKeys) {
        ((InputPortModelListener)this.portListener).configChanged((Port)servoPort, portConfigKeys);
    }

    public void changePortType(LcOutputType portType, Port<? extends BidibStatus> port) {
        ((InputPortModelListener)this.portListener).changePortType(portType, port);
    }

    protected InputPort getRow(int rowIndex) {
        InputPort port = (InputPort)this.getValueAt(rowIndex, 4);
        return port;
    }
}

