/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.component;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.AccessoryExecutionState;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.BoosterNodeInterface;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.script.ScriptCommand;
import org.bidib.wizard.api.script.ScriptEngineListener;
import org.bidib.wizard.api.script.ScriptStatus;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.AccessoryListUtils;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.script.DefaultScriptContext;
import org.bidib.wizard.common.script.booster.BoosterScripting;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.node.NodeScripting;
import org.bidib.wizard.common.script.node.types.CvType;
import org.bidib.wizard.common.script.node.types.FeatureType;
import org.bidib.wizard.common.script.node.types.ScriptingTargetType;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.common.script.switching.AccessoryScripting;
import org.bidib.wizard.common.script.switching.NodeTreeScripting;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.common.script.switching.SwitchFunctionsScriptCommandFactory;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SoundPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.model.status.SoundPortStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.loco.view.ScriptPanel;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkSwitchNodeOperationsDialog
extends EscapeDialog
implements PortScripting,
AccessoryScripting,
NodeTreeScripting,
NodeScripting,
BoosterScripting,
ScriptEngineListener<Scripting> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkSwitchNodeOperationsDialog.class);
    private static final String ENCODED_COLUMN_SPECS = "60dlu, 3dlu, 60dlu, 3dlu, 0dlu:grow";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private static final String WORKING_DIR_BULK_SWITCHING_KEY = "bulkSwitching";
    private static final String SCRIPT_EXTENSION = "bidibt";
    private final FileFilter scriptFilter;
    private ValueModel selectedScriptModel = new ValueHolder();
    private ValueModel currentCommandModel = new ValueHolder();
    private JButton startScript;
    private JButton stopScript;
    private JLabel executionStateIconLabel;
    private ImageIcon executionPendingIcon;
    private ImageIcon executionRunningIcon;
    private ImageIcon executionFinishedIcon;
    private ImageIcon executionErrorIcon;
    private ValueModel checkRepeatingModel = new ValueHolder();
    private AtomicBoolean scriptRepeating = new AtomicBoolean(false);
    private final NodeInterface node;
    private ScriptEngine<Scripting> scriptEngine;
    private final SwitchingNodeService switchingNodeService;
    private final BoosterService boosterService;
    private final NodeService nodeService;
    private final DefaultScriptContext scriptContext;
    private final ConsoleService consoleService;

    public BulkSwitchNodeOperationsDialog(final DockingDesktop desktop, final NodeInterface node, NodeService nodeService, SwitchingNodeService switchingNodeService, BoosterService boosterService, final SettingsService settingsService, ConsoleService consoleService) {
        super(JOptionPane.getFrameForComponent((Component)desktop), Resources.getString(BulkSwitchNodeOperationsDialog.class, (String)"title"), true);
        this.node = node;
        this.nodeService = nodeService;
        this.switchingNodeService = switchingNodeService;
        this.boosterService = boosterService;
        this.consoleService = consoleService;
        String scriptDescription = Resources.getString(ScriptPanel.class, (String)"scriptDescription");
        this.scriptFilter = new FileNameExtensionFilter(scriptDescription, SCRIPT_EXTENSION);
        this.scriptContext = new DefaultScriptContext();
        this.executionPendingIcon = ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, (String)"/icons/accessory-wait.png");
        this.executionRunningIcon = ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, (String)"/icons/accessory-wait.png");
        this.executionFinishedIcon = ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, (String)"/icons/accessory-successful.png");
        this.executionErrorIcon = ImageUtils.createImageIcon(BulkSwitchNodeOperationsDialog.class, (String)"/icons/accessory-error.png");
        boolean debugDialog = false;
        Object panel = debugDialog ? new FormDebugPanel() : new JPanel();
        FormBuilder formBuilder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        JButton btnSelectScript = new JButton(Resources.getString(ScriptPanel.class, (String)"selectScript"));
        btnSelectScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final WizardSettingsInterface wizardSettings = settingsService.getWizardSettings();
                String storedWorkingDirectory = wizardSettings.getWorkingDirectory(BulkSwitchNodeOperationsDialog.WORKING_DIR_BULK_SWITCHING_KEY);
                FileDialog dialog = new FileDialog((Component)((Object)BulkSwitchNodeOperationsDialog.this), 0, storedWorkingDirectory, "*.bidibt", new FileFilter[]{BulkSwitchNodeOperationsDialog.this.scriptFilter}){

                    public void approve(String fileName) {
                        LOGGER.info("Load script: {}", (Object)fileName);
                        try {
                            File file = new File(fileName);
                            if (file.exists()) {
                                LOGGER.info("The script file exists: {}", (Object)file);
                                BulkSwitchNodeOperationsDialog.this.selectedScriptModel.setValue((Object)file.getName());
                                BulkSwitchNodeOperationsDialog.this.prepareScript(fileName);
                                BulkSwitchNodeOperationsDialog.this.startScript.setEnabled(true);
                            } else {
                                BulkSwitchNodeOperationsDialog.this.selectedScriptModel.setValue((Object)"no script selected");
                                BulkSwitchNodeOperationsDialog.this.startScript.setEnabled(false);
                            }
                            String workingDir = Paths.get(fileName, new String[0]).getParent().toString();
                            LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                            wizardSettings.setWorkingDirectory(BulkSwitchNodeOperationsDialog.WORKING_DIR_BULK_SWITCHING_KEY, workingDir);
                        }
                        catch (IOException | IllegalArgumentException ex) {
                            LOGGER.info("Load and process script file failed.", (Throwable)ex);
                            BulkSwitchNodeOperationsDialog.this.startScript.setEnabled(false);
                            TaskDialogs.build((Window)JOptionPane.getFrameForComponent((Component)desktop), (String)Resources.getString(BulkSwitchNodeOperationsDialog.class, (String)"load-script-failed.instruction", (Object[])new Object[]{ex.getMessage()}), (String)Resources.getString(BulkSwitchNodeOperationsDialog.class, (String)"load-script-failed.text")).error();
                        }
                    }
                };
                dialog.showDialog();
            }
        });
        formBuilder.add((Component)btnSelectScript).xy(1, 1);
        JLabel scriptLabel = WizardComponentFactory.createLabel((ValueModel)this.selectedScriptModel);
        formBuilder.add((Component)scriptLabel).xyw(3, 1, 3);
        JCheckBox repeatingCheck = WizardComponentFactory.createCheckBox((ValueModel)this.checkRepeatingModel, (String)Resources.getString(ScriptPanel.class, (String)"repeating"));
        formBuilder.add((Component)repeatingCheck).xyw(1, 3, 3);
        this.startScript = new JButton(Resources.getString(ScriptPanel.class, (String)"startScript"));
        this.startScript.setEnabled(false);
        this.startScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BulkSwitchNodeOperationsDialog.this.scriptContext.unregister("scriptErrors");
                BulkSwitchNodeOperationsDialog.this.executionStateIconLabel.setIcon(BulkSwitchNodeOperationsDialog.this.executionPendingIcon);
                BulkSwitchNodeOperationsDialog.this.scriptEngine.startScript();
            }
        });
        formBuilder.add((Component)this.startScript).xy(1, 5);
        this.stopScript = new JButton(Resources.getString(ScriptPanel.class, (String)"stopScript"));
        this.stopScript.setEnabled(false);
        this.stopScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BulkSwitchNodeOperationsDialog.this.stopScript();
            }
        });
        formBuilder.add((Component)this.stopScript).xy(3, 5);
        this.executionStateIconLabel = new JLabel();
        formBuilder.add((Component)this.executionStateIconLabel).xy(5, 5);
        JLabel currentCommandLabel = WizardComponentFactory.createLabel((ValueModel)this.currentCommandModel);
        formBuilder.add((Component)currentCommandLabel).xyw(1, 7, 5);
        this.checkRepeatingModel.addValueChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.info("Repeating has changed: {}", BulkSwitchNodeOperationsDialog.this.checkRepeatingModel.getValue());
                Boolean repeating = (Boolean)BulkSwitchNodeOperationsDialog.this.checkRepeatingModel.getValue();
                BulkSwitchNodeOperationsDialog.this.scriptRepeating.set(repeating);
                BulkSwitchNodeOperationsDialog.this.scriptEngine.setScriptRepeating(repeating.booleanValue());
            }
        });
        JPanel mainPanel = formBuilder.border((Border)Paddings.DIALOG).build();
        JButton cancelButton = new JButton(Resources.getString(BulkSwitchNodeOperationsDialog.class, (String)"cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BulkSwitchNodeOperationsDialog.this.setVisible(false);
                BulkSwitchNodeOperationsDialog.this.fireCancel(node);
            }
        });
        JPanel buttonBar = new ButtonBarBuilder().addButton((JComponent)cancelButton).build();
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.add((Component)buttonBar, "East");
        southPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)southPanel, "South");
        this.getContentPane().setPreferredSize(new Dimension(400, 300));
        this.scriptEngine = new ScriptEngine((Scripting)this, (ApplicationContext)this.scriptContext);
        this.scriptEngine.addScriptEngineListener((ScriptEngineListener)this);
    }

    public void showDialog() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setMinimumSize(this.getSize());
        this.setVisible(true);
    }

    private void fireCancel(NodeInterface node) {
        LOGGER.info("Stop the script on press cancel button.");
        this.stopScript();
    }

    private void stopScript() {
        LOGGER.info("Stop the script.");
        this.scriptEngine.stopScript();
    }

    public void scriptStatusChanged(ScriptStatus scriptStatus) {
        SwingUtilities.invokeLater(() -> {
            switch (scriptStatus) {
                case RUNNING: {
                    this.startScript.setEnabled(false);
                    this.stopScript.setEnabled(true);
                    this.executionStateIconLabel.setIcon(this.executionRunningIcon);
                    break;
                }
                case STOPPED: 
                case FINISHED: {
                    this.startScript.setEnabled(true);
                    this.stopScript.setEnabled(false);
                    this.executionStateIconLabel.setIcon(this.executionFinishedIcon);
                    break;
                }
                case FINISHED_WITH_ERRORS: 
                case ABORTED: {
                    this.startScript.setEnabled(true);
                    this.stopScript.setEnabled(false);
                    this.executionStateIconLabel.setIcon(this.executionErrorIcon);
                    break;
                }
            }
            this.currentCommandChanged(null);
        });
    }

    private void prepareScript(String fileName) throws IOException {
        Path fFilePath = Paths.get(fileName, new String[0]);
        SwitchFunctionsScriptCommandFactory factory = new SwitchFunctionsScriptCommandFactory(this.consoleService);
        LinkedList<ScriptCommand<Scripting>> scriptCommands = new LinkedList<ScriptCommand<Scripting>>();
        try (Scanner scanner = new Scanner(fFilePath, StandardCharsets.UTF_8);){
            while (scanner.hasNextLine()) {
                this.processLine(scanner.nextLine().trim(), factory, scriptCommands);
            }
        }
        LOGGER.info("Prepared list of commands: {}", scriptCommands);
        this.scriptEngine.setScriptCommands(scriptCommands);
    }

    private void processLine(String line, SwitchFunctionsScriptCommandFactory factory, List<ScriptCommand<Scripting>> scriptCommands) {
        LOGGER.info("Process line: {}", (Object)line);
        if (line.startsWith("#") || StringUtils.isBlank((CharSequence)line)) {
            LOGGER.info("Skip comment or empty line.");
        } else {
            LOGGER.info("Current line: {}", (Object)line);
            ScriptCommand command = factory.parse(line);
            if (command != null) {
                scriptCommands.add((ScriptCommand<Scripting>)command);
            }
        }
    }

    public void sendPortStatusAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int portNumber, BidibStatus portStatus) {
        SwitchingNodeInterface selectedNode = node != null ? node : this.node.getSwitchingNode();
        SwitchPort port = null;
        switch (lcOutputType) {
            case SWITCHPORT: {
                SwitchPortStatus switchPortStatus = (SwitchPortStatus)portStatus;
                SwitchPort switchPort = new SwitchPort();
                switchPort.setId(portNumber);
                switchPort.setStatus((BidibStatus)switchPortStatus);
                port = switchPort;
                break;
            }
            case SWITCHPAIRPORT: {
                SwitchPortStatus switchPairPortStatus = (SwitchPortStatus)portStatus;
                SwitchPairPort switchPairPort = new SwitchPairPort();
                switchPairPort.setId(portNumber);
                switchPairPort.setStatus((BidibStatus)switchPairPortStatus);
                port = switchPairPort;
                break;
            }
            case SOUNDPORT: {
                SoundPortStatus soundPortStatus = (SoundPortStatus)portStatus;
                SoundPort soundPort = new SoundPort();
                soundPort.setId(portNumber);
                soundPort.setStatus((BidibStatus)soundPortStatus);
                port = soundPort;
                break;
            }
            case LIGHTPORT: {
                LightPortStatus lightPortStatus = (LightPortStatus)portStatus;
                LightPort lightPort = new LightPort();
                lightPort.setId(portNumber);
                lightPort.setStatus((BidibStatus)lightPortStatus);
                port = lightPort;
                break;
            }
            default: {
                LOGGER.warn("Unsupported port type: {}", (Object)lcOutputType);
            }
        }
        if (port != null) {
            this.switchingNodeService.setPortStatus("main", selectedNode, port);
        }
    }

    public void sendPortValueAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int port, int portValue) {
        SwitchingNodeInterface selectedNode = node != null ? node : this.node.getSwitchingNode();
        switch (lcOutputType) {
            case SERVOPORT: {
                ServoPort servoPort = new ServoPort();
                servoPort.setId(port);
                servoPort.setValue(Integer.valueOf(portValue));
                this.switchingNodeService.setPortStatus("main", selectedNode, (Port)servoPort);
                break;
            }
            case MOTORPORT: {
                MotorPort motorPort = new MotorPort();
                motorPort.setId(port);
                motorPort.setValue(Integer.valueOf(portValue));
                this.switchingNodeService.setPortStatus("main", selectedNode, (Port)motorPort);
                break;
            }
        }
    }

    public void currentCommandChanged(final ScriptCommand<Scripting> command) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.currentCommandModel.setValue((Object)(command != null ? command.toString() : null));
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        BulkSwitchNodeOperationsDialog.this.currentCommandModel.setValue(command != null ? command.toString() : null);
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOGGER.warn("Update current command failed.", (Throwable)e);
            }
        }
    }

    public void setActiveAspect(SwitchingNodeInterface node, int accessoryNumber, int aspectNumber) {
        LOGGER.info("Activate the aspect, node: {}, accessoryNumber: {}, aspectNumber: {}", new Object[]{node, accessoryNumber, aspectNumber});
        Accessory accessory = AccessoryListUtils.findAccessoryByAccessoryNumber((Iterable)node.getNode().getAccessories(), (int)accessoryNumber);
        this.switchingNodeService.setAccessoryAspect("main", node, accessory, aspectNumber);
    }

    public AccessoryExecutionState getAccessoryExecutionState(SwitchingNodeInterface node, int accessoryNumber) {
        return null;
    }

    public List<NodeInterface> getNodesByVidAndPid(int vid, int pid) {
        List nodes = this.nodeService.getAllNodes("main");
        return nodes.stream().filter(n -> NodeUtils.isMatchingVidAndPid((long)n.getUniqueId(), (int)vid, (int)pid)).collect(Collectors.toList());
    }

    public void setCv(Long uuid, CvType ... cvTypes) {
    }

    public List<ConfigurationVariable> getCv(Long uniqueId, CvType ... cvTypes) {
        LOGGER.info("Get the CV directly from the node, uniqueId: {}, cvTypes: {}", (Object)uniqueId, (Object)cvTypes);
        return Collections.emptyList();
    }

    public void setFeature(Long uuid, FeatureType ... features) {
    }

    public List<Feature> featuresGetAll(Long uniqueId, boolean discardCache) {
        LOGGER.info("Get all features directly from the node, uniqueId: {}", (Object)uniqueId);
        return Collections.emptyList();
    }

    public void setLabel(Long uuid, TargetType portType) {
    }

    public void setMacro(Long uuid, Macro macro) {
    }

    public void setAccessory(Long uuid, Accessory accessory) {
    }

    public boolean isNodeHasRestartPending(Long uuid) {
        return false;
    }

    public void resetNode(Long uuid) {
    }

    public void reselectNode(Long uuid) {
    }

    public void setPortConfig(Long uniqueId, TargetType targetType, Map<Byte, PortConfigValue<?>> portConfig) {
        LOGGER.info("Set the port scripting, uuid: {}, targetType: {}, portConfig: {}", new Object[]{ByteUtils.formatHexUniqueId((Long)uniqueId), targetType, portConfig});
        NodeInterface node = this.nodeService.getNode("main", uniqueId.longValue());
        int portId = targetType.getPortNum();
        ScriptingTargetType scriptingTargetType = targetType.getScriptingTargetType();
        SwitchPairPort port = null;
        switch (scriptingTargetType) {
            case SWITCHPAIRPORT: {
                port = new SwitchPairPort();
                port.setId(portId);
                break;
            }
        }
        this.switchingNodeService.setPortConfig("main", node.getSwitchingNode(), (Port)port, (LcOutputType)null, portConfig);
    }

    public void assertPortType(Long uuid, TargetType portType) {
    }

    public void setBoosterStatus(BoosterNodeInterface boosterNode, BoosterStatus requestedStatus) {
        LOGGER.info("Set the booster status, node: {}, requestedStatus: {}", (Object)boosterNode, (Object)requestedStatus);
        this.boosterService.setBoosterState("main", boosterNode, requestedStatus);
    }

    public void setCommandStationStatus(CommandStationNodeInterface commandStationNode, CommandStationStatus requestedStatus) {
        LOGGER.info("Set the command station status, node: {}, requestedStatus: {}", (Object)commandStationNode, (Object)requestedStatus);
        this.boosterService.setCommandStationState("main", commandStationNode, requestedStatus);
    }

    public void setIdentifyState(Long uniqueId, IdentifyState identifyState) {
        NodeInterface node = this.nodeService.getNode("main", uniqueId.longValue());
        this.nodeService.identify("main", node, identifyState);
    }

    public IdentifyState queryIdentifyState(Long uniqueId) {
        NodeInterface node = this.nodeService.getNode("main", uniqueId.longValue());
        return node.getIdentifyState();
    }

    public String setString(Long uniqueId, int namespace, int index, String value) {
        return null;
    }

    public String getString(Long uniqueId, int namespace, int index) {
        return null;
    }

    public NodeInterface getNodeByUniqueIdWithoutClassBits(byte[] uniqueId) {
        return null;
    }

    public CommandStationStatus queryCommandStationStatus(CommandStationNodeInterface commandStationNode) {
        return null;
    }

    public String sendNodeDebugString(Long uniqueId, int namespace, int index, String value, int expectedResponseCount) {
        return null;
    }
}

