/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.grid.TableColumnChooser;
import io.reactivex.rxjava3.subjects.Subject;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.BacklightPortValueListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.listener.PortTableLayoutListener;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.editor.NumberRangeEditor;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.client.common.view.renderer.DmxChannelRenderer;
import org.bidib.wizard.client.common.view.renderer.PortAwareNumberRenderer;
import org.bidib.wizard.client.common.view.slider.ConfigXAwareSliderRenderer;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BacklightPortStatus;
import org.bidib.wizard.mvc.common.view.editor.DmxChannelCellEditor;
import org.bidib.wizard.mvc.main.controller.BacklightPortPanelController;
import org.bidib.wizard.mvc.main.model.BacklightPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.BacklightPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.SimpleHierarchicalPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.BacklightPortTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BacklightPortListPanel
extends SimpleHierarchicalPortListPanel<BacklightPortTableModel, BacklightPortStatus, BacklightPort, BacklightPortValueListener, BacklightPortModelListener>
implements TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator,
PortTableLayoutListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklightPortListPanel.class);
    private final MainModel mainModel;
    private final AtomicBoolean isDmxNode = new AtomicBoolean(true);
    private final TabVisibilityListener tabVisibilityListener;

    public BacklightPortListPanel(BacklightPortPanelController controller, BacklightPortTableModel tableModel, MainModel mainModel, TabVisibilityListener tabVisibilityListener, Subject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super(tableModel, Resources.getString(BacklightPortListPanel.class, (String)"emptyTable"), portConfigChangeEventSubject, mainModel);
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
    }

    @Override
    protected AbstractPortHierarchicalTable<BacklightPort> createPortTable(BacklightPortTableModel tableModel, String emptyTableText) {
        return new BacklightPortTable(tableModel, emptyTableText);
    }

    @Override
    protected void createTable(BacklightPortTableModel tableModel, String emptyTableText, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super.createTable(tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);
        PortListMenuListener portListMenuListener = this.createPortListMenuListener(this.table, nodeSelectionProvider, null);
        this.table.setPortListMenuListener(portListMenuListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LOGGER.trace("Component is resized: {}", (Object)e.getComponent());
                BacklightPortListPanel.this.table.repaint();
            }
        });
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof BacklightPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void processListChanged() {
        super.processListChanged();
        this.tabVisibilityListener.setTabVisible(this, this.isTabVisible());
        NodeInterface node = this.mainModel.getSelectedNode();
        this.portTableLayoutChanged(node);
    }

    public void portTableLayoutChanged(NodeInterface node) {
        if (TableColumnChooser.isVisibleColumn((JTable)this.table, (int)3)) {
            LOGGER.info("The DMX column is visible for node: {}", (Object)node);
            if (node != null) {
                boolean newNodeIsDmxNode = ProductUtils.isOneDMX((long)node.getUniqueId());
                if (newNodeIsDmxNode != this.isDmxNode.get()) {
                    LOGGER.info("The DMX support of node has changed, newNodeIsDmxNode: {}", (Object)newNodeIsDmxNode);
                    this.isDmxNode.set(newNodeIsDmxNode);
                    TableColumn tcDmxMapping = this.table.getColumnModel().getColumn(3);
                    if (newNodeIsDmxNode) {
                        tcDmxMapping.setCellRenderer((TableCellRenderer)new DmxChannelRenderer());
                        tcDmxMapping.setCellEditor((TableCellEditor)((Object)new DmxChannelCellEditor(1, 256)));
                        tcDmxMapping.setHeaderValue(Resources.getString(BacklightPortTableModel.class, (String)"dmxMapping"));
                    } else {
                        tcDmxMapping.setCellRenderer((TableCellRenderer)new PortAwareNumberRenderer());
                        tcDmxMapping.setCellEditor((TableCellEditor)new NumberRangeEditor(0, 255));
                        tcDmxMapping.setHeaderValue(Resources.getString(BacklightPortTableModel.class, (String)"channel"));
                    }
                    JTableHeader th = this.table.getTableHeader();
                    th.repaint();
                } else {
                    LOGGER.info("The DMX column is visible but the isDmxNode property has not changed: {}", (Object)this.isDmxNode);
                }
            }
        } else {
            LOGGER.info("The DMX column is not visible.");
        }
        ArrayList<BacklightPort> ports = new ArrayList<BacklightPort>();
        ports.addAll(this.getPorts());
        if (CollectionUtils.isNotEmpty(ports)) {
            try {
                BacklightPort backlightPort = (BacklightPort)ports.get(0);
                if (backlightPort != null) {
                    int dimmStretchMin = backlightPort.getDimStretchMin();
                    int dimmStretchMax = backlightPort.getDimStretchMax();
                    LOGGER.info("Set the values for dimmStretchMin: {}, dimmStretchMax: {}", (Object)dimmStretchMin, (Object)dimmStretchMax);
                    ConfigXAwareSliderRenderer sliderRendererDimmMin = (ConfigXAwareSliderRenderer)this.table.getColumnModel().getColumn(2).getCellRenderer();
                    ConfigXAwareSliderRenderer sliderRendererDimmMax = (ConfigXAwareSliderRenderer)this.table.getColumnModel().getColumn(1).getCellRenderer();
                    sliderRendererDimmMin.setMaxValue(dimmStretchMin);
                    sliderRendererDimmMax.setMaxValue(dimmStretchMax);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Get the dimm stretch values failed.", (Throwable)ex);
            }
        }
    }

    public Class<?> getPortClass() {
        return BacklightPort.class;
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasBacklightPorts();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<BacklightPort> getPorts() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            return node.getBacklightPorts();
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        this.listChanged();
    }
}

