/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.FeedbackAddressData;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.FeedbackPortListener;
import org.bidib.wizard.client.common.dialog.LabelDialog;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.client.common.table.DefaultPortListMenuListener;
import org.bidib.wizard.client.common.table.PortTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.menu.PortListMenu;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.mvc.main.controller.FeedbackPortPanelController;
import org.bidib.wizard.mvc.main.controller.listener.FeedbackPortPanelListener;
import org.bidib.wizard.mvc.main.model.FeedbackPortModel;
import org.bidib.wizard.mvc.main.model.FeedbackPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.SimplePortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.FeedbackPortTableCellRenderer;
import org.bidib.wizard.mvc.main.view.table.FlagEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPortListPanel
extends SimplePortListPanel<FeedbackPortStatus, FeedbackPort, FeedbackPortListener, PortModelListener<FeedbackPort>>
implements TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPortListPanel.class);
    private static final long serialVersionUID = 1L;
    private final FeedbackPortPanelListener controller;
    private final TabVisibilityListener tabVisibilityListener;

    public FeedbackPortListPanel(FeedbackPortPanelController controller, FeedbackPortTableModel tableModel, FeedbackPortModel feedbackPortModel, MainModel model, TabVisibilityListener tabVisibilityListener) {
        super(tableModel, Resources.getString(FeedbackPortListPanel.class, (String)"emptyTable"));
        this.controller = controller;
        this.tabVisibilityListener = tabVisibilityListener;
        LOGGER.debug("Create new FeedbackPortListPanel.");
        this.table.setDefaultCellRenderer((TableCellRenderer)new FeedbackPortTableCellRenderer());
        this.table.setDefaultEditor(FeedbackPort.class, (TableCellEditor)new FlagEditor(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (value instanceof FeedbackPort) {
                    this.textField.setText(value != null ? ((FeedbackPort)value).getLabel() : null);
                    this.textField.setToolTipText(null);
                } else {
                    this.textField.setText(value != null ? value.toString() : null);
                    this.textField.setToolTipText(null);
                }
                return this.textField;
            }
        });
        this.table.setRowHeight(100);
        this.table.setTableHeader(null);
        feedbackPortModel.addPortListListener(this);
    }

    @Override
    protected PortTable createPortTable(SimplePortTableModel<FeedbackPortStatus, FeedbackPort, PortModelListener<FeedbackPort>> tableModel, String emptyTableText) {
        return new PortTable((TableModel)tableModel, emptyTableText){
            private static final long serialVersionUID = 1L;

            public void adjustRowHeight() {
            }

            protected void prepareTableStyleProvider() {
            }

            public void clearTable() {
            }

            protected PortListMenu createMenu() {
                return new FeedbackPortListMenu(this.popupEvent, "No port selected.");
            }

            protected PortListMenuListener createMenuListener() {
                this.setPortMappingVisible(false);
                LOGGER.info("Create the menu listener.");
                return new FeedbackPortListMenuListener(){

                    public void editLabel(MouseEvent popupEvent) {
                        final int row = this.getRow(popupEvent.getPoint());
                        final int column = this.getColumn(popupEvent.getPoint());
                        LOGGER.info("Edit label on row: {}, column: {}", (Object)row, (Object)column);
                        if (row > -1) {
                            Object val = this.getValueAt(row, column);
                            if (val instanceof Port) {
                                val = ((Port)val).getLabel();
                            }
                            new LabelDialog((String)val, popupEvent.getXOnScreen(), popupEvent.getYOnScreen()){

                                public void labelChanged(String label) {
                                    LOGGER.info("Set the new label for row: {}, column: {}, label: {}", new Object[]{row, column, label});
                                    this.setValueAt(label, row, column);
                                }
                            };
                        } else {
                            LOGGER.warn("The row is not available!");
                        }
                    }

                    @Override
                    public void openLocoDialog() {
                        LOGGER.info("Open the loco controller.");
                        int row = this.getRow(popupEvent.getPoint());
                        int column = this.getColumn(popupEvent.getPoint());
                        if (row > -1) {
                            Object val = this.getValueAt(row, column);
                            if (val instanceof FeedbackPort) {
                                FeedbackPort feedbackPort = (FeedbackPort)val;
                                if (CollectionUtils.isNotEmpty((Collection)feedbackPort.getAddresses())) {
                                    FeedbackAddressData addressData = (FeedbackAddressData)feedbackPort.getAddresses().get(0);
                                    FeedbackPortListPanel.this.fireOpenLocoDialog(addressData);
                                } else {
                                    LOGGER.info("No address available.");
                                    FeedbackPortListPanel.this.fireOpenLocoDialog(null);
                                }
                            }
                        } else {
                            LOGGER.warn("The row is not available!");
                        }
                    }

                    @Override
                    public void openPomDialog() {
                        LOGGER.info("Open the POM controller.");
                        int row = this.getRow(popupEvent.getPoint());
                        int column = this.getColumn(popupEvent.getPoint());
                        if (row > -1) {
                            Object val = this.getValueAt(row, column);
                            if (val instanceof FeedbackPort) {
                                FeedbackPort feedbackPort = (FeedbackPort)val;
                                if (CollectionUtils.isNotEmpty((Collection)feedbackPort.getAddresses())) {
                                    FeedbackAddressData addressData = (FeedbackAddressData)feedbackPort.getAddresses().get(0);
                                    FeedbackPortListPanel.this.fireOpenPomDialog(addressData);
                                } else {
                                    LOGGER.info("No address available.");
                                    FeedbackPortListPanel.this.fireOpenPomDialog(null);
                                }
                            }
                        } else {
                            LOGGER.warn("The row is not available!");
                        }
                    }
                };
            }

            protected void showPortListMenu(MouseEvent e, PortListMenu portListMenu, int row, int column) {
                Object value = this.getValueAt(row, column);
                if (row >= 0 && column >= 0 && (value instanceof Port || value instanceof String)) {
                    if (row >= 0 && this.getSelectedRowCount() == 0) {
                        this.setRowSelectionInterval(row, row);
                    }
                    if (value instanceof FeedbackPort) {
                        FeedbackPort feedbackPort = (FeedbackPort)value;
                        if (!feedbackPort.isEnabled()) {
                            portListMenu.setMapPortEnabled(feedbackPort.isRemappingEnabled(), this.isPortMappingVisible());
                        } else {
                            portListMenu.setMapPortEnabled(false, this.isPortMappingVisible());
                        }
                        String label = null;
                        label = StringUtils.isNotBlank((CharSequence)feedbackPort.getLabel()) ? String.format("%1$02d : %2$s", feedbackPort.getId(), feedbackPort.getLabel()) : (feedbackPort.getId() > -1 ? String.format("%1$02d", feedbackPort.getId()) : " ");
                        ((FeedbackPortListMenu)portListMenu).setLabel("Port: " + label);
                    } else {
                        portListMenu.setMapPortEnabled(false, false);
                        ((FeedbackPortListMenu)portListMenu).setLabel("No port selected.");
                    }
                    portListMenu.setInsertPortsEnabled(false, false);
                    portListMenu.setRemovePortEnabled(false, false);
                    portListMenu.setPopupEvent(this.popupEvent);
                    this.grabFocus();
                    portListMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof FeedbackPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void listChanged() {
        LOGGER.info("List has changed, remove all rows and add rows again.");
        this.tableModel.setRowCount(0);
        List<FeedbackPort> ports = this.getPorts();
        ((FeedbackPortTableModel)this.tableModel).addRows(ports);
        this.tabVisibilityListener.setTabVisible(this, this.isTabVisible());
    }

    @Override
    protected List<FeedbackPort> getPorts() {
        NodeInterface node = this.controller.getSelectedNode();
        if (node != null) {
            return node.getFeedbackPorts();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.controller.getSelectedNode();
        if (node != null) {
            int feedbackSize = Feature.getIntFeatureValue((Collection)node.getNode().getFeatures(), (int)FeatureEnum.FEATURE_BM_SIZE.getNumber());
            boolean isTabVisible = feedbackSize > 0;
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    public Class<?> getPortClass() {
        return FeedbackPort.class;
    }

    private void fireOpenLocoDialog(FeedbackAddressData addressData) {
        this.controller.openLocoDialog(addressData);
    }

    private void fireOpenPomDialog(FeedbackAddressData addressData) {
        this.controller.openPomDialog(addressData);
    }

    public void refreshView() {
        this.listChanged();
    }

    private abstract class FeedbackPortListMenuListener
    extends DefaultPortListMenuListener {
        private FeedbackPortListMenuListener() {
        }

        public abstract void openLocoDialog();

        public abstract void openPomDialog();
    }

    private class FeedbackPortListMenu
    extends PortListMenu {
        private static final long serialVersionUID = 1L;
        private JMenuItem openLocoDialog;
        private JMenuItem openPomDialog;

        public FeedbackPortListMenu(MouseEvent popupEvent, String label) {
            super(popupEvent, label);
            this.openLocoDialog = new JMenuItem(Resources.getString(FeedbackPortListMenu.class, (String)"openLocoDialog") + " ...");
            this.openLocoDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeedbackPortListMenu.this.fireOpenLocoDialog();
                }
            });
            this.add(this.openLocoDialog);
            this.openPomDialog = new JMenuItem(Resources.getString(FeedbackPortListMenu.class, (String)"openPomDialog") + " ...");
            this.openPomDialog.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeedbackPortListMenu.this.fireOpenPomDialog();
                }
            });
            this.add(this.openPomDialog);
        }

        private void fireOpenLocoDialog() {
            for (PortListMenuListener l : this.menuListeners) {
                if (!(l instanceof FeedbackPortListMenuListener)) continue;
                ((FeedbackPortListMenuListener)l).openLocoDialog();
            }
        }

        private void fireOpenPomDialog() {
            for (PortListMenuListener l : this.menuListeners) {
                if (!(l instanceof FeedbackPortListMenuListener)) continue;
                ((FeedbackPortListMenuListener)l).openPomDialog();
            }
        }
    }
}

