/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.StyledLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.DecoderVendorFactory;
import org.bidib.jbidibc.core.schema.bidib.products.ProductType;
import org.bidib.jbidibc.core.schema.bidib2.FeatureCode;
import org.bidib.jbidibc.core.schema.bidib2.common.DocumentationType;
import org.bidib.jbidibc.core.schema.decodervendor.VendorType;
import org.bidib.jbidibc.core.utils.ProductsUtils;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ConversionUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.firmware.FirmwareVersion;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.converter.SoftwareVersionConverter;
import org.bidib.wizard.client.common.converter.UniqueIdConverter;
import org.bidib.wizard.client.common.mvc.firmware.controller.FirmwareController;
import org.bidib.wizard.client.common.table.AbstractEmptyTable;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.config.FirmwareControllerFactory;
import org.bidib.wizard.firmwarerepo.core.FirmwareRepoService;
import org.bidib.wizard.mvc.main.model.InfoModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoPanel
implements TabPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoPanel.class);
    private static final String ENCODED_DETAILS_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:10dlu:grow, 3dlu, pref";
    private final MainModel mainModel;
    private final DetailsPanel detailsPanel;
    private final JPanel contentPanel;
    private List<VendorType> vendors;
    private final PropertyChangeListener nodeListener;
    private NodeInterface selectedNode;
    private JLabel imageContainer;
    private List<FeatureCode> featureCodes;
    private final SettingsService settingsService;
    private final LookupService lookupService;
    private final FirmwareControllerFactory firmwareControllerFactory;
    private final FirmwareRepoService firmwareRepoService;

    public InfoPanel(MainModel model, SettingsService settingsService, LookupService lookupService, FirmwareControllerFactory firmwareControllerFactory, FirmwareRepoService firmwareRepoService) {
        this.mainModel = model;
        this.settingsService = settingsService;
        this.lookupService = lookupService;
        this.firmwareControllerFactory = firmwareControllerFactory;
        this.firmwareRepoService = firmwareRepoService;
        this.nodeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                switch (evt.getPropertyName()) {
                    case "features": {
                        LOGGER.info("The features have changed, update the node info.");
                        SwingUtilities.invokeLater(() -> InfoPanel.this.updateNodeInfo(InfoPanel.this.selectedNode));
                        break;
                    }
                    case "userName": {
                        LOGGER.info("The username has changed, update the node info.");
                        SwingUtilities.invokeLater(() -> InfoPanel.this.updateNodeInfo(InfoPanel.this.selectedNode));
                    }
                }
            }
        };
        this.detailsPanel = this.createDetailsPanel();
        this.contentPanel = this.detailsPanel.getContentPanel();
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    private DetailsPanel createDetailsPanel() {
        DetailsPanel detailsPanel = new DetailsPanel(new InfoModel());
        Consumer<SoftwareVersion> firmwareUpdateConsumer = sw -> {
            NodeInterface node = this.selectedNode;
            JFrame frame = (JFrame)JOptionPane.getFrameForComponent(this.getComponent());
            FirmwareVersion newFirmware = node.getUpdateFirmwareVersion();
            LOGGER.info("Show the firmware update dialog for node: {}, newFirmware: {}", (Object)node, (Object)newFirmware);
            FirmwareController firmwareController = this.firmwareControllerFactory.createFirmwareController(this.firmwareRepoService, node, frame);
            firmwareController.start(newFirmware);
        };
        if (CollectionUtils.isEmpty(this.featureCodes)) {
            LOGGER.info("Get the feature codes and the vendors.");
            this.featureCodes = BidibFactory.getFeatureCodes();
            this.vendors = DecoderVendorFactory.getDecoderVendors();
            LOGGER.info("Get the feature codes and the vendors has finished.");
        }
        detailsPanel.preparePanel(firmwareUpdateConsumer);
        return detailsPanel;
    }

    public void nodeChanged() {
        LOGGER.info("The selected node has changed.");
        this.updateComponentState();
    }

    private void updateComponentState() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (this.selectedNode != null && !this.selectedNode.equals((Object)node)) {
            this.selectedNode.getNode().removePropertyChangeListener(this.nodeListener);
        }
        InfoModel infoModel = (InfoModel)((Object)this.detailsPanel.getPresentationModel().getBean());
        if (node != null) {
            infoModel.setFeatures(null);
            this.selectedNode = node;
            this.selectedNode.getNode().addPropertyChangeListener(this.nodeListener);
            this.updateNodeInfo(node);
        } else {
            infoModel.setFeatures(null);
            this.selectedNode = null;
        }
    }

    private void updateNodeInfo(NodeInterface node) {
        String productName;
        if (node == null) {
            this.detailsPanel.getFirmwareUpdateButton().setEnabled(false);
            return;
        }
        Node coreNode = node.getNode();
        LOGGER.info("Update the node info panel for node: {}, coreNode: {}, coreNode identity: {}", new Object[]{node, coreNode, coreNode.getIdentity()});
        long uniqueId = node.getUniqueId();
        int vendorId = NodeUtils.getVendorId((long)node.getUniqueId());
        int productId = NodeUtils.getPid((long)node.getUniqueId(), (int)coreNode.getRelevantPidBits());
        LOGGER.info("Search for vendorId: {} (0x{}), productId: {} (0x{})", new Object[]{vendorId, ByteUtils.intToHex((int)vendorId), productId, ByteUtils.intToHex((int)productId)});
        Optional product = this.lookupService.getProduct(vendorId, productId);
        StringBuilder description = new StringBuilder();
        String url = null;
        if (product.isPresent()) {
            productName = ((ProductType)product.get()).getName();
            String language = XmlLocaleUtils.getXmlLocale();
            DocumentationType doc = ProductsUtils.getDocumentationOfLanguage((ProductType)((ProductType)product.get()), (String)language);
            if (doc != null) {
                if (StringUtils.isNotBlank((CharSequence)doc.getText())) {
                    description.append(doc.getText());
                } else {
                    description.append(productName);
                }
                if (StringUtils.isNotBlank((CharSequence)doc.getDescription())) {
                    description.append(" - ").append(doc.getDescription());
                }
                url = doc.getUrl();
            } else {
                description.append(productName);
            }
        } else {
            LOGGER.info("No products available to get the description for node: {}", (Object)node);
        }
        if (description.length() == 0) {
            description.append(Resources.getString(this.getClass(), (String)"product-unknown"));
        }
        if (StringUtils.isBlank((CharSequence)(productName = coreNode.getStoredString(0)))) {
            productName = "";
        }
        PresentationModel<InfoModel> presentationModel = this.detailsPanel.getPresentationModel();
        InfoModel infoModel = (InfoModel)((Object)presentationModel.getBean());
        infoModel.setDescription(description.toString());
        infoModel.setProductName(productName);
        infoModel.setVendor(DecoderVendorFactory.getDecoderVendorName(this.vendors, (int)vendorId));
        infoModel.setHomepage(url);
        infoModel.setUniqueId(uniqueId);
        infoModel.setUserName(org.bidib.wizard.api.utils.NodeUtils.getNodeName((NodeInterface)node));
        infoModel.setAddress(NodeUtils.formatAddressLong((byte[])coreNode.getAddr()));
        infoModel.setFirmware(coreNode.getSoftwareVersion());
        infoModel.setProtocol(coreNode.getProtocolVersion() != null ? coreNode.getProtocolVersion().toString() : null);
        infoModel.setFeatures(Collections.unmodifiableList(this.getSortedFeatures(node)));
        this.detailsPanel.resortFeaturesTable();
        this.detailsPanel.getFirmwareUpdateButton().setEnabled(node.isUpdatable());
        try {
            LOGGER.debug("Size of container: {}", (Object)this.imageContainer.getSize());
            ImageIcon icon = this.loadImage(vendorId, productId, 200, 200);
            this.imageContainer.setIcon(icon);
        }
        catch (Exception ex) {
            LOGGER.warn("Load image of node failed, vid: {}, pid: {}.", new Object[]{vendorId, productId, ex});
            this.imageContainer.setIcon(null);
        }
    }

    private List<Feature> getSortedFeatures(NodeInterface node) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        features.addAll(node.getNode().getFeatures());
        Collections.sort(features, (o1, o2) -> o1.getType() - o2.getType());
        return features;
    }

    private static String getFeatureUnit(List<FeatureCode> featureCodes, final Feature feature) {
        if (feature != null && feature.getFeatureEnum() != null) {
            String featureUnit;
            switch (feature.getFeatureEnum()) {
                case FEATURE_BST_AMPERE: {
                    return String.format("%d mA", ConversionUtils.convertCurrent((int)feature.getValue()));
                }
            }
            FeatureCode featureCode = (FeatureCode)IterableUtils.find(featureCodes, (Predicate)new Predicate<FeatureCode>(){

                public boolean evaluate(FeatureCode featureCode) {
                    return featureCode.getId() == feature.getType();
                }
            });
            if (featureCode != null && StringUtils.isNotEmpty((CharSequence)(featureUnit = featureCode.getUnit()))) {
                return featureUnit;
            }
        }
        return " ";
    }

    private ImageIcon loadImage(int vendorId, long productId, int width, int height) {
        String labelPath = this.settingsService.getMiscSettings().getBidibConfigDir();
        String searchPathUser = "/data/images";
        File fileUser = new File(labelPath, searchPathUser);
        searchPathUser = fileUser.getPath();
        ImageIcon icon = null;
        File imageFile = new File(fileUser, "bidib-" + vendorId + "-" + productId + ".png");
        if (imageFile.exists()) {
            icon = ImageUtils.loadImageIcon((File)imageFile, (int)width, (int)height);
        }
        if (icon == null) {
            icon = ImageUtils.loadImageIcon(this.getClass(), (String)("/images/bidib-" + vendorId + "-" + productId + ".png"), (int)width, (int)height);
        }
        return icon;
    }

    private class DetailsPanel {
        private PresentationModel<InfoModel> presentationModel;
        private JButton firmwareUpdateButton;
        private JPanel contentPanel;
        private AbstractEmptyTable featuresTable;

        public DetailsPanel(InfoModel infoModel) {
            this.presentationModel = new PresentationModel((Object)infoModel);
        }

        public PresentationModel<InfoModel> getPresentationModel() {
            return this.presentationModel;
        }

        public JButton getFirmwareUpdateButton() {
            return this.firmwareUpdateButton;
        }

        protected JPanel getContentPanel() {
            return this.contentPanel;
        }

        protected void resortFeaturesTable() {
            this.featuresTable.resort();
        }

        public void preparePanel(Consumer<SoftwareVersion> firmwareUpdateConsumer) {
            JPanel contentPanel = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public String getName() {
                    return Resources.getString(InfoPanel.class, (String)"name");
                }
            };
            FormBuilder builder = FormBuilder.create().columns(InfoPanel.ENCODED_DETAILS_COLUMN_SPECS, new Object[0]).rows("pref, 3dlu, pref", new Object[0]).panel(contentPanel);
            builder.border((Border)Paddings.TABBED_DIALOG);
            AbstractValueModel descriptionModel = this.presentationModel.getModel("description");
            builder.add(Resources.getString(InfoPanel.class, (String)"description"), new Object[0]).xy(1, 1);
            JLabel description = WizardComponentFactory.createLabel((ValueModel)descriptionModel);
            builder.add((Component)description).xyw(3, 1, 7);
            AbstractValueModel productNameModel = this.presentationModel.getModel("productName");
            builder.add(Resources.getString(InfoPanel.class, (String)"productname"), new Object[0]).xy(1, 3);
            JLabel productName = WizardComponentFactory.createLabel((ValueModel)productNameModel);
            builder.add((Component)productName).xyw(3, 3, 7);
            builder.appendRows("3dlu, pref", new Object[0]);
            AbstractValueModel vendorModel = this.presentationModel.getModel("vendor");
            builder.add(Resources.getString(InfoPanel.class, (String)"vendor"), new Object[0]).xy(1, 5);
            JLabel vendorInfo = WizardComponentFactory.createLabel((ValueModel)vendorModel);
            builder.add((Component)vendorInfo).xyw(3, 5, 7);
            builder.appendRows("3dlu, pref", new Object[0]);
            AbstractValueModel homepageModel = this.presentationModel.getModel("homepage");
            builder.add(Resources.getString(InfoPanel.class, (String)"homepage"), new Object[0]).xy(1, 7);
            final JideButton homepage = WizardComponentFactory.createHyperlinkButton((ValueModel)homepageModel);
            homepage.setAlwaysShowHyperlink(true);
            homepage.setAction((Action)new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    String homepageText = homepage.getText();
                    if (StringUtils.isNotBlank((CharSequence)homepageText)) {
                        try {
                            URI uri = new URI(homepageText);
                            Desktop.getDesktop().browse(uri);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Open homepage failed: {}", (Object)homepageText, (Object)ex);
                        }
                    }
                }
            });
            builder.add((Component)homepage).xyw(3, 7, 7);
            builder.appendRows("3dlu, pref", new Object[0]);
            AbstractValueModel uniqueIdModel = this.presentationModel.getModel("uniqueId");
            ConverterValueModel uniqueIdRawModel = new ConverterValueModel((ValueModel)uniqueIdModel, (BindingConverter)new UniqueIdConverter(uniqueId -> ByteUtils.convertUniqueIdToString((byte[])ByteUtils.convertLongToUniqueId((Long)uniqueId))));
            ConverterValueModel uniqueIdPrettyModel = new ConverterValueModel((ValueModel)uniqueIdModel, (BindingConverter)new UniqueIdConverter(uniqueId -> ByteUtils.getUniqueIdAsString((Long)uniqueId)));
            builder.add(Resources.getString(InfoPanel.class, (String)"uniqueId"), new Object[0]).xy(1, 9);
            StyledLabel uniqueIdRaw = WizardComponentFactory.createStyledLabel((ValueModel)uniqueIdRawModel, (String)"{%1$s:f:#FF0000}");
            builder.add((Component)uniqueIdRaw).xyw(3, 9, 3);
            UniqueIdPopupMenu uniqueIdRawPopupMenu = new UniqueIdPopupMenu(() -> (InfoModel)((Object)((Object)InfoPanel.this.detailsPanel.getPresentationModel().getBean())), uniqueId -> ByteUtils.convertUniqueIdToString((byte[])ByteUtils.convertLongToUniqueId((Long)uniqueId)));
            PopupListener popupListenerRaw = new PopupListener((JPopupMenu)((Object)uniqueIdRawPopupMenu));
            uniqueIdRaw.addMouseListener((MouseListener)popupListenerRaw);
            Color prettyColor = UIManager.getColor("InfoPanel.uniqueId.formatted.foreground");
            String prettyColorHex = Integer.toString(prettyColor.getRGB(), 16);
            StyledLabel uniqueIdPrettyPrint = WizardComponentFactory.createStyledLabel((ValueModel)uniqueIdPrettyModel, (String)(", {%1$s:f:#" + prettyColorHex + "}"));
            builder.add((Component)uniqueIdPrettyPrint).xy(7, 9);
            UniqueIdPopupMenu uniqueIdPrettyPopupMenu = new UniqueIdPopupMenu(() -> (InfoModel)((Object)((Object)InfoPanel.this.detailsPanel.getPresentationModel().getBean())), uniqueId -> ByteUtils.getUniqueIdAsString((Long)uniqueId));
            PopupListener popupListenerPretty = new PopupListener((JPopupMenu)((Object)uniqueIdPrettyPopupMenu));
            uniqueIdPrettyPrint.addMouseListener((MouseListener)popupListenerPretty);
            builder.appendRows("3dlu, pref", new Object[0]);
            AbstractValueModel userNameModel = this.presentationModel.getModel("userName");
            builder.add(Resources.getString(InfoPanel.class, (String)"username"), new Object[0]).xy(1, 11);
            StyledLabel userName = WizardComponentFactory.createStyledLabel((ValueModel)userNameModel, (String)"{%1$s:f:#00AA55}");
            builder.add((Component)userName).xyw(3, 11, 7);
            builder.appendRows("3dlu, pref", new Object[0]);
            AbstractValueModel addressModel = this.presentationModel.getModel("address");
            builder.add(Resources.getString(InfoPanel.class, (String)"address"), new Object[0]).xy(1, 13);
            JLabel address = WizardComponentFactory.createLabel((ValueModel)addressModel);
            builder.add((Component)address).xyw(3, 13, 7);
            builder.appendRows("3dlu, pref", new Object[0]);
            ConverterValueModel firmwareModel = new ConverterValueModel((ValueModel)this.presentationModel.getModel("firmware"), (BindingConverter)new SoftwareVersionConverter());
            builder.add(Resources.getString(InfoPanel.class, (String)"firmware"), new Object[0]).xy(1, 15);
            JLabel firmware = WizardComponentFactory.createLabel((ValueModel)firmwareModel);
            builder.add((Component)firmware).xy(3, 15);
            this.firmwareUpdateButton = new JButton("Update");
            this.firmwareUpdateButton.setEnabled(false);
            this.firmwareUpdateButton.addActionListener(evt -> firmwareUpdateConsumer.accept(((InfoModel)((Object)((Object)this.presentationModel.getBean()))).getFirmware()));
            builder.add((Component)this.firmwareUpdateButton).xy(5, 15);
            builder.appendRows("3dlu, pref", new Object[0]);
            AbstractValueModel protocolModel = this.presentationModel.getModel("protocol");
            builder.add(Resources.getString(InfoPanel.class, (String)"protocol"), new Object[0]).xy(1, 17);
            JLabel protocol = WizardComponentFactory.createLabel((ValueModel)protocolModel);
            builder.add((Component)protocol).xyw(3, 17, 7);
            InfoPanel.this.imageContainer = new JLabel();
            InfoPanel.this.imageContainer.setPreferredSize(new Dimension(200, 200));
            InfoPanel.this.imageContainer.setMaximumSize(new Dimension(200, 200));
            JPanel imagePanel = new JPanel(new BorderLayout());
            imagePanel.setOpaque(false);
            imagePanel.add((Component)InfoPanel.this.imageContainer, "North");
            builder.add((Component)imagePanel).xywh(11, 1, 1, 15);
            builder.appendRows("3dlu, fill:40dlu:grow", new Object[0]);
            AbstractValueModel featureModel = this.presentationModel.getModel("features");
            SelectionInList featureList = new SelectionInList((List)featureModel.getValue());
            this.featuresTable = WizardComponentFactory.createTable((AbstractTableAdapter)new FeatureTableAdapter((SelectionInList<Feature>)featureList, InfoPanel.this.featureCodes), (String)Resources.getString(InfoPanel.class, (String)"no-features-available"));
            this.featuresTable.getColumnModel().getColumn(0).setPreferredWidth(60);
            this.featuresTable.getColumnModel().getColumn(0).setMaxWidth(80);
            this.featuresTable.getColumnModel().getColumn(1).setPreferredWidth(60);
            this.featuresTable.getColumnModel().getColumn(1).setMaxWidth(80);
            this.featuresTable.getColumnModel().getColumn(2).setPreferredWidth(60);
            this.featuresTable.getColumnModel().getColumn(2).setMaxWidth(80);
            JScrollPane scroll = new JScrollPane();
            scroll.setViewportView((Component)this.featuresTable);
            builder.add((Component)scroll).xyw(1, 19, 11);
            this.contentPanel = builder.build();
        }
    }

    private static class FeatureTableAdapter
    extends AbstractTableAdapter<Feature> {
        private static final long serialVersionUID = 1L;
        private static final String[] COLUMNNAMES = new String[]{Resources.getString(FeatureTableAdapter.class, (String)"id"), Resources.getString(FeatureTableAdapter.class, (String)"value"), Resources.getString(FeatureTableAdapter.class, (String)"unit"), Resources.getString(FeatureTableAdapter.class, (String)"name")};
        private final List<FeatureCode> featureCodes;

        public FeatureTableAdapter(SelectionInList<Feature> featureList, List<FeatureCode> featureCodes) {
            super(featureList, COLUMNNAMES);
            this.featureCodes = featureCodes;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Feature feature = (Feature)this.getRow(rowIndex);
            switch (columnIndex) {
                case 0: {
                    FeatureEnum featureEnum = feature.getFeatureEnum();
                    return featureEnum != null ? featureEnum.getNumber() : feature.getType();
                }
                case 1: {
                    return feature.getValue();
                }
                case 2: {
                    return InfoPanel.getFeatureUnit(this.featureCodes, feature);
                }
                case 3: {
                    return feature.getFeatureName();
                }
            }
            return null;
        }
    }

    private static class PopupListener
    extends MouseAdapter {
        private final JPopupMenu popup;

        public PopupListener(JPopupMenu popup) {
            this.popup = popup;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private static class UniqueIdPopupMenu
    extends BasicPopupMenu {
        private static final long serialVersionUID = 1L;
        private JMenuItem copyToClipboardItem;
        private final Supplier<InfoModel> infoModelSupplier;
        private final Function<Long, String> formatter;

        public UniqueIdPopupMenu(Supplier<InfoModel> infoModelSupplier, Function<Long, String> formatter) {
            this.infoModelSupplier = infoModelSupplier;
            this.formatter = formatter;
            this.copyToClipboardItem = new JMenuItem(Resources.getString(InfoPanel.class, (String)"copy-to-clipboard"));
            this.copyToClipboardItem.addActionListener(e -> {
                InfoModel infoModel = this.infoModelSupplier.get();
                Long uniqueId = infoModel.getUniqueId();
                String uniqueIdRaw = this.formatter.apply(uniqueId);
                StringSelection selection = new StringSelection(uniqueIdRaw);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(selection, selection);
            });
            this.add(this.copyToClipboardItem);
        }
    }

    public static class InfoFormPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public InfoFormPanel() {
            super(new BorderLayout());
        }

        @Override
        public String getName() {
            return Resources.getString(InfoPanel.class, (String)"name");
        }
    }
}

