/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.Trigger;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.grid.DefaultExpandableRow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.model.listener.PortListenerProvider;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.cvdef.AbstractNode;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeHelper;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.client.common.view.cvdef.GBM16TReverserCvNode;
import org.bidib.wizard.client.common.view.cvdef.GBM16TReverserEditor;
import org.bidib.wizard.client.common.view.cvdef.GBM16TReverserPresentationModel;
import org.bidib.wizard.client.common.view.cvdef.GBM16TReverserValueBean;
import org.bidib.wizard.client.common.view.cvdef.KeywordNodeNode;
import org.bidib.wizard.client.common.view.listener.TabStatusListener;
import org.bidib.wizard.model.ports.FeedbackPort;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvDefinitionPanelProvider;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvValueUtils;
import org.bidib.wizard.mvc.main.controller.ReverserPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.CvDefinitionRequestListenerAware;
import org.bidib.wizard.mvc.main.view.panel.PendingChangesAware;
import org.bidib.wizard.mvc.main.view.panel.listener.TabSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverserPanel
implements TabPanelProvider,
TabVisibilityProvider,
CvDefinitionPanelProvider,
CvDefinitionRequestListenerAware,
PortListenerProvider<FeedbackPort>,
PendingChangesAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReverserPanel.class);
    private final ReverserPanelController reverserPanelController;
    private final MainModel mainModel;
    private final TabStatusListener tabStatusListener;
    private NodeInterface selectedNode;
    private JPanel contentPanel;
    private GBM16TReverserEditor gbm16TReverserEditor;
    private JButton saveButton;
    private Map<String, CvNode> cvNumberToNodeMap;
    private Map<String, ConfigurationVariable> configVariables;
    private CvDefinitionTreeTableModel treeModel;
    private final ValueHolder valueModel = new ValueHolder(false);
    private List<CvDefinitionRequestListener> cvDefinitionRequestListeners = new LinkedList<CvDefinitionRequestListener>();

    public ReverserPanel(ReverserPanelController reverserPanelController, FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider, MainModel model, TabStatusListener tabStatusListener) {
        this.reverserPanelController = reverserPanelController;
        this.mainModel = model;
        this.tabStatusListener = tabStatusListener;
        JPanel panel = new JPanel();
        FormBuilder detailFormBuilder = FormBuilder.create().columns("p", new Object[0]).rows("p", new Object[0]).panel(panel);
        detailFormBuilder.border((Border)Paddings.DLU4);
        this.gbm16TReverserEditor = this.createGBM16TReverserEditor(feedbackPortStatusChangeProvider);
        detailFormBuilder.add((Component)this.gbm16TReverserEditor.getComponent()).xy(1, 1);
        JPanel builderPanel = detailFormBuilder.build();
        JScrollPane scrollPane = new JScrollPane(builderPanel);
        this.contentPanel = new ReverserFormPanel(this);
        this.contentPanel.setName(this.getName());
        this.contentPanel.add((Component)scrollPane, "Center");
        PropertyConnector.connect((Object)this.gbm16TReverserEditor.getSaveButtonEnabledModel(), (String)"value", (Object)this.valueModel, (String)"value");
        PropertyConnector.connect((Object)this.valueModel, (String)"value", (Object)this.saveButton, (String)"enabled");
        this.valueModel.addValueChangeListener(evt -> this.setPendingChanges((Boolean)this.valueModel.getValue()));
    }

    @Override
    public JPanel getComponent() {
        return this.contentPanel;
    }

    public String getName() {
        return Resources.getString(this.getClass(), (String)"name");
    }

    public void setPendingChanges(boolean pendingChanges) {
        LOGGER.info("set pending changes flag: {}", (Object)pendingChanges);
        this.tabStatusListener.updatePendingChanges((Component)this.contentPanel, pendingChanges);
    }

    private GBM16TReverserEditor createGBM16TReverserEditor(FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider) {
        GBM16TReverserEditor gbm16TReverserEditor = new GBM16TReverserEditor(feedbackPortStatusChangeProvider, new Trigger(), this.createButtonPanel(), new String[]{"/images/reverser/reverser_DUAL_small.png", "/images/reverser/reverser_DUAL_table_small.png"});
        return gbm16TReverserEditor;
    }

    private JPanel createButtonPanel() {
        this.saveButton = new JButton(Resources.getString(this.getClass(), (String)"editor.save"));
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("save pressed.");
                ReverserPanel.this.saveValues();
            }
        });
        JButton resetButton = new JButton(Resources.getString(this.getClass(), (String)"editor.reset"));
        resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOGGER.info("Reset was pressed.");
                Trigger trigger = ReverserPanel.this.getTrigger();
                if (trigger != null) {
                    trigger.triggerFlush();
                    trigger.triggerFlush();
                }
            }
        });
        JPanel buttonBar = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.saveButton, resetButton}).build();
        return buttonBar;
    }

    private void saveValues() {
        LOGGER.info("Save the values.");
        try {
            Trigger trigger = this.getTrigger();
            if (trigger == null) {
                LOGGER.info("No trigger available. Do not save!");
                return;
            }
            trigger.triggerCommit();
            GBM16TReverserEditor valueEditor = this.gbm16TReverserEditor;
            GBM16TReverserPresentationModel presentationModel = this.gbm16TReverserEditor.getCvAdapter();
            LOGGER.info("Current presentationModel: {}", (Object)presentationModel);
            GBM16TReverserValueBean valueBean = (GBM16TReverserValueBean)presentationModel.getBean();
            LOGGER.info("Current valueBean: {}", (Object)valueBean);
            CvNode cvNode = valueEditor.getCvNode();
            LOGGER.debug("Current selected cvNode: {}", (Object)cvNode);
            if (cvNode != null) {
                valueEditor.updateCvValues(this.cvNumberToNodeMap, this.treeModel);
                DefaultExpandableRow root = (DefaultExpandableRow)this.treeModel.getRoot();
                NodeInterface selectedNode = this.mainModel.getSelectedNode();
                CvValueUtils.writeCvValues(selectedNode, root, this.cvNumberToNodeMap, (CvDefinitionPanelProvider)this);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Commit failed.", (Throwable)ex);
        }
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            int feedbackSize = Feature.getIntFeatureValue((Collection)node.getNode().getFeatures(), (int)FeatureEnum.FEATURE_BM_SIZE.getNumber());
            boolean isTabVisible = ProductUtils.isGBM16TS((long)node.getUniqueId()) && feedbackSize > 0;
            LOGGER.info("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    public void nodeChanged() {
        LOGGER.info("The selected node has changed.");
        this.updateComponentState();
    }

    private void updateComponentState() {
        NodeInterface node = this.mainModel.getSelectedNode();
        this.cvNumberToNodeMap = null;
        this.configVariables = null;
        this.treeModel = null;
        if (this.isTabVisible()) {
            this.updateNodeInfo(node);
        } else {
            this.updateNodeInfo(null);
        }
        this.selectedNode = node;
        if (node != null) {
            CvDefinitionTreeTableModel cvDefinitionTreeTableModel;
            this.treeModel = cvDefinitionTreeTableModel = this.reverserPanelController.getCvDefinitionTreeTableModel(node);
            this.cvNumberToNodeMap = this.reverserPanelController.getCvNumberToNodeMap(node);
            this.configVariables = node.getConfigVariables();
        }
    }

    private void updateNodeInfo(NodeInterface node) {
        if (node == null) {
            LOGGER.info("Clear the value of the gbm16TReverserEditor.");
            this.gbm16TReverserEditor.setValue(null, Collections.emptyMap());
            return;
        }
        LOGGER.info("refresh the feedback ports for node: {}", (Object)node);
        Map<String, CvNode> cvNumberToNodeMap = this.reverserPanelController.getCvNumberToNodeMap(node);
        CvDefinitionTreeTableModel cvDefinitionTreeTableModel = this.reverserPanelController.getCvDefinitionTreeTableModel(node);
        if (cvNumberToNodeMap == null || cvDefinitionTreeTableModel == null) {
            LOGGER.info("No cvNumberToNodeMap or cvDefinitionTreeTableModel available for node: {}", cvNumberToNodeMap);
            this.gbm16TReverserEditor.setValue(null, Collections.emptyMap());
            return;
        }
        LinkedList keywordNodeNodes = new LinkedList();
        CvDefinitionTreeHelper.findNodeByKeyword((DefaultExpandableRow)((DefaultExpandableRow)cvDefinitionTreeTableModel.getRoot()), (String)"Reverser", keywordNodeNodes);
        LOGGER.info("Found reversers in cvDefinitionTreeTableModel: {}", keywordNodeNodes);
        if (keywordNodeNodes.isEmpty()) {
            this.gbm16TReverserEditor.setValue(null, Collections.emptyMap());
            return;
        }
        KeywordNodeNode keywordNodeNode = (KeywordNodeNode)keywordNodeNodes.get(0);
        GBM16TReverserCvNode gbm16tReverserCvNode = null;
        if (keywordNodeNode != null) {
            gbm16tReverserCvNode = (GBM16TReverserCvNode)keywordNodeNode.getMasterNode();
            LOGGER.info("Set the gbm16tReverserCvNode: {}", (Object)gbm16tReverserCvNode);
            LinkedList cvNodes = new LinkedList();
            CvDefinitionTreeHelper.addCvOfSubnode((AbstractNode)keywordNodeNode, cvNodes, cvNumberToNodeMap);
            LOGGER.info("Nodes to update: {}", cvNodes);
            LinkedList<ConfigurationVariable> cvSet = new LinkedList<ConfigurationVariable>();
            for (CvNode cvNode : cvNodes) {
                cvSet.add(cvNode.getConfigVar());
            }
            try {
                this.readCvValues(cvSet);
            }
            catch (RuntimeException ex) {
                LOGGER.warn("Load CV values has failed!", (Throwable)ex);
                JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(ReverserPanel.class, (String)"loadcvfailed.message"), Resources.getString(ReverserPanel.class, (String)"loadcvfailed.title"), 0);
            }
        }
        this.gbm16TReverserEditor.setValue((CvNode)gbm16tReverserCvNode, cvNumberToNodeMap);
    }

    private void readCvValues(List<ConfigurationVariable> configVariables) {
        LOGGER.info("Read the CV values.");
        if (configVariables != null && configVariables.size() > 0) {
            LOGGER.info("Get the CV values for configuration variables, count: {}", (Object)configVariables.size());
            this.fireLoadConfigVariables(configVariables);
        } else {
            LOGGER.warn("No configuration variables available.");
        }
    }

    @Override
    public void addCvDefinitionRequestListener(CvDefinitionRequestListener l) {
        this.cvDefinitionRequestListeners.add(l);
    }

    private void fireLoadConfigVariables(List<ConfigurationVariable> configVariables) {
        for (CvDefinitionRequestListener l : this.cvDefinitionRequestListeners) {
            l.loadCvValues(configVariables);
        }
    }

    @Override
    public void writeConfigVariables(List<ConfigurationVariable> cvList) {
        this.fireWriteConfigVariables(cvList);
    }

    private void fireWriteConfigVariables(List<ConfigurationVariable> cvList) {
        for (CvDefinitionRequestListener l : this.cvDefinitionRequestListeners) {
            l.writeCvValues(cvList);
        }
    }

    public PortListener<FeedbackPort> getPortListener() {
        return this.gbm16TReverserEditor.getPortListener();
    }

    private Trigger getTrigger() {
        return this.gbm16TReverserEditor.getTrigger();
    }

    @Override
    public void checkPendingChanges() {
    }

    @Override
    public boolean hasPendingChanges() {
        return (Boolean)this.valueModel.getValue();
    }

    @Override
    public void savePendingChanges() {
        if (this.hasPendingChanges()) {
            LOGGER.info("Save the pending changes.");
            this.saveValues();
        } else {
            LOGGER.info("No pending changes to save available.");
        }
    }

    public static class ReverserFormPanel
    extends JPanel
    implements TabSelectionListener {
        private static final long serialVersionUID = 1L;
        private final ReverserPanel reverserPanel;

        public ReverserFormPanel(ReverserPanel reverserPanel) {
            super(new BorderLayout());
            this.reverserPanel = reverserPanel;
        }

        @Override
        public void tabSelected(boolean selected) {
            LOGGER.info("Tab is selected: {}", (Object)selected);
            if (selected) {
                this.reverserPanel.updateComponentState();
            }
        }
    }
}

