/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import io.reactivex.rxjava3.subjects.Subject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.SwitchPairPortListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.main.controller.SwitchPairPortPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SwitchPairPortTableModel;
import org.bidib.wizard.mvc.main.model.listener.SwitchPairPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.SimpleHierarchicalPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.SwitchPairPortTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPairPortListPanel
extends SimpleHierarchicalPortListPanel<SwitchPairPortTableModel, SwitchPortStatus, SwitchPairPort, SwitchPairPortListener, SwitchPairPortModelListener>
implements TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPairPortListPanel.class);
    private static final long serialVersionUID = 1L;
    private final MainModel mainModel;
    private final TabVisibilityListener tabVisibilityListener;

    public SwitchPairPortListPanel(SwitchPairPortPanelController controller, SwitchPairPortTableModel tableModel, MainModel mainModel, TabVisibilityListener tabVisibilityListener, Subject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super(tableModel, Resources.getString(SwitchPairPortListPanel.class, (String)"emptyTable"), portConfigChangeEventSubject, mainModel);
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
    }

    @Override
    protected AbstractPortHierarchicalTable<SwitchPairPort> createPortTable(SwitchPairPortTableModel tableModel, String emptyTableText) {
        return new SwitchPairPortTable(tableModel, emptyTableText);
    }

    @Override
    protected void createTable(SwitchPairPortTableModel tableModel, String emptyTableText, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super.createTable(tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);
        PortListMenuListener portListMenuListener = this.createPortListMenuListener(this.table, nodeSelectionProvider, null);
        this.table.setPortListMenuListener(portListMenuListener);
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof SwitchPairPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processListChanged() {
        super.processListChanged();
        boolean hasPortIdentifiers = false;
        ArrayList<SwitchPairPort> ports = new ArrayList<SwitchPairPort>();
        ports.addAll(this.getPorts());
        ArrayList<SwitchPairPort> arrayList = ports;
        synchronized (arrayList) {
            for (SwitchPairPort port : ports) {
                if (!port.isRemappingEnabled()) continue;
                hasPortIdentifiers = true;
                break;
            }
        }
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            LOGGER.trace("A node is selected.");
            if (ProductUtils.isOneControl((long)node.getUniqueId()) || ProductUtils.isOneDriveTurn((long)node.getUniqueId())) {
                LOGGER.info("Set the time ticks factor to 2 for OneControl and OneDriveTurn nodes. Current node: {}", (Object)this);
                ((SwitchPairPortTable)this.table).setTicksTimeFactor(2);
            } else {
                ((SwitchPairPortTable)this.table).setTicksTimeFactor(1);
            }
            boolean hasSwitchPortConfigTicks = false;
            boolean hasSwitchPortConfigLoadType = false;
            if (node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)node.getSwitchPairPorts())) {
                LOGGER.info("Check if at least one switch port has the switchPair port config available.");
                for (SwitchPairPort port : node.getSwitchPairPorts()) {
                    if (!hasSwitchPortConfigTicks) {
                        hasSwitchPortConfigTicks = port.isPortConfigKeySupported(Byte.valueOf((byte)11));
                    }
                    if (!hasSwitchPortConfigLoadType) {
                        hasSwitchPortConfigLoadType = port.isPortConfigKeySupported(Byte.valueOf(BidibLibrary.BIDIB_PCFG_LOAD_TYPE));
                    }
                    if (!hasSwitchPortConfigTicks || !hasSwitchPortConfigLoadType) continue;
                    break;
                }
            } else {
                Feature switchPortConfigAvailable = Feature.findFeature((Collection)node.getNode().getFeatures(), (int)67);
                if (switchPortConfigAvailable != null) {
                    hasSwitchPortConfigTicks = switchPortConfigAvailable.getValue() > 0;
                }
                for (SwitchPairPort port : node.getEnabledSwitchPairPorts()) {
                    if (!hasSwitchPortConfigTicks) {
                        hasSwitchPortConfigTicks = port.isPortConfigKeySupported(Byte.valueOf((byte)11));
                    }
                    if (!hasSwitchPortConfigLoadType) {
                        hasSwitchPortConfigLoadType = port.isPortConfigKeySupported(Byte.valueOf(BidibLibrary.BIDIB_PCFG_LOAD_TYPE));
                    }
                    if (!hasSwitchPortConfigTicks || !hasSwitchPortConfigLoadType) continue;
                    break;
                }
            }
            LOGGER.info("List has changed, hasPortIdentifiers: {}, hasSwitchPortConfigTicks: {}, hasSwitchPortConfigLoadType: {}", new Object[]{hasPortIdentifiers, hasSwitchPortConfigTicks, hasSwitchPortConfigLoadType});
            int viewColumnIndex = 1;
            viewColumnIndex = this.table.setColumnVisible(1, viewColumnIndex, hasSwitchPortConfigTicks);
            viewColumnIndex = this.table.setColumnVisible(2, viewColumnIndex, hasSwitchPortConfigLoadType);
            viewColumnIndex = this.table.setColumnVisible(3, viewColumnIndex, hasPortIdentifiers);
        } else {
            ((SwitchPairPortTable)this.table).setTicksTimeFactor(1);
        }
        this.tabVisibilityListener.setTabVisible(this, this.isTabVisible());
    }

    public Class<?> getPortClass() {
        return SwitchPairPort.class;
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasSwitchPairPorts();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<SwitchPairPort> getPorts() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            ArrayList<SwitchPairPort> ports = new ArrayList<SwitchPairPort>();
            ports.addAll(node.getSwitchPairPorts());
            return ports;
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        this.listChanged();
    }
}

