/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import io.reactivex.rxjava3.subjects.Subject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.SwitchPortListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.listener.PortTableLayoutListener;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.main.controller.SwitchPortPanelController;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SwitchPortTableModel;
import org.bidib.wizard.mvc.main.model.listener.SwitchPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.SimpleHierarchicalPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.SwitchPortTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPortListPanel
extends SimpleHierarchicalPortListPanel<SwitchPortTableModel, SwitchPortStatus, SwitchPort, SwitchPortListener, SwitchPortModelListener>
implements TabVisibilityProvider,
PortTableLayoutListener,
TabPanelProvider,
TabComponentCreator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPortListPanel.class);
    private final MainModel mainModel;
    private final TabVisibilityListener tabVisibilityListener;

    public SwitchPortListPanel(SwitchPortPanelController controller, SwitchPortTableModel tableModel, MainModel mainModel, TabVisibilityListener tabVisibilityListener, Subject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super(tableModel, Resources.getString(SwitchPortListPanel.class, (String)"emptyTable"), portConfigChangeEventSubject, mainModel);
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
    }

    @Override
    protected AbstractPortHierarchicalTable<SwitchPort> createPortTable(SwitchPortTableModel tableModel, String emptyTableText) {
        return new SwitchPortTable(tableModel, emptyTableText);
    }

    @Override
    protected void createTable(SwitchPortTableModel tableModel, String emptyTableText, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super.createTable(tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);
        PortListMenuListener portListMenuListener = this.createPortListMenuListener(this.table, nodeSelectionProvider, null);
        this.table.setPortListMenuListener(portListMenuListener);
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof SwitchPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void processListChanged() {
        super.processListChanged();
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            LOGGER.trace("A node is selected.");
            if (ProductUtils.isOneControl((long)node.getUniqueId()) || ProductUtils.isOneDriveTurn((long)node.getUniqueId())) {
                LOGGER.info("Set the time ticks factor to 2 for OneControl and OneDriveTurn nodes. Current node: {}", (Object)this);
                ((SwitchPortTable)this.table).setTicksTimeFactor(2);
            } else {
                ((SwitchPortTable)this.table).setTicksTimeFactor(1);
            }
            this.portTableLayoutChanged(node);
        } else {
            ((SwitchPortTable)this.table).setTicksTimeFactor(1);
        }
        this.tabVisibilityListener.setTabVisible(this, this.isTabVisible());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void portTableLayoutChanged(NodeInterface node) {
        boolean hasPortIdentifiers = false;
        ArrayList<SwitchPort> ports = new ArrayList<SwitchPort>();
        ports.addAll(this.getPorts());
        ArrayList<SwitchPort> arrayList = ports;
        synchronized (arrayList) {
            for (SwitchPort port : ports) {
                if (!port.isRemappingEnabled()) continue;
                hasPortIdentifiers = true;
                break;
            }
        }
        boolean hasSwitchPortConfigIo = false;
        boolean hasSwitchPortConfigTicks = false;
        boolean hasSwitchPortConfigLoadType = false;
        if (node != null) {
            if (node.getNode().isPortFlatModelAvailable() && CollectionUtils.isNotEmpty((Collection)node.getSwitchPorts())) {
                LOGGER.info("Check if at least one switch port has the switch port config available.");
                for (SwitchPort port : node.getSwitchPorts()) {
                    if (!hasSwitchPortConfigIo) {
                        hasSwitchPortConfigIo = port.isPortConfigKeySupported(Byte.valueOf(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL));
                    }
                    if (!hasSwitchPortConfigTicks) {
                        hasSwitchPortConfigTicks = port.isPortConfigKeySupported(Byte.valueOf((byte)11));
                    }
                    if (!hasSwitchPortConfigLoadType) {
                        hasSwitchPortConfigLoadType = port.isPortConfigKeySupported(Byte.valueOf(BidibLibrary.BIDIB_PCFG_LOAD_TYPE));
                    }
                    if (!hasSwitchPortConfigIo || !hasSwitchPortConfigTicks || !hasSwitchPortConfigLoadType) continue;
                    break;
                }
            } else {
                Feature switchPortConfigAvailable = Feature.findFeature((Collection)node.getNode().getFeatures(), (int)67);
                if (switchPortConfigAvailable != null) {
                    hasSwitchPortConfigTicks = hasSwitchPortConfigIo = switchPortConfigAvailable.getValue() > 0;
                }
                for (SwitchPort port : node.getSwitchPorts()) {
                    if (!hasSwitchPortConfigIo) {
                        hasSwitchPortConfigIo = port.isPortConfigKeySupported(Byte.valueOf(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL));
                    }
                    if (!hasSwitchPortConfigTicks) {
                        hasSwitchPortConfigTicks = port.isPortConfigKeySupported(Byte.valueOf((byte)11));
                    }
                    if (!hasSwitchPortConfigLoadType) {
                        hasSwitchPortConfigLoadType = port.isPortConfigKeySupported(Byte.valueOf(BidibLibrary.BIDIB_PCFG_LOAD_TYPE));
                    }
                    if (!hasSwitchPortConfigIo || !hasSwitchPortConfigTicks || !hasSwitchPortConfigLoadType) continue;
                    break;
                }
            }
        }
        LOGGER.info("List has changed, hasPortIdentifiers: {}, hasSwitchPortConfigIo: {}, hasSwitchPortConfigTicks: {}", new Object[]{hasPortIdentifiers, hasSwitchPortConfigIo, hasSwitchPortConfigTicks});
        int viewColumnIndex = 1;
        viewColumnIndex = this.table.setColumnVisible(1, viewColumnIndex, hasSwitchPortConfigIo);
        viewColumnIndex = this.table.setColumnVisible(2, viewColumnIndex, hasSwitchPortConfigTicks);
        viewColumnIndex = this.table.setColumnVisible(3, viewColumnIndex, hasSwitchPortConfigLoadType);
        viewColumnIndex = this.table.setColumnVisible(4, viewColumnIndex, hasPortIdentifiers);
    }

    public Class<?> getPortClass() {
        return SwitchPort.class;
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasSwitchPorts();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<SwitchPort> getPorts() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            ArrayList<SwitchPort> ports = new ArrayList<SwitchPort>();
            ports.addAll(node.getSwitchPorts());
            return ports;
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        this.listChanged();
    }
}

