/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.swing.JideTabbedPane;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bidib.jbidibc.core.schema.bidib.products.ProductType;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.AccessoryListListener;
import org.bidib.wizard.api.model.listener.CvDefinitionRequestListener;
import org.bidib.wizard.api.model.listener.MacroListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.model.listener.PortListenerProvider;
import org.bidib.wizard.api.model.listener.PortStatusListener;
import org.bidib.wizard.api.model.listener.PortValueListener;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.listener.TabStatusListener;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.script.node.types.ScriptingTargetType;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.config.CvDefinitionPanelControllerFactory;
import org.bidib.wizard.config.FirmwareControllerFactory;
import org.bidib.wizard.config.ReverserPanelControllerFactory;
import org.bidib.wizard.firmwarerepo.core.FirmwareRepoService;
import org.bidib.wizard.mvc.common.exception.NodeChangeVetoException;
import org.bidib.wizard.mvc.main.controller.AccessoryPanelController;
import org.bidib.wizard.mvc.main.controller.BacklightPortPanelController;
import org.bidib.wizard.mvc.main.controller.BoosterPanelController;
import org.bidib.wizard.mvc.main.controller.CvDefinitionPanelController;
import org.bidib.wizard.mvc.main.controller.FeedbackPortPanelController;
import org.bidib.wizard.mvc.main.controller.FeedbackPositionPanelController;
import org.bidib.wizard.mvc.main.controller.FlagPanelController;
import org.bidib.wizard.mvc.main.controller.GlobalDetectorPanelController;
import org.bidib.wizard.mvc.main.controller.InputPortPanelController;
import org.bidib.wizard.mvc.main.controller.LightPortPanelController;
import org.bidib.wizard.mvc.main.controller.LocoPanelController;
import org.bidib.wizard.mvc.main.controller.MacroPanelController;
import org.bidib.wizard.mvc.main.controller.MotorPortPanelController;
import org.bidib.wizard.mvc.main.controller.ReverserPanelController;
import org.bidib.wizard.mvc.main.controller.ServoPortPanelController;
import org.bidib.wizard.mvc.main.controller.SoundPortPanelController;
import org.bidib.wizard.mvc.main.controller.SwitchPairPortPanelController;
import org.bidib.wizard.mvc.main.controller.SwitchPortPanelController;
import org.bidib.wizard.mvc.main.model.ConnectionPhaseModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.AccessorySelectionListener;
import org.bidib.wizard.mvc.main.model.listener.MacroSelectionListener;
import org.bidib.wizard.mvc.main.view.menu.listener.MainMenuListener;
import org.bidib.wizard.mvc.main.view.panel.AccessoryListPanel;
import org.bidib.wizard.mvc.main.view.panel.AnalogPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.BacklightPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.BasicOperationsPanel;
import org.bidib.wizard.mvc.main.view.panel.BoosterPanel;
import org.bidib.wizard.mvc.main.view.panel.CvDefinitionPanel;
import org.bidib.wizard.mvc.main.view.panel.EmptyPanel;
import org.bidib.wizard.mvc.main.view.panel.FeedbackPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.FeedbackPositionListPanel;
import org.bidib.wizard.mvc.main.view.panel.FlagListPanel;
import org.bidib.wizard.mvc.main.view.panel.GlobalDetectorPanel;
import org.bidib.wizard.mvc.main.view.panel.InfoPanel;
import org.bidib.wizard.mvc.main.view.panel.InputPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.LightPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.LocoPanelView;
import org.bidib.wizard.mvc.main.view.panel.MacroListPanel;
import org.bidib.wizard.mvc.main.view.panel.MotorPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.PendingChangesAware;
import org.bidib.wizard.mvc.main.view.panel.ReverserPanel;
import org.bidib.wizard.mvc.main.view.panel.ServoPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.SoundPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.SwitchPairPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.SwitchPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.ShutdownListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabSelectionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.stepcontrol.controller.StepControlController;
import org.bidib.wizard.mvc.stepcontrol.view.StepControlPanel;
import org.bidib.wizard.nodescript.script.node.ChangeLabelSupport;
import org.bidib.wizard.nodescript.script.node.ScriptingSupportProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class TabPanel
extends JPanel
implements NodeListListener,
Dockable,
TabVisibilityListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TabPanel.class);
    private String emptyLabel;
    private final MainModel model;
    private final TitledBorder border;
    private InfoPanel infoPanel;
    private BasicOperationsPanel basicOperationsPanel;
    private AccessoryListPanel accessoryListPanel;
    private AnalogPortListPanel analogPortListPanel;
    private BoosterPanel boosterPanel;
    private FeedbackPortListPanel feedbackPortListPanel;
    private FeedbackPositionListPanel feedbackPositionListPanel;
    private GlobalDetectorPanel globalDetectorPanel;
    private InputPortListPanel inputPortListPanel;
    private LightPortListPanel lightPortListPanel;
    private BacklightPortListPanel backlightPortListPanel;
    private MacroListPanel macroListPanel;
    private MotorPortListPanel motorPortListPanel;
    private ServoPortListPanel servoPortListPanel;
    private SoundPortListPanel soundPortListPanel;
    private SwitchPortListPanel switchPortListPanel;
    private SwitchPairPortListPanel switchPairPortListPanel;
    private FlagListPanel flagListPanel;
    private StepControlPanel stepControlPanel;
    private CvDefinitionPanel cvDefinitionPanel;
    private ReverserPanel reverserPanel;
    private final JideTabbedPane tabbedPane;
    private NodeInterface displayedNode;
    private final List<TabPanelProvider> tabs = new LinkedList<TabPanelProvider>();
    private final ScriptingSupportProvider scriptingSupportProvider;
    private EmptyPanel emptyPanel;
    private TabStatusListener tabStatusListener;
    private AccessoryPanelController accessoryPanelController;
    private BoosterPanelController boosterPanelController;
    private MacroPanelController macroPanelController;
    private FeedbackPortPanelController feedbackPortPanelController;
    private BacklightPortPanelController backlightPortPanelController;
    private InputPortPanelController inputPortPanelController;
    private FeedbackPositionPanelController feedbackPositionPanelController;
    private LightPortPanelController lightPortPanelController;
    private GlobalDetectorPanelController globalDetectorPanelController;
    private SoundPortPanelController soundPortPanelController;
    private SwitchPortPanelController switchPortPanelController;
    private ServoPortPanelController servoPortPanelController;
    private MotorPortPanelController motorPortPanelController;
    private SwitchPairPortPanelController switchPairPortPanelController;
    private StepControlController stepControlController;
    private CvDefinitionPanelController cvDefinitionPanelController;
    private ReverserPanelController reverserPanelController;
    private FlagPanelController flagPanelController;
    private LocoPanelController locoPanelController;
    private LocoPanelView locoControlPanel;
    private final SettingsService settingsService;
    private final ApplicationContext applicationContext;
    private final LookupService lookupService;
    private final PropertyChangeListener pclNodeLabel;
    private CvDefinitionRequestListener cvDefinitionRequestListener;

    public TabPanel(MainModel model, ConnectionPhaseModel connectionPhaseModel, SettingsService settingsService, ScriptingSupportProvider scriptingSupportProvider, MainMenuListener mainMenuListener, ApplicationContext applicationContext, LookupService lookupService) {
        this.model = model;
        this.settingsService = settingsService;
        this.scriptingSupportProvider = scriptingSupportProvider;
        this.applicationContext = applicationContext;
        this.lookupService = lookupService;
        LOGGER.info("Create new TabPanel instance.");
        this.emptyLabel = Resources.getString(this.getClass(), (String)"emptyLabel");
        this.border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.emptyLabel);
        this.setBorder(this.border);
        this.setLayout(new BorderLayout());
        DockKeys.DOCKKEY_TAB_PANEL.setName(Resources.getString(this.getClass(), (String)"title"));
        DockKeys.DOCKKEY_TAB_PANEL.setCloseEnabled(false);
        DockKeys.DOCKKEY_TAB_PANEL.setAutoHideEnabled(false);
        DockKeys.DOCKKEY_TAB_PANEL.setFloatEnabled(true);
        final ImageIcon pendingChangesIcon = ImageUtils.createImageIcon(TabPanel.class, (String)"/icons/16x16/savetonode.png");
        this.emptyPanel = new EmptyPanel(connectionPhaseModel, settingsService, mainMenuListener);
        this.tabbedPane = new JideTabbedPane();
        this.tabStatusListener = new TabStatusListener(){

            public void updatePendingChanges(Component source, boolean hasPendingChanges) {
                ImageIcon icon = null;
                if (hasPendingChanges) {
                    icon = pendingChangesIcon;
                }
                int componentIndex = TabPanel.this.tabbedPane.indexOfComponent(source);
                LOGGER.info("updatePendingChanges, hasPendingChanges: {}, componentIndex: {}, component: {}", new Object[]{hasPendingChanges, componentIndex, source});
                if (componentIndex > -1) {
                    TabPanel.this.tabbedPane.setIconAt(componentIndex, (Icon)icon);
                }
            }
        };
        this.pclNodeLabel = evt -> this.updateBorderLabel();
        this.showInnerComponent(true);
        Timer createContentTimer = new Timer(1000, evt -> this.createContent());
        createContentTimer.setRepeats(false);
        createContentTimer.start();
    }

    private void createContent() {
        LOGGER.info("Create the content of the TabPanel. Get the controllers from the application context.");
        this.accessoryPanelController = (AccessoryPanelController)this.applicationContext.getBean(AccessoryPanelController.class);
        this.accessoryListPanel = this.accessoryPanelController.createAccessoryListPanel(this);
        this.boosterPanelController = (BoosterPanelController)((Object)this.applicationContext.getBean(BoosterPanelController.class));
        this.model.addNodeListListener((NodeListListener)this.boosterPanelController);
        this.boosterPanel = this.boosterPanelController.createPanel(this);
        this.analogPortListPanel = new AnalogPortListPanel(this.model, this);
        this.feedbackPortPanelController = (FeedbackPortPanelController)this.applicationContext.getBean(FeedbackPortPanelController.class);
        this.feedbackPortListPanel = this.feedbackPortPanelController.createPanel(this);
        this.inputPortPanelController = (InputPortPanelController)this.applicationContext.getBean(InputPortPanelController.class);
        this.inputPortListPanel = this.inputPortPanelController.createPanel(this);
        this.globalDetectorPanelController = (GlobalDetectorPanelController)this.applicationContext.getBean(GlobalDetectorPanelController.class);
        this.globalDetectorPanel = this.globalDetectorPanelController.createGlobalDetectorPanel(this);
        this.feedbackPositionPanelController = (FeedbackPositionPanelController)this.applicationContext.getBean(FeedbackPositionPanelController.class);
        this.feedbackPositionListPanel = this.feedbackPositionPanelController.createFeedbackPositionListPanel(this);
        this.lightPortPanelController = (LightPortPanelController)this.applicationContext.getBean(LightPortPanelController.class);
        this.lightPortListPanel = this.lightPortPanelController.createPanel(this);
        this.backlightPortPanelController = (BacklightPortPanelController)this.applicationContext.getBean(BacklightPortPanelController.class);
        this.backlightPortListPanel = this.backlightPortPanelController.createPanel(this);
        this.motorPortPanelController = (MotorPortPanelController)this.applicationContext.getBean(MotorPortPanelController.class);
        this.motorPortListPanel = this.motorPortPanelController.createPanel(this);
        this.servoPortPanelController = (ServoPortPanelController)this.applicationContext.getBean(ServoPortPanelController.class);
        this.servoPortListPanel = this.servoPortPanelController.createPanel(this);
        this.soundPortPanelController = (SoundPortPanelController)this.applicationContext.getBean(SoundPortPanelController.class);
        this.soundPortListPanel = this.soundPortPanelController.createPanel(this);
        this.switchPortPanelController = (SwitchPortPanelController)this.applicationContext.getBean(SwitchPortPanelController.class);
        this.switchPortListPanel = this.switchPortPanelController.createPanel(this);
        this.macroPanelController = (MacroPanelController)this.applicationContext.getBean(MacroPanelController.class);
        this.macroListPanel = this.macroPanelController.createMacroListPanel(this);
        DefaultApplicationContext.getInstance().register("macroListController", (Object)this.macroPanelController);
        this.switchPairPortPanelController = (SwitchPairPortPanelController)this.applicationContext.getBean(SwitchPairPortPanelController.class);
        this.switchPairPortListPanel = this.switchPairPortPanelController.createPanel(this);
        this.flagPanelController = (FlagPanelController)this.applicationContext.getBean(FlagPanelController.class);
        this.flagListPanel = this.flagPanelController.createFlagListPanel();
        this.locoPanelController = (LocoPanelController)this.applicationContext.getBean(LocoPanelController.class);
        this.locoControlPanel = this.locoPanelController.createPanel();
        FirmwareControllerFactory firmwareControllerFactory = (FirmwareControllerFactory)this.applicationContext.getBean(FirmwareControllerFactory.class);
        FirmwareRepoService firmwareRepoService = (FirmwareRepoService)this.applicationContext.getBean(FirmwareRepoService.class);
        this.infoPanel = new InfoPanel(this.model, this.settingsService, this.lookupService, firmwareControllerFactory, firmwareRepoService);
        this.basicOperationsPanel = new BasicOperationsPanel(this.model, this.applicationContext);
        CvDefinitionPanelControllerFactory cvDefinitionPanelControllerFactory = (CvDefinitionPanelControllerFactory)this.applicationContext.getBean(CvDefinitionPanelControllerFactory.class);
        this.cvDefinitionPanelController = cvDefinitionPanelControllerFactory.createController(this.model);
        this.cvDefinitionPanelController.start(this.tabStatusListener);
        this.cvDefinitionPanel = this.cvDefinitionPanelController.getCvDefinitionPanel();
        DefaultApplicationContext.getInstance().register("cvDefinitionPanelController", (Object)this.cvDefinitionPanelController);
        ReverserPanelControllerFactory reverserPanelControllerFactory = (ReverserPanelControllerFactory)this.applicationContext.getBean(ReverserPanelControllerFactory.class);
        this.reverserPanelController = reverserPanelControllerFactory.createController(this.model, this);
        this.reverserPanelController.start(this.tabStatusListener);
        this.reverserPanel = this.reverserPanelController.getReverserPanel();
        this.stepControlController = (StepControlController)this.applicationContext.getBean(StepControlController.class);
        DefaultApplicationContext.getInstance().register("stepControlController", (Object)this.stepControlController);
        this.stepControlController.start(this.tabStatusListener);
        this.stepControlPanel = this.stepControlController.getComponent();
        boolean showActionInLastTab = this.settingsService.getWizardSettings().isShowActionInLastTab();
        if (!showActionInLastTab) {
            this.tabs.add(this.basicOperationsPanel);
        }
        this.tabs.add(this.infoPanel);
        this.tabs.add(this.stepControlPanel);
        this.tabs.add(this.accessoryListPanel);
        this.tabs.add(this.macroListPanel);
        this.tabs.add(this.inputPortListPanel);
        this.tabs.add(this.analogPortListPanel);
        this.tabs.add(this.lightPortListPanel);
        this.tabs.add(this.backlightPortListPanel);
        this.tabs.add(this.motorPortListPanel);
        this.tabs.add(this.switchPortListPanel);
        this.tabs.add(this.switchPairPortListPanel);
        this.tabs.add(this.servoPortListPanel);
        this.tabs.add(this.soundPortListPanel);
        this.tabs.add(this.flagListPanel);
        this.tabs.add(this.boosterPanel);
        this.tabs.add(this.feedbackPortListPanel);
        this.tabs.add(this.feedbackPositionListPanel);
        this.tabs.add(this.globalDetectorPanel);
        this.tabs.add(this.reverserPanel);
        this.tabs.add(this.cvDefinitionPanel);
        this.tabs.add(this.locoControlPanel);
        if (showActionInLastTab) {
            this.tabs.add(this.basicOperationsPanel);
        }
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.ANALOGPORT, (ChangeLabelSupport)this.analogPortListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.BACKLIGHTPORT, (ChangeLabelSupport)this.backlightPortListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.FEEDBACKPORT, (ChangeLabelSupport)this.feedbackPortListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.INPUTPORT, (ChangeLabelSupport)this.inputPortListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.LIGHTPORT, (ChangeLabelSupport)this.lightPortListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.MOTORPORT, (ChangeLabelSupport)this.motorPortListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.SERVOPORT, (ChangeLabelSupport)this.servoPortListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.SOUNDPORT, (ChangeLabelSupport)this.soundPortListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.SWITCHPORT, (ChangeLabelSupport)this.switchPortListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.SWITCHPAIRPORT, (ChangeLabelSupport)this.switchPairPortListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.FLAG, (ChangeLabelSupport)this.flagListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.MACRO, (ChangeLabelSupport)this.macroListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.ACCESSORY, (ChangeLabelSupport)this.accessoryListPanel);
        this.scriptingSupportProvider.addScriptingSupport(ScriptingTargetType.ASPECT, (ChangeLabelSupport)this.accessoryListPanel);
        this.model.addNodeListListener(this);
        this.cvDefinitionPanelController.setTabEnableCallback(() -> {
            for (TabPanelProvider tab : this.tabs) {
                if (!(tab instanceof TabVisibilityProvider)) continue;
                TabVisibilityProvider tabVisibilityProvider = (TabVisibilityProvider)tab;
                LOGGER.debug("Set visibility of tab: {}", (Object)tabVisibilityProvider);
                this.enableTab(tabVisibilityProvider.getComponent(), ((TabVisibilityProvider)tab).isTabVisible());
            }
            if (this.displayedNode != null && ProductUtils.isStepControl((long)this.displayedNode.getUniqueId())) {
                LOGGER.info("Activate the StepControl panel.");
                try {
                    this.tabbedPane.setSelectedComponent((Component)this.stepControlPanel.getComponent());
                    this.stepControlPanel.tabSelected(true);
                }
                catch (Exception ex) {
                    LOGGER.warn("Activate the StepControl panel failed.", (Throwable)ex);
                }
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component selectedComponent = TabPanel.this.tabbedPane.getSelectedComponent();
                LOGGER.debug("Currently selected component in tabbedPane: {}", (Object)selectedComponent);
                for (TabPanelProvider comp : TabPanel.this.tabs) {
                    if (!(comp.getComponent() instanceof TabSelectionListener)) continue;
                    TabSelectionListener listener = (TabSelectionListener)((Object)comp.getComponent());
                    LOGGER.info("Select tab, current component: {}", (Object)listener);
                    listener.tabSelected(listener.equals(selectedComponent));
                }
            }
        });
        this.cvDefinitionPanel.addCvDefinitionRequestListener(this.cvDefinitionRequestListener);
        this.stepControlPanel.addCvDefinitionRequestListener(this.cvDefinitionRequestListener);
        this.lightPortPanelController.addCvDefinitionRequestListener(this.cvDefinitionRequestListener);
        this.reverserPanel.addCvDefinitionRequestListener(this.cvDefinitionRequestListener);
    }

    private void showInnerComponent(boolean empty) {
        if (empty) {
            this.remove((Component)this.tabbedPane);
            this.add(this.emptyPanel.getContent());
        } else {
            this.remove(this.emptyPanel.getContent());
            this.add((Component)this.tabbedPane);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.emptyPanel != null && this.emptyPanel.getContent() != null) {
            this.emptyPanel.getContent().updateUI();
        }
        if (this.tabbedPane != null) {
            this.tabbedPane.updateUI();
        }
    }

    public void addCvDefinitionRequestListener(CvDefinitionRequestListener cvDefinitionRequestListener) {
        this.cvDefinitionRequestListener = cvDefinitionRequestListener;
    }

    private void updateBorderLabel() {
        SwingUtils.executeInEDT(() -> {
            Object nodeName = this.emptyLabel;
            if (this.displayedNode != null) {
                Optional product = this.lookupService.getProduct(this.displayedNode.getNode().getUniqueId());
                nodeName = org.bidib.wizard.api.utils.NodeUtils.getNodeName((NodeInterface)this.displayedNode);
                if (product.isPresent()) {
                    nodeName = (String)nodeName + " - " + ((ProductType)product.get()).getName();
                }
            }
            this.border.setTitle((String)nodeName);
            this.repaint();
        });
    }

    public void listChanged() {
        LOGGER.debug("list has changed.");
    }

    public void nodeChanged(NodeInterface node) {
        LOGGER.debug("The node has changed, currently displayedNode: {}", (Object)this.displayedNode);
        SwingUtils.executeInEDT(() -> this.internalNodeChanged());
    }

    private void internalNodeChanged() {
        AccessorySelectionListener accessorySelectionListener;
        AccessoryListListener accessoryListListener;
        MacroSelectionListener macroSelectionListener;
        MacroListListener macroListListener;
        PortValueListener portValueListener;
        PortValueListener portValueListener2;
        PortStatusListener portListener;
        PortListListener portListListener;
        LOGGER.debug("handle node has changed: {}", (Object)this.displayedNode);
        if (this.displayedNode != null && this.displayedNode.equals((Object)this.model.getSelectedNode())) {
            LOGGER.debug("The node has not changed.");
            return;
        }
        if (this.displayedNode != null) {
            this.displayedNode.removePropertyChangeListener("label", this.pclNodeLabel);
        }
        this.tabbedPane.removeAll();
        if (this.displayedNode != null) {
            for (TabPanelProvider tab : this.tabs) {
                if (tab instanceof PortListListener) {
                    portListListener = (PortListListener)tab;
                    this.displayedNode.removePortListListener(portListListener.getPortClass(), portListListener);
                }
                if (tab instanceof PortStatusListener) {
                    portListener = (PortStatusListener)tab;
                    this.displayedNode.removePortListener(portListener.getPortClass(), (PortListener)portListener);
                }
                if (tab instanceof PortListenerProvider && (portListener = ((PortListenerProvider)tab).getPortListener()) != null) {
                    this.displayedNode.removePortListener(portListener.getPortClass(), (PortListener)portListener);
                    if (portListener instanceof PortValueListener) {
                        portValueListener2 = (PortValueListener)portListener;
                        LOGGER.debug("Remove port value listener: {}, port class: {}", (Object)portValueListener2, (Object)portValueListener2.getPortClass());
                        this.displayedNode.removePortValueListener(portValueListener2.getPortClass(), portValueListener2);
                    }
                }
                if (tab instanceof PortValueListener) {
                    portValueListener = (PortValueListener)tab;
                    this.displayedNode.removePortValueListener(portValueListener.getPortClass(), portValueListener);
                }
                if (tab instanceof MacroListListener) {
                    macroListListener = (MacroListListener)tab;
                    this.displayedNode.removeMacroListListener(macroListListener);
                }
                if (tab instanceof MacroSelectionListener) {
                    macroSelectionListener = (MacroSelectionListener)tab;
                    this.model.removeMacroSelectionListener(macroSelectionListener);
                }
                if (tab instanceof AccessoryListListener) {
                    accessoryListListener = (AccessoryListListener)tab;
                    this.displayedNode.removeAccessoryListListener(accessoryListListener);
                }
                if (!(tab instanceof AccessorySelectionListener)) continue;
                accessorySelectionListener = (AccessorySelectionListener)tab;
                this.model.removeAccessorySelectionListener(accessorySelectionListener);
            }
        }
        this.displayedNode = this.model.getSelectedNode();
        this.showInnerComponent(this.displayedNode == null);
        for (TabPanelProvider tab : this.tabs) {
            if (this.displayedNode != null) {
                if (tab instanceof PortListListener) {
                    portListListener = (PortListListener)tab;
                    this.displayedNode.addPortListListener(portListListener.getPortClass(), portListListener);
                    portListListener.refreshPorts();
                }
                if (tab instanceof PortStatusListener) {
                    portListener = (PortStatusListener)tab;
                    LOGGER.debug("Add port status listener, port class: {}, port status listener: {}", (Object)portListener.getPortClass(), (Object)portListener);
                    this.displayedNode.addPortListener(portListener.getPortClass(), (PortListener)portListener);
                }
                if (tab instanceof PortListenerProvider) {
                    portListener = ((PortListenerProvider)tab).getPortListener();
                    if (portListener != null) {
                        LOGGER.debug("Add port listener, port class: {}, port listener: {}", (Object)portListener.getPortClass(), (Object)portListener);
                        this.displayedNode.addPortListener(portListener.getPortClass(), (PortListener)portListener);
                        if (portListener instanceof PortValueListener) {
                            portValueListener2 = (PortValueListener)portListener;
                            LOGGER.debug("Add port value listener: {}, port class: {}", (Object)portValueListener2, (Object)portValueListener2.getPortClass());
                            this.displayedNode.addPortValueListener(portValueListener2.getPortClass(), portValueListener2);
                        }
                    } else {
                        LOGGER.warn("The PortListenerProvider has no port listener assigned: {}", (Object)tab);
                    }
                }
                if (tab instanceof PortValueListener) {
                    portValueListener = (PortValueListener)tab;
                    this.displayedNode.addPortValueListener(portValueListener.getPortClass(), portValueListener);
                }
                if (tab instanceof MacroListListener) {
                    macroListListener = (MacroListListener)tab;
                    this.displayedNode.addMacroListListener(macroListListener);
                    macroListListener.listChanged();
                }
                if (tab instanceof MacroSelectionListener) {
                    macroSelectionListener = (MacroSelectionListener)tab;
                    this.model.addMacroSelectionListener(macroSelectionListener);
                }
                if (tab instanceof AccessoryListListener) {
                    accessoryListListener = (AccessoryListListener)tab;
                    this.displayedNode.addAccessoryListListener(accessoryListListener);
                    accessoryListListener.listChanged();
                }
                if (tab instanceof AccessorySelectionListener) {
                    accessorySelectionListener = (AccessorySelectionListener)tab;
                    this.model.addAccessorySelectionListener(accessorySelectionListener);
                }
            }
            if (!(tab instanceof TabVisibilityProvider)) continue;
            TabVisibilityProvider tabVisibilityProvider = (TabVisibilityProvider)tab;
            LOGGER.debug("Set visibility of tab: {}", (Object)tabVisibilityProvider);
            this.enableTab(tabVisibilityProvider.getComponent(), ((TabVisibilityProvider)tab).isTabVisible());
        }
        this.enableTab(this.flagListPanel.getComponent(), this.displayedNode != null && NodeUtils.hasAccessoryFunctions((long)this.displayedNode.getUniqueId()) && this.displayedNode.hasMacros());
        this.enableTab(this.infoPanel.getComponent(), this.displayedNode != null);
        this.enableTab(this.basicOperationsPanel.getComponent(), this.displayedNode != null);
        this.enableTab(this.boosterPanel.getComponent(), this.displayedNode != null && (NodeUtils.hasBoosterFunctions((long)this.displayedNode.getUniqueId()) || NodeUtils.hasCommandStationFunctions((long)this.displayedNode.getUniqueId())));
        this.enableTab(this.locoControlPanel.getComponent(), this.displayedNode != null && ProductUtils.isSpeedometer((long)this.displayedNode.getUniqueId()));
        if (this.displayedNode != null) {
            this.displayedNode.addPropertyChangeListener("label", this.pclNodeLabel);
        }
        this.updateBorderLabel();
        this.flagListPanel.nodeChanged();
        this.infoPanel.nodeChanged();
        this.basicOperationsPanel.nodeChanged();
        this.reverserPanel.nodeChanged();
    }

    private void enableTab(Component component, boolean enable) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.innerEnableTab(component, enable);
        } else {
            SwingUtilities.invokeLater(() -> this.innerEnableTab(component, enable));
        }
    }

    private void innerEnableTab(Component component, boolean enable) {
        int componentIndex = this.tabbedPane.indexOfComponent(component);
        LOGGER.debug("enableTab, enable: {}, componentIndex: {}, name: {}, component: {}", new Object[]{enable, componentIndex, component.getName(), component});
        if (enable && componentIndex == -1) {
            TabPanelProvider tab;
            JPanel currentComponent;
            int index = 0;
            Iterator<TabPanelProvider> iterator = this.tabs.iterator();
            while (iterator.hasNext() && (currentComponent = (tab = iterator.next()).getComponent()) != component) {
                if (this.tabbedPane.indexOfComponent((Component)currentComponent) < 0) continue;
                ++index;
            }
            this.tabbedPane.add(component, index);
            if (index == 0) {
                this.tabbedPane.setSelectedIndex(0);
            }
        } else if (!enable && componentIndex >= 0) {
            this.tabbedPane.remove(component);
        }
        LOGGER.debug("number of components in tabbed pane: {}", (Object)this.tabbedPane.getComponentCount());
    }

    public void nodeStateChanged(NodeInterface node) {
    }

    public Component getComponent() {
        return this;
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_TAB_PANEL;
    }

    public void listNodeAdded(NodeInterface node) {
    }

    public void listNodeRemoved(NodeInterface node) {
    }

    public void nodeWillChange(NodeInterface node) {
        for (TabPanelProvider tab : this.tabs) {
            boolean pendingChanges;
            if (tab instanceof NodeListListener) {
                ((NodeListListener)tab).nodeWillChange(node);
            }
            if (!(tab instanceof PendingChangesAware) || !(pendingChanges = ((PendingChangesAware)tab).hasPendingChanges())) continue;
            LOGGER.warn("The current tab has pending changes: {}", (Object)tab);
            throw new NodeChangeVetoException("Pending changes in " + String.valueOf(tab) + " detected.");
        }
    }

    @Override
    public void setTabVisible(Component component, boolean visible) {
        LOGGER.debug("Set the component visible, component: {}, visible: {}", (Object)component, (Object)visible);
        this.enableTab(component, visible);
    }

    public void performShutdown() {
        for (TabPanelProvider tab : this.tabs) {
            if (!(tab.getComponent() instanceof ShutdownListener)) continue;
            try {
                ((ShutdownListener)((Object)tab.getComponent())).performShutdown();
            }
            catch (Exception ex) {
                LOGGER.warn("Perform shutdown failed on tab: {}", (Object)tab, (Object)ex);
            }
        }
    }

    public void savePendingChanges() {
        for (TabPanelProvider tab : this.tabs) {
            boolean pendingChanges;
            if (!(tab instanceof PendingChangesAware) || !(pendingChanges = ((PendingChangesAware)tab).hasPendingChanges())) continue;
            LOGGER.warn("The current tab has pending changes: {}", (Object)tab);
            ((PendingChangesAware)tab).savePendingChanges();
        }
    }
}

