/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.utils.PortUtils;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.rxjava2.SwingScheduler;
import org.bidib.wizard.client.common.table.AbstractPortEditorPanel;
import org.bidib.wizard.client.common.table.listener.PortEditorPanelCallback;
import org.bidib.wizard.client.common.text.HintTextField;
import org.bidib.wizard.client.common.text.WizardBindings;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.bidib.wizard.client.common.view.validation.DefaultRangeValidationCallback;
import org.bidib.wizard.client.common.view.validation.IconFeedbackPanel;
import org.bidib.wizard.client.common.view.validation.IntegerInputValidationDocument;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.client.common.view.validation.RangeValidationCallback;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.main.model.SwitchPairPortTableModel;
import org.bidib.wizard.mvc.main.view.panel.renderer.LoadTypeCellRenderer;
import org.bidib.wizard.mvc.main.view.table.converter.PortStatusToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPairPortEditorPanel
extends AbstractPortEditorPanel<SwitchPairPort> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPairPortEditorPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private static final int TIME_BETWEEN_STATUS_EVENTS_MILLIS = 80;
    private static final int TIME_BETWEEN_PORT_CONFIG_EVENTS_MILLIS = 100;
    private ValueModel switchOffTimeConverterModel;
    private ValueModel selectionHolderLoadType;
    private JTextField portName;
    private HintTextField switchOffTimeText;
    private JComboBox<LoadTypeEnum> comboLoadType;
    private JComboBox<SwitchPortStatus> comboPortStatus;
    private JButton btnPortStatus;
    private final Subject<SwitchPortStatus> statusEventSubject = PublishSubject.create().toSerialized();

    public SwitchPairPortEditorPanel(SwitchPairPort port, Consumer<SwitchPairPort> saveCallback, Consumer<SwitchPairPort> valueCallback, Consumer<SwitchPairPort> refreshCallback, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super((Port)port, saveCallback, valueCallback, refreshCallback, portConfigChangeEventSubject, nodeSelectionProvider);
    }

    protected SwitchPairPort clonePort(SwitchPairPort port) {
        SwitchPairPort clone = (SwitchPairPort)SwitchPairPort.builder().withLoadType(port.getLoadType()).withSwitchOffTime(port.getSwitchOffTime()).withStatus((BidibStatus)((SwitchPortStatus)port.getStatus())).withRemappingEnabled(port.isRemappingEnabled()).withKnownPortConfigKeys(port.getKnownPortConfigKeys()).withId(port.getId()).withLabel(port.getLabel()).withEnabled(port.isEnabled()).withIsInactive(port.isInactive()).withPortIdentifier(port.getPortIdentifier()).build();
        return clone;
    }

    protected JPanel doCreateComponent(SwitchPairPort port) {
        AbstractPortEditorPanel.PortEditorPanelDebugContainer panel;
        int row = 1;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new AbstractPortEditorPanel.PortEditorPanelDebugContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        ArrayList<JComponent> order = new ArrayList<JComponent>();
        BufferedValueModel bufferedPortNameModel = this.getPresentationModel().getBufferedModel("label");
        dialogBuilder.add(Resources.getString(SwitchPairPortTableModel.class, (String)"label") + ":", new Object[0]).xy(1, row);
        this.portName = WizardComponentFactory.createTextField((ValueModel)bufferedPortNameModel, (boolean)false);
        this.portName.setEnabled(port.isEnabled());
        dialogBuilder.add((Component)this.portName).xyw(3, row, 7);
        order.add(this.portName);
        row += 2;
        if (this.isPortConfigKeySupported((byte)11)) {
            BufferedValueModel valueValueModel = this.getPresentationModel().getBufferedModel("switchOffTime");
            this.switchOffTimeConverterModel = new ConverterValueModel((ValueModel)valueValueModel, (BindingConverter)new StringToIntegerConverter());
            this.switchOffTimeText = new HintTextField(() -> this.triggerValidation());
            IntegerInputValidationDocument switchOffTimeDocument = new IntegerInputValidationDocument(5, "0123456789");
            switchOffTimeDocument.setRangeValidationCallback((RangeValidationCallback)new DefaultRangeValidationCallback(0, 255, showHint -> this.switchOffTimeText.showHint(showHint.booleanValue())));
            this.switchOffTimeText.setDocument((Document)switchOffTimeDocument);
            this.switchOffTimeText.setColumns(2);
            this.switchOffTimeText.setHorizontalAlignment(4);
            WizardBindings.bind((JTextField)this.switchOffTimeText, (ValueModel)this.switchOffTimeConverterModel, (boolean)true);
            dialogBuilder.add(Resources.getString(SwitchPairPortTableModel.class, (String)"switchOffTime") + ":", new Object[0]).xy(1, row);
            dialogBuilder.add((Component)this.switchOffTimeText).xy(3, row);
            this.switchOffTimeText.setEnabled(port.isEnabled());
            order.add((JComponent)this.switchOffTimeText);
            ValidationComponentUtils.setMandatory((JComponent)this.switchOffTimeText, (boolean)true);
            ValidationComponentUtils.setMessageKeys((JComponent)this.switchOffTimeText, (Object[])new Object[]{"validation.switchOffTime_key"});
            row += 2;
            valueValueModel.addValueChangeListener(evt -> {
                if (valueValueModel.getValue() instanceof Integer) {
                    int switchOffTimeValue = (Integer)valueValueModel.getValue();
                    LOGGER.info("The switchOffTime value has been changed: {}", (Object)switchOffTimeValue);
                    this.getLocalPortConfigChangeEventSubject().onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf((byte)11), (PortConfigValue)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)switchOffTimeValue)))));
                }
            });
        }
        if (this.isPortConfigKeySupported(BidibLibrary.BIDIB_PCFG_LOAD_TYPE)) {
            this.selectionHolderLoadType = this.getPresentationModel().getBufferedModel("loadType");
            ArrayListModel loadTypeList = new ArrayListModel();
            for (IntegerInputValidationDocument value : LoadTypeEnum.values()) {
                loadTypeList.add((Object)value);
            }
            SelectionInList loadTypeSelection = new SelectionInList((ListModel)loadTypeList);
            ComboBoxAdapter comboBoxAdapterLoadType = new ComboBoxAdapter((ListModel)loadTypeSelection, this.selectionHolderLoadType);
            this.comboLoadType = new JComboBox();
            this.comboLoadType.setModel((ComboBoxModel<LoadTypeEnum>)comboBoxAdapterLoadType);
            this.comboLoadType.setRenderer(new LoadTypeCellRenderer());
            this.comboLoadType.setEnabled(port.isEnabled());
            order.add(this.comboLoadType);
            dialogBuilder.add(Resources.getString(SwitchPairPortTableModel.class, (String)"loadType") + ":", new Object[0]).xy(1, row);
            dialogBuilder.add(this.comboLoadType).xy(3, row);
            row += 2;
            this.selectionHolderLoadType.addValueChangeListener(evt -> {
                if (this.selectionHolderLoadType.getValue() instanceof Integer) {
                    int loadTypeValue = (Integer)this.selectionHolderLoadType.getValue();
                    LOGGER.info("The loadType value has been changed: {}", (Object)loadTypeValue);
                    this.getLocalPortConfigChangeEventSubject().onNext((Object)new PortConfigChangeEvent(null, 0L, (PortTypeAware)port, Byte.valueOf(BidibLibrary.BIDIB_PCFG_LOAD_TYPE), (PortConfigValue)new BytePortConfigValue(Byte.valueOf(ByteUtils.getLowByte((int)loadTypeValue)))));
                }
            });
        }
        AbstractValueModel selectionHolderPortStatus = this.getPresentationModel().getModel("status");
        ConverterValueModel portStatusConverterModel = new ConverterValueModel((ValueModel)selectionHolderPortStatus, (BindingConverter)new PortStatusToStringConverter("org.bidib.wizard.model.status.SwitchPairPortStatus", "status."));
        JLabel statusLabel = WizardComponentFactory.createLabel((ValueModel)portStatusConverterModel);
        SelectionInList portStatusSelection = new SelectionInList((Object[])SwitchPortStatus.ON.getValues());
        ValueHolder portStatusHolder = new ValueHolder(selectionHolderPortStatus.getValue());
        ComboBoxAdapter comboBoxAdapterPortStatus = new ComboBoxAdapter((ListModel)portStatusSelection, (ValueModel)portStatusHolder);
        this.comboPortStatus = new JComboBox();
        this.comboPortStatus.setRenderer((ListCellRenderer<SwitchPortStatus>)new BidibStatusListRenderer("org.bidib.wizard.model.status.SwitchPairPortStatus", "status."));
        this.comboPortStatus.setModel((ComboBoxModel<SwitchPortStatus>)comboBoxAdapterPortStatus);
        SwitchPortStatus oppositeStatus = (SwitchPortStatus)PortUtils.getOppositeStatus((BidibStatus)((SwitchPortStatus)selectionHolderPortStatus.getValue()));
        LOGGER.info("Set the opposite status in the port status selection: {}", (Object)oppositeStatus);
        this.comboPortStatus.setSelectedItem(oppositeStatus);
        this.btnPortStatus = new JButton(Resources.getString(SwitchPairPortTableModel.class, (String)"test"));
        this.btnPortStatus.addActionListener(arg_0 -> this.lambda$doCreateComponent$4((ValueModel)portStatusHolder, arg_0));
        Disposable disp = this.statusEventSubject.throttleLatest(80L, TimeUnit.MILLISECONDS, (Scheduler)SwingScheduler.getInstance(), true).subscribe(portStatus -> this.sendStatusToPort(port, (SwitchPortStatus)portStatus));
        this.getCompDisp().add(disp);
        dialogBuilder.add(Resources.getString(SwitchPairPortTableModel.class, (String)"status") + ":", new Object[0]).xy(1, row);
        dialogBuilder.add((Component)statusLabel).xy(3, row);
        dialogBuilder.add(this.comboPortStatus).xy(5, row);
        dialogBuilder.add((Component)this.btnPortStatus).xy(7, row);
        this.comboPortStatus.setEnabled(port.isEnabled());
        this.btnPortStatus.setEnabled(port.isEnabled());
        order.add(this.comboPortStatus);
        order.add(this.btnPortStatus);
        JPanel buttonPanel = this.getButtonPanel();
        dialogBuilder.add((Component)buttonPanel).xyw(1, row += 2, 9);
        this.addButtons(buttonPanel, order);
        Disposable dispLocalPortConfigChange = this.getLocalPortConfigChangeEventSubject().buffer(100L, TimeUnit.MILLISECONDS, (Scheduler)SwingScheduler.getInstance()).subscribe(evts -> {
            PortConfigChangeEvent event = null;
            for (PortConfigChangeEvent evt : evts) {
                LOGGER.info("Process event: {}", (Object)evt);
                if (event == null) {
                    event = evt;
                    continue;
                }
                event.getPortConfig().putAll(evt.getPortConfig());
            }
            if (event != null) {
                LOGGER.info("Publish the config change event to the node: {}", event);
                this.getPortConfigChangeEventSubject().onNext(event);
            }
        });
        this.getCompDisp().add(dispLocalPortConfigChange);
        if (this.getValidationResultModel() != null) {
            LOGGER.debug("Create iconfeedback panel.");
            IconFeedbackPanel cvIconPanel = new IconFeedbackPanel((ValidationResultModel)this.getValidationResultModel(), (JComponent)dialogBuilder.build());
            AbstractPortEditorPanel.PortEditorPanelContainer panel2 = new AbstractPortEditorPanel.PortEditorPanelContainer((PortEditorPanelCallback)this);
            FormBuilder feedbackBuilder = FormBuilder.create().columns("p:g", new Object[0]).rows("fill:p:grow", new Object[0]).panel((JPanel)panel2);
            feedbackBuilder.add((Component)cvIconPanel).xy(1, 1);
            this.setPanel(feedbackBuilder.build());
        } else {
            this.setPanel(dialogBuilder.build());
        }
        bufferedPortNameModel.addValueChangeListener(evt -> this.triggerValidation());
        if (this.switchOffTimeConverterModel != null) {
            this.switchOffTimeConverterModel.addValueChangeListener(evt -> this.triggerValidation());
        }
        if (this.selectionHolderLoadType != null) {
            this.selectionHolderLoadType.addValueChangeListener(evt -> this.triggerValidation());
        }
        this.enableComponents();
        this.triggerValidation();
        this.getPanel().setFocusCycleRoot(true);
        this.getPanel().setFocusTraversalPolicy(this.createFocusTransversalPolicy(order));
        return this.getPanel();
    }

    public void requestDefaultFocus() {
        this.portName.requestFocusInWindow();
    }

    protected void propertyChanged(PropertyChangeEvent evt) {
        LOGGER.info("The port property has been changed, propertyName: {}, new value: {}", (Object)evt.getPropertyName(), evt.getNewValue());
        super.propertyChanged(evt);
        SwingUtilities.invokeLater(() -> {
            try {
                switch (evt.getPropertyName()) {
                    case "status": 
                    case "portStatus": {
                        this.updatePortStatusFromOriginalPort();
                        break;
                    }
                    case "portConfigChanged": {
                        break;
                    }
                    case "portTypeChanged": {
                        LOGGER.info("The port type has changed: {}", evt.getNewValue());
                        if (((SwitchPairPort)this.getOriginalPort()).getPortType() != LcOutputType.SWITCHPAIRPORT) break;
                        LOGGER.info("Current port type is SWITCHPAIRPORT.");
                        this.updatePortStatusFromOriginalPort();
                        this.enableComponents();
                        break;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Update the status failed.", (Throwable)ex);
            }
        });
    }

    private void updatePortStatusFromOriginalPort() {
        AbstractValueModel selectionHolderPortStatus = this.getPresentationModel().getModel("status");
        SwitchPortStatus status = (SwitchPortStatus)((SwitchPairPort)this.getOriginalPort()).getStatus();
        LOGGER.info("Current status of original port: {}", (Object)status);
        selectionHolderPortStatus.setValue((Object)status);
        if (this.comboPortStatus != null) {
            SwitchPortStatus oppositeStatus = (SwitchPortStatus)PortUtils.getOppositeStatus((BidibStatus)((SwitchPortStatus)selectionHolderPortStatus.getValue()));
            LOGGER.info("Set the opposite status in the port status selection: {}", (Object)oppositeStatus);
            this.comboPortStatus.setSelectedItem(oppositeStatus);
        }
    }

    protected ValidationResult validate(SwitchPairPort port) {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.getPresentationModel(), "validation");
        if (this.switchOffTimeConverterModel != null && this.switchOffTimeConverterModel.getValue() == null) {
            support.addError("switchOffTime_key", "not_empty_for_write");
        } else if (this.switchOffTimeText != null && this.switchOffTimeText.isShowHint()) {
            support.add(Severity.INFO, "switchOffTime_key", "validRange;0..255");
        }
        if (this.selectionHolderLoadType != null && this.selectionHolderLoadType.getValue() == null) {
            support.addError("loadType_key", "not_empty_for_write");
        }
        ValidationResult validationResult = support.getResult();
        return validationResult;
    }

    private void sendStatusToPort(SwitchPairPort port, SwitchPortStatus portStatus) {
        LOGGER.info("Send the new portStatus to the port: {}", (Object)portStatus);
        this.triggerValidation();
        SwitchPairPort switchPairPort = (SwitchPairPort)SwitchPairPort.builder().withStatus((BidibStatus)portStatus).withId(port.getId()).build();
        this.getValueCallback().accept(switchPairPort);
    }

    protected void doEnableComponents(SwitchPairPort port) {
        boolean enabled = port.isEnabled();
        this.portName.setEnabled(enabled);
        if (this.comboLoadType != null) {
            this.comboLoadType.setEnabled(enabled);
        }
        if (this.switchOffTimeText != null) {
            this.switchOffTimeText.setEnabled(enabled);
        }
        this.comboPortStatus.setEnabled(enabled);
        this.btnPortStatus.setEnabled(enabled);
    }

    private /* synthetic */ void lambda$doCreateComponent$4(ValueModel portStatusHolder, ActionEvent evt) {
        SwitchPortStatus portStatus = (SwitchPortStatus)portStatusHolder.getValue();
        LOGGER.info("The port status has been changed: {}", (Object)portStatus);
        this.statusEventSubject.onNext((Object)portStatus);
    }
}

