/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.view.panel;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang3.BooleanUtils;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.CvUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.validation.PropertyValidationI18NSupport;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.pom.model.CurrentAddressBeanModel;
import org.bidib.wizard.mvc.pom.model.PomProgrammerModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.RailcomProgBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomOperationCommand;
import org.bidib.wizard.mvc.pom.model.command.PomRailcomConfigCommand;
import org.bidib.wizard.mvc.pom.view.panel.AbstractPomPanel;
import org.bidib.wizard.mvc.pom.view.panel.PomValidationResultModel;

public class RailcomPanel
extends AbstractPomPanel<RailcomProgBeanModel> {
    private ValueModel channel1ValueModel;
    private ValueModel channel2ValueModel;
    private ValueModel channelUsageValueModel;
    private ValueModel railcomPlusValueModel;
    private RailcomProgBeanModel railcomProgBeanModel;
    private PomValidationResultModel railcomValidationModel;
    private Icon infoIcon = ImageUtils.createImageIcon(RailcomPanel.class, (String)"/icons/information.png");
    private JComponent[] components;

    public RailcomPanel(PomProgrammerModel cvProgrammerModel, CurrentAddressBeanModel currentAddressBeanModel) {
        super(cvProgrammerModel, currentAddressBeanModel);
        this.railcomProgBeanModel = new RailcomProgBeanModel();
        this.setProgCommandAwareBeanModel(this.railcomProgBeanModel);
    }

    @Override
    protected void postConstruct() {
        if (this.currentAddressBeanModel.getDccAddress() != null) {
            this.LOGGER.info("The address is available already. Trigger the validation.");
            this.triggerValidation();
        }
    }

    @Override
    protected void createWorkerPanel(FormBuilder builder, int[] rowHolder, PomValidationResultModel parentValidationModel) {
        int row = rowHolder[0];
        builder.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"railcom-message"))).xyw(1, row, 7);
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"railcom-activate-info"), this.infoIcon, 10)).xyw(1, row += 2, 7);
        this.channel1ValueModel = new PropertyAdapter((Object)this.railcomProgBeanModel, "channel1", true);
        JCheckBox checkChannel1 = WizardComponentFactory.createCheckBox((ValueModel)this.channel1ValueModel, (String)Resources.getString(this.getClass(), (String)"channel1"));
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add((Component)checkChannel1).xyw(1, row += 2, 7);
        this.channel2ValueModel = new PropertyAdapter((Object)this.railcomProgBeanModel, "channel2", true);
        JCheckBox checkChannel2 = WizardComponentFactory.createCheckBox((ValueModel)this.channel2ValueModel, (String)Resources.getString(this.getClass(), (String)"channel2"));
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add((Component)checkChannel2).xyw(1, row += 2, 7);
        this.channelUsageValueModel = new PropertyAdapter((Object)this.railcomProgBeanModel, "channelUsage", true);
        JCheckBox checkChannelUsage = WizardComponentFactory.createCheckBox((ValueModel)this.channelUsageValueModel, (String)Resources.getString(this.getClass(), (String)"channelUsage"));
        checkChannelUsage.setToolTipText(Resources.getString(this.getClass(), (String)"channelUsage.tooltip"));
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add((Component)checkChannelUsage).xyw(1, row += 2, 7);
        this.railcomPlusValueModel = new PropertyAdapter((Object)this.railcomProgBeanModel, "railcomPlus", true);
        JCheckBox checkRailcomPlus = WizardComponentFactory.createCheckBox((ValueModel)this.railcomPlusValueModel, (String)Resources.getString(this.getClass(), (String)"railcomplus"));
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add((Component)checkRailcomPlus).xyw(1, row += 2, 7);
        ValidationComponentUtils.setMessageKey((JComponent)checkRailcomPlus, (Object)"validation.railcomplus_key");
        this.components = new JComponent[4];
        this.components[0] = checkChannel1;
        this.components[1] = checkChannel2;
        this.components[2] = checkChannelUsage;
        this.components[3] = checkRailcomPlus;
        this.railcomValidationModel = new PomValidationResultModel(parentValidationModel);
        this.railcomProgBeanModel.addPropertyChangeListener("railcomPlus", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RailcomPanel.this.LOGGER.debug("RailCom+ has changed: {}", (Object)RailcomPanel.this.railcomProgBeanModel.isRailcomPlus());
                RailcomPanel.this.triggerValidation();
            }
        });
        this.railcomProgBeanModel.addPropertyChangeListener("channel2", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RailcomPanel.this.LOGGER.debug("Channel2 has changed: {}", (Object)RailcomPanel.this.railcomProgBeanModel.isChannel2());
                RailcomPanel.this.triggerValidation();
            }
        });
        this.readButtonEnabled = new ValueHolder(false);
        this.readButton.setEnabled(false);
        this.readButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RailcomPanel.this.fireRead();
            }
        });
        this.writeButtonEnabled = new ValueHolder(false);
        this.writeButton.setEnabled(false);
        this.writeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RailcomPanel.this.fireWrite();
            }
        });
        JPanel progActionButtons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.readButton, this.writeButton}).build();
        builder.appendRows("p, 3dlu", new Object[0]);
        builder.add((Component)progActionButtons).xyw(1, row += 2, 7);
        rowHolder[0] = row;
    }

    @Override
    protected Object getCurrentOperation() {
        return this.railcomProgBeanModel.getCurrentOperation();
    }

    @Override
    protected ValidationResultModel getValidationResultModel() {
        return this.railcomValidationModel;
    }

    private ValidationResult validate() {
        PropertyValidationI18NSupport support = new PropertyValidationI18NSupport((Object)this.railcomValidationModel, "validation");
        if (BooleanUtils.isTrue((Boolean)((Boolean)this.railcomPlusValueModel.getValue())) && BooleanUtils.isFalse((Boolean)((Boolean)this.channel2ValueModel.getValue()))) {
            support.addError("railcomplus_key", "channel2_required");
        }
        ValidationResult validationResult = support.getResult();
        this.LOGGER.info("Prepared validationResult: {}", (Object)validationResult);
        return validationResult;
    }

    @Override
    protected void triggerValidation() {
        ValidationResult validationResult = this.validate();
        this.railcomValidationModel.setResult(validationResult);
        this.LOGGER.debug("Set the writeButtonEnabled, validStateNoWarnOrErrors: {}, validState: {}", (Object)this.railcomValidationModel.getValidStateNoWarnOrErrors(), (Object)this.railcomValidationModel.getValidState());
        this.writeButtonEnabled.setValue((Object)this.railcomValidationModel.getValidState());
        this.readButtonEnabled.setValue((Object)this.railcomValidationModel.getValidState());
    }

    @Override
    protected void disableInputElements() {
        for (JComponent comp : this.components) {
            comp.setEnabled(false);
        }
        super.disableInputElements();
    }

    @Override
    protected void enableInputElements() {
        for (JComponent comp : this.components) {
            comp.setEnabled(true);
        }
        this.triggerValidation();
    }

    private void fireWrite() {
        this.disableInputElements();
        this.railcomProgBeanModel.getExecutedProgCommands().clear();
        List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = this.railcomProgBeanModel.getProgCommands();
        progCommands.clear();
        PomAddressData addressData = new PomAddressData(this.currentAddressBeanModel.getDccAddress().intValue(), this.currentAddressBeanModel.getAddressType());
        progCommands.add(new PomRailcomConfigCommand(addressData, PomOperation.WR_BIT, 28, CvUtils.preparePomBitCvValue((int)0, (int)(Boolean.TRUE.equals(this.channel1ValueModel.getValue()) ? 1 : 0))));
        progCommands.add(new PomRailcomConfigCommand(addressData, PomOperation.WR_BIT, 28, CvUtils.preparePomBitCvValue((int)1, (int)(Boolean.TRUE.equals(this.channel2ValueModel.getValue()) ? 1 : 0))));
        progCommands.add(new PomRailcomConfigCommand(addressData, PomOperation.WR_BIT, 28, CvUtils.preparePomBitCvValue((int)2, (int)(Boolean.TRUE.equals(this.channelUsageValueModel.getValue()) ? 1 : 0))));
        progCommands.add(new PomRailcomConfigCommand(addressData, PomOperation.WR_BIT, 28, CvUtils.preparePomBitCvValue((int)7, (int)(Boolean.TRUE.equals(this.railcomPlusValueModel.getValue()) ? 1 : 0))));
        this.startTimeoutControl(1000);
        this.fireNextCommand();
    }

    private void fireRead() {
        this.disableInputElements();
        this.railcomProgBeanModel.getExecutedProgCommands().clear();
        List<PomOperationCommand<? extends ProgCommandAwareBeanModel>> progCommands = this.railcomProgBeanModel.getProgCommands();
        progCommands.clear();
        PomAddressData addressData = new PomAddressData(this.currentAddressBeanModel.getDccAddress().intValue(), this.currentAddressBeanModel.getAddressType());
        progCommands.add(new PomRailcomConfigCommand(addressData, PomOperation.RD_BYTE, 28, ByteUtils.getLowByte((int)0)));
        this.startTimeoutControl(1000);
        this.fireNextCommand();
    }
}

