/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.view.panel;

import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.common.CommPort;
import org.bidib.wizard.api.model.common.NetBidibServiceInfo;
import org.bidib.wizard.api.model.common.PreferencesPortType;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.common.model.settings.ConnectionConfiguration;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.mvc.preferences.model.PreferencesModel;
import org.bidib.wizard.mvc.preferences.view.panel.MiscSettingsPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPanel
extends AbstractSettingsPanel<GlobalSettingsInterface> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "top:pref, 8dlu, top:pref, 8dlu, top:pref, 8dlu, top:pref, 8dlu, pref";
    private final PreferencesModel model;
    private final GlobalSettingsInterface globalSettings;
    private CommPortRadioPanel commPortRadioPanel;
    private SpeedometerPanel speedometerPanel;
    private NetBidibPanel netBidibPanel;
    private SerialOverTcpPortRadioPanel serialOverTcpPortRadioPanel;
    private JLabel labelSerial;
    private JLabel labelSerialOverTcp;
    private JLabel labelNetBidib;
    private JLabel labelSpeedometer;
    private JPanel contentPanel;
    private final WizardSettingsInterface wizardSettings;
    private BufferedValueModel selectedPortTypeModel;
    private BufferedValueModel previousSelectedNetBidibHostModel;
    private BufferedValueModel previousSelectedSpeedometerPortModel;
    private BufferedValueModel previousSelectedSerialOverTcpHostModel;
    private BufferedValueModel previousSelectedSerialSymLinkModel;
    private BufferedValueModel previousSelectedComPortModel;
    private BufferedValueModel previousSelectedSimulationFileNameModel;

    public ConnectionPanel(PreferencesModel model, GlobalSettingsInterface globalSettings, WizardSettingsInterface wizardSettings, Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.model = model;
        this.globalSettings = globalSettings;
        this.wizardSettings = wizardSettings;
    }

    public JPanel createPanel() {
        Object panel;
        this.labelSerial = new JLabel(Resources.getString(MiscSettingsPanel.class, (String)"serialPort") + ":");
        this.labelSerialOverTcp = new JLabel(Resources.getString(MiscSettingsPanel.class, (String)"serialOverTcpPort") + ":");
        this.labelNetBidib = new JLabel(Resources.getString(MiscSettingsPanel.class, (String)"netBidib") + ":");
        this.labelSpeedometer = new JLabel(Resources.getString(MiscSettingsPanel.class, (String)"speedometer") + ":");
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.preparePresentationModel(this.globalSettings);
        dialogBuilder.add((Component)this.labelSerial).xy(1, 1);
        JComboBox<CommPort> commPortsCombo = new JComboBox<CommPort>();
        ButtonGroup group = new ButtonGroup();
        this.commPortRadioPanel = new CommPortRadioPanel(group, commPortsCombo);
        dialogBuilder.add((Component)this.commPortRadioPanel).xy(3, 1);
        dialogBuilder.add((Component)this.labelSerialOverTcp).xy(1, 3);
        this.serialOverTcpPortRadioPanel = new SerialOverTcpPortRadioPanel(group);
        dialogBuilder.add((Component)this.serialOverTcpPortRadioPanel).xy(3, 3);
        dialogBuilder.add((Component)this.labelNetBidib).xy(1, 5);
        JComboBox<NetBidibServiceInfo> netBidibServiceInfoCombo = new JComboBox<NetBidibServiceInfo>();
        this.netBidibPanel = new NetBidibPanel(group, netBidibServiceInfoCombo);
        dialogBuilder.add((Component)this.netBidibPanel).xy(3, 5);
        dialogBuilder.add((Component)this.labelSpeedometer).xy(1, 7);
        JComboBox<CommPort> commPortsSpeedometer = new JComboBox<CommPort>();
        this.speedometerPanel = new SpeedometerPanel(group, commPortsSpeedometer);
        dialogBuilder.add((Component)this.speedometerPanel).xy(3, 7);
        this.speedometerPanel.addPeer(this.commPortRadioPanel);
        this.speedometerPanel.addPeer(this.netBidibPanel);
        this.speedometerPanel.addPeer(this.serialOverTcpPortRadioPanel);
        this.commPortRadioPanel.addPeer(this.netBidibPanel);
        this.commPortRadioPanel.addPeer(this.speedometerPanel);
        this.commPortRadioPanel.addPeer(this.serialOverTcpPortRadioPanel);
        this.netBidibPanel.addPeer(this.commPortRadioPanel);
        this.netBidibPanel.addPeer(this.speedometerPanel);
        this.netBidibPanel.addPeer(this.serialOverTcpPortRadioPanel);
        this.serialOverTcpPortRadioPanel.addPeer(this.commPortRadioPanel);
        this.serialOverTcpPortRadioPanel.addPeer(this.speedometerPanel);
        this.serialOverTcpPortRadioPanel.addPeer(this.netBidibPanel);
        this.setCommPorts(commPortsCombo);
        this.setCommPortsSpeedometer(commPortsSpeedometer);
        this.setNetBidibServices(netBidibServiceInfoCombo);
        this.commPortRadioPanel.setEnabled(this.globalSettings.isSerialPortsEnabled());
        this.speedometerPanel.setEnabled(this.globalSettings.isSpeedometerEnabled());
        this.netBidibPanel.setEnabled(this.globalSettings.isNetBidibEnabled());
        this.serialOverTcpPortRadioPanel.setEnabled(this.globalSettings.isSerialOverTcpEnabled());
        this.commPortRadioPanel.setInitialValues(this.globalSettings);
        this.speedometerPanel.setInitialValues(this.globalSettings);
        this.netBidibPanel.setInitialValues(this.globalSettings);
        this.serialOverTcpPortRadioPanel.setInitialValues(this.globalSettings);
        this.selectedPortTypeModel = this.presentationModel.getBufferedModel("selectedPortType");
        this.previousSelectedNetBidibHostModel = this.presentationModel.getBufferedModel("previousSelectedNetBidibHost");
        this.previousSelectedSpeedometerPortModel = this.presentationModel.getBufferedModel("previousSelectedSpeedometerPort");
        this.previousSelectedSerialOverTcpHostModel = this.presentationModel.getBufferedModel("previousSelectedSerialOverTcpHost");
        this.previousSelectedSerialSymLinkModel = this.presentationModel.getBufferedModel("previousSelectedSerialSymLink");
        this.previousSelectedComPortModel = this.presentationModel.getBufferedModel("previousSelectedComPort");
        this.previousSelectedSimulationFileNameModel = this.presentationModel.getBufferedModel("previousSelectedSimulationFileName");
        if (this.selectedPortTypeModel.getValue() != null) {
            PreferencesPortType selectedPortType = (PreferencesPortType)this.selectedPortTypeModel.getValue();
            switch (selectedPortType.getConnectionPortType()) {
                case SerialPort: 
                case SerialSymLink: 
                case SerialSimulation: {
                    this.commPortRadioPanel.select(selectedPortType);
                    break;
                }
                case NetBidibClient: {
                    this.netBidibPanel.select(selectedPortType);
                    break;
                }
                case SerialOverTcp: 
                case SerialOverTcpSimulation: {
                    this.serialOverTcpPortRadioPanel.select(selectedPortType);
                    break;
                }
                default: {
                    PreferencesPortType speedometerPortType = PreferencesPortType.getValue((String)(PreferencesPortType.ConnectionPortType.Speedometer.name() + ":" + this.globalSettings.getPreviousSelectedSpeedometerPort()));
                    this.speedometerPanel.select(speedometerPortType);
                }
            }
        }
        this.model.addPropertyChangeListener(event -> {
            switch (event.getPropertyName()) {
                case "detectedNetBidibServices": {
                    this.setNetBidibServices(netBidibServiceInfoCombo);
                    break;
                }
                case "commPorts": {
                    this.setCommPorts(commPortsCombo);
                    break;
                }
            }
        });
        this.contentPanel = dialogBuilder.build();
        this.contentPanel.setOpaque(false);
        return this.contentPanel;
    }

    private void fireSelectedPortTypeChanged(PreferencesPortType portType) {
        LOGGER.info("Selected port type has changed: {}", (Object)portType);
        if (this.selectedPortTypeModel != null) {
            this.selectedPortTypeModel.setValue((Object)portType);
        }
    }

    private void setCommPorts(JComboBox<CommPort> commPortsCombo) {
        LinkedHashSet<CommPort> commPorts = new LinkedHashSet<CommPort>();
        CommPort activeCommPort = null;
        String activeCommPortName = null;
        PreferencesPortType portType = ConnectionConfiguration.toPreferencesPortType((List)this.globalSettings.getConnectionConfigurations(), (String)"main");
        if (portType != null && PreferencesPortType.ConnectionPortType.SerialPort.equals((Object)portType.getConnectionPortType())) {
            activeCommPortName = this.extractPortName(portType.getConnectionName());
            if ("null".equals(activeCommPortName)) {
                activeCommPortName = null;
            }
            LOGGER.debug("The activeCommPortName: {}", (Object)activeCommPortName);
        } else if (StringUtils.isNotBlank((CharSequence)this.globalSettings.getPreviousSelectedComPort())) {
            activeCommPortName = this.extractPortName(this.globalSettings.getPreviousSelectedComPort());
            if ("null".equals(activeCommPortName)) {
                activeCommPortName = null;
            }
            LOGGER.debug("The activeCommPortName: {}", (Object)activeCommPortName);
        }
        for (CommPort commPort : this.model.getAvailableCommPorts()) {
            commPorts.add(commPort);
            if (SystemUtils.IS_OS_WINDOWS) {
                if (activeCommPortName == null || !activeCommPortName.startsWith(commPort.getName())) continue;
                activeCommPort = commPort;
                continue;
            }
            if (activeCommPortName == null || !activeCommPortName.equals(commPort.getName())) continue;
            activeCommPort = commPort;
        }
        LOGGER.debug("Add empty item if someone wants to release the port.");
        CommPort commPortNone = new CommPort("<none>");
        commPorts.add(commPortNone);
        commPortsCombo.setModel(new DefaultComboBoxModel<CommPort>(commPorts.toArray(new CommPort[0])));
        if (activeCommPort != null) {
            LOGGER.debug("Select the active commport: {}", (Object)activeCommPort);
            this.commPortRadioPanel.setSelectedPort(activeCommPort);
        } else if (StringUtils.isNotBlank((CharSequence)activeCommPortName) && !"<none>".equals(activeCommPortName)) {
            LOGGER.debug("Set the active symlink: {}", (Object)activeCommPortName);
            this.commPortRadioPanel.setSymlink(activeCommPortName);
        } else {
            LOGGER.debug("Select <none> item because no default active port is set.");
            this.commPortRadioPanel.setSelectedPort(commPortNone);
        }
    }

    private void setCommPortsSpeedometer(JComboBox<CommPort> commPortsCombo) {
        LinkedHashSet<CommPort> commPorts = new LinkedHashSet<CommPort>();
        CommPort activeCommPort = null;
        String activeCommPortName = null;
        PreferencesPortType portType = ConnectionConfiguration.toPreferencesPortType((List)this.globalSettings.getConnectionConfigurations(), (String)"main");
        if (portType != null && PreferencesPortType.ConnectionPortType.Speedometer.equals((Object)portType.getConnectionPortType())) {
            activeCommPortName = this.extractPortName(portType.getConnectionName());
            if ("null".equals(activeCommPortName)) {
                activeCommPortName = null;
            }
            LOGGER.debug("The activeCommPortName: {}", (Object)activeCommPortName);
        } else if (StringUtils.isNotBlank((CharSequence)this.globalSettings.getPreviousSelectedSpeedometerPort())) {
            activeCommPortName = this.extractPortName(this.globalSettings.getPreviousSelectedSpeedometerPort());
            if ("null".equals(activeCommPortName)) {
                activeCommPortName = null;
            }
            LOGGER.debug("The activeCommPortName: {}", (Object)activeCommPortName);
        }
        for (CommPort commPort : this.model.getAvailableCommPorts()) {
            commPorts.add(commPort);
            if (activeCommPortName == null || !activeCommPortName.equals(commPort.getName())) continue;
            activeCommPort = commPort;
        }
        LOGGER.debug("Add empty item if someone wants to release the port.");
        CommPort commPortNone = new CommPort("<none>");
        commPorts.add(commPortNone);
        commPortsCombo.setModel(new DefaultComboBoxModel<CommPort>(commPorts.toArray(new CommPort[0])));
        if (activeCommPort != null) {
            LOGGER.debug("Select the active commport: {}", (Object)activeCommPort);
            this.speedometerPanel.setSelectedPort(activeCommPort);
        } else {
            LOGGER.debug("Select <none> item because no default active port is set.");
            this.speedometerPanel.setSelectedPort(commPortNone);
        }
    }

    private void setNetBidibServices(JComboBox<NetBidibServiceInfo> netBidibServiceInfoCombo) {
        PreferencesPortType portType = ConnectionConfiguration.toPreferencesPortType((List)this.globalSettings.getConnectionConfigurations(), (String)"main");
        String activeNetBidibServiceName = null;
        if (portType != null && PreferencesPortType.ConnectionPortType.NetBidibClient.equals((Object)portType.getConnectionPortType())) {
            activeNetBidibServiceName = this.extractPortName(portType.getConnectionName());
            if ("null".equals(activeNetBidibServiceName)) {
                activeNetBidibServiceName = null;
            }
            LOGGER.debug("The activeNetBidibServiceName: {}", (Object)activeNetBidibServiceName);
        } else if (StringUtils.isNotBlank((CharSequence)this.globalSettings.getPreviousSelectedNetBidibHost())) {
            activeNetBidibServiceName = this.extractPortName(this.globalSettings.getPreviousSelectedNetBidibHost());
            if ("null".equals(activeNetBidibServiceName)) {
                activeNetBidibServiceName = null;
            }
            LOGGER.debug("The activeNetBidibServiceName: {}", (Object)activeNetBidibServiceName);
        }
        LinkedHashSet<NetBidibServiceInfo> netBidibServices = new LinkedHashSet<NetBidibServiceInfo>();
        Set<NetBidibServiceInfo> detectedNetBidibServices = this.model.getDetectedNetBidibServices();
        LOGGER.info("Detected netBidib services: {}", detectedNetBidibServices);
        NetBidibServiceInfo activeServiceInfo = null;
        for (NetBidibServiceInfo si : detectedNetBidibServices) {
            netBidibServices.add(si);
            if (activeNetBidibServiceName == null || !activeNetBidibServiceName.equals(si.getQualifiedName())) continue;
            activeServiceInfo = si;
        }
        NetBidibServiceInfo serviceInfoNone = new NetBidibServiceInfo("<none>");
        netBidibServices.add(serviceInfoNone);
        netBidibServiceInfoCombo.setModel(new DefaultComboBoxModel<NetBidibServiceInfo>(netBidibServices.toArray(new NetBidibServiceInfo[0])));
        if (activeServiceInfo != null) {
            LOGGER.debug("Select the active service info: {}", (Object)activeServiceInfo);
            this.netBidibPanel.setSelectedService(activeServiceInfo);
        } else {
            LOGGER.debug("Select <none> item because no default active port is set.");
            this.netBidibPanel.setSelectedService(serviceInfoNone);
        }
    }

    private String extractPortName(String connectionUri) {
        return connectionUri;
    }

    private class CommPortRadioPanel
    extends JPanel
    implements PortRadioPanel {
        private static final long serialVersionUID = 1L;
        private JComboBox<CommPort> commPortsCombo;
        private JTextField textFieldSerialSymLink;
        private JLabel labelSerialMock;
        private JRadioButton comboButton;
        private JRadioButton textFieldButton;
        private JRadioButton serialMockButton;
        private final JTextField simulationFileName;
        private List<PortRadioPanel> peer;
        private static final String WORKING_DIR_SIMULATION_KEY = "simulation";

        public void addPeer(PortRadioPanel peer) {
            this.peer.add(peer);
        }

        public CommPortRadioPanel(ButtonGroup group, JComboBox<CommPort> commPortsCombo) {
            super(new GridBagLayout());
            this.peer = new ArrayList<PortRadioPanel>();
            this.setOpaque(false);
            super.setEnabled(false);
            this.commPortsCombo = commPortsCombo;
            this.comboButton = new JRadioButton("");
            this.comboButton.setContentAreaFilled(false);
            this.textFieldButton = new JRadioButton("");
            this.textFieldButton.setContentAreaFilled(false);
            this.serialMockButton = new JRadioButton("");
            this.serialMockButton.setContentAreaFilled(false);
            group.add(this.comboButton);
            group.add(this.textFieldButton);
            group.add(this.serialMockButton);
            this.textFieldSerialSymLink = new JTextField(20);
            this.textFieldSerialSymLink.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.setText();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.setText();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.setText();
                }

                private void setText() {
                    if (CommPortRadioPanel.this.textFieldButton.isSelected()) {
                        PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialSymLink.name());
                        portType.setConnectionName(CommPortRadioPanel.this.textFieldSerialSymLink.getText());
                        ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                    }
                    if (ConnectionPanel.this.previousSelectedSerialSymLinkModel != null) {
                        ConnectionPanel.this.previousSelectedSerialSymLinkModel.setValue((Object)CommPortRadioPanel.this.textFieldSerialSymLink.getText());
                    }
                }
            });
            this.commPortsCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommPort commPort = (CommPort)CommPortRadioPanel.this.commPortsCombo.getSelectedItem();
                    LOGGER.debug("The selection of the comm port has changed: {}", (Object)commPort);
                    if (commPort != null && !"<none>".equals(commPort.getName())) {
                        LOGGER.info("The COM port was selected, auto select the COM port radio button.");
                        CommPortRadioPanel.this.comboButton.setSelected(true);
                    }
                    if (CommPortRadioPanel.this.comboButton.isSelected()) {
                        PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialPort.name());
                        portType.setConnectionName(commPort != null ? commPort.getName() : "");
                        portType.setSerialNumber(commPort != null ? commPort.getSerialNumber() : null);
                        LOGGER.info("Selectced port: {}", (Object)portType);
                        ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                    }
                    if (ConnectionPanel.this.previousSelectedComPortModel != null) {
                        ConnectionPanel.this.previousSelectedComPortModel.setValue((Object)(commPort != null ? commPort.getName() : ""));
                    }
                }
            });
            this.simulationFileName = new JTextField();
            this.simulationFileName.getDocument().addDocumentListener(new DefaultDocumentListener(){

                @Override
                protected void valueChanged() {
                    LOGGER.info("The simulation filename has changed: {}", (Object)CommPortRadioPanel.this.simulationFileName.getText());
                    if (ConnectionPanel.this.previousSelectedSimulationFileNameModel != null) {
                        ConnectionPanel.this.previousSelectedSimulationFileNameModel.setValue((Object)CommPortRadioPanel.this.simulationFileName.getText());
                    }
                    PreferencesPortType portType = CommPortRadioPanel.this.prepareSimulationPortType(CommPortRadioPanel.this.simulationFileName);
                    ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                }
            });
            this.labelSerialMock = new JLabel(Resources.getString(MiscSettingsPanel.class, (String)"serialMock"));
            this.labelSerialMock.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    CommPortRadioPanel.this.serialMockButton.setSelected(true);
                    PreferencesPortType portType = CommPortRadioPanel.this.prepareSimulationPortType(CommPortRadioPanel.this.simulationFileName);
                    ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                }
            });
            this.comboButton.addActionListener(this);
            this.textFieldButton.addActionListener(this);
            this.serialMockButton.addActionListener(this);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 0, 5, 0);
            this.add((Component)this.comboButton, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridwidth = 3;
            this.add(this.commPortsCombo, gbc);
            gbc.gridwidth = 1;
            gbc = new GridBagConstraints();
            gbc.gridy = 1;
            gbc.insets = new Insets(0, 0, 5, 0);
            this.add((Component)this.textFieldButton, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 0, 5, 5);
            this.add((Component)new JLabel("Symlink"), gbc);
            gbc.insets = new Insets(0, 0, 5, 0);
            gbc.gridx = 2;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            this.add((Component)this.textFieldSerialSymLink, gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 2;
            this.add((Component)this.serialMockButton, gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 2;
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 0, 0, 5);
            this.add((Component)this.labelSerialMock, gbc);
            gbc.gridx = 2;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 5);
            this.add((Component)this.simulationFileName, gbc);
            JButton selectSimulationButton = new JButton(Resources.getString(ConnectionPanel.class, (String)"select-simulation"));
            selectSimulationButton.setToolTipText(Resources.getString(ConnectionPanel.class, (String)"select-simulation.tooltip"));
            selectSimulationButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SimulationFileFilter ffXmlJson = new SimulationFileFilter("(json|xml)", ".+\\.(json|xml)$", "*.xml, *.json");
                    SimulationFileFilter ffXml = new SimulationFileFilter("xml", ".+\\.xml$", "*.xml");
                    SimulationFileFilter ffJson = new SimulationFileFilter("json", ".+\\.json$", "*.json");
                    String storedWorkingDirectory = ConnectionPanel.this.wizardSettings.getWorkingDirectory(CommPortRadioPanel.WORKING_DIR_SIMULATION_KEY);
                    FileDialog dialog = new FileDialog(ConnectionPanel.this.contentPanel, 0, storedWorkingDirectory, null, new FileFilter[]{ffXmlJson, ffXml, ffJson}){

                        public void approve(String fileName) {
                            File file = new File(fileName);
                            String selectedFile = file.getPath();
                            LOGGER.info("The selected simulation file: {}", (Object)selectedFile);
                            CommPortRadioPanel.this.simulationFileName.setText(selectedFile);
                            String workingDir = Paths.get(fileName, new String[0]).getParent().toString();
                            LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                            ConnectionPanel.this.wizardSettings.setWorkingDirectory(CommPortRadioPanel.WORKING_DIR_SIMULATION_KEY, workingDir);
                        }
                    };
                    dialog.showDialog();
                }
            });
            gbc.gridx = 3;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.add((Component)selectSimulationButton, gbc);
        }

        private void setSelectedPort(CommPort commPort) {
            this.commPortsCombo.setSelectedItem(commPort);
            this.actionPerformed(null);
        }

        private void setSymlink(String symlink) {
            this.textFieldSerialSymLink.setText(symlink);
            this.actionPerformed(null);
        }

        private PreferencesPortType prepareSimulationPortType(JTextField simulationFileName) {
            PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialSimulation.name());
            String simulationFilename = simulationFileName.getText();
            portType.setConnectionName(simulationFilename);
            LOGGER.info("Use the simulationFilename: {}", (Object)simulationFilename);
            return portType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.commPortsCombo.setEnabled(this.comboButton.isEnabled());
            this.textFieldSerialSymLink.setEnabled(this.textFieldButton.isEnabled());
            this.labelSerialMock.setEnabled(this.serialMockButton.isEnabled());
            if (e != null && (e.getSource() == this.comboButton || e.getSource() == this.textFieldButton || e.getSource() == this.serialMockButton) && this.peer != null && CollectionUtils.isNotEmpty(this.peer)) {
                LOGGER.trace("Update peers from commPort.");
                for (PortRadioPanel p : this.peer) {
                    p.actionPerformed(e);
                }
            }
            if (e != null) {
                PreferencesPortType portType;
                if (e.getSource() == this.serialMockButton) {
                    portType = this.prepareSimulationPortType(this.simulationFileName);
                    ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                } else if (e.getSource() == this.comboButton) {
                    portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialPort.name());
                    portType.setConnectionName(this.commPortsCombo.getSelectedItem() != null ? this.commPortsCombo.getSelectedItem().toString() : null);
                    ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                } else if (e.getSource() == this.textFieldButton) {
                    portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialSymLink.name());
                    portType.setConnectionName(this.textFieldSerialSymLink.getText());
                    ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                }
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            boolean old = this.isEnabled();
            if (old != enabled) {
                super.setEnabled(enabled);
                this.comboButton.setEnabled(enabled);
                this.textFieldButton.setEnabled(enabled);
                this.serialMockButton.setEnabled(enabled);
                this.actionPerformed(null);
                if (!enabled && (this.serialMockButton.isSelected() || this.textFieldButton.isSelected() || this.comboButton.isSelected()) && CollectionUtils.isNotEmpty(this.peer)) {
                    for (PortRadioPanel p : this.peer) {
                        p.selectDefault();
                    }
                }
            }
        }

        @Override
        public void selectDefault() {
            this.serialMockButton.setSelected(true);
            PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialSimulation.name());
            ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
        }

        public void setInitialValues(GlobalSettingsInterface model) {
            this.textFieldSerialSymLink.setText(model.getPreviousSelectedSerialSymLink());
            this.simulationFileName.setText(model.getPreviousSelectedSimulationFileName());
        }

        public void select(PreferencesPortType portType) {
            LOGGER.info("Selected the portType: {}", (Object)portType);
            switch (portType.getConnectionPortType()) {
                case SerialPort: {
                    this.comboButton.setSelected(true);
                    break;
                }
                case SerialSymLink: {
                    this.textFieldButton.setSelected(true);
                    this.textFieldSerialSymLink.setText(portType.getConnectionName());
                    break;
                }
                default: {
                    this.serialMockButton.setSelected(true);
                    this.simulationFileName.setText(portType.getConnectionName());
                }
            }
        }
    }

    private class SerialOverTcpPortRadioPanel
    extends JPanel
    implements PortRadioPanel {
        private static final long serialVersionUID = 1L;
        public static final String DEFAULT_TCP_PORT = "62800";
        public static final String DEFAULT_TCP_HOST = "localhost";
        private JTextField textField;
        private JTextField portTextField;
        private JLabel labelSerialOverTcpMock;
        private JRadioButton textFieldButton;
        private JRadioButton serialOverTcpMockButton;
        private List<PortRadioPanel> peer;

        public void addPeer(PortRadioPanel peer) {
            this.peer.add(peer);
        }

        public SerialOverTcpPortRadioPanel(ButtonGroup group) {
            super(new GridBagLayout());
            this.peer = new ArrayList<PortRadioPanel>();
            this.setOpaque(false);
            super.setEnabled(false);
            this.textFieldButton = new JRadioButton("");
            this.textFieldButton.setContentAreaFilled(false);
            this.serialOverTcpMockButton = new JRadioButton("");
            this.serialOverTcpMockButton.setContentAreaFilled(false);
            group.add(this.textFieldButton);
            group.add(this.serialOverTcpMockButton);
            this.textField = new JTextField(20);
            this.portTextField = new JTextField(5);
            this.portTextField.setText(DEFAULT_TCP_PORT);
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.setText();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.setText();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.setText();
                }

                private void setText() {
                    if (SerialOverTcpPortRadioPanel.this.textFieldButton.isSelected()) {
                        PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialOverTcp.name());
                        String host = StringUtils.isNotBlank((CharSequence)SerialOverTcpPortRadioPanel.this.textField.getText()) ? SerialOverTcpPortRadioPanel.this.textField.getText().trim() : SerialOverTcpPortRadioPanel.DEFAULT_TCP_HOST;
                        String port = StringUtils.isNotBlank((CharSequence)SerialOverTcpPortRadioPanel.this.portTextField.getText()) ? SerialOverTcpPortRadioPanel.this.portTextField.getText() : SerialOverTcpPortRadioPanel.DEFAULT_TCP_PORT;
                        String connectionName = String.format("%1$s:%2$s", host, port);
                        portType.setConnectionName(connectionName);
                        ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                    }
                    if (ConnectionPanel.this.previousSelectedSerialOverTcpHostModel != null) {
                        ConnectionPanel.this.previousSelectedSerialOverTcpHostModel.setValue((Object)String.format("%1$s:%2$s", SerialOverTcpPortRadioPanel.this.textField.getText(), SerialOverTcpPortRadioPanel.this.portTextField.getText()));
                    }
                }
            };
            this.textField.getDocument().addDocumentListener(documentListener);
            this.portTextField.getDocument().addDocumentListener(documentListener);
            this.labelSerialOverTcpMock = new JLabel(Resources.getString(MiscSettingsPanel.class, (String)"serialOverTcpMock"));
            this.labelSerialOverTcpMock.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SerialOverTcpPortRadioPanel.this.serialOverTcpMockButton.setSelected(true);
                    PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialOverTcpSimulation.name());
                    ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                }
            });
            this.textFieldButton.addActionListener(this);
            this.serialOverTcpMockButton.addActionListener(this);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 0, 5, 0);
            this.add((Component)this.textFieldButton, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.textField, gbc);
            gbc.gridx = 2;
            gbc.weightx = 0.0;
            this.add((Component)new JLabel(":"), gbc);
            gbc.gridx = 3;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.portTextField, gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 1;
            this.add((Component)this.serialOverTcpMockButton, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.labelSerialOverTcpMock, gbc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.labelSerialOverTcpMock.setEnabled(this.serialOverTcpMockButton.isEnabled());
            this.textField.setEnabled(this.textFieldButton.isEnabled());
            this.portTextField.setEnabled(this.textFieldButton.isEnabled());
            if (e != null && (e.getSource() == this.textFieldButton || e.getSource() == this.serialOverTcpMockButton) && this.peer != null && CollectionUtils.isNotEmpty(this.peer)) {
                LOGGER.trace("Update peers from plainTcpPort.");
                for (PortRadioPanel p : this.peer) {
                    p.actionPerformed(e);
                }
            }
            if (e != null) {
                PreferencesPortType portType;
                if (e.getSource() == this.serialOverTcpMockButton) {
                    portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialOverTcpSimulation.name());
                    ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                } else if (e.getSource() == this.textFieldButton) {
                    portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialOverTcp.name());
                    String connectionName = String.format("%1$s:%2$s", this.textField.getText(), this.portTextField.getText());
                    portType.setConnectionName(connectionName);
                    ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                }
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            boolean old = this.isEnabled();
            if (old != enabled) {
                super.setEnabled(enabled);
                this.textFieldButton.setEnabled(enabled);
                this.serialOverTcpMockButton.setEnabled(enabled);
                this.actionPerformed(null);
                if (!enabled && (this.serialOverTcpMockButton.isSelected() || this.textFieldButton.isSelected()) && CollectionUtils.isNotEmpty(this.peer)) {
                    for (PortRadioPanel p : this.peer) {
                        p.selectDefault();
                    }
                }
            }
        }

        @Override
        public void selectDefault() {
            this.serialOverTcpMockButton.setSelected(true);
            PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.SerialOverTcpSimulation.name());
            ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
        }

        public void setInitialValues(GlobalSettingsInterface model) {
            String prevSelectedHost = model.getPreviousSelectedSerialOverTcpHost();
            if (StringUtils.isNotBlank((CharSequence)prevSelectedHost)) {
                LOGGER.info("SerialOverTcpPortRadioPanel, current value of prevSelectedHost: {}", (Object)prevSelectedHost);
                try {
                    String[] splited = prevSelectedHost.split(":");
                    this.textField.setText(splited[0]);
                    if (splited.length > 1) {
                        this.portTextField.setText(splited[1]);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the initial values in the SerialOverTcpPortRadioPanel failed, prevSelectedHost: {}", (Object)prevSelectedHost, (Object)ex);
                }
            }
        }

        public void select(PreferencesPortType portType) {
            switch (portType.getConnectionPortType()) {
                case SerialOverTcp: {
                    this.textFieldButton.setSelected(false);
                    String prevSelectedHost = portType.getConnectionName();
                    if (StringUtils.isNotBlank((CharSequence)prevSelectedHost)) {
                        try {
                            String[] splited = prevSelectedHost.split(":");
                            this.textField.setText(splited[0]);
                            if (splited.length > 1) {
                                this.portTextField.setText(splited[1]);
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Set the selected values in the SerialOverTcpPortRadioPanel failed, prevSelectedHost: {}", (Object)prevSelectedHost, (Object)ex);
                        }
                    }
                    this.textFieldButton.setSelected(true);
                    break;
                }
                default: {
                    this.serialOverTcpMockButton.setSelected(true);
                }
            }
        }
    }

    private class NetBidibPanel
    extends JPanel
    implements PortRadioPanel {
        private static final long serialVersionUID = 1L;
        public static final String DEFAULT_TCP_PORT = "62875";
        public static final String DEFAULT_TCP_HOST = "localhost";
        private JTextField textField;
        private JTextField portTextField;
        private JRadioButton textFieldButton;
        private JRadioButton serviceInfoButton;
        private JComboBox<NetBidibServiceInfo> netBidibServiceInfoCombo;
        private List<PortRadioPanel> peer;

        public void addPeer(PortRadioPanel peer) {
            this.peer.add(peer);
        }

        public NetBidibPanel(ButtonGroup group, JComboBox<NetBidibServiceInfo> netBidibServiceInfoCombo) {
            super(new GridBagLayout());
            this.peer = new ArrayList<PortRadioPanel>();
            this.setOpaque(false);
            super.setEnabled(false);
            this.netBidibServiceInfoCombo = netBidibServiceInfoCombo;
            this.textFieldButton = new JRadioButton("");
            this.textFieldButton.setContentAreaFilled(false);
            this.serviceInfoButton = new JRadioButton("");
            this.serviceInfoButton.setContentAreaFilled(false);
            group.add(this.textFieldButton);
            group.add(this.serviceInfoButton);
            this.textField = new JTextField(20);
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.setText();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.setText();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.setText();
                }

                private void setText() {
                    if (NetBidibPanel.this.textFieldButton.isSelected()) {
                        PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.NetBidibClient.name());
                        String host = StringUtils.isNotBlank((CharSequence)NetBidibPanel.this.textField.getText()) ? NetBidibPanel.this.textField.getText().trim() : null;
                        String port = StringUtils.isNotBlank((CharSequence)NetBidibPanel.this.portTextField.getText()) ? NetBidibPanel.this.portTextField.getText().trim() : NetBidibPanel.DEFAULT_TCP_PORT;
                        String connectionName = host != null ? String.format("%1$s:%2$s", host, port) : null;
                        portType.setConnectionName(connectionName);
                        ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                    }
                    if (ConnectionPanel.this.previousSelectedNetBidibHostModel != null) {
                        if (StringUtils.isNotBlank((CharSequence)NetBidibPanel.this.textField.getText())) {
                            ConnectionPanel.this.previousSelectedNetBidibHostModel.setValue((Object)String.format("%1$s:%2$s", NetBidibPanel.this.textField.getText().trim(), NetBidibPanel.this.portTextField.getText()));
                        } else {
                            ConnectionPanel.this.previousSelectedNetBidibHostModel.setValue(null);
                        }
                    }
                }
            };
            this.textField.getDocument().addDocumentListener(documentListener);
            this.portTextField = new JTextField(5);
            this.portTextField.setText(DEFAULT_TCP_PORT);
            this.portTextField.getDocument().addDocumentListener(documentListener);
            this.textFieldButton.addActionListener(this);
            this.serviceInfoButton.addActionListener(this);
            this.netBidibServiceInfoCombo.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    if (value instanceof NetBidibServiceInfo) {
                        NetBidibServiceInfo si = (NetBidibServiceInfo)value;
                        String text = NetBidibServiceInfo.format((NetBidibServiceInfo)si, code -> Resources.getString(ConnectionPanel.class, (String)code));
                        this.setText(text);
                    }
                    return renderer;
                }
            });
            this.netBidibServiceInfoCombo.addActionListener(e -> {
                NetBidibServiceInfo netBidibServiceInfo = (NetBidibServiceInfo)this.netBidibServiceInfoCombo.getSelectedItem();
                LOGGER.debug("The selection of the netBidibServiceInfo has changed: {}", (Object)netBidibServiceInfo);
                if (netBidibServiceInfo != null) {
                    if (netBidibServiceInfo != null && !"<none>".equals(netBidibServiceInfo.getQualifiedName())) {
                        LOGGER.info("The netBidib service was selected, auto select the netBidib service radio button.");
                        this.serviceInfoButton.setSelected(true);
                    }
                    PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.NetBidibClient.name());
                    String host = netBidibServiceInfo.getAddresses() != null && netBidibServiceInfo.getAddresses().length > 0 ? netBidibServiceInfo.getAddresses()[0].getHostAddress() : null;
                    String port = String.valueOf(netBidibServiceInfo.getPort());
                    String connectionName = host != null ? String.format("%1$s:%2$s", host, port) : null;
                    portType.setConnectionName(connectionName);
                    ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                }
                if (ConnectionPanel.this.previousSelectedNetBidibHostModel != null) {
                    if (StringUtils.isNotBlank((CharSequence)this.textField.getText())) {
                        ConnectionPanel.this.previousSelectedNetBidibHostModel.setValue((Object)String.format("%1$s:%2$s", this.textField.getText().trim(), this.portTextField.getText()));
                    } else {
                        ConnectionPanel.this.previousSelectedNetBidibHostModel.setValue(null);
                    }
                }
            });
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 0, 5, 0);
            this.add((Component)this.serviceInfoButton, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.gridwidth = 3;
            this.add(this.netBidibServiceInfoCombo, gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 1;
            gbc.insets = new Insets(0, 0, 5, 0);
            this.add((Component)this.textFieldButton, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.textField, gbc);
            gbc.gridx = 2;
            gbc.weightx = 0.0;
            this.add((Component)new JLabel(":"), gbc);
            gbc.gridx = 3;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add((Component)this.portTextField, gbc);
        }

        private void setSelectedService(NetBidibServiceInfo serviceInfo) {
            this.netBidibServiceInfoCombo.setSelectedItem(serviceInfo);
            this.actionPerformed(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.textField.setEnabled(this.textFieldButton.isEnabled());
            this.portTextField.setEnabled(this.textFieldButton.isEnabled());
            if (e != null && (e.getSource() == this.textFieldButton || e.getSource() == this.serviceInfoButton) && CollectionUtils.isNotEmpty(this.peer)) {
                LOGGER.trace("Update peers from netBidibPort.");
                for (PortRadioPanel p : this.peer) {
                    p.actionPerformed(e);
                }
            }
            if (e != null) {
                PreferencesPortType portType;
                if (e.getSource() == this.textFieldButton) {
                    portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.NetBidibClient.name());
                    String host = StringUtils.isNotBlank((CharSequence)this.textField.getText()) ? this.textField.getText().trim() : null;
                    String connectionName = host != null ? String.format("%1$s:%2$s", host, this.portTextField.getText()) : null;
                    portType.setConnectionName(connectionName);
                    ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                } else if (e.getSource() == this.serviceInfoButton) {
                    portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.NetBidibClient.name());
                    NetBidibServiceInfo netBidibServiceInfo = (NetBidibServiceInfo)this.netBidibServiceInfoCombo.getSelectedItem();
                    String host = netBidibServiceInfo != null && netBidibServiceInfo.getAddresses() != null && netBidibServiceInfo.getAddresses().length > 0 ? netBidibServiceInfo.getAddresses()[0].getHostAddress() : null;
                    String port = netBidibServiceInfo != null ? String.valueOf(netBidibServiceInfo.getPort()) : null;
                    String connectionName = host != null ? String.format("%1$s:%2$s", host, port) : null;
                    portType.setConnectionName(connectionName);
                    ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                }
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            boolean old = this.isEnabled();
            if (old != enabled) {
                super.setEnabled(enabled);
                this.serviceInfoButton.setEnabled(enabled);
                this.netBidibServiceInfoCombo.setEnabled(enabled);
                this.textFieldButton.setEnabled(enabled);
                this.portTextField.setEnabled(enabled);
                this.actionPerformed(null);
                if (!enabled && (this.textFieldButton.isSelected() || this.serviceInfoButton.isSelected()) && CollectionUtils.isNotEmpty(this.peer)) {
                    for (PortRadioPanel p : this.peer) {
                        p.selectDefault();
                    }
                }
            }
        }

        @Override
        public void selectDefault() {
        }

        private NetBidibServiceInfo getSelectedServiceInfo(String host, int port) {
            DefaultComboBoxModel comboModel = (DefaultComboBoxModel)this.netBidibServiceInfoCombo.getModel();
            NetBidibServiceInfo selectedServiceInfo = null;
            for (int index = 0; index < comboModel.getSize(); ++index) {
                NetBidibServiceInfo si = (NetBidibServiceInfo)comboModel.getElementAt(index);
                if (si.getAddresses() == null || si.getAddresses().length <= 0 || !si.getAddresses()[0].getHostAddress().equals(host) || si.getPort() != port) continue;
                selectedServiceInfo = si;
                break;
            }
            return selectedServiceInfo;
        }

        public void setInitialValues(GlobalSettingsInterface model) {
            String prevSelectedHost = model.getPreviousSelectedNetBidibHost();
            if (StringUtils.isNotBlank((CharSequence)prevSelectedHost)) {
                LOGGER.info("NetBidibPanel, current value of prevSelectedHost: {}", (Object)prevSelectedHost);
                try {
                    int index = prevSelectedHost.lastIndexOf(":");
                    String[] splited = index > -1 ? new String[]{prevSelectedHost.substring(0, index), prevSelectedHost.substring(index + 1)} : new String[]{prevSelectedHost};
                    if (splited.length > 1) {
                        NetBidibServiceInfo selectedServiceInfo = this.getSelectedServiceInfo(splited[0], Integer.parseInt(splited[1]));
                        if (selectedServiceInfo != null) {
                            LOGGER.info("Found the initial selected service info: {}", (Object)selectedServiceInfo);
                            this.netBidibServiceInfoCombo.setSelectedItem(selectedServiceInfo);
                            this.serviceInfoButton.setSelected(true);
                        } else {
                            this.netBidibServiceInfoCombo.setSelectedItem(new NetBidibServiceInfo("<none>"));
                            this.serviceInfoButton.setSelected(true);
                        }
                    }
                    this.textField.setText(splited[0]);
                    if (splited.length > 1) {
                        this.portTextField.setText(splited[1]);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the initial values in the NetBidibPanel failed, prevSelectedHost: {}", (Object)prevSelectedHost, (Object)ex);
                }
            }
        }

        public void select(PreferencesPortType portType) {
            switch (portType.getConnectionPortType()) {
                case NetBidibClient: {
                    this.textFieldButton.setSelected(false);
                    this.serviceInfoButton.setSelected(false);
                    String prevSelectedHost = portType.getConnectionName();
                    if (!StringUtils.isNotBlank((CharSequence)prevSelectedHost)) break;
                    try {
                        int index = prevSelectedHost.lastIndexOf(":");
                        String[] splited = index > -1 ? new String[]{prevSelectedHost.substring(0, index), prevSelectedHost.substring(index + 1)} : new String[]{prevSelectedHost};
                        if (splited.length > 1) {
                            NetBidibServiceInfo selectedServiceInfo = this.getSelectedServiceInfo(splited[0], Integer.parseInt(splited[1]));
                            if (selectedServiceInfo != null) {
                                LOGGER.info("Found the initial selected service info: {}", (Object)selectedServiceInfo);
                                this.netBidibServiceInfoCombo.setSelectedItem(selectedServiceInfo);
                                this.serviceInfoButton.setSelected(true);
                            } else {
                                this.textFieldButton.setSelected(true);
                            }
                        }
                        this.textField.setText(splited[0]);
                        if (splited.length <= 1) break;
                        this.portTextField.setText(splited[1]);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Set the selected value in the NetBidibPanel failed, prevSelectedHost: {}", (Object)prevSelectedHost, (Object)ex);
                    }
                    break;
                }
            }
        }
    }

    private class SpeedometerPanel
    extends JPanel
    implements PortRadioPanel {
        private static final long serialVersionUID = 1L;
        private JComboBox<CommPort> commPorts;
        private JRadioButton comboButton;
        private List<PortRadioPanel> peer;

        public void addPeer(PortRadioPanel peer) {
            this.peer.add(peer);
        }

        public SpeedometerPanel(ButtonGroup group, JComboBox<CommPort> commPorts) {
            super(new GridBagLayout());
            this.peer = new ArrayList<PortRadioPanel>();
            this.setOpaque(false);
            super.setEnabled(false);
            this.commPorts = commPorts;
            this.comboButton = new JRadioButton("");
            this.comboButton.setContentAreaFilled(false);
            group.add(this.comboButton);
            this.commPorts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CommPort commPort = (CommPort)SpeedometerPanel.this.commPorts.getSelectedItem();
                    LOGGER.debug("The selection of the comm port has changed: {}", (Object)commPort);
                    if (commPort != null && !"<none>".equals(commPort.getName())) {
                        LOGGER.info("The COM port was selected, auto select the COM port radio button.");
                        SpeedometerPanel.this.comboButton.setSelected(true);
                    }
                    if (SpeedometerPanel.this.comboButton.isSelected()) {
                        PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.Speedometer.name());
                        portType.setConnectionName(commPort != null ? commPort.getName() : "");
                        LOGGER.info("Selectced port: {}", (Object)portType);
                        ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
                    }
                    if (ConnectionPanel.this.previousSelectedSpeedometerPortModel != null) {
                        ConnectionPanel.this.previousSelectedSpeedometerPortModel.setValue((Object)(commPort != null ? commPort.getName() : ""));
                    }
                }
            });
            this.comboButton.addActionListener(this);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.insets = new Insets(0, 0, 5, 0);
            this.add((Component)this.comboButton, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            this.add(commPorts, gbc);
        }

        private void setSelectedPort(CommPort commPort) {
            this.commPorts.setSelectedItem(commPort);
            this.actionPerformed(null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.commPorts.setEnabled(this.comboButton.isEnabled());
            if (e != null && e.getSource() == this.comboButton && CollectionUtils.isNotEmpty(this.peer)) {
                LOGGER.trace("Update peers from speedometerPort.");
                for (PortRadioPanel p : this.peer) {
                    p.actionPerformed(e);
                }
            }
            if (e != null && e.getSource() == this.comboButton) {
                PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.Speedometer.name());
                portType.setConnectionName(this.commPorts.getSelectedItem() != null ? this.commPorts.getSelectedItem().toString() : null);
                ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            boolean old = this.isEnabled();
            if (old != enabled) {
                super.setEnabled(enabled);
                this.comboButton.setEnabled(enabled);
                this.actionPerformed(null);
                if (!enabled && this.comboButton.isSelected() && CollectionUtils.isNotEmpty(this.peer)) {
                    for (PortRadioPanel p : this.peer) {
                        p.selectDefault();
                    }
                }
            }
        }

        @Override
        public void selectDefault() {
            PreferencesPortType portType = PreferencesPortType.getValue((String)PreferencesPortType.ConnectionPortType.Speedometer.name());
            ConnectionPanel.this.fireSelectedPortTypeChanged(portType);
        }

        public void setInitialValues(GlobalSettingsInterface globalSettings) {
        }

        public void select(PreferencesPortType portType) {
            switch (portType.getConnectionPortType()) {
                case Speedometer: {
                    this.comboButton.setSelected(true);
                    break;
                }
            }
        }
    }

    private static interface PortRadioPanel
    extends ActionListener {
        public void selectDefault();
    }

    private final class SimulationFileFilter
    extends FileFilter {
        public static final String SUFFIX_XML = "xml";
        public static final String SUFFIX_JSON = "json";
        public static final String SUFFIX_XML_JSON = "(json|xml)";
        private static final String PATTERN_XML_FILENAME = ".+\\.xml$";
        private static final String PATTERN_JSON_FILENAME = ".+\\.json$";
        private static final String PATTERN_XML_JSON_FILENAME = ".+\\.(json|xml)$";
        public static final String FILTER_DESCRIPTION_XML = "*.xml";
        public static final String FILTER_DESCRIPTION_JSON = "*.json";
        public static final String FILTER_DESCRIPTION_XML_JSON = "*.xml, *.json";
        private final String filenameSuffix;
        private final String filenamePattern;
        private final String filterDescription;

        public SimulationFileFilter(String filenameSuffix, String filenamePattern, String filterDescription) {
            this.filenameSuffix = filenameSuffix;
            this.filenamePattern = filenamePattern;
            this.filterDescription = filterDescription;
        }

        @Override
        public boolean accept(File file) {
            boolean result = false;
            if (file != null) {
                Matcher m;
                String extension;
                if (file.isDirectory()) {
                    result = true;
                } else if (file.toString() != null && (extension = FilenameUtils.getExtension((String)file.toString()).toLowerCase()).matches(this.filenameSuffix) && (m = Pattern.compile(this.filenamePattern).matcher(file.getName())).matches()) {
                    LOGGER.trace("The pattern matches!");
                    result = true;
                }
            }
            return result;
        }

        @Override
        public String getDescription() {
            return Resources.getString(ConnectionPanel.class, (String)"filter") + " (" + this.filterDescription + ")";
        }
    }

    private static class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.valueChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.valueChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.valueChanged();
        }

        protected void valueChanged() {
        }
    }
}

