/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pt.view.command;

import org.bidib.jbidibc.messages.enums.AddressMode;
import org.bidib.jbidibc.messages.enums.PtOperation;
import org.bidib.wizard.mvc.pt.view.command.PtOperationCommand;
import org.bidib.wizard.mvc.pt.view.panel.AddressProgBeanModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PtAddressValueCommand
extends PtOperationCommand<AddressProgBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PtAddressValueCommand.class);
    private final ValueType valueType;

    public PtAddressValueCommand(PtOperation ptOperation, int cvNumber, int cvValue, ValueType valueType) {
        super(ptOperation, cvNumber, cvValue);
        this.valueType = valueType;
    }

    @Override
    public void setCvValueResult(Integer cvValueResult) {
        super.setCvValueResult(cvValueResult);
    }

    @Override
    public void postExecute(AddressProgBeanModel addressProgBeanModel) {
        super.postExecute(addressProgBeanModel);
        LOGGER.debug("PostExecute, cvValueresult: {}", (Object)this.getCvValueResult());
        if (this.getCvValueResult() != null) {
            Integer addressValue = addressProgBeanModel.getAddress();
            int address = addressValue != null ? addressValue : 0;
            int addressPart = this.getCvValueResult();
            AddressMode mode = addressProgBeanModel.getAddressMode();
            LOGGER.debug("Stored address: {}, new addressPart: {}, valueType: {}, mode: {}", new Object[]{address, addressPart, this.valueType, mode});
            address = AddressMode.LONG.equals((Object)mode) ? (ValueType.high.equals((Object)this.valueType) ? (address & 0xFF00) + (addressPart & 0xFF) : (address & 0xFF) + ((addressPart & 0xFF) - 192) * 256) : addressPart & 0xFF;
            LOGGER.debug("Prepared new address: {}", (Object)address);
            addressProgBeanModel.setAddress(address);
        }
    }

    public static enum ValueType {
        low,
        high;

    }
}

