/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.worklist.view;

import com.jidesoft.grid.AbstractTableCellEditorRenderer;
import com.jidesoft.grid.CellRolloverSupport;
import com.jidesoft.swing.JideButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.worklist.view.ButtonActionData;

public class ButtonsCellEditorRenderer
extends AbstractTableCellEditorRenderer
implements CellRolloverSupport {
    private static final long serialVersionUID = 1L;
    private static final int ICON_HEIGHT = 16;
    final ImageIcon removeIcon = ImageUtils.loadImageIcon(ButtonsCellEditorRenderer.class, (String)"/icons/16x16/remove_package.png", (int)16, (int)16);
    final ImageIcon removeRolloverIcon = ImageUtils.loadImageIcon(ButtonsCellEditorRenderer.class, (String)"/icons/16x16/remove_package_rollover.png", (int)16, (int)16);
    final ImageIcon editIcon = ImageUtils.loadImageIcon(ButtonsCellEditorRenderer.class, (String)"/icons/16x16/wrench.png", (int)16, (int)16);
    final ImageIcon editRolloverIcon = ImageUtils.loadImageIcon(ButtonsCellEditorRenderer.class, (String)"/icons/16x16/wrench_rollover.png", (int)16, (int)16);
    private final Consumer<ButtonActionData> actionCallback;

    public ButtonsCellEditorRenderer(Consumer<ButtonActionData> actionCallback) {
        this.actionCallback = actionCallback;
    }

    public Component createTableCellEditorRendererComponent(JTable table, int row, int column) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setOpaque(true);
        panel.add(this.createButton(this.editIcon, this.editRolloverIcon, Resources.getString(ButtonsCellEditorRenderer.class, (String)"edit.tooltip")));
        panel.add(Box.createRigidArea(new Dimension(3, 0)));
        panel.add(this.createButton(this.removeIcon, this.removeRolloverIcon, Resources.getString(ButtonsCellEditorRenderer.class, (String)"remove.tooltip")));
        return panel;
    }

    public void configureTableCellEditorRendererComponent(JTable table, Component editorRendererComponent, boolean forRenderer, Object value, boolean isSelected, boolean hasFocus, final int row, int column) {
        if (!forRenderer) {
            JButton editButton = (JButton)((JPanel)editorRendererComponent).getComponent(0);
            editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ButtonsCellEditorRenderer.this.actionCallback != null) {
                        ButtonsCellEditorRenderer.this.actionCallback.accept(new ButtonActionData(row, ButtonActionData.ActionEnum.EDIT));
                    }
                }
            });
            JButton removeButton = (JButton)((JPanel)editorRendererComponent).getComponent(2);
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ButtonsCellEditorRenderer.this.actionCallback != null) {
                        ButtonsCellEditorRenderer.this.actionCallback.accept(new ButtonActionData(row, ButtonActionData.ActionEnum.DELETE));
                    }
                }
            });
        }
        editorRendererComponent.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        editorRendererComponent.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
    }

    public Object getCellEditorValue() {
        return null;
    }

    public boolean isRollover(JTable table, MouseEvent e, int row, int column) {
        return true;
    }

    private JButton createButton(Icon icon, Icon rolloverIcon, String toolTipText) {
        JideButton button = new JideButton(icon);
        button.setOpaque(false);
        button.setContentAreaFilled(false);
        button.setPreferredSize(new Dimension(16, 16));
        button.setMaximumSize(new Dimension(16, 16));
        button.setMinimumSize(new Dimension(16, 16));
        button.setContentAreaFilled(false);
        button.setRolloverIcon(rolloverIcon);
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setRequestFocusEnabled(false);
        button.setToolTipText(toolTipText);
        return button;
    }
}

