package org.bidib.wizard.mvc.accessory.view.panel;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JTextField;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.IntegerRangeFilter;
import org.bidib.wizard.mvc.accessory.model.AccessoryBeanModel;
import org.bidib.wizard.mvc.accessory.model.AccessoryModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.util.PropertyValidationSupport;
import com.jgoodies.validation.view.ValidationComponentUtils;

public class DccExtAccessoryPanel extends AbstractAccessoryPanel<AccessoryBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DccExtAccessoryPanel.class);

    private final AccessoryBeanModel accessoryBeanModel;

    private ValueModel aspectValueModel;

    private JButton aspectButton;

    public DccExtAccessoryPanel(final AccessoryModel accessoryModel) {
        super(accessoryModel);
        accessoryBeanModel = new AccessoryBeanModel();
    }

    @Override
    protected AccessoryBeanModel getAccessoryBeanModel() {
        return accessoryBeanModel;
    }

    @Override
    protected void addSpecificComponents(final FormBuilder builder, final int[] rowHolder) {

        // goto next line
        int row = rowHolder[0];
        row += 2;
        builder.appendRows("3dlu, p");

        // add the aspect textfield
        aspectValueModel =
            new PropertyAdapter<AccessoryBeanModel>(getAccessoryBeanModel(), AccessoryModel.PROPERTYNAME_ASPECT, true);

        final ValueModel addressConverterModel =
            new ConverterValueModel(aspectValueModel, new StringConverter(new DecimalFormat("#")));

        final JTextField aspectText = new JTextField();
        InputValidationDocument addressDocument = new InputValidationDocument(3, InputValidationDocument.NUMERIC);
        addressDocument.setDocumentFilter(new IntegerRangeFilter(0, 255));
        aspectText.setDocument(addressDocument);
        aspectText.setColumns(3);

        // bind manually because we changed the document of the textfield
        Bindings.bind(aspectText, addressConverterModel, false);

        builder.add(Resources.getString(DccExtAccessoryPanel.class, "aspect")).xy(1, row);
        builder.add(aspectText).xy(3, row);

        ValidationComponentUtils.setMandatory(aspectText, true);
        ValidationComponentUtils.setMessageKeys(aspectText, "validation.aspect_key");

        this.aspectButton =
            new JButton(new AbstractAction(Resources.getString(DccExtAccessoryPanel.class, "activate")) {
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    // set aspect button was pressed
                    Integer aspect = (Integer) aspectValueModel.getValue();
                    LOGGER.info("Pressed button: {}, aspect: {}", e.getActionCommand(), aspect);

                    addLogText("Send DCC extended accessory request, address: {}, aspect: {}",
                        accessoryBeanModel.getDccAddress(), aspect);

                    // set the aspect triggers the property change listener
                    accessoryBeanModel.setAcknowledge(null);
                    accessoryBeanModel.setAspect(aspect);
                    // send the request
                    final AddressData addressData =
                        new AddressData(accessoryBeanModel.getDccAddress(), AddressTypeEnum.EXTENDED_ACCESSORY);
                    sendRequest(addressData, aspect);
                }
            });
        this.aspectButton.setEnabled(false);
        builder.add(aspectButton).xy(5, row);

        getAccessoryBeanModel()
            .addPropertyChangeListener(AccessoryModel.PROPERTYNAME_ASPECT, new PropertyChangeListener() {

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    LOGGER.debug("DCC aspect has changed: {}", getAccessoryBeanModel().getAspect());
                    triggerValidation();
                }
            });

        // update the row holder
        rowHolder[0] = row;
    }

    @Override
    protected void addSpecificValidation() {

        PropertyConnector
            .connect(accessoryValidationModel, AccessoryValidationResultModel.PROPERTY_VALID_STATE, this.aspectButton,
                "enabled");
    }

    @Override
    protected void validateSpecificPanel(PropertyValidationSupport support) {

        // the aspect must be set
        if (getAccessoryBeanModel().getAspect() == null) {
            support.addError("aspect_key", "not_empty");
        }
    }

    private static final int MAX_ADDRESS = 511;

    @Override
    protected int getMaxAddress() {
        return MAX_ADDRESS;
    }
}
