package org.bidib.wizard.mvc.loco.controller;

import org.bidib.wizard.model.status.SpeedLevel;
import org.bidib.wizard.model.status.SpeedSteps;

public interface LocoControlListener {

    /**
     * Set the speed of the decoder.
     * 
     * @param speedLevel
     *            the speed level value
     */
    void setSpeed(SpeedLevel speedLevel);

    /**
     * Set the function.
     * 
     * @param index
     *            the function index
     * @param value
     *            the function value
     */
    void setFunction(int index, boolean value);

    /**
     * Set the binary state.
     * 
     * @param state
     *            the state index
     * @param value
     *            the state value
     */
    void setBinaryState(int state, boolean value);

    /**
     * Set the speed steps of the selected decoder-.
     * 
     * @param speedSteps
     *            the speed steps
     */
    void setSpeedSteps(SpeedSteps speedSteps);

    /**
     * Clear loco from refresh buffer of command station.
     */
    void clearLoco();
}
