package org.bidib.wizard.mvc.stepcontrol.view.wizard;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;

import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.bidib.wizard.mvc.common.view.wizard.CancelAction;
import org.bidib.wizard.mvc.common.view.wizard.DefaultJWizardComponents;
import org.bidib.wizard.mvc.common.view.wizard.FinishAction;
import org.bidib.wizard.mvc.common.view.wizard.SimpleButtonPanel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;

public class CustomLogoJWizardDialog extends JDialog {
    private static final long serialVersionUID = 1L;

    private DefaultJWizardComponents wizardComponents;

    private JPanel buttonPanel;

    private ImageIcon[] logos;

    /**
     * Creates a new CustomLogoJWizardDialog without parent.
     * 
     * @param logos
     *            one or more ImageIcon objects to be shown within the wizard
     */
    public CustomLogoJWizardDialog(ImageIcon... logos) {
        this.logos = logos;
        wizardComponents = new DefaultJWizardComponents();
        init();
    }

    /**
     * Creates a new CustomLogoJWizardDialog with a frame as owner.
     * 
     * @param owner
     *            Owner of this wizard dialog
     * @param logos
     *            an ImageIcon object to be shown within the wizard
     * @param modal
     *            true, if the wizard should be shown modal; false otherwise
     */
    public CustomLogoJWizardDialog(Frame owner, ImageIcon[] logos, boolean modal) {
        super(owner, modal);
        this.logos = logos;
        wizardComponents = new DefaultJWizardComponents();
        init();
    }

    private void init() {

        JPanel logoPanel = new JPanel();

        StringBuilder sb = new StringBuilder("<html>");

        sb.append("<table style=\"border-spacing: 5px;\">");

        for (ImageIcon logo : logos) {
            String fileString;
            if (logo.toString().indexOf("file:") < 0 && logo.toString().indexOf("http:") < 0) {
                fileString = "file:///" + System.getProperty("user.dir") + "/" + logo.toString();
                fileString = fileString.replaceAll("\\\\", "/");
            }
            else {
                fileString = logo.toString();
            }
            sb.append("<tr><td>");

            sb.append("<img src='").append(fileString).append("'>");

            sb.append("</td></tr>");
        }
        sb.append("</table>");
        sb.append("</html>");

        logoPanel.add(new JLabel(sb.toString()), BorderLayout.CENTER);

        // prepare the form
        boolean debug = false;
        FormBuilder builder =
            FormBuilder
                .create().columns("p, 3dlu, p:g").rows("fill:150dlu:g, 5dlu, 20dlu")
                .panel(debug ? new FormDebugPanel() : new JPanel());

        builder.border(Paddings.DLU4);

        builder.add(logoPanel).xy(1, 1);
        builder.add(wizardComponents.getWizardPanelsContainer()).xy(3, 1);

        buttonPanel = new SimpleButtonPanel(wizardComponents);

        builder.addSeparator(null).xyw(1, 2, 3);
        builder.add(buttonPanel).xyw(1, 3, 3);

        JPanel content = builder.build();
        this.getContentPane().add(content);

        wizardComponents.setFinishAction(new FinishAction(wizardComponents) {
            @Override
            public void performAction() {
                dispose();
            }
        });
        wizardComponents.setCancelAction(new CancelAction(wizardComponents) {
            @Override
            public void performAction() {
                dispose();
            }
        });

        Dimension dim = getPreferredSize();
        dim.height += 40;
        setPreferredSize(dim);
        setMinimumSize(dim);

        pack();
    }

    /**
     * Returns this wizards components.
     * 
     * @return DefaultJWizardComponents
     */
    public DefaultJWizardComponents getWizardComponents() {
        return wizardComponents;
    }

    /**
     * Sets this wizards components.
     * 
     * @param aWizardComponents
     *            DefaultJWizardComponents
     */
    public void setWizardComponents(DefaultJWizardComponents aWizardComponents) {
        wizardComponents = aWizardComponents;
    }

    /** Shows this dialog. */
    @Override
    public void setVisible(boolean visible) {
        wizardComponents.updateComponents();
        super.setVisible(visible);
    }

}
