/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.dialog;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.JHyperlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AboutDialog.class);
    private final Properties version = new Properties();
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 10dlu, fill:150dlu:grow";
    private static final String ENCODED_DIALOG_ROWS_SPECS = "p, 10dlu, top:p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, fill:pref:grow";

    public AboutDialog(Component parentComponent) {
        try {
            this.version.load(this.getClass().getResourceAsStream("/META-INF/build-info.properties"));
        }
        catch (Exception ex) {
            LOGGER.warn("Load build info failed.", (Throwable)ex);
        }
        JOptionPane pane = new JOptionPane(this.getPanel(), 1);
        JDialog dialog = pane.createDialog(parentComponent, Resources.getString(this.getClass(), (String)"title") + " " + this.version.getProperty("build.name"));
        dialog.setVisible(true);
    }

    private JPanel getPanel() {
        boolean debugDialog = false;
        FormBuilder dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROWS_SPECS, new Object[0]).panel((JPanel)(debugDialog ? new FormDebugPanel() : new JPanel(new BorderLayout())));
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        int row = 1;
        dialogBuilder.add(this.version.getProperty("build.name"), new Object[0]).xyw(1, row, 3);
        String authorsText = "<html>" + Stream.of(this.version.getProperty("build.projectauthor").split(";")).collect(Collectors.joining("<br/>")) + "</html>";
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"authors"), new Object[0]).xy(1, row += 2);
        dialogBuilder.add(authorsText, new Object[0]).xy(3, row);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"version"), new Object[0]).xy(1, row += 2);
        dialogBuilder.add(this.version.getProperty("build.version"), new Object[0]).xy(3, row);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"build"), new Object[0]).xy(1, row += 2);
        dialogBuilder.add(this.version.getProperty("build.buildnumber-and-branch-info"), new Object[0]).xy(3, row);
        LocalDateTime parsed = LocalDateTime.parse(this.version.getProperty("build.time"), DateTimeFormatter.ISO_DATE_TIME);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"date"), new Object[0]).xy(1, row += 2);
        dialogBuilder.add(parsed.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), new Object[0]).xy(3, row);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"java"), new Object[0]).xy(1, row += 2);
        dialogBuilder.add(System.getProperty("java.version"), new Object[0]).xy(3, row);
        JHyperlink famfamfamHyperLink = new JHyperlink();
        famfamfamHyperLink.setURL("http://www.famfamfam.com/lab/icons/silk/");
        famfamfamHyperLink.setText("Icons provided by http://www.famfamfam.com/lab/icons/silk/");
        dialogBuilder.add((Component)famfamfamHyperLink).xyw(1, row += 2, 3);
        JHyperlink jideHyperLink = new JHyperlink();
        jideHyperLink.setURL("http://www.jidesoft.com");
        jideHyperLink.setText("Free JIDE license for open source project by http://www.jidesoft.com");
        dialogBuilder.add((Component)jideHyperLink).xyw(1, row += 2, 3);
        dialogBuilder.add("<html>Images provided by:<br/>OpenDCC, Martin Welzel, Andreas Tillner</html>", new Object[0]).xyw(1, row += 2, 3);
        dialogBuilder.add("<html>NL translation: Bert van der Lugt Melsert<br/>FR translation: Yann Monbaron</html>", new Object[0]).xyw(1, row += 2, 3);
        return dialogBuilder.build();
    }
}

