/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.debug.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.debug.LineEndingEnum;
import org.bidib.wizard.api.model.common.CommPort;

public class DebugInterfaceModel
extends Model {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_COM_PORTS = "comPorts";
    public static final String PROPERTY_SELECTED_PORT = "selectedPort";
    public static final String PROPERTY_SEND_TEXT = "sendText";
    public static final String PROPERTY_BAUDRATE = "baudRate";
    public static final String PROPERTY_SEND_FILE = "sendFile";
    public static final String PROPERTY_CONNECTED = "connected";
    public static final String PROPERTY_DISCONNECTED = "disconnected";
    public static final String PROPERTY_TRANSFER_IN_PROGRESS = "transferInProgress";
    public static final String PROPERTY_TRANSMIT_ENABLED = "transmitEnabled";
    public static final String PROPERTY_LINE_ENDING = "lineEnding";
    public static final String PROPERTY_LOG_TO_FILE = "logToFile";
    public static final String PROPERTY_LOGFILE_NAME = "logFileName";
    private ArrayListModel<CommPort> commPorts = new ArrayListModel();
    private CommPort selectedPort;
    private Integer baudRate;
    private String sendText;
    private File sendFile;
    private boolean connected;
    private boolean transferInProgress;
    private boolean logToFile;
    private String logFileName;
    private LineEndingEnum lineEnding = LineEndingEnum.CRLF;

    public ArrayListModel<CommPort> getCommPortsListModel() {
        return this.commPorts;
    }

    public Collection<CommPort> getCommPorts() {
        return this.commPorts;
    }

    public void setCommPorts(List<CommPort> commPorts) {
        ArrayList<CommPort> oldValue = new ArrayList<CommPort>((Collection<CommPort>)this.commPorts);
        this.commPorts.clear();
        this.commPorts.addAll(commPorts);
        this.firePropertyChange(PROPERTY_COM_PORTS, oldValue, commPorts);
    }

    public CommPort getSelectedPort() {
        return this.selectedPort;
    }

    public void setSelectedPort(CommPort selectedPort) {
        CommPort oldValue = this.selectedPort;
        this.selectedPort = selectedPort;
        this.firePropertyChange(PROPERTY_SELECTED_PORT, oldValue, selectedPort);
    }

    public Integer getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(Integer baudRate) {
        Integer oldValue = this.baudRate;
        this.baudRate = baudRate;
        this.firePropertyChange(PROPERTY_BAUDRATE, oldValue, baudRate);
    }

    public String getSendText() {
        return this.sendText;
    }

    public void setSendText(String sendText) {
        String oldValue = this.sendText;
        this.sendText = sendText;
        this.firePropertyChange(PROPERTY_SEND_TEXT, oldValue, sendText);
    }

    public File getSendFile() {
        return this.sendFile;
    }

    public void setSendFile(File sendFile) {
        File oldValue = this.sendFile;
        this.sendFile = sendFile;
        this.firePropertyChange(PROPERTY_SEND_FILE, oldValue, sendFile);
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        boolean oldTransmitEnabled = this.isTransmitEnabled();
        boolean oldValue = this.connected;
        this.connected = connected;
        if (SwingUtilities.isEventDispatchThread()) {
            this.firePropertyChange(PROPERTY_CONNECTED, oldValue, connected);
            this.firePropertyChange(PROPERTY_DISCONNECTED, !oldValue, !connected);
            this.firePropertyChange(PROPERTY_TRANSMIT_ENABLED, oldTransmitEnabled, this.isTransmitEnabled());
        } else {
            SwingUtilities.invokeLater(() -> {
                this.firePropertyChange(PROPERTY_CONNECTED, oldValue, connected);
                this.firePropertyChange(PROPERTY_DISCONNECTED, !oldValue, !connected);
                this.firePropertyChange(PROPERTY_TRANSMIT_ENABLED, oldTransmitEnabled, this.isTransmitEnabled());
            });
        }
    }

    public boolean isDisconnected() {
        return !this.connected;
    }

    public void setDisconnected(boolean disconnected) {
        this.setConnected(!disconnected);
    }

    public boolean isTransferInProgress() {
        return this.transferInProgress;
    }

    public void setTransferInProgress(boolean transferInProgress) {
        boolean oldTransmitEnabled = this.isTransmitEnabled();
        boolean oldValue = this.transferInProgress;
        this.transferInProgress = transferInProgress;
        if (SwingUtilities.isEventDispatchThread()) {
            this.firePropertyChange(PROPERTY_TRANSFER_IN_PROGRESS, oldValue, transferInProgress);
            this.firePropertyChange(PROPERTY_TRANSMIT_ENABLED, oldTransmitEnabled, this.isTransmitEnabled());
        } else {
            SwingUtilities.invokeLater(() -> {
                this.firePropertyChange(PROPERTY_TRANSFER_IN_PROGRESS, oldValue, transferInProgress);
                this.firePropertyChange(PROPERTY_TRANSMIT_ENABLED, oldTransmitEnabled, this.isTransmitEnabled());
            });
        }
    }

    public boolean isTransmitEnabled() {
        return this.isConnected() && !this.isTransferInProgress();
    }

    public LineEndingEnum getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(LineEndingEnum lineEnding) {
        LineEndingEnum oldValue = this.lineEnding;
        this.lineEnding = lineEnding;
        this.firePropertyChange(PROPERTY_LINE_ENDING, oldValue, lineEnding);
    }

    public boolean isLogToFile() {
        return this.logToFile;
    }

    public void setLogToFile(boolean logToFile) {
        boolean oldValue = this.logToFile;
        this.logToFile = logToFile;
        this.firePropertyChange(PROPERTY_LOG_TO_FILE, oldValue, logToFile);
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public void setLogFileName(String logFileName) {
        String oldValue = this.logFileName;
        this.logFileName = logFileName;
        this.firePropertyChange(PROPERTY_LOGFILE_NAME, oldValue, logFileName);
    }
}

