/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.error.controller;

import java.util.function.Supplier;
import org.bidib.wizard.mvc.error.model.ErrorModel;
import org.bidib.wizard.mvc.error.view.ErrorView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorController {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ErrorController.class.getName());
    private static final ErrorModel model = new ErrorModel();

    public void start(Supplier<Boolean> startupPassed) {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable e) {
                LOGGER.error("Uncaught exception detected: " + model.getStackTrace(e));
                ErrorController.setError(e);
            }
        });
        new ErrorView(model, startupPassed){

            @Override
            public void windowClosed() {
                LOGGER.error("Exit the runtime after error window was closed.");
                System.exit(20);
            }
        };
    }

    public static void setError(Throwable e) {
        model.setError(e);
    }
}

