/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.logger.view;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.text.SimpleDateFormat;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.BasicPopupMenu;
import org.bidib.wizard.core.logger.BidibLogsAppender;
import org.bidib.wizard.mvc.common.view.text.CopyAllAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogsPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogsPane.class);
    private final JScrollPane logsPane;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private final JTextArea logsArea;
    private BidibLogsAppender bidibAppender;
    private Disposable loggingDisposable;
    private final JPopupMenu popupMenu;
    private JCheckBoxMenuItem autoScrollsItem;
    private JMenuItem clearItem;

    public LogsPane() {
        this.logsPane = new JScrollPane(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void processMouseWheelEvent(MouseWheelEvent e) {
                super.processMouseWheelEvent(e);
                if (LogsPane.this.logsArea.getAutoscrolls()) {
                    LOGGER.info("Clear the flag on the autoScrollsItem and disable autoscrolls.");
                    LogsPane.this.autoScrollsItem.setSelected(false);
                    LogsPane.this.logsArea.setAutoscrolls(false);
                    LogsPane.this.logsArea.setCaretPosition(LogsPane.this.logsArea.getCaretPosition() > 0 ? LogsPane.this.logsArea.getCaretPosition() - 1 : 0);
                }
            }
        };
        this.logsArea = new JTextArea(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void processMouseEvent(MouseEvent e) {
                if (this.getAutoscrolls() && e.getID() == 502 && !e.isPopupTrigger()) {
                    LOGGER.info("Clear the flag on the autoScrollsItem.");
                    LogsPane.this.autoScrollsItem.setSelected(false);
                }
                super.processMouseEvent(e);
            }
        };
        this.logsArea.setEditable(false);
        this.logsArea.setFont(new Font("Monospaced", 0, 11));
        this.logsPane.getViewport().add((Component)this.logsArea, null);
        this.addObserverToBidibLogAppender();
        this.logsPane.setAutoscrolls(true);
        this.popupMenu = new BasicPopupMenu(){
            private static final long serialVersionUID = 1L;
        };
        this.prepareMenuItems(this.popupMenu);
        this.logsArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 1 && e.isPopupTrigger()) {
                    LOGGER.debug("Show the popup menu.");
                    e.consume();
                    LogsPane.this.popupMenu.show(LogsPane.this.logsArea, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                LOGGER.debug("Mouse released.");
                if (e.isPopupTrigger()) {
                    this.mousePressed(e);
                }
            }
        });
    }

    private void prepareMenuItems(JPopupMenu menu) {
        this.autoScrollsItem = new JCheckBoxMenuItem(Resources.getString(this.getClass(), (String)"autoScrolls"));
        this.autoScrollsItem.setSelected(true);
        this.autoScrollsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogsPane.this.logsArea.setCaretPosition(LogsPane.this.logsArea.getDocument().getLength());
                boolean enabled = LogsPane.this.autoScrollsItem.isSelected();
                LOGGER.info("Set autoscrolls enabled: {}", (Object)enabled);
                if (enabled) {
                    LogsPane.this.logsArea.setAutoscrolls(enabled);
                    LogsPane.this.logsArea.setCaretPosition(LogsPane.this.logsArea.getDocument().getLength());
                } else {
                    LogsPane.this.logsArea.setAutoscrolls(enabled);
                    LogsPane.this.logsArea.setCaretPosition(LogsPane.this.logsArea.getCaretPosition() > 0 ? LogsPane.this.logsArea.getCaretPosition() - 1 : 0);
                }
            }
        });
        this.addMenuItem(menu, this.autoScrollsItem);
        this.clearItem = new JMenuItem(Resources.getString(this.getClass(), (String)"clear"));
        this.clearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LogsPane.this.logsArea.setText(null);
                    LogsPane.this.logsArea.setCaretPosition(LogsPane.this.logsArea.getDocument().getLength());
                    boolean enabled = LogsPane.this.autoScrollsItem.isSelected();
                    LogsPane.this.logsArea.setAutoscrolls(!enabled);
                    LogsPane.this.logsArea.setAutoscrolls(enabled);
                }
                catch (Exception ex) {
                    LOGGER.warn("Clear logsarea failed.", (Throwable)ex);
                }
            }
        });
        this.addMenuItem(menu, this.clearItem);
        JMenuItem copyAllToClipboard = new JMenuItem(Resources.getString(this.getClass(), (String)"copyAllToClipboard"));
        copyAllToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogsPane.this.fireCopyAllToClipboard();
            }
        });
        this.addMenuItem(menu, copyAllToClipboard);
    }

    private void addMenuItem(Object menu, JMenuItem menuItem) {
        if (menu instanceof JMenu) {
            ((JMenu)menu).add(menuItem);
        } else if (menu instanceof JPopupMenu) {
            ((JPopupMenu)menu).add(menuItem);
        }
    }

    private void fireCopyAllToClipboard() {
        LOGGER.info("Copy all content to clipboard.");
        ActionEvent copyAll = new ActionEvent(this.logsArea, 0, "copy-all-to-clipboard");
        CopyAllAction action = new CopyAllAction();
        action.actionPerformed(copyAll);
    }

    public JScrollPane get() {
        return this.logsPane;
    }

    private void addObserverToBidibLogAppender() {
        String appenderName = "BidibLogsAppender";
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (Logger logger : context.getLoggerList()) {
            Appender appender = ((AppenderAttachable)logger).getAppender(appenderName);
            if (!(appender instanceof BidibLogsAppender)) continue;
            this.bidibAppender = (BidibLogsAppender)appender;
            break;
        }
        if (this.bidibAppender == null) {
            LoggerFactory.getLogger(LogsPane.class).error("Can't find appender with name: {}", (Object)appenderName);
        } else {
            this.loggingDisposable = this.bidibAppender.getLoggingSubject().subscribe(le -> this.publishLoggingEvent((ILoggingEvent)le));
        }
    }

    protected void publishLoggingEvent(final ILoggingEvent log) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int lines = LogsPane.this.logsArea.getLineCount();
                    if (lines > 2000) {
                        int end = LogsPane.this.logsArea.getLineEndOffset(50);
                        LogsPane.this.logsArea.getDocument().remove(0, end);
                    }
                }
                catch (BadLocationException ex) {
                    LOGGER.warn("Remove some lines from logsArea failed.", (Throwable)ex);
                }
                ILoggingEvent loggingEvent = log;
                LogsPane.this.logsArea.append(LogsPane.this.dateFormat.format(loggingEvent.getTimeStamp()));
                LogsPane.this.logsArea.append(" - ");
                LogsPane.this.logsArea.append(loggingEvent.getFormattedMessage());
                LogsPane.this.logsArea.append(System.lineSeparator());
            }
        });
    }

    public void close() {
        if (this.bidibAppender != null) {
            LOGGER.info("Remove observer from appender.");
            try {
                this.loggingDisposable.dispose();
                this.loggingDisposable = null;
            }
            catch (Exception ex) {
                LOGGER.warn("Remove observer from appender failed.", (Throwable)ex);
            }
            this.bidibAppender = null;
        }
    }
}

