/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.bidib.jbidibc.core.node.ConfigurationVariable;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvData;
import org.bidib.jbidibc.exchange.vendorcv.VendorCvFactory;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.CvDefinitionListener;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.service.node.NodeService;
import org.bidib.wizard.client.common.controller.CvDefinitionPanelControllerInterface;
import org.bidib.wizard.client.common.controller.FeedbackPortStatusChangeProvider;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.cvdef.CvContainer;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.client.common.view.cvdef.CvNode;
import org.bidib.wizard.client.common.view.listener.TabStatusListener;
import org.bidib.wizard.client.common.view.statusbar.StatusBar;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.common.utils.SearchPathUtils;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.CvDefinitionPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CvDefinitionPanelController
implements CvDefinitionPanelControllerInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(CvDefinitionPanelController.class);
    private final MainModel mainModel;
    private final FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider;
    private final StatusBar statusBar;
    private CvDefinitionPanel cvDefinitionPanel;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private MiscSettingsInterface miscSettings;
    private final String connectionId;
    @Autowired
    private CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry;
    private CvDefinitionListener cvDefinitionListener;
    private NodeInterface selectedNode;
    private Runnable enableTabCallback;

    public CvDefinitionPanelController(MainModel mainModel, FeedbackPortStatusChangeProvider feedbackPortStatusChangeProvider, String connectionId, StatusBar statusBar) {
        this.mainModel = mainModel;
        this.feedbackPortStatusChangeProvider = feedbackPortStatusChangeProvider;
        this.connectionId = connectionId;
        this.statusBar = statusBar;
    }

    public void start(TabStatusListener tabStatusListener) {
        this.cvDefinitionPanel = new CvDefinitionPanel(this, this.feedbackPortStatusChangeProvider, this.mainModel, tabStatusListener, this.settingsService, this.statusBar);
        this.cvDefinitionListener = new CvDefinitionListener(){

            public void cvDefinitionValuesChanged(boolean read, List<String> changedNames) {
                if (CvDefinitionPanelController.this.cvDefinitionPanel != null) {
                    SwingUtils.executeInEDT(() -> CvDefinitionPanelController.this.cvDefinitionPanel.cvDefinitionValuesChanged(read, changedNames));
                }
            }
        };
        this.mainModel.addNodeListListener((NodeListListener)new DefaultNodeListListener(){

            public void nodeChanged(NodeInterface node) {
                NodeInterface selectedNode = CvDefinitionPanelController.this.mainModel.getSelectedNode();
                LOGGER.info("The selected node has changed: {}", (Object)selectedNode);
                if (CvDefinitionPanelController.this.selectedNode != null && !Objects.equals(CvDefinitionPanelController.this.selectedNode, selectedNode)) {
                    LOGGER.info("Selected node has changed, unregister cv definition listener.");
                    CvDefinitionPanelController.this.selectedNode.removeCvDefinitionListener(CvDefinitionPanelController.this.cvDefinitionListener);
                    CvDefinitionPanelController.this.selectedNode = null;
                }
                if (selectedNode == null) {
                    LOGGER.info("Reset the pending changes in the cvDefinitionPanel.");
                    CvDefinitionPanelController.this.cvDefinitionPanel.resetPendingChanges();
                } else {
                    LOGGER.info("Register cv definition listener.");
                    CvDefinitionPanelController.this.selectedNode = selectedNode;
                    CvDefinitionPanelController.this.selectedNode.addCvDefinitionListener(CvDefinitionPanelController.this.cvDefinitionListener);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void listNodeRemoved(NodeInterface node) {
                LOGGER.info("The node was removed: {}", (Object)node);
                try {
                    CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry = CvDefinitionPanelController.this.cvDefinitionTreeModelRegistry;
                    synchronized (cvDefinitionTreeModelRegistry) {
                        CvDefinitionPanelController.this.cvDefinitionTreeModelRegistry.removeCvContainer(node.getUniqueId());
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Remove CV container from registry failed.", (Throwable)ex);
                }
                if (CvDefinitionPanelController.this.selectedNode != null && Objects.equals(CvDefinitionPanelController.this.selectedNode, node)) {
                    LOGGER.info("Selected node was removed, unregister cv definition listener.");
                    CvDefinitionPanelController.this.selectedNode.removeCvDefinitionListener(CvDefinitionPanelController.this.cvDefinitionListener);
                    CvDefinitionPanelController.this.selectedNode = null;
                }
            }
        });
    }

    public CvDefinitionPanel getCvDefinitionPanel() {
        return this.cvDefinitionPanel;
    }

    public void setTabEnableCallback(Runnable enableTabCallback) {
        this.enableTabCallback = enableTabCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CvDefinitionTreeTableModel getCvDefinitionTreeTableModel(NodeInterface node) {
        LOGGER.info("Get the cvDefinitionTreeTableModel for node: {}", (Object)node);
        long uniqueId = node.getUniqueId();
        CvContainer cvContainer = null;
        CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry = this.cvDefinitionTreeModelRegistry;
        synchronized (cvDefinitionTreeModelRegistry) {
            cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
            if (cvContainer == null && node.getVendorCV() != null) {
                LOGGER.info("No cvContainer found but vendorCV available. Prepare the vendorCV tree for node: {}", (Object)node);
                VendorCvData vendorCV = node.getVendorCV();
                this.cvDefinitionTreeModelRegistry.prepareVendorCVTree(node, vendorCV, false);
                cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
            }
        }
        if (cvContainer != null) {
            return cvContainer.getCvTreeModel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationVariable> getConfigVariables(NodeInterface node) {
        LOGGER.info("Get the configuration variables for node: {}", (Object)node);
        long uniqueId = node.getUniqueId();
        CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry = this.cvDefinitionTreeModelRegistry;
        synchronized (cvDefinitionTreeModelRegistry) {
            CvContainer cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
            if (cvContainer != null) {
                return cvContainer.getConfigVariables();
            }
        }
        LOGGER.info("No configuration variables registered for node: {}", (Object)node);
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, CvNode> getCvNumberToNodeMap(NodeInterface node) {
        LOGGER.info("Get the cvNumberToNodeMap for node: {}", (Object)node);
        long uniqueId = node.getUniqueId();
        CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry = this.cvDefinitionTreeModelRegistry;
        synchronized (cvDefinitionTreeModelRegistry) {
            CvContainer cvContainer = this.cvDefinitionTreeModelRegistry.getCvContainer(uniqueId);
            if (cvContainer != null) {
                return cvContainer.getCvNumberToNodeMap();
            }
        }
        LOGGER.info("No cvNumberToNodeMap registered for node: {}", (Object)node);
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceVendorCVTree(NodeInterface node, VendorCvData vendorCV) {
        CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry = this.cvDefinitionTreeModelRegistry;
        synchronized (cvDefinitionTreeModelRegistry) {
            this.cvDefinitionTreeModelRegistry.prepareVendorCVTree(node, vendorCV, true);
        }
    }

    public VendorCvData copyCvDefinitionToUserDir(Context context, NodeInterface node) {
        VendorCvData vendorCV = null;
        if (node != null) {
            try {
                String labelPath = this.miscSettings.getBidibConfigDir();
                File targetPath = new File(labelPath, "data/BiDiBNodeVendorData");
                vendorCV = VendorCvFactory.getCvDefinition((Node)node.getNode(), (Context)context, SearchPathUtils::lookupFilesInClasspath, (String[])new String[]{"classpath:/bidib"});
                LOGGER.info("Copy the vendorCV: {}", (Object)vendorCV);
                if (vendorCV != null) {
                    String fileName = vendorCV.getFilename();
                    LOGGER.info("Save to target filename: {}", (Object)fileName);
                    FileUtils.forceMkdir((File)targetPath);
                    VendorCvFactory.saveCvDefinition((VendorCvData)vendorCV, (File)new File(targetPath, fileName));
                } else {
                    LOGGER.warn("No vendorCV available for node: {}", (Object)node);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Get CV definition for node failed.", (Throwable)ex);
                throw new RuntimeException("Copy VendorCV to user dir failed.", ex);
            }
            if (vendorCV != null) {
                this.replaceVendorCVTree(node, vendorCV);
            } else if (ProductUtils.isOneBootloader((long)node.getUniqueId())) {
                LOGGER.info("The current node is a OneBootloader.");
            } else {
                LOGGER.warn("No CV definition available for node: {}", (Object)node);
            }
        }
        return vendorCV;
    }

    public VendorCvData deleteCvDefinitionFromUserDir(Context context, NodeInterface node) {
        VendorCvData vendorCV = null;
        if (node != null) {
            VendorCvData orgVendorCV = node.getVendorCV();
            if (orgVendorCV != null) {
                String labelPath = this.miscSettings.getBidibConfigDir();
                File targetPath = new File(labelPath, "data/BiDiBNodeVendorData");
                String filePath = orgVendorCV.getFilePath();
                try {
                    Path path = Paths.get(filePath, new String[0]);
                    if (!path.startsWith(targetPath.getPath())) {
                        LOGGER.warn("Do not try to delete internal file: {}", (Object)filePath);
                        throw new RuntimeException("Delete internal VendorCV is not allowed.");
                    }
                    Files.deleteIfExists(Paths.get(filePath, new String[0]));
                }
                catch (IOException ex) {
                    LOGGER.warn("Delete exisiting cv file failed, path: {}", (Object)filePath, (Object)ex);
                }
            }
            try {
                vendorCV = this.loadCvDefinition(context, node);
            }
            catch (Exception ex) {
                LOGGER.warn("Get CV definition for node failed.", (Throwable)ex);
            }
        }
        return vendorCV;
    }

    public VendorCvData loadCvDefinition(Context context, NodeInterface node) {
        VendorCvData vendorCV = null;
        LOGGER.info("Load the CV definition for node: {}", (Object)node);
        if (node != null) {
            vendorCV = node.getVendorCV();
            if (vendorCV == null) {
                try {
                    String installationPath = this.settingsService.getInstallationPath();
                    LOGGER.info("Current installation path: {}", (Object)installationPath);
                    File file = new File(installationPath);
                    file = new File(file.getAbsoluteFile(), "data/BiDiBNodeVendorData");
                    String userHome = System.getProperty("user.home");
                    File searchPathUserHomeWizard = new File(userHome, ".BiDiBWizard/data/BiDiBNodeVendorData");
                    String labelPath = this.miscSettings.getBidibConfigDir();
                    File searchPathLabelPath = new File(labelPath, "data/BiDiBNodeVendorData");
                    vendorCV = VendorCvFactory.getCvDefinition((Node)node.getNode(), (Context)context, SearchPathUtils::lookupFilesInClasspath, (String[])new String[]{searchPathLabelPath.getAbsolutePath(), file.getAbsolutePath(), "classpath:/bidib", searchPathUserHomeWizard.getAbsolutePath()});
                }
                catch (Exception ex) {
                    LOGGER.warn("Get CV definition for node failed.", (Throwable)ex);
                }
            }
            if (vendorCV != null) {
                if (node.getVendorCV() == null) {
                    node.setVendorCV(vendorCV);
                }
                if (this.enableTabCallback != null && this.cvDefinitionPanel != null) {
                    SwingUtils.executeInEDT(() -> {
                        this.enableTabCallback.run();
                        this.cvDefinitionPanel.cvDefinitionChanged();
                    });
                } else {
                    if (this.enableTabCallback != null) {
                        SwingUtils.executeInEDT(() -> this.enableTabCallback.run());
                    }
                    if (this.cvDefinitionPanel != null) {
                        SwingUtils.executeInEDT(() -> this.cvDefinitionPanel.cvDefinitionChanged());
                    }
                }
                LOGGER.info("Prepare the CvDefinitionTreeTableModel in the CvDefinitionPanelController for node: {}", (Object)node);
                this.getCvDefinitionTreeTableModel(node);
                List<ConfigurationVariable> configurationVariables = this.getConfigVariables(node);
                node.setConfigVariables(configurationVariables);
            } else if (ProductUtils.isOneBootloader((long)node.getUniqueId())) {
                LOGGER.info("The current node is a OneBootloader.");
            } else {
                LOGGER.warn("No CV definition available for node: {}", (Object)node);
            }
        }
        return vendorCV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadCvDefinition(Context context, NodeInterface node) {
        LOGGER.info("Reload the CV definition for node: {}", (Object)node);
        node.setVendorCV(null);
        CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry = this.cvDefinitionTreeModelRegistry;
        synchronized (cvDefinitionTreeModelRegistry) {
            this.cvDefinitionTreeModelRegistry.removeCvContainer(node.getUniqueId());
        }
        this.loadCvDefinition(context, node);
    }

    public List<ConfigurationVariable> setConfigVariables(NodeInterface node, List<ConfigurationVariable> configVariables) {
        return this.nodeService.setConfigVariables(this.connectionId, node, configVariables);
    }
}

