/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.PortValueListener;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.script.DefaultScriptContext;
import org.bidib.wizard.common.script.common.WaitCommand;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.switching.MotorPortCommand;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.model.ports.MotorPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.MotorPortStatus;
import org.bidib.wizard.mvc.main.controller.wrapper.NodePortWrapper;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.MotorPortTableModel;
import org.bidib.wizard.mvc.main.model.listener.MotorPortModelListener;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.panel.MotorPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class MotorPortPanelController
implements PortScripting {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotorPortPanelController.class);
    private final MainModel mainModel;
    private MotorPortListPanel motorPortListPanel;
    private final Map<NodeInterface, NodePortWrapper> testToggleRegistry = new LinkedHashMap<NodeInterface, NodePortWrapper>();
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private ConsoleService consoleService;
    private final Subject<PortConfigChangeEvent> portConfigChangeEventSubject;
    private CompositeDisposable compDisp;

    public MotorPortPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.compDisp = new CompositeDisposable();
        this.portConfigChangeEventSubject = PublishSubject.create().toSerialized();
    }

    public MotorPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        final MotorPortTableModel tableModel = new MotorPortTableModel();
        tableModel.setPortListener(new MotorPortModelListener(){

            public void labelChanged(MotorPort port, String label) {
                port.setLabel(label);
                try {
                    NodeLabels nodeLabels = MotorPortPanelController.this.getNodeLabels();
                    BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.motorPort, (int)port.getId(), (String)port.getLabel());
                    MotorPortPanelController.this.saveLabels();
                }
                catch (InvalidConfigurationException ex) {
                    LOGGER.warn("Save motor port labels failed.", (Throwable)ex);
                    String labelPath = ex.getReason();
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
                }
            }

            public void configChanged(MotorPort port, PortConfigKeys ... portConfigKeys) {
                LOGGER.info("The port config value are changed for port: {}", (Object)port);
                LinkedHashMap values = new LinkedHashMap();
                if (MapUtils.isNotEmpty(values)) {
                    try {
                        MotorPortPanelController.this.switchingNodeService.setPortConfig("main", MotorPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), (Port)port, null, values);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Set the motorPort parameters failed.", (Throwable)ex);
                        MotorPortPanelController.this.mainModel.setNodeHasError(MotorPortPanelController.this.mainModel.getSelectedNode(), true);
                    }
                } else {
                    LOGGER.info("No config values to save available.");
                }
            }

            public void changePortType(LcOutputType portType, Port<? extends BidibStatus> port) {
                LOGGER.info("The port type will change to: {}, port: {}", (Object)portType, port);
                HashMap values = new HashMap();
                MotorPortPanelController.this.switchingNodeService.setPortConfig("main", MotorPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), port, portType, values);
            }

            @Override
            public void testButtonPressed(MotorPort port, MotorPortStatus newStatus) {
                LOGGER.info("The test button was pressed for port: {}", (Object)port);
                NodeInterface node = MotorPortPanelController.this.mainModel.getSelectedNode();
                if (MotorPortStatus.TEST != port.getStatus()) {
                    MotorPortPanelController.this.stopTestToggleTask(node, (Port<?>)port);
                    MotorPort motorPort = port;
                    MotorPortPanelController.this.switchingNodeService.setPortStatus("main", node.getSwitchingNode(), (Port)motorPort);
                } else {
                    MotorPortPanelController.this.addTestToggleTask(node, (Port<?>)port);
                }
            }
        });
        final MotorPortListPanel motorPortListPanel = new MotorPortListPanel(this, tableModel, this.mainModel, tabVisibilityListener, this.portConfigChangeEventSubject);
        motorPortListPanel.setPortListener(new PortValueListener<MotorPort>(){

            public Class<?> getPortClass() {
                return MotorPort.class;
            }

            public void labelChanged(MotorPort port, String label) {
                LOGGER.info("The label has been changed by nodeScript, port: {}, label: {}", (Object)port, (Object)label);
                NodeLabels nodeLabels = MotorPortPanelController.this.getNodeLabels();
                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.motorPort, (int)port.getId(), (String)port.getLabel());
                MotorPortPanelController.this.saveLabels();
                motorPortListPanel.repaint();
            }

            public void valueChanged(NodeInterface node, MotorPort port) {
                LOGGER.info("Value has changed for motor port: {}", (Object)port);
                SwingUtilities.invokeLater(() -> tableModel.notifyPortStatusChanged(port));
            }

            public void configChanged(NodeInterface node, MotorPort port) {
                LOGGER.info("The configuration of the port has changed: {}", (Object)port);
                SwingUtilities.invokeLater(() -> tableModel.notifyPortConfigChanged(port));
            }
        });
        this.mainModel.addNodeListListener((NodeListListener)new DefaultNodeListListener(){

            public void nodeWillChange(NodeInterface node) {
                LOGGER.info("The selected node will change!");
                try {
                    LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
                    for (NodeInterface currentNode : MotorPortPanelController.this.testToggleRegistry.keySet()) {
                        nodes.add(currentNode);
                    }
                    LOGGER.info("Found nodes to stop the test toggle task: {}", nodes);
                    for (NodeInterface currentNode : nodes) {
                        MotorPortPanelController.this.stopTestToggleTask(currentNode, null);
                    }
                    LOGGER.info("Stop the test toggle task passed for nodes: {}", nodes);
                }
                catch (Exception ex) {
                    LOGGER.warn("Stop test toggle tasks failed.", (Throwable)ex);
                }
            }

            public void nodeChanged(NodeInterface node) {
                super.nodeChanged(node);
                LOGGER.info("The selected node has been changed: {}", (Object)node);
                MotorPortPanelController.this.compDisp.dispose();
                MotorPortPanelController.this.compDisp.clear();
                MotorPortPanelController.this.compDisp = new CompositeDisposable();
                if (node != null) {
                    MotorPortPanelController.this.addMotorPortModelListener(node);
                }
            }
        });
        this.motorPortListPanel = motorPortListPanel;
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null) {
            this.addMotorPortModelListener(selectedNode);
        }
        return motorPortListPanel;
    }

    public void addTestToggleTask(NodeInterface node, Port<?> port) {
        LOGGER.info("Add test toggle task for node: {}, port: {}", (Object)node, port);
        NodePortWrapper nodePortWrapper = this.testToggleRegistry.remove(node);
        ScriptEngine scriptEngine = null;
        if (nodePortWrapper != null) {
            scriptEngine = nodePortWrapper.removePort(port);
        }
        if (scriptEngine != null) {
            LOGGER.info("Found a node scripting engine in the registry: {}", scriptEngine);
            try {
                scriptEngine.stopScript(Long.valueOf(2000L));
            }
            catch (Exception ex) {
                LOGGER.warn("Stop script failed.", (Throwable)ex);
            }
        }
        DefaultScriptContext context = new DefaultScriptContext();
        context.register("selectedNode", (Object)node);
        context.register("mainModel", (Object)this.mainModel);
        scriptEngine = new ScriptEngine((Scripting)this, (ApplicationContext)context);
        LinkedList<Object> scriptCommands = new LinkedList<Object>();
        MotorPortCommand spc = new MotorPortCommand(this.consoleService);
        spc.parse("motor " + port.getId() + " 10");
        scriptCommands.add(spc);
        WaitCommand wc = new WaitCommand(this.consoleService);
        wc.parse("wait 2000");
        scriptCommands.add(wc);
        spc = new MotorPortCommand(this.consoleService);
        spc.parse("motor " + port.getId() + " 0");
        scriptCommands.add(spc);
        wc = new WaitCommand(this.consoleService);
        wc.parse("wait 2000");
        scriptCommands.add(wc);
        LOGGER.info("Prepared list of commands: {}", scriptCommands);
        scriptEngine.setScriptCommands(scriptCommands);
        scriptEngine.setScriptRepeating(true);
        if (nodePortWrapper == null) {
            LOGGER.info("Create new NodePortWrapper for node: {}", (Object)node);
            nodePortWrapper = new NodePortWrapper(node);
        }
        LOGGER.info("Put script engine in registry for node: {}", (Object)node);
        nodePortWrapper.addPort(port, (ScriptEngine<PortScripting>)scriptEngine);
        this.testToggleRegistry.put(node, nodePortWrapper);
        scriptEngine.startScript();
    }

    public void stopTestToggleTask(NodeInterface node, Port<?> port) {
        LOGGER.info("Stop test toggle task for node: {}, port: {}", (Object)node, port);
        NodePortWrapper nodePortWrapper = this.testToggleRegistry.get(node);
        if (nodePortWrapper != null) {
            HashSet toRemove = new HashSet();
            if (port != null) {
                toRemove.add(port);
            } else {
                toRemove.addAll(nodePortWrapper.getKeySet());
            }
            for (Port port2 : toRemove) {
                ScriptEngine<PortScripting> engine = nodePortWrapper.removePort(port2);
                if (engine != null) {
                    LOGGER.info("Found a node scripting engine in the registry: {}", engine);
                    try {
                        engine.stopScript(Long.valueOf(2000L));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Stop script failed.", (Throwable)ex);
                    }
                    continue;
                }
                LOGGER.warn("No scripting engine found for node: {}", (Object)node);
            }
            if (nodePortWrapper.isEmpty()) {
                LOGGER.info("No more ports registered for node: {}", (Object)node);
                this.testToggleRegistry.remove(node);
            }
        }
    }

    public void sendPortStatusAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int port, BidibStatus portStatus) {
    }

    public void sendPortValueAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int port, int portValue) {
        LOGGER.info("Send motor value on the port: {}, portValue: {}", (Object)port, (Object)portValue);
        try {
            SwitchingNodeInterface selectedNode = node != null ? node : this.mainModel.getSelectedNode().getSwitchingNode();
            MotorPort motorPort = new MotorPort();
            motorPort.setId(port);
            motorPort.setValue(Integer.valueOf(portValue));
            this.switchingNodeService.setPortStatus("main", selectedNode, (Port)motorPort);
        }
        catch (Exception ex) {
            LOGGER.warn("Activate motor port failed.", (Throwable)ex);
        }
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.motorPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.motorPortListPanel.refreshView());
        }
    }

    private void addMotorPortModelListener(NodeInterface selectedNode) {
        LOGGER.info("Add motor port model listener for node: {}", (Object)selectedNode);
        Disposable disp = this.portConfigChangeEventSubject.subscribe(evt -> {
            LOGGER.info("Received event: {}", evt);
            PortTypeAware port = evt.getPort();
            try {
                MotorPort motorPort = new MotorPort();
                motorPort.setId(port.getPortNumber().intValue());
                LOGGER.info("Prepared motor port: {}", (Object)motorPort);
                this.switchingNodeService.setPortConfig("main", selectedNode.getSwitchingNode(), (Port)motorPort, null, evt.getPortConfig());
            }
            catch (Exception ex) {
                LOGGER.warn("Set the motorport config failed.", (Throwable)ex);
                selectedNode.setNodeHasError(true);
                selectedNode.setReasonData("Set the motorport config failed.");
            }
        });
        this.compDisp.add(disp);
    }
}

