/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.OutputStatusListener;
import org.bidib.wizard.client.common.model.SimplePortTableModel;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.model.ports.AnalogPort;
import org.bidib.wizard.model.status.AnalogPortStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.SimplePortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.ComboBoxWithButtonEditor;
import org.bidib.wizard.mvc.main.view.table.ComboBoxWithButtonRenderer;

public class AnalogPortListPanel
extends SimplePortListPanel<AnalogPortStatus, AnalogPort, OutputStatusListener<AnalogPortStatus, AnalogPort>, PortModelListener<AnalogPort>>
implements TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator {
    private static final long serialVersionUID = 1L;
    private final MainModel mainModel;
    private final TabVisibilityListener tabVisibilityListener;

    public AnalogPortListPanel(MainModel model, TabVisibilityListener tabVisibilityListener) {
        super(new SimplePortTableModel<AnalogPortStatus, AnalogPort, PortModelListener<AnalogPort>>(){
            private static final long serialVersionUID = 1L;

            public int getColumnPortInstance() {
                return 2;
            }

            public void notifyPortStatusChanged(AnalogPort port) {
            }

            public void notifyPortConfigChanged(AnalogPort port) {
            }

            public void notifyPortLabelChanged(AnalogPort port) {
            }

            public void refreshRow(AnalogPort port, IntConsumer rowConsumer) {
            }
        }, Resources.getString(AnalogPortListPanel.class, (String)"emptyTable"));
        this.mainModel = model;
        this.tabVisibilityListener = tabVisibilityListener;
        TableColumn buttonColumn = this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1);
        buttonColumn.setCellRenderer(new ComboBoxWithButtonRenderer<BidibStatus>(this.table.getActions((BidibStatus)AnalogPortStatus.START), ">"));
        buttonColumn.setCellEditor(new ComboBoxWithButtonEditor(this.table.getActions((BidibStatus)AnalogPortStatus.START), ">"));
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof AnalogPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void listChanged() {
        super.listChanged();
        this.tabVisibilityListener.setTabVisible(this, this.isTabVisible());
    }

    public Class<?> getPortClass() {
        return AnalogPort.class;
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasAnalogPorts();
            this.LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<AnalogPort> getPorts() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            return node.getAnalogPorts();
        }
        return Collections.emptyList();
    }
}

