/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import java.util.Dictionary;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SliderPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SliderPanel.class);
    private static final String INFINITY = "\u221e";
    private final JSlider slider;
    private final JLabel sliderLabel = new JLabel();
    private final ChangeListener sliderChangeListener;
    private int infiniteValue;
    private boolean silentUpdate;

    public SliderPanel(String title, int min, int max, int value, boolean inverted, int infiniteValue) {
        this.infiniteValue = infiniteValue;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        this.setLayout(new BoxLayout(this, 1));
        this.slider = new JSlider(0){
            private static final long serialVersionUID = 1L;

            @Override
            public Dictionary<?, ?> getLabelTable() {
                JLabel label;
                Dictionary result = super.getLabelTable();
                if (result != null && (label = (JLabel)result.get(SliderPanel.this.getInfiniteValue())) != null) {
                    label.setText(SliderPanel.INFINITY);
                }
                return result;
            }
        };
        this.sliderChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (SliderPanel.this.silentUpdate) {
                    LOGGER.info("Silent update flag is set, do not propagate to listeners.");
                    return;
                }
                SliderPanel.this.stateChanged(e);
            }
        };
        this.slider.addChangeListener(this.sliderChangeListener);
        this.slider.setInverted(inverted);
        this.slider.setMajorTickSpacing(max - min);
        this.slider.setMaximum(max);
        this.slider.setMinimum(min);
        this.slider.setMinorTickSpacing(16);
        this.slider.setPaintLabels(true);
        this.slider.setPaintTicks(true);
        this.slider.setValue(value);
        this.add(Box.createVerticalGlue());
        this.add(this.slider);
        this.add(Box.createVerticalGlue());
        this.setLabel(value);
        this.add(this.sliderLabel);
    }

    protected int getInfiniteValue() {
        return this.infiniteValue;
    }

    public void setLabel(int value) {
        this.sliderLabel.setText(value != this.infiniteValue ? String.valueOf(value) : INFINITY);
    }

    public void setValue(int value) {
        this.slider.setValue(value);
    }

    public void setValueSilently(int value) {
        try {
            this.silentUpdate = true;
            this.slider.removeChangeListener(this.sliderChangeListener);
            this.slider.setValue(value);
            this.setLabel(value);
        }
        finally {
            this.silentUpdate = false;
            this.slider.addChangeListener(this.sliderChangeListener);
        }
    }

    public abstract void stateChanged(ChangeEvent var1);
}

