/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.stepcontrol.view.converter;

import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.common.base.Preconditions;
import java.text.DecimalFormat;
import java.text.Format;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AngleDegreesConverter
implements BindingConverter<Number, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AngleDegreesConverter.class);
    private final Format format;
    private final long totalSteps;

    public AngleDegreesConverter(Format format, long totalSteps) {
        this.format = (Format)Preconditions.checkNotNull((Object)format, (String)"The format must not be null.");
        this.totalSteps = totalSteps;
    }

    public AngleDegreesConverter(long totalSteps) {
        this(new DecimalFormat("0.0"), totalSteps);
    }

    public String targetValue(Number sourceValue) {
        if (sourceValue != null) {
            long value = sourceValue.longValue();
            long lValue = value & 0xFFFFFFFFL;
            double angle = AngleDegreesConverter.getPositionAsAngle(lValue, this.totalSteps);
            return this.format.format(angle);
        }
        return null;
    }

    public static double getPositionAsAngle(long position, long totalSteps) {
        return (float)position * 360.0f / (float)totalSteps;
    }

    public Number sourceValue(String targetValue) {
        try {
            if (StringUtils.isNotBlank((CharSequence)targetValue)) {
                return Long.valueOf(targetValue);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Cannot parse the target value {}", (Object)targetValue);
        }
        return null;
    }
}

