package org.bidib.wizard.mvc.main.controller;

import java.util.Map;

import org.bidib.jbidibc.messages.port.PortConfigValue;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.NodeSelectionListener;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.model.status.CommandStationStatus;

public interface MainControllerInterface {

    void stop();

    /**
     * Open the connection.
     */
    void openConnection();

    /**
     * Close the connection.
     */
    void closeConnection();

    /**
     * Listen for incoming netBidib connections.
     */
    void listenNetBidib();

    /**
     * Clear the nodes.
     */
    void clearNodes();

    void addNodeListListener(NodeListListener nodeListListener);

    void removeNodeListListener(NodeListListener nodeListListener);

    void addNodeSelectionListListener(NodeSelectionListener l);

    void removeNodeSelectionListener(NodeSelectionListener l);

    /**
     * Switch all boosters off.
     */
    void allBoosterOff();

    /**
     * Switch all boosters on.
     * 
     * @param boosterAndCommandStation
     *            switch all booster and command station on
     * @param requestedCommandStationState
     *            the requested command station state
     */
    void allBoosterOn(boolean boosterAndCommandStation, CommandStationStatus requestedCommandStationState);

    /**
     * Reset the node.
     * 
     * @param node
     *            the node
     */
    void resetNode(final NodeInterface node);

    void transferAccessoryToNode(final NodeInterface node, final Accessory accessory);

    /**
     * Replace the port config.
     * 
     * @param portType
     *            the port type
     * @param portConfig
     *            the new port config
     */
    void replacePortConfig(TargetType portType, final Map<Byte, PortConfigValue<?>> portConfig);

    /**
     * Switch the port type.
     * 
     * @param portType
     *            the port type
     */
    void mapPortType(TargetType portType);

}
