/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel;

import java.awt.Point;
import java.awt.event.ActionEvent;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.mvc.dmx.view.panel.DmxChartPanel;
import org.bidib.wizard.mvc.dmx.view.panel.LocationAwareAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmxChannelAction
extends LocationAwareAction<DmxChannel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmxChannelAction.class);
    private static final long serialVersionUID = 1L;

    public DmxChannelAction(DmxChannel dmxChannel, DmxChartPanel dmxChartPanel) {
        super(dmxChannel.toString(), (Object)dmxChannel, dmxChartPanel);
    }

    public void actionPerformed(ActionEvent event) {
        Point currentMousePoint = this.dmxChartPanel.getCurrentMousePoint();
        String seriesKey = Integer.toString(((DmxChannel)this.getActionObject()).getChannelId());
        LOGGER.info("Selected series key: {}, currentMousePoint: {}", (Object)seriesKey, (Object)currentMousePoint);
        int currentX = (int)Math.round(currentMousePoint.getX());
        int currentY = (int)Math.round(currentMousePoint.getY());
        DmxChartPanel.LOGGER.info("Add new point at X: {}, Y: {}", (Object)currentX, (Object)currentY);
        LOGGER.info("Create a new point without a port at X: {}, Y: {}", (Object)currentX, (Object)currentY);
        this.dmxChartPanel.createDataItem(seriesKey, currentX, currentY, (Port)null, (DmxChannel)this.getActionObject(), null);
    }
}

