/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.firmware.model;

import com.jgoodies.binding.beans.Model;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.exchange.firmware.FilenameType;
import org.bidib.jbidibc.exchange.firmware.FirmwareNode;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.core.model.firmware.NodeUpdateStatus;
import org.bidib.wizard.core.model.firmware.UpdateStatus;
import org.bidib.wizard.mvc.firmware.model.listener.FirmwareModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmwareModel
extends Model {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirmwareModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTYNAME_IN_PROGRESS = "inProgress";
    public static final String PROPERTYNAME_IDLE = "idle";
    public static final String PROPERTYNAME_IDLE_AND_VALID = "idleAndValid";
    public static final String PROPERTYNAME_UPDATE_STATUS = "updateStatus";
    public static final String PROPERTYNAME_NODE_UPDATE_STATUS = "nodeUpdateStatus";
    public static final String PROPERTYNAME_CV_DEFINITION_FILES = "cvDefinitionFiles";
    public static final String PROPERTYNAME_UPDATE_VERSION = "updateVersion";
    public static final String PROPERTYNAME_DEFAULT_LABELS_FILES = "defaultLabelsFiles";
    public static final String PROPERTYNAME_VENDOR_IMAGE_FILES = "vendorImageFiles";
    private final Collection<FirmwareModelListener> listeners = new LinkedList();
    private boolean inProgress = false;
    private int progressValue = 0;
    private NodeInterface node;
    private String nodeName;
    private String productName;
    private String uniqueId;
    private String nodeCurrentVersion;
    private boolean errorDetected = false;
    private String firmwareArchivePath;
    private String cvDefinitionArchivePath;
    private String vendorImageArchivePath;
    private List<FirmwareNode> firmwareFiles;
    private List<String> cvDefinitionFiles;
    private List<String> vendorImageFiles;
    private UpdateStatus updateStatus = UpdateStatus.NONE;
    private NodeUpdateStatus nodeUpdateStatus = NodeUpdateStatus.NONE;
    private boolean isBootloaderRootNode;
    private String updateVersion;
    private List<FilenameType> defaultLabelsFiles;

    public void addFirmwareModelListener(FirmwareModelListener l) {
        this.listeners.add(l);
    }

    public void removeFirmwareModelListener(FirmwareModelListener l) {
        this.listeners.remove(l);
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public void setInProgress(boolean inProgress) {
        boolean oldValue = this.inProgress;
        boolean oldIdleAndValid = this.isIdleAndValid();
        this.inProgress = inProgress;
        boolean newIdleAndValid = this.isIdleAndValid();
        SwingUtilities.invokeLater(() -> {
            this.firePropertyChange(PROPERTYNAME_IN_PROGRESS, oldValue, inProgress);
            this.firePropertyChange(PROPERTYNAME_IDLE, !oldValue, !inProgress);
            this.firePropertyChange(PROPERTYNAME_IDLE_AND_VALID, oldIdleAndValid, newIdleAndValid);
        });
    }

    public void setIdle(boolean idle) {
        boolean oldValue = !this.inProgress;
        boolean oldIdleAndValid = this.isIdleAndValid();
        this.inProgress = !idle;
        boolean newIdleAndValid = this.isIdleAndValid();
        SwingUtilities.invokeLater(() -> {
            this.firePropertyChange(PROPERTYNAME_IDLE, oldValue, this.inProgress);
            this.firePropertyChange(PROPERTYNAME_IDLE_AND_VALID, oldIdleAndValid, newIdleAndValid);
        });
    }

    public boolean isIdle() {
        return !this.inProgress;
    }

    public boolean isIdleAndValid() {
        boolean isIdleAndValid = !this.inProgress && !UpdateStatus.NODE_LOST.equals((Object)this.updateStatus);
        LOGGER.info("isIdleAndValid: {}, inProgress: {}, updateStatus: {}", new Object[]{isIdleAndValid, this.inProgress, this.updateStatus});
        return isIdleAndValid;
    }

    public int getProgressValue() {
        return this.progressValue;
    }

    public void setProgressValue(int progressValue) {
        if (this.progressValue != progressValue) {
            this.progressValue = progressValue;
            this.fireProgressChanged(progressValue);
        }
    }

    public void addProcessingStatus(String processingStatus, int style, Object ... args) {
        this.fireProcessingStatusChanged(processingStatus, style, args);
    }

    public NodeInterface getNode() {
        return this.node;
    }

    public void setNode(NodeInterface node) {
        this.node = node;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getNodeCurrentVersion() {
        return this.nodeCurrentVersion;
    }

    public void setNodeCurrentVersion(String version) {
        this.nodeCurrentVersion = version;
    }

    public boolean isErrorDetected() {
        return this.errorDetected;
    }

    public void setFirmwareFiles(String firmwareArchivePath, List<FirmwareNode> firmwareFiles) {
        this.firmwareArchivePath = firmwareArchivePath;
        this.firmwareFiles = firmwareFiles;
        this.fireFirmwareFileChanged();
    }

    public List<FirmwareNode> getFirmwareFiles() {
        LinkedList files = new LinkedList();
        files.addAll(this.firmwareFiles);
        return Collections.unmodifiableList(files);
    }

    public List<String> getCvDefinitionFiles() {
        if (this.cvDefinitionFiles == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.cvDefinitionFiles);
    }

    public void setCvDefinitionFiles(String cvDefinitionArchivePath, List<String> cvDefinitionFiles) {
        this.cvDefinitionArchivePath = cvDefinitionArchivePath;
        List oldValue = this.cvDefinitionFiles;
        if (cvDefinitionFiles == null) {
            cvDefinitionFiles = Collections.emptyList();
        }
        this.cvDefinitionFiles = cvDefinitionFiles;
        this.firePropertyChange(PROPERTYNAME_CV_DEFINITION_FILES, (Object)oldValue, cvDefinitionFiles);
    }

    public List<String> getVendorImageFiles() {
        if (this.vendorImageFiles == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.vendorImageFiles);
    }

    public void setVendorImageFiles(String vendorImageArchivePath, List<String> vendorImageFiles) {
        this.vendorImageArchivePath = vendorImageArchivePath;
        List oldValue = this.vendorImageFiles;
        if (this.cvDefinitionFiles == null) {
            this.cvDefinitionFiles = Collections.emptyList();
        }
        this.vendorImageFiles = vendorImageFiles;
        this.firePropertyChange(PROPERTYNAME_VENDOR_IMAGE_FILES, (Object)oldValue, (Object)this.vendorImageFiles);
    }

    public String getCvDefinitionArchivePath() {
        return this.cvDefinitionArchivePath;
    }

    public String getVendorImageArchivePath() {
        return this.vendorImageArchivePath;
    }

    public String getFirmwareArchivePath() {
        return this.firmwareArchivePath;
    }

    public UpdateStatus getUpdateStatus() {
        return this.updateStatus;
    }

    public void setUpdateStatus(UpdateStatus updateStatus) {
        UpdateStatus oldValue = this.updateStatus;
        boolean oldIdleAndValid = this.isIdleAndValid();
        this.updateStatus = updateStatus;
        boolean newIdleAndValid = this.isIdleAndValid();
        SwingUtilities.invokeLater(() -> {
            this.firePropertyChange(PROPERTYNAME_UPDATE_STATUS, (Object)oldValue, (Object)updateStatus);
            this.firePropertyChange(PROPERTYNAME_IDLE_AND_VALID, oldIdleAndValid, newIdleAndValid);
        });
    }

    public NodeUpdateStatus getNodeUpdateStatus() {
        return this.nodeUpdateStatus;
    }

    public void setNodeUpdateStatus(NodeUpdateStatus nodeUpdateStatus) {
        NodeUpdateStatus oldValue = this.nodeUpdateStatus;
        this.nodeUpdateStatus = nodeUpdateStatus;
        SwingUtilities.invokeLater(() -> this.firePropertyChange(PROPERTYNAME_NODE_UPDATE_STATUS, (Object)oldValue, (Object)this.nodeUpdateStatus));
    }

    public boolean isBootloaderRootNode() {
        return this.isBootloaderRootNode;
    }

    public void setBootloaderRootNode(boolean isBootloaderRootNode) {
        this.isBootloaderRootNode = isBootloaderRootNode;
    }

    public String getUpdateVersion() {
        return this.updateVersion;
    }

    public void setUpdateVersion(String updateVersion) {
        String oldValue = this.updateVersion;
        this.updateVersion = updateVersion;
        SwingUtilities.invokeLater(() -> this.firePropertyChange(PROPERTYNAME_UPDATE_VERSION, (Object)oldValue, (Object)updateVersion));
    }

    public List<FilenameType> getDefaultLabelsFiles() {
        return this.defaultLabelsFiles;
    }

    public void setDefaultLabelsFiles(String cvDefinitionArchivePath, List<FilenameType> defaultLabelsFiles) {
        this.cvDefinitionArchivePath = cvDefinitionArchivePath;
        List oldValue = this.defaultLabelsFiles;
        this.defaultLabelsFiles = defaultLabelsFiles;
        this.firePropertyChange(PROPERTYNAME_DEFAULT_LABELS_FILES, (Object)oldValue, defaultLabelsFiles);
    }

    private void fireProcessingStatusChanged(String processingStatus, int style, Object ... args) {
        for (FirmwareModelListener l : this.listeners) {
            l.processingStatusChanged(processingStatus, style, args);
        }
    }

    private void fireProgressChanged(int progressValue) {
        for (FirmwareModelListener l : this.listeners) {
            l.progressValueChanged(progressValue);
        }
    }

    private void fireFirmwareFileChanged() {
        for (FirmwareModelListener l : this.listeners) {
            l.firmwareFileChanged();
        }
    }
}

