/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.controller;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.DriveAcknowledge;
import org.bidib.jbidibc.messages.enums.PositionLocationEnum;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.jbidibc.messages.utils.ThreadFactoryBuilder;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeProvider;
import org.bidib.wizard.api.model.connection.AbstractMessageEvent;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.api.model.connection.event.CommandStationDriveAcknowledgeMessageEvent;
import org.bidib.wizard.api.model.connection.event.OccupancyCvMessageEvent;
import org.bidib.wizard.api.model.connection.event.OccupancyDynStateMessageEvent;
import org.bidib.wizard.api.model.connection.event.OccupancyPositionMessageEvent;
import org.bidib.wizard.api.model.connection.event.OccupancySpeedMessageEvent;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.exception.ConnectionException;
import org.bidib.wizard.core.model.connection.MessageEventConsumer;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.common.view.RegisteredDialog;
import org.bidib.wizard.mvc.common.view.ViewCloseListener;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.loco.model.LocoModel;
import org.bidib.wizard.mvc.loco.model.RfBasisMode;
import org.bidib.wizard.mvc.loco.model.listener.LocoModelListener;
import org.bidib.wizard.mvc.loco.view.LocoDialog;
import org.bidib.wizard.utils.WindowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LocoController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoController.class);
    private final CommandStationNodeInterface node;
    private final JFrame parent;
    private final LocoModel locoModel = new LocoModel();
    private LocoDialog locoView;
    private LocoModelListener locoModelListener;
    @Autowired
    private ConnectionService connectionService;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private ConsoleService consoleService;
    private CompositeDisposable compDispMessages;
    private final NodeProvider nodeProvider;
    private final ScheduledExecutorService commandStationStatusWorker;
    private final ScheduledExecutorService commandStationSpeedWorker;
    private final Map<Class<? extends AbstractMessageEvent>, MessageEventConsumer<AbstractMessageEvent, NodeInterface>> messageActionMap = new HashMap();

    public LocoController(CommandStationNodeInterface node, JFrame parent, NodeProvider nodeProvider) {
        this.node = node;
        this.parent = parent;
        this.nodeProvider = nodeProvider;
        this.compDispMessages = new CompositeDisposable();
        this.commandStationStatusWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("commandStationStatusWorkers-thread-%d").build());
        this.commandStationSpeedWorker = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("commandStationSpeedWorkers-thread-%d").build());
    }

    public void start(AddressData initialAddress, SpeedSteps speedSteps) {
        ArrayList<LocoDialog> dialogRegistry;
        LOGGER.info("Current connectionService: {}", (Object)this.connectionService);
        if (ProductUtils.isRFBasisNode((long)this.node.getNode().getUniqueId()) || ProductUtils.isSpeedometer((long)this.node.getNode().getUniqueId())) {
            LOGGER.info("The default speed steps for the decoders on the RF Basis Node or Speedometer is 128.");
            this.locoModel.setSpeedSteps(speedSteps != null ? speedSteps : this.settingsService.getWizardSettings().getLastSelectedSpeedSteps());
            this.locoModel.setCarControlEnabled(true);
        } else {
            this.locoModel.setSpeedSteps(speedSteps != null ? speedSteps : this.settingsService.getWizardSettings().getLastSelectedSpeedSteps());
        }
        if (initialAddress != null) {
            LOGGER.info("Set the provided initial address: {}", (Object)initialAddress);
            this.locoModel.setAddress(Integer.valueOf(initialAddress.getAddress()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(dialogRegistry = (ArrayList<LocoDialog>)DefaultApplicationContext.getInstance().get("dialogRegistry", List.class)))) {
            String searchKey = LocoDialog.prepareKey((Integer)this.locoModel.getAddress());
            RegisteredDialog existingDialog = (RegisteredDialog)IterableUtils.find((Iterable)dialogRegistry, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
            if (existingDialog != null) {
                LOGGER.info("Found existing dialog: {}", (Object)existingDialog);
                try {
                    if (SystemUtils.IS_OS_WINDOWS) {
                        WindowUtils.bringWindowToFront((Window)((Window)existingDialog));
                    } else {
                        ((Window)existingDialog).toFront();
                    }
                    return;
                }
                catch (Exception ex) {
                    LOGGER.warn("Bring the existing dialog to front failed.");
                }
            } else {
                LOGGER.info("No existing dialog found.");
            }
        }
        this.prepareMessageMap();
        try {
            CompositeDisposable disp = new CompositeDisposable();
            Disposable dispConnStatus = this.connectionService.subscribeConnectionStatusChanges(connectionInfo -> {
                if (connectionInfo.getConnectionId().equals("main")) {
                    LOGGER.info("Current state: {}", (Object)connectionInfo.getConnectionState());
                    switch (6.$SwitchMap$org$bidib$api$json$types$ConnectionPhase[connectionInfo.getConnectionState().getActualPhase().ordinal()]) {
                        case 1: {
                            LOGGER.info("The connection was opened.");
                            this.registerForMessages();
                            break;
                        }
                        case 2: {
                            LOGGER.info("The connection was closed.");
                            this.compDispMessages.dispose();
                            if (this.locoView != null) {
                                this.locoView.close(this.settingsService);
                                this.locoView = null;
                            }
                            disp.dispose();
                            break;
                        }
                    }
                }
            }, error -> LOGGER.warn("The connection status change caused an error.", error));
            disp.add(dispConnStatus);
        }
        catch (Exception ex) {
            LOGGER.warn("Register controller as node listener failed.", (Throwable)ex);
        }
        try {
            LOGGER.info("Check if the connection is connected already.");
            boolean isConnected = this.connectionService.isConnected("main");
            if (isConnected) {
                this.registerForMessages();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Register for messages failed.", (Throwable)ex);
        }
        this.locoModelListener = new /* Unavailable Anonymous Inner Class!! */;
        this.locoModel.addLocoModelListener(this.locoModelListener);
        this.locoModel.addPropertyChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        LOGGER.info("Create new instance of LocoDialog.");
        this.locoView = new LocoDialog(this.parent, this.locoModel, this.settingsService);
        this.locoView.addViewCloseListener((ViewCloseListener)new /* Unavailable Anonymous Inner Class!! */);
        if (dialogRegistry == null) {
            dialogRegistry = new ArrayList<LocoDialog>();
            DefaultApplicationContext.getInstance().register("dialogRegistry", dialogRegistry);
        }
        LOGGER.info("Register the LocoDialog in the dialog registry: {}", (Object)this.locoView);
        dialogRegistry.add(this.locoView);
        try {
            CompositeDisposable disp = new CompositeDisposable();
            Disposable dispCsState = this.node.subscribeSubjectCommandStationState(csState -> {
                LOGGER.info("Current command station state: {}", csState);
                if (CommandStationState.isOffState((CommandStationState)csState)) {
                    LOGGER.info("Set the command station to status GO.");
                    this.commandStationStatusWorker.submit(() -> this.commandStationService.setCommandStationState("main", this.node, CommandStationStatus.GO));
                }
                disp.dispose();
            }, error -> {
                LOGGER.warn("Get the current command station state failed.");
                disp.dispose();
            }, () -> LOGGER.warn("Get the current command station state subscription has completed, node: {}", (Object)this.node));
            disp.add(dispCsState);
            this.commandStationService.queryCommandStationState("main", this.node);
        }
        catch (Exception ex) {
            LOGGER.warn("Get command station state failed.", (Throwable)ex);
        }
    }

    private void registerForMessages() {
        LOGGER.info("Register for messages from the connection.");
        try {
            BidibConnection connection = this.connectionService.find("main");
            Disposable dispMessages = connection.getSubjectMessages().subscribe(msg -> this.handleBidibMessageEvent(msg));
            this.compDispMessages.add(dispMessages);
        }
        catch (ConnectionException ex) {
            LOGGER.warn("No connection found, register on messages is skipped.", (Throwable)ex);
        }
    }

    private void prepareMessageMap() {
        LOGGER.info("Prepare the message map.");
        this.messageActionMap.put(OccupancySpeedMessageEvent.class, (evt, node) -> {
            OccupancySpeedMessageEvent event = (OccupancySpeedMessageEvent)evt;
            AddressData addressData = event.getAddressData();
            if (this.locoModel.getAddress() != null && addressData.getAddress() == this.locoModel.getAddress().intValue()) {
                int speed = event.getSpeed();
                SwingUtilities.invokeLater(() -> {
                    LOGGER.info("Update the reported speed: {}", (Object)speed);
                    this.locoModel.setReportedSpeed(Integer.valueOf(speed));
                });
            }
        });
        this.messageActionMap.put(OccupancyDynStateMessageEvent.class, (evt, node) -> {
            OccupancyDynStateMessageEvent event = (OccupancyDynStateMessageEvent)evt;
            AddressData decoderAddress = event.getDecoderAddress();
            int dynNumber = event.getDynNumber();
            int dynValue = event.getDynValue();
            LOGGER.info("dynState, decoderAddress: {}, dynNumber: {}, dynValue: {}", new Object[]{decoderAddress, dynNumber, dynValue});
            SwingUtilities.invokeLater(() -> {
                if (this.locoModel.getAddress() != null && decoderAddress.getAddress() == this.locoModel.getAddress().intValue() && dynNumber == 3) {
                    this.locoModel.setDynStateEnergy(dynValue);
                } else {
                    LOGGER.debug("The dynState ist not forwarded to model");
                }
            });
        });
        this.messageActionMap.put(OccupancyCvMessageEvent.class, (evt, node) -> {
            OccupancyCvMessageEvent event = (OccupancyCvMessageEvent)evt;
            LOGGER.info("Received new occupancy CV event: {}", (Object)event);
            LOGGER.warn("The occupancy CV event is not processed and discarded: {}", (Object)event);
        });
        this.messageActionMap.put(CommandStationDriveAcknowledgeMessageEvent.class, (evt, node) -> {
            CommandStationDriveAcknowledgeMessageEvent event = (CommandStationDriveAcknowledgeMessageEvent)evt;
            LOGGER.info("Received new commandStationDrive acknowledge event: {}", (Object)event);
            byte[] address = event.getAddress();
            int dccAddress = event.getDccAddress();
            DriveAcknowledge state = event.getDriveAcknowledge();
            Integer getAcknowledgedMessageNumber = event.getAcknowledgedMessageNumber();
            LOGGER.debug("The CS_DRIVE message was acknowledge, node address: {}, dccAddress: {}, driveAck: {}, getAcknowledgedMessageNumber: {}", new Object[]{NodeUtils.formatAddressLong((byte[])address), dccAddress, state, getAcknowledgedMessageNumber});
            if (node != null && Arrays.equals(address, node.getNode().getAddr()) && this.locoModel.getAddress() != null && dccAddress == this.locoModel.getAddress()) {
                LOGGER.info("Received drive ackn for the selected node, dccAddress: {}, driveAck: {}, getAcknowledgedMessageNumber: {}", new Object[]{dccAddress, state, getAcknowledgedMessageNumber});
                this.locoModel.incCounterCsDriveAck();
            }
        });
        this.messageActionMap.put(OccupancyPositionMessageEvent.class, (evt, node) -> {
            OccupancyPositionMessageEvent event = (OccupancyPositionMessageEvent)evt;
            LOGGER.debug("Process the event: {}", (Object)event);
            if (event.getLocationType() == PositionLocationEnum.cellIdentifier && this.locoModel.getAddress() != null && event.getDecoderAddress() == this.locoModel.getAddress()) {
                SwingUtilities.invokeLater(() -> {
                    LOGGER.info("Update the cellIdentifier: {}", (Object)event);
                    this.locoModel.setReportedCellNumber(Integer.valueOf(event.getLocationAddress()));
                });
            } else {
                LOGGER.debug("Do not show position feedback with type: {}", (Object)event.getLocationType());
            }
        });
    }

    private void handleBidibMessageEvent(AbstractMessageEvent event) {
        LOGGER.debug("Handle the message event: {}", (Object)event);
        try {
            MessageEventConsumer action = (MessageEventConsumer)this.messageActionMap.get(event.getClass());
            if (action != null) {
                action.accept((Object)event, (Object)this.node.getNode());
            } else {
                LOGGER.debug("No message event action configured for event: {}", (Object)event);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Execute the message event action failed, node: {}, event: {}", new Object[]{this.node, event, ex});
        }
    }

    private void unregisterView(RegisteredDialog view) {
        if (view != null) {
            try {
                String searchKey;
                RegisteredDialog existingDialog;
                List dialogRegistry = (List)DefaultApplicationContext.getInstance().get("dialogRegistry", List.class);
                if (CollectionUtils.isNotEmpty((Collection)dialogRegistry) && (existingDialog = (RegisteredDialog)IterableUtils.find((Iterable)dialogRegistry, (Predicate)new /* Unavailable Anonymous Inner Class!! */)) != null) {
                    LOGGER.info("Found existing dialog to unregister: {}", (Object)existingDialog);
                    dialogRegistry.remove(existingDialog);
                    LOGGER.info("Registry after remove: {}", (Object)dialogRegistry);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Unregister view failed: {}", (Object)view, (Object)ex);
            }
        } else {
            LOGGER.info("No view available to unregister.");
        }
    }

    private void registerActiveRfBasis(Context context) {
        if (this.locoModel.isCarControlEnabled() && this.locoModel.getActiveBase() != null && this.locoModel.getActiveBase() != RfBasisMode.SINGLE) {
            RfBasisMode activeRfBase = this.locoModel.getActiveBase();
            this.registerRfBasisInContext(context, activeRfBase);
        }
    }

    private void registerPrevActiveRfBasis(Context context) {
        if (this.locoModel.isCarControlEnabled() && this.locoModel.getPrevActiveBase() != null && this.locoModel.getPrevActiveBase() != RfBasisMode.SINGLE) {
            RfBasisMode prevActiveRfBase = this.locoModel.getPrevActiveBase();
            this.registerRfBasisInContext(context, prevActiveRfBase);
        }
    }

    private void registerRfBasisInContext(Context context, RfBasisMode rfBase) {
        context.unregister("activeRfBasis");
        if (rfBase.getBaseNumber() != null) {
            int activeBaseNumber = rfBase.getBaseNumber();
            NodeInterface rfBasisNode = this.nodeProvider.getNodes().stream().filter(bidibNode -> ProductUtils.isRFBasisNode((long)bidibNode.getUniqueId()) && bidibNode.getBaseNumber() == activeBaseNumber).findFirst().orElse(null);
            if (rfBasisNode != null) {
                LOGGER.info("Found the active rfBasisNode: {}", (Object)rfBasisNode);
                context.register("activeRfBasis", (Object)rfBasisNode.getNode());
            } else {
                LOGGER.warn("No active rfBasisNode found for activeBaseNumber: {}", (Object)activeBaseNumber);
            }
        } else {
            LOGGER.info("No base number for active rf base available.");
        }
    }
}

