/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.model;

import com.jgoodies.common.bean.Bean;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.loco.model.BinStateValue;
import org.bidib.wizard.mvc.loco.model.RfBasisMode;
import org.bidib.wizard.mvc.loco.model.listener.LocoModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoModel
extends Bean {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoModel.class);
    private final Collection<LocoModelListener> listeners = new LinkedList();
    public static final String PROPERTYNAME_SPEED = "speed";
    public static final String PROPERTYNAME_ADDRESS = "address";
    public static final String PROPERTYNAME_ACTIVE_BASE = "activeBase";
    public static final String PROPERTYNAME_REPORTED_CELLNUMBER = "reportedCellNumber";
    public static final String PROPERTYNAME_REPORTED_SPEED = "reportedSpeed";
    public static final String PROPERTYNAME_CARCONTROLENABLED = "carControlEnabled";
    public static final String PROPERTYNAME_DEV_BINSTATE_NUMBER = "devBinStateNumber";
    public static final String PROPERTYNAME_DEV_BINSTATE_VALUE = "devBinStateValue";
    public static final String PROPERTYNAME_COUNTER_CS_DRIVE = "counterCsDrive";
    public static final String PROPERTYNAME_COUNTER_CS_DRIVE_ACK = "counterCsDriveAck";
    public static final String PROPERTYNAME_COUNTER_CS_BIN_STATE = "counterCsBinState";
    private Integer address;
    private Integer reportedSpeed;
    private int dynStateEnergy;
    private DirectionStatus direction = DirectionStatus.FORWARD;
    private Integer speed;
    private SpeedSteps speedSteps = SpeedSteps.DCC128;
    private BitSet functions = new BitSet(29);
    private boolean carControlEnabled;
    private RfBasisMode activeBase = RfBasisMode.SINGLE;
    private RfBasisMode prevActiveBase;
    private Integer reportedCellNumber;
    private Integer devBinStateNumber;
    private BinStateValue devBinStateValue = BinStateValue.ON;
    private AtomicInteger counterCsDrive = new AtomicInteger();
    private AtomicInteger counterCsDriveAck = new AtomicInteger();
    private AtomicInteger counterCsBinState = new AtomicInteger();

    public void addLocoModelListener(LocoModelListener l) {
        this.listeners.add(l);
    }

    public void removeLocoModelListener(LocoModelListener l) {
        this.listeners.remove(l);
    }

    public Integer getAddress() {
        return this.address;
    }

    public void setAddress(Integer address) {
        Integer oldValue = this.address;
        this.address = address;
        this.firePropertyChange(PROPERTYNAME_ADDRESS, (Object)oldValue, (Object)address);
    }

    public Integer getReportedSpeed() {
        return this.reportedSpeed;
    }

    public void setReportedSpeed(Integer reportedSpeed) {
        LOGGER.info("Update the reported speed: {}", (Object)reportedSpeed);
        Integer oldValue = this.reportedSpeed;
        this.reportedSpeed = reportedSpeed;
        this.firePropertyChange(PROPERTYNAME_REPORTED_SPEED, (Object)oldValue, (Object)reportedSpeed);
    }

    public DirectionStatus getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionStatus direction) {
        if (this.direction != direction) {
            this.direction = direction;
            this.fireDirectionChanged(direction);
        }
    }

    public boolean getFunction(int index) {
        return this.functions.get(index);
    }

    public BitSet getFunctions() {
        return (BitSet)this.functions.clone();
    }

    public void setFunction(int index, boolean value) {
        if (this.getFunction(index) != value) {
            this.functions.set(index, value);
            this.fireFunctionChanged(index, value);
        }
    }

    public int getDynStateEnergy() {
        return this.dynStateEnergy;
    }

    public void setDynStateEnergy(int dynStateEnergy) {
        if (this.dynStateEnergy != dynStateEnergy || dynStateEnergy == 0 || dynStateEnergy == 1) {
            this.dynStateEnergy = dynStateEnergy;
            this.fireDynStateEnergyChanged(dynStateEnergy);
        }
    }

    public SpeedSteps getSpeedSteps() {
        return this.speedSteps;
    }

    public void setSpeedSteps(SpeedSteps speedSteps) {
        if (this.speedSteps != speedSteps) {
            this.speedSteps = speedSteps;
            this.fireSpeedStepsChanged(speedSteps);
        }
    }

    public Integer getSpeed() {
        return this.speed;
    }

    public void setSpeed(Integer speed) {
        Integer oldValue = this.speed;
        LOGGER.info("Set the new speed: {}, oldValue: {}", (Object)speed, (Object)oldValue);
        this.speed = speed;
        if (speed != null && (speed == 0 || speed == 1)) {
            oldValue = null;
        }
        this.firePropertyChange(PROPERTYNAME_SPEED, (Object)oldValue, (Object)speed);
    }

    private void fireDirectionChanged(DirectionStatus direction) {
        for (LocoModelListener l : this.listeners) {
            l.directionChanged(direction);
        }
    }

    private void fireFunctionChanged(int index, boolean value) {
        for (LocoModelListener l : this.listeners) {
            l.functionChanged(index, value);
        }
    }

    private void fireSpeedStepsChanged(SpeedSteps speedSteps) {
        for (LocoModelListener l : this.listeners) {
            l.speedStepsChanged(speedSteps);
        }
    }

    private void fireDynStateEnergyChanged(int dynStateEnergy) {
        for (LocoModelListener l : this.listeners) {
            l.dynStateEnergyChanged(dynStateEnergy);
        }
    }

    private void fireBinaryStateChanged(int state, boolean value) {
        for (LocoModelListener l : this.listeners) {
            l.binaryStateChanged(state, value);
        }
    }

    public void setBinaryState(int state, boolean value) {
        this.fireBinaryStateChanged(state, value);
    }

    public boolean isCarControlEnabled() {
        return this.carControlEnabled;
    }

    public void setCarControlEnabled(boolean carControlEnabled) {
        boolean oldValue = this.carControlEnabled;
        this.carControlEnabled = carControlEnabled;
        this.firePropertyChange(PROPERTYNAME_CARCONTROLENABLED, oldValue, carControlEnabled);
    }

    public RfBasisMode getActiveBase() {
        return this.activeBase;
    }

    public void setActiveBase(RfBasisMode activeBase) {
        LOGGER.info("Set the new active rf base: {}", (Object)activeBase);
        RfBasisMode oldValue = this.activeBase;
        if (this.activeBase != activeBase) {
            LOGGER.info("The new active rf base has changed. Update the prev active base: {}", (Object)this.activeBase);
            this.prevActiveBase = this.activeBase;
        }
        this.activeBase = activeBase;
        this.firePropertyChange(PROPERTYNAME_ACTIVE_BASE, (Object)oldValue, (Object)activeBase);
    }

    public RfBasisMode getPrevActiveBase() {
        return this.prevActiveBase;
    }

    public void resetPrevActiveBase() {
        this.prevActiveBase = null;
    }

    public Integer getReportedCellNumber() {
        return this.reportedCellNumber;
    }

    public void setReportedCellNumber(Integer reportedCellNumber) {
        Integer oldValue = this.reportedCellNumber;
        this.reportedCellNumber = reportedCellNumber;
        this.firePropertyChange(PROPERTYNAME_REPORTED_CELLNUMBER, (Object)oldValue, (Object)this.reportedCellNumber);
    }

    public Integer getDevBinStateNumber() {
        return this.devBinStateNumber;
    }

    public void setDevBinStateNumber(Integer devBinStateNumber) {
        Integer oldValue = this.devBinStateNumber;
        this.devBinStateNumber = devBinStateNumber;
        this.firePropertyChange(PROPERTYNAME_DEV_BINSTATE_NUMBER, (Object)oldValue, (Object)devBinStateNumber);
    }

    public BinStateValue getDevBinStateValue() {
        return this.devBinStateValue;
    }

    public void setDevBinStateValue(BinStateValue devBinStateValue) {
        BinStateValue oldValue = this.devBinStateValue;
        this.devBinStateValue = devBinStateValue;
        this.firePropertyChange(PROPERTYNAME_DEV_BINSTATE_VALUE, (Object)oldValue, (Object)devBinStateValue);
    }

    public int getCounterCsDrive() {
        return this.counterCsDrive.get();
    }

    public int incCounterCsDrive() {
        int oldValue = this.counterCsDrive.get();
        int newValue = this.counterCsDrive.addAndGet(1);
        this.firePropertyChange(PROPERTYNAME_COUNTER_CS_DRIVE, oldValue, newValue);
        return newValue;
    }

    public void resetCounterCsDrive() {
        int oldValue = this.counterCsDrive.get();
        this.counterCsDrive.set(0);
        this.firePropertyChange(PROPERTYNAME_COUNTER_CS_DRIVE, oldValue, 0);
    }

    public int getCounterCsDriveAck() {
        return this.counterCsDriveAck.get();
    }

    public int incCounterCsDriveAck() {
        int oldValue = this.counterCsDriveAck.get();
        int newValue = this.counterCsDriveAck.addAndGet(1);
        SwingUtilities.invokeLater(() -> this.firePropertyChange(PROPERTYNAME_COUNTER_CS_DRIVE_ACK, oldValue, newValue));
        return newValue;
    }

    public void resetCounterCsAckDrive() {
        int oldValue = this.counterCsDriveAck.get();
        this.counterCsDriveAck.set(0);
        this.firePropertyChange(PROPERTYNAME_COUNTER_CS_DRIVE_ACK, oldValue, 0);
    }

    public int getCounterCsBinState() {
        return this.counterCsBinState.get();
    }

    public int incCounterCsBinState() {
        int oldValue = this.counterCsBinState.get();
        int newValue = this.counterCsBinState.addAndGet(1);
        this.firePropertyChange(PROPERTYNAME_COUNTER_CS_BIN_STATE, oldValue, newValue);
        return newValue;
    }

    public void resetCounterCsBinState() {
        int oldValue = this.counterCsBinState.get();
        this.counterCsBinState.set(0);
        this.firePropertyChange(PROPERTYNAME_COUNTER_CS_BIN_STATE, oldValue, 0);
    }

    public void triggerClear() {
        for (LocoModelListener l : this.listeners) {
            l.triggerClearLoco();
        }
    }
}

