/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.view;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.FormsSetup;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideToggleButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.IntegerRangeFilter;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.slider.JZeroSlider;
import org.bidib.wizard.common.script.loco.LocoViewScripting;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.common.view.ViewCloseListener;
import org.bidib.wizard.mvc.common.view.graph.LedBarGraph;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.loco.model.BinStateValue;
import org.bidib.wizard.mvc.loco.model.LocoModel;
import org.bidib.wizard.mvc.loco.model.RfBasisMode;
import org.bidib.wizard.mvc.loco.model.listener.LocoModelListener;
import org.bidib.wizard.mvc.loco.view.EmptyAddressHandler;
import org.bidib.wizard.mvc.loco.view.LocoView;
import org.bidib.wizard.mvc.loco.view.ScriptPanel;
import org.bidib.wizard.mvc.loco.view.SpeedGaugeBinding;
import org.bidib.wizard.mvc.loco.view.SpeedGaugeBuilder;
import org.bidib.wizard.mvc.loco.view.listener.LocoViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LocoView
implements LocoViewScripting,
TabPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoView.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref:grow";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, pref";
    private static final int PAGE_STEPS = 12;
    private LocoModel locoModel;
    private JComboBox<SpeedSteps> speedStepsCombo;
    private JTextField address;
    private JLabel speed;
    private JSlider speedSlider;
    private JLabel reportedSpeed;
    private JButton stopButton;
    private JButton stopEmergencyButton;
    private Map<String, JButton> functionButtonMap = new HashMap();
    private final List<LocoViewListener> locoViewListeners = new LinkedList();
    private final List<ViewCloseListener> viewCloseListeners = new LinkedList();
    private LocoModelListener locoModelListener;
    private JPanel directionPanel;
    private JPanel lightAndStopButtonPanel;
    private JPanel functionButtonPanel;
    private JPanel multiRfBaseButtonPanel;
    private JPanel counterPanel;
    private JPanel directBinStatePanel;
    private ScriptPanel scriptPanel;
    private LedBarGraph ledBarGraph;
    private JPanel contentPanel;
    private boolean m4SupportEnabled;
    private JComponent[] rfBaseButtons;
    private JComponent[] devBinStateValueButtons;
    private BlinkerLed blinkerRight;
    private BlinkerLed blinkerLeft;

    public LocoView(LocoModel locoModel, SettingsService settingsService) {
        1 panel;
        this.locoModel = locoModel;
        this.m4SupportEnabled = settingsService.getWizardSettings().isM4SupportEnabled();
        FormBuilder formBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new /* Unavailable Anonymous Inner Class!! */;
            formBuilder = FormBuilder.create().columns("pref, 3dlu, pref:grow", new Object[0]).rows("pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, pref", new Object[0]).panel((JPanel)panel);
        } else {
            panel = new /* Unavailable Anonymous Inner Class!! */;
            formBuilder = FormBuilder.create().columns("pref, 3dlu, pref:grow", new Object[0]).rows("pref, 3dlu, pref, 3dlu, pref, 9dlu, pref, 3dlu, pref", new Object[0]).panel((JPanel)panel);
        }
        formBuilder.border((Border)Paddings.TABBED_DIALOG);
        try {
            formBuilder.add((Component)this.createLocoAddressPanel()).xy(1, 1);
        }
        catch (Exception ex) {
            LOGGER.warn("Create loco address panel failed.", (Throwable)ex);
        }
        try {
            this.directionPanel = this.createDirectionPanel();
            formBuilder.add((Component)this.directionPanel).xy(1, 3);
            DisabledPanel.disable((Container)this.directionPanel);
            formBuilder.add((Component)this.createSpeedGaugePanel()).xy(3, 3);
        }
        catch (Exception ex) {
            LOGGER.warn("Create direction panel failed.", (Throwable)ex);
        }
        LinkedList functionButtons = new LinkedList();
        try {
            this.lightAndStopButtonPanel = this.createLightAndStopButtonPanel(functionButtons);
            formBuilder.add((Component)this.lightAndStopButtonPanel).xyw(1, 5, 3);
            DisabledPanel.disable((Container)this.lightAndStopButtonPanel);
        }
        catch (Exception ex) {
            LOGGER.warn("Create light and buttons panel failed.", (Throwable)ex);
        }
        int row = 11;
        try {
            this.functionButtonPanel = this.createFunctionButtonPanel(functionButtons);
            formBuilder.add((Component)this.functionButtonPanel).xyw(1, 7, 1);
            DisabledPanel.disable((Container)this.functionButtonPanel);
            if (locoModel.isCarControlEnabled()) {
                this.multiRfBaseButtonPanel = this.addMultiRfBasisButtons();
                formBuilder.add((Component)this.multiRfBaseButtonPanel).xyw(1, 9, 1);
                DisabledPanel.disable((Container)this.multiRfBaseButtonPanel);
                this.counterPanel = this.addCounterPanel();
                formBuilder.add((Component)this.counterPanel).xyw(3, 9, 1);
                DisabledPanel.disable((Container)this.counterPanel);
                if (settingsService.getWizardSettings().isPowerUser()) {
                    formBuilder.appendRows("3dlu, pref", new Object[0]);
                    this.directBinStatePanel = this.addDirectBinStatePanel();
                    formBuilder.add((Component)this.directBinStatePanel).xy(1, row);
                    DisabledPanel.disable((Container)this.directBinStatePanel);
                    row += 2;
                }
            } else {
                LOGGER.info("No multi RF basis buttons added.");
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Create function buttons panel failed.", (Throwable)ex);
        }
        this.scriptPanel = new ScriptPanel((LocoViewScripting)this, settingsService);
        this.addLocoViewListener((LocoViewListener)this.scriptPanel);
        JPanel panel2 = this.scriptPanel.createPanel();
        panel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(this.getClass(), (String)"script") + ":"));
        formBuilder.appendRows("3dlu, pref", new Object[0]);
        formBuilder.add((Component)panel2).xyw(1, row, 3);
        this.locoModelListener = new /* Unavailable Anonymous Inner Class!! */;
        locoModel.addLocoModelListener(this.locoModelListener);
        locoModel.addPropertyChangeListener((PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.contentPanel = formBuilder.build();
        EmptyAddressHandler handler = new EmptyAddressHandler(value -> {
            LOGGER.info("The address value is not empty: {}", value);
            if (value.booleanValue()) {
                DisabledPanel.enable((Container)this.directionPanel);
                DisabledPanel.enable((Container)this.lightAndStopButtonPanel);
                DisabledPanel.enable((Container)this.functionButtonPanel);
                if (this.multiRfBaseButtonPanel != null) {
                    DisabledPanel.enable((Container)this.multiRfBaseButtonPanel);
                }
                if (this.counterPanel != null) {
                    DisabledPanel.enable((Container)this.counterPanel);
                }
                if (this.directBinStatePanel != null) {
                    DisabledPanel.enable((Container)this.directBinStatePanel);
                }
            } else {
                DisabledPanel.disable((Container)this.directionPanel);
                DisabledPanel.disable((Container)this.lightAndStopButtonPanel);
                DisabledPanel.disable((Container)this.functionButtonPanel);
                if (this.multiRfBaseButtonPanel != null) {
                    DisabledPanel.disable((Container)this.multiRfBaseButtonPanel);
                }
                if (this.counterPanel != null) {
                    DisabledPanel.disable((Container)this.counterPanel);
                }
                if (this.directBinStatePanel != null) {
                    DisabledPanel.disable((Container)this.directBinStatePanel);
                }
            }
        });
        PropertyConnector.connect((Object)locoModel, (String)"address", (Object)handler, (String)"address").updateProperty2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeSliderSilently(int speed) {
        ChangeListener[] changeListeners;
        for (ChangeListener listener : changeListeners = this.speedSlider.getChangeListeners()) {
            this.speedSlider.removeChangeListener(listener);
        }
        try {
            this.speedSlider.setValue(speed);
        }
        finally {
            for (ChangeListener listener : changeListeners) {
                this.speedSlider.addChangeListener(listener);
            }
        }
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    private JPanel createLocoAddressPanel() {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 3dlu, 40dlu, 10dlu, pref, 3dlu, 60dlu, 10dlu, pref, 3dlu:grow", new Object[0]).rows("pref", new Object[0]);
        this.address = new JTextField();
        this.address.setDocument((Document)new InputValidationDocument(5, "0123456789"));
        if (this.locoModel.getAddress() != null) {
            this.address.setText(Integer.toString(this.locoModel.getAddress()));
        } else {
            this.address.setText(null);
        }
        this.address.getDocument().addDocumentListener((DocumentListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add(Resources.getString(this.getClass(), (String)"address"), new Object[0]).xy(1, 1);
        formBuilder.add((Component)this.address).xy(3, 1);
        if (this.m4SupportEnabled) {
            this.speedStepsCombo = new JComboBox<SpeedSteps>(SpeedSteps.values());
        } else {
            ArrayList<SpeedSteps> speedSteps = new ArrayList<SpeedSteps>();
            speedSteps.addAll(Arrays.asList(SpeedSteps.values()));
            CollectionUtils.filter(speedSteps, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
            this.speedStepsCombo = new JComboBox<SpeedSteps>(speedSteps.toArray(new SpeedSteps[0]));
        }
        this.speedStepsCombo.setSelectedItem(this.locoModel.getSpeedSteps());
        this.speedStepsCombo.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        formBuilder.add(Resources.getString(this.getClass(), (String)"speedSteps"), new Object[0]).xy(5, 1);
        formBuilder.add((Component)this.speedStepsCombo).xyw(7, 1, 1);
        JButton removeButton = new JButton(Resources.getString(LocoView.class, (String)"remove"));
        removeButton.setToolTipText(Resources.getString(LocoView.class, (String)"remove.tooltip"));
        removeButton.addActionListener(evt -> {
            LOGGER.info("Remove loco from DCC refresh.");
            this.locoModel.triggerClear();
        });
        formBuilder.add((Component)removeButton).xyw(9, 1, 2);
        return formBuilder.build();
    }

    private JPanel createDirectionPanel() {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 3dlu, 60dlu:grow, 3dlu, pref", new Object[0]).rows("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", new Object[0]);
        formBuilder.border((Border)new EmptyBorder(10, 0, 10, 0));
        PropertyAdapter speedModel = new PropertyAdapter((Object)this.locoModel, "speed", true);
        ConverterValueModel speedConverterModel = new ConverterValueModel((ValueModel)speedModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.speed = WizardComponentFactory.createLabel((ValueModel)speedConverterModel);
        formBuilder.add(Resources.getString(this.getClass(), (String)"speed"), new Object[0]).xy(1, 1);
        formBuilder.add((Component)this.speed).xy(3, 1);
        PropertyAdapter reportedSpeedModel = new PropertyAdapter((Object)this.locoModel, "reportedSpeed", true);
        ConverterValueModel reportedSpeedConverterModel = new ConverterValueModel((ValueModel)reportedSpeedModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.reportedSpeed = WizardComponentFactory.createLabel((ValueModel)reportedSpeedConverterModel);
        formBuilder.add(Resources.getString(this.getClass(), (String)"reportedSpeed"), new Object[0]).xy(1, 3);
        formBuilder.add((Component)this.reportedSpeed).xy(3, 3);
        this.speedSlider = new JZeroSlider();
        this.speedSlider.setOpaque(FormsSetup.getOpaqueDefault());
        int steps = this.locoModel.getSpeedSteps().getSteps() - 1;
        this.speedSlider.setMaximum(steps);
        if (this.locoModel.isCarControlEnabled()) {
            this.speedSlider.setMinimum(0);
        } else {
            this.speedSlider.setMinimum(-steps);
        }
        this.speedSlider.setPaintTicks(true);
        InputMap keyMap = (InputMap)UIManager.get("Slider.focusInputMap", this.speedSlider.getLocale());
        if (LOGGER.isDebugEnabled() && keyMap != null) {
            Object binding = keyMap.get(KeyStroke.getKeyStroke(36, 0));
            LOGGER.debug("HOME is binded: {}", binding);
        }
        this.speedSlider.getInputMap().put(KeyStroke.getKeyStroke(36, 0), "speedToMaxValue");
        this.speedSlider.getInputMap().put(KeyStroke.getKeyStroke(35, 0), "speedToMinValue");
        this.speedSlider.getInputMap().put(KeyStroke.getKeyStroke(33, 0), "speedUpValue");
        this.speedSlider.getInputMap().put(KeyStroke.getKeyStroke(34, 0), "speedDownValue");
        this.speedSlider.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "speedStop");
        this.speedSlider.getActionMap().put("speedToMaxValue", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.speedSlider.getActionMap().put("speedToMinValue", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.speedSlider.getActionMap().put("speedUpValue", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.speedSlider.getActionMap().put("speedDownValue", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.speedSlider.getActionMap().put("speedStop", (Action)new /* Unavailable Anonymous Inner Class!! */);
        this.speedSlider.setValue(0);
        this.speedSlider.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.speedSlider.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        int speedDelta = 1;
        this.speedSlider.addMouseWheelListener(evt -> {
            if (evt.getWheelRotation() < 0) {
                int iNewValue = this.speedSlider.getValue() - speedDelta;
                if (iNewValue >= this.speedSlider.getMinimum()) {
                    this.speedSlider.setValue(iNewValue);
                } else {
                    this.speedSlider.setValue(0);
                }
            } else {
                int iNewValue = this.speedSlider.getValue() + speedDelta;
                if (iNewValue <= this.speedSlider.getMaximum()) {
                    this.speedSlider.setValue(iNewValue);
                } else {
                    this.speedSlider.setValue(this.speedSlider.getMaximum());
                }
            }
        });
        formBuilder.add((Component)this.speedSlider).xyw(1, 5, 5);
        JLabel minimumValueLabel = new JLabel(Resources.getString(this.getClass(), (String)"backwards"));
        formBuilder.add((Component)minimumValueLabel).xy(1, 7);
        if (this.locoModel.isCarControlEnabled()) {
            minimumValueLabel.setText(Resources.getString(LocoView.class, (String)"stop"));
        }
        formBuilder.add(Resources.getString(LocoView.class, (String)"forwards"), new Object[0]).xy(5, 7);
        JPanel helperPanel = new JPanel(new BorderLayout());
        helperPanel.setOpaque(false);
        this.ledBarGraph = new LedBarGraph(10, LedBarGraph.Orientation.vertical);
        this.ledBarGraph.setOpaque(FormsSetup.getOpaqueDefault());
        helperPanel.add((Component)formBuilder.build(), "Center");
        helperPanel.add((Component)this.ledBarGraph, "East");
        this.locoModel.addPropertyChangeListener("carControlEnabled", (PropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.locoModel.addPropertyChangeListener("speed", evt -> {
            boolean stopped = this.isSpeedStopped(this.locoModel.getSpeed());
            this.speedStepsCombo.setEnabled(stopped);
        });
        boolean stopped = this.isSpeedStopped(this.locoModel.getSpeed());
        this.speedStepsCombo.setEnabled(stopped);
        return helperPanel;
    }

    private boolean isSpeedStopped(Integer speed) {
        boolean stopped = false;
        if (speed != null) {
            switch (speed) {
                case 0: 
                case 1: {
                    stopped = true;
                    break;
                }
            }
        } else {
            stopped = true;
        }
        return stopped;
    }

    private JComponent createSpeedGaugePanel() {
        SpeedGaugeBinding speedGauge = SpeedGaugeBuilder.speedGauge((String)"Speed", (String)"km/h");
        16 panel = new /* Unavailable Anonymous Inner Class!! */;
        panel.setOpaque(false);
        panel.setLayout(new BorderLayout());
        panel.add((Component)speedGauge, "Center");
        PropertyAdapter reportedSpeedModel = new PropertyAdapter((Object)this.locoModel, "reportedSpeed", true);
        Bindings.bind((JComponent)speedGauge, (String)"valueAnimated", (ValueModel)reportedSpeedModel);
        return panel;
    }

    private JPanel createLightAndStopButtonPanel(List<JideButton> functionButtons) {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 3dlu, 60dlu:grow, 3dlu, pref", new Object[0]).rows("pref", new Object[0]);
        ImageIcon lightOnIcon = ImageUtils.createImageIcon(LocoView.class, (String)"/icons/16x16/lightbulb.png");
        ImageIcon lightOffIcon = ImageUtils.createImageIcon(LocoView.class, (String)"/icons/16x16/lightbulb_off.png");
        JideToggleButton lightButton = new JideToggleButton((Icon)lightOffIcon);
        lightButton.setSelectedIcon((Icon)lightOnIcon);
        lightButton.setButtonStyle(1);
        lightButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        functionButtons.add((JideButton)lightButton);
        this.functionButtonMap.put("F0", lightButton);
        formBuilder.add((Component)lightButton).xy(1, 1);
        JPanel stopPanel = new JPanel(new GridBagLayout());
        stopPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Resources.getString(this.getClass(), (String)"stopLoco") + ":"));
        this.stopButton = new JButton(Resources.getString(this.getClass(), (String)"stop"));
        this.stopButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.stopEmergencyButton = new JButton(Resources.getString(this.getClass(), (String)"emergencyStop"));
        this.stopEmergencyButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        JPanel buttonPanel = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.stopButton, this.stopEmergencyButton}).build();
        formBuilder.add((Component)buttonPanel).xy(3, 1);
        return formBuilder.build();
    }

    private JPanel createFunctionButtonPanel(List<JideButton> functionButtons) {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref, 8dlu, pref", new Object[0]).rows("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", new Object[0]);
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"additionalFunctions"), new Object[0]).xyw(1, 1, 19);
        int columns = 10;
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 10; ++column) {
                int functionIndex = row * 10 + (column + 1);
                String buttonText = "F" + functionIndex;
                if (functionIndex > 28) {
                    buttonText = "B" + functionIndex;
                }
                JideToggleButton functionButton = new JideToggleButton(buttonText);
                functionButton.setButtonStyle(1);
                functionButton.addActionListener(arg_0 -> this.lambda$createFunctionButtonPanel$4(functionIndex, (JideButton)functionButton, arg_0));
                functionButtons.add((JideButton)functionButton);
                this.functionButtonMap.put(buttonText, functionButton);
                formBuilder.add((Component)functionButton).xy(column * 2 + 1, row * 2 + 3);
            }
        }
        return formBuilder.build();
    }

    private JPanel addMultiRfBasisButtons() {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref:grow", new Object[0]).rows("pref, 3dlu, pref", new Object[0]);
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"multiRFBasis"), new Object[0]).xyw(1, 1, 15);
        PropertyAdapter activeBaseModel = new PropertyAdapter((Object)this.locoModel, "activeBase", true);
        this.rfBaseButtons = new JComponent[RfBasisMode.values().length];
        int column = 0;
        int col = 0;
        int row = 3;
        for (RfBasisMode rfBaseMode : RfBasisMode.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)activeBaseModel, (Object)rfBaseMode, (String)Resources.getString(RfBasisMode.class, (String)rfBaseMode.getKey()));
            this.rfBaseButtons[column] = radio;
            formBuilder.add((Component)radio).xy(col * 2 + 1, row);
            ++column;
            ++col;
            if (rfBaseMode != RfBasisMode.SINGLE) continue;
            formBuilder.appendRows("3dlu, pref", new Object[0]);
            col = 0;
            row += 2;
        }
        formBuilder.appendRows("3dlu, pref", new Object[0]);
        col = 0;
        PropertyAdapter reportedCellNumberModel = new PropertyAdapter((Object)this.locoModel, "reportedCellNumber", true);
        ConverterValueModel reportedCellNumberConverterModel = new ConverterValueModel((ValueModel)reportedCellNumberModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField reportedCellNumberText = WizardComponentFactory.createTextField((ValueModel)reportedCellNumberConverterModel, (boolean)false);
        reportedCellNumberText.setEditable(false);
        formBuilder.add("Reported RF Cellnumber", new Object[0]).xyw(1, row += 2, 5);
        formBuilder.add((Component)reportedCellNumberText).xy(7, row);
        activeBaseModel.addValueChangeListener(evt -> {
            Integer functionIndex;
            LOGGER.info("The active RF base has changed: {}", evt.getNewValue());
            RfBasisMode activeRfBase = this.locoModel.getActiveBase();
            if (activeRfBase != null && (functionIndex = activeRfBase.getFunctionIndex()) != null) {
                this.locoModel.setBinaryState(functionIndex.intValue(), true);
            }
        });
        return formBuilder.build();
    }

    private JPanel addCounterPanel() {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 5dlu, pref:grow", new Object[0]).rows("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", new Object[0]);
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"Counter"), new Object[0]).xyw(1, 1, 3);
        PropertyAdapter counterCsDriveModel = new PropertyAdapter((Object)this.locoModel, "counterCsDrive", true);
        ConverterValueModel counterCsDriveConverterModel = new ConverterValueModel((ValueModel)counterCsDriveModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField counterCsDriveText = WizardComponentFactory.createTextField((ValueModel)counterCsDriveConverterModel, (boolean)false);
        counterCsDriveText.setEditable(false);
        formBuilder.add("CS_DRIVE", new Object[0]).xy(1, 3);
        formBuilder.add((Component)counterCsDriveText).xy(3, 3);
        PropertyAdapter counterCsBinStateModel = new PropertyAdapter((Object)this.locoModel, "counterCsBinState", true);
        ConverterValueModel counterCsBinStateConverterModel = new ConverterValueModel((ValueModel)counterCsBinStateModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField counterCsBinStateText = WizardComponentFactory.createTextField((ValueModel)counterCsBinStateConverterModel, (boolean)false);
        counterCsBinStateText.setEditable(false);
        formBuilder.add("CS_BIN_STATE", new Object[0]).xy(1, 5);
        formBuilder.add((Component)counterCsBinStateText).xy(3, 5);
        PropertyAdapter counterCsDriveAckModel = new PropertyAdapter((Object)this.locoModel, "counterCsDriveAck", true);
        ConverterValueModel counterCsDriveAckConverterModel = new ConverterValueModel((ValueModel)counterCsDriveAckModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField counterCsDriveAckText = WizardComponentFactory.createTextField((ValueModel)counterCsDriveAckConverterModel, (boolean)false);
        counterCsDriveAckText.setEditable(false);
        formBuilder.add("CS_DRIVE_ACK", new Object[0]).xy(1, 7);
        formBuilder.add((Component)counterCsDriveAckText).xy(3, 7);
        JButton resetButton = new JButton(Resources.getString(this.getClass(), (String)"reset"));
        resetButton.addActionListener(evt -> {
            LOGGER.info("Reset the counters.");
            this.locoModel.resetCounterCsDrive();
            this.locoModel.resetCounterCsAckDrive();
            this.locoModel.resetCounterCsBinState();
        });
        formBuilder.add((Component)resetButton).xy(1, 9);
        return formBuilder.build();
    }

    private JPanel addDirectBinStatePanel() {
        FormBuilder formBuilder = FormBuilder.create().columns("pref, 5dlu, max(pref;30dlu), 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu:grow", new Object[0]).rows("pref, 3dlu, pref", new Object[0]);
        formBuilder.addSeparator(Resources.getString(this.getClass(), (String)"devBinState"), new Object[0]).xyw(1, 1, 10);
        PropertyAdapter devBinStateNumberModel = new PropertyAdapter((Object)this.locoModel, "devBinStateNumber", true);
        ConverterValueModel binStateNumberConverterModel = new ConverterValueModel((ValueModel)devBinStateNumberModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        JTextField devBinStateNumberText = WizardComponentFactory.createTextField((ValueModel)binStateNumberConverterModel, (boolean)false);
        InputValidationDocument stateNumberDocument = new InputValidationDocument(5, "0123456789");
        stateNumberDocument.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(0, Short.MAX_VALUE));
        devBinStateNumberText.setDocument((Document)stateNumberDocument);
        formBuilder.add("Number", new Object[0]).xy(1, 3);
        formBuilder.add((Component)devBinStateNumberText).xy(3, 3);
        PropertyAdapter devBinStateValueModel = new PropertyAdapter((Object)this.locoModel, "devBinStateValue", true);
        this.devBinStateValueButtons = new JComponent[BinStateValue.values().length];
        int column = 0;
        for (BinStateValue binStateValue : BinStateValue.values()) {
            JRadioButton radio = WizardComponentFactory.createRadioButton((ValueModel)devBinStateValueModel, (Object)binStateValue, (String)Resources.getString(BinStateValue.class, (String)binStateValue.getKey()));
            this.devBinStateValueButtons[column] = radio;
            formBuilder.add((Component)radio).xy(5 + column * 2, 3);
            ++column;
        }
        JButton sendButton = new JButton(Resources.getString(this.getClass(), (String)"send"));
        sendButton.addActionListener(evt -> {
            BinStateValue devBinStateValue = this.locoModel.getDevBinStateValue();
            if (devBinStateValue != null) {
                boolean functionValue = devBinStateValue.getFunctionValue();
                Integer binStateNumber = this.locoModel.getDevBinStateNumber();
                if (binStateNumber != null) {
                    this.locoModel.setBinaryState(binStateNumber.intValue(), functionValue);
                } else {
                    LOGGER.info("No bin state number available. The BIN_STATE is not fired.");
                }
            }
        });
        sendButton.setEnabled(false);
        formBuilder.add((Component)sendButton).xy(9, 3);
        devBinStateNumberModel.addValueChangeListener(evt -> {
            Integer binStateNumber = this.locoModel.getDevBinStateNumber();
            sendButton.setEnabled(binStateNumber != null);
        });
        return formBuilder.build();
    }

    private JPanel createImagePanel(List<JideButton> functionButtons) {
        JPanel imagePanel = new JPanel(new BorderLayout());
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.setPreferredSize(new Dimension(140, 140));
        ImageIcon carFrontIcon = ImageUtils.loadImageIcon(LocoView.class, (String)"/images/Truck-Front.png", (int)120, (int)120);
        JLabel backgroundLabel = new JLabel(carFrontIcon);
        backgroundLabel.setOpaque(true);
        backgroundLabel.setBounds(0, 0, 140, 140);
        layeredPane.add((Component)backgroundLabel, (Object)10);
        this.blinkerRight = new BlinkerLed(0, 0, 8, 6, Color.ORANGE.brighter(), Color.ORANGE);
        this.blinkerLeft = new BlinkerLed(0, 0, 8, 6, Color.ORANGE.brighter(), Color.ORANGE);
        BlinkerLed lightRight = new BlinkerLed(0, 0, 8, 11, Color.YELLOW, Color.WHITE);
        BlinkerLed lightLeft = new BlinkerLed(0, 0, 8, 11, Color.YELLOW, Color.WHITE);
        layeredPane.add((Component)this.blinkerLeft, (Object)20);
        layeredPane.add((Component)this.blinkerRight, (Object)20);
        layeredPane.add((Component)lightLeft, (Object)20);
        layeredPane.add((Component)lightRight, (Object)20);
        this.blinkerLeft.setBounds(37, 84, 10, 7);
        this.blinkerRight.setBounds(93, 84, 10, 7);
        lightLeft.setBounds(37, 92, 10, 11);
        lightRight.setBounds(93, 92, 10, 11);
        Cursor cursor = Cursor.getPredefinedCursor(12);
        this.blinkerLeft.setCursor(cursor);
        this.blinkerRight.setCursor(cursor);
        lightLeft.setCursor(cursor);
        lightRight.setCursor(cursor);
        JideToggleButton functionButtonLeft = (JideToggleButton)LocoView.getButton((JButton)((JButton)functionButtons.get(2)), JideToggleButton.class);
        functionButtonLeft.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        JideToggleButton functionButtonRight = (JideToggleButton)LocoView.getButton((JButton)((JButton)functionButtons.get(1)), JideToggleButton.class);
        functionButtonRight.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        JideToggleButton functionButtonLights = (JideToggleButton)LocoView.getButton((JButton)((JButton)functionButtons.get(0)), JideToggleButton.class);
        functionButtonLights.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        backgroundLabel.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        imagePanel.add((Component)layeredPane, "Center");
        return imagePanel;
    }

    private static <T> T getButton(JButton button, Class<T> type) {
        if (type.isInstance(button)) {
            return type.cast(button);
        }
        throw new IllegalArgumentException("The provided button has not the requested type.");
    }

    protected void fireWriteState(int state, boolean value) {
        this.locoModel.setBinaryState(state, value);
    }

    private void addLocoViewListener(LocoViewListener listener) {
        this.locoViewListeners.add(listener);
    }

    public void addViewCloseListener(ViewCloseListener listener) {
        this.viewCloseListeners.add(listener);
    }

    private void fireEmergencyStop() {
        this.locoModel.setSpeed(Integer.valueOf(1));
        for (LocoViewListener listener : this.locoViewListeners) {
            listener.emergencyStop();
        }
    }

    private void fireStop() {
        this.locoModel.setSpeed(Integer.valueOf(0));
        for (LocoViewListener listener : this.locoViewListeners) {
            listener.stop();
        }
    }

    public void selectDecoderAddress(int dccAddress) {
        LOGGER.info("Select the decoder address: {}", (Object)dccAddress);
        this.address.setText(String.valueOf(dccAddress));
        this.locoModel.setSpeed(null);
    }

    public void setSpeedSteps(SpeedSteps speedSteps) {
        LOGGER.info("Set the speed steps: {}", (Object)speedSteps);
        this.speedStepsCombo.setSelectedItem(speedSteps);
    }

    public void setSpeed(int speed) {
        LOGGER.info("Set the speed: {}", (Object)speed);
        this.changeSliderSilently(speed);
        this.locoModel.setSpeed(Integer.valueOf(speed));
    }

    public void setFunction(int function) {
        LOGGER.info("Set the function: {}", (Object)function);
        JideToggleButton functionButton = (JideToggleButton)LocoView.getButton((JButton)((JButton)this.functionButtonMap.get("F" + function)), JideToggleButton.class);
        LOGGER.warn("Fetched functionButton: {}", (Object)functionButton);
        functionButton.doClick();
    }

    public void setBinState(int binStateNumber, boolean flag) {
        LOGGER.info("Set the binState, binStateNumber: {}, flag: {}", (Object)binStateNumber, (Object)flag);
        this.locoModel.setBinaryState(binStateNumber, flag);
    }

    public void setStop() {
        LOGGER.info("Set stop.");
        this.stopButton.doClick();
    }

    public void setStopEmergency() {
        LOGGER.info("Set stop emergency.");
        this.stopEmergencyButton.doClick();
    }

    public void cleanup(SettingsService settingsService) {
        LOGGER.info("The LocoView is disposed.");
        for (ViewCloseListener closeListener : this.viewCloseListeners) {
            try {
                closeListener.close();
            }
            catch (Exception ex) {
                LOGGER.warn("Notify view close listener failed.", (Throwable)ex);
            }
        }
        SpeedSteps lastSelectedSpeedSteps = this.locoModel.getSpeedSteps();
        settingsService.getWizardSettings().setLastSelectedSpeedSteps(lastSelectedSpeedSteps);
        if (this.blinkerLeft != null) {
            this.blinkerLeft.setActive(false, true);
        }
        if (this.blinkerRight != null) {
            this.blinkerRight.setActive(false, true);
        }
        this.viewCloseListeners.clear();
        this.locoViewListeners.clear();
        if (this.locoModelListener != null) {
            this.locoModel.removeLocoModelListener(this.locoModelListener);
            this.locoModelListener = null;
        }
        if (this.scriptPanel != null) {
            this.scriptPanel.close();
            this.scriptPanel = null;
        }
        if (this.locoModel != null) {
            this.locoModel = null;
        }
        this.functionButtonMap.clear();
    }

    private /* synthetic */ void lambda$createFunctionButtonPanel$4(int functionIndex, JideButton functionButton, ActionEvent event) {
        LOGGER.info("Set function with index: {}", (Object)functionIndex);
        if (functionIndex < 29) {
            this.locoModel.setFunction(functionIndex, functionButton.isSelected());
        } else {
            this.locoModel.setBinaryState(functionIndex, true);
        }
    }
}

