/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.booster.view;

import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.model.status.BoosterStatus;

public class BoosterStateCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    Map<BoosterState, ImageIcon> boosterStateIcons = new LinkedHashMap<BoosterState, ImageIcon>();

    public BoosterStateCellRenderer() {
        this.boosterStateIcons.put(BoosterState.OFF, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOff_00.png"));
        this.boosterStateIcons.put(BoosterState.OFF_SHORT, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOff_01_by_short.png"));
        this.boosterStateIcons.put(BoosterState.OFF_HOT, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOff_02_by_hot.png"));
        this.boosterStateIcons.put(BoosterState.OFF_NO_POWER, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOff_03_by_novcc.png"));
        this.boosterStateIcons.put(BoosterState.OFF_GO_REQ, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOff_04_by_askforon.png"));
        this.boosterStateIcons.put(BoosterState.OFF_HERE, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOff_05_by_localkey.png"));
        this.boosterStateIcons.put(BoosterState.OFF_NO_DCC, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOff_06_by_nodcc.png"));
        this.boosterStateIcons.put(BoosterState.ON, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOn_80.png"));
        this.boosterStateIcons.put(BoosterState.ON_LIMIT, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOn_81_cur_limit.png"));
        this.boosterStateIcons.put(BoosterState.ON_HOT, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOn_82_hot.png"));
        this.boosterStateIcons.put(BoosterState.ON_STOP_REQ, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOn_83_askforstop.png"));
        this.boosterStateIcons.put(BoosterState.ON_HERE, ImageUtils.createImageIcon(BoosterStateCellRenderer.class, (String)"/icons/booster/boosterOn_84_by_localkey.png"));
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
        if (value instanceof BoosterState) {
            BoosterState boosterState = (BoosterState)value;
            Icon icon = this.boosterStateIcons.get(boosterState);
            this.setIcon(icon);
            this.setToolTipText(Resources.getString(BoosterStatus.class, (String)BoosterStatus.valueOf((BoosterState)boosterState).getKey()));
        } else {
            this.setIcon(null);
            this.setToolTipText(null);
        }
        return this;
    }
}

