/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.error.view;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.bidib.wizard.client.common.dialog.ExceptionDialog;
import org.bidib.wizard.mvc.error.model.ErrorModel;
import org.bidib.wizard.mvc.error.model.listener.ErrorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ErrorView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorView.class);
    private final AtomicBoolean dialogVisible = new AtomicBoolean();

    public ErrorView(final ErrorModel model, final Supplier<Boolean> startupPassed) {
        model.addErrorListener(new ErrorListener(){

            @Override
            public void errorChanged(String errorMessage, String stackTrace) {
                LOGGER.warn("Show the error message: {}", (Object)errorMessage);
                if (ErrorView.this.dialogVisible.getAndSet(true)) {
                    LOGGER.warn("The dialog is visible already. Only show single instance.");
                    return;
                }
                if (!SwingUtilities.isEventDispatchThread()) {
                    try {
                        SwingUtilities.invokeLater(() -> this.lambda$errorChanged$0(errorMessage, stackTrace, model, (Supplier)startupPassed));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Show error dialog failed", (Throwable)ex);
                    }
                } else {
                    try {
                        ErrorView.this.showErrorDialog(errorMessage, stackTrace);
                        model.resetStackTrace();
                        if (!((Boolean)startupPassed.get()).booleanValue()) {
                            ErrorView.this.windowClosed();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Show error dialog failed", (Throwable)ex);
                    }
                }
            }

            private /* synthetic */ void lambda$errorChanged$0(String errorMessage, String stackTrace, ErrorModel model2, Supplier startupPassed2) {
                try {
                    ErrorView.this.showErrorDialog(errorMessage, stackTrace);
                    model2.resetStackTrace();
                    if (!((Boolean)startupPassed2.get()).booleanValue()) {
                        ErrorView.this.windowClosed();
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Show error dialog failed", (Throwable)ex);
                }
            }
        });
    }

    private void showErrorDialog(final String errorMessage, final String stackTrace) {
        ExceptionDialog dialog = new ExceptionDialog(){
            private static final long serialVersionUID = 1L;

            protected Supplier<String> getExceptionMessageSupplier() {
                return () -> stackTrace;
            }

            protected Supplier<String> getErrorMessageSupplier() {
                return () -> errorMessage;
            }
        };
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setVisible(true);
        this.dialogVisible.set(false);
    }

    public abstract void windowClosed();
}

