/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.loco.view.speedo;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.dialog.EscapeDialog;
import org.bidib.wizard.mvc.loco.view.listener.MeasurementViewListener;
import org.bidib.wizard.mvc.loco.view.listener.ProgressStatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementProgressDialog
extends EscapeDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MeasurementProgressDialog.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 10dlu, max(300dlu;pref)";
    private int result = 2;
    private final AtomicBoolean continueMeasurementHolder = new AtomicBoolean(true);
    private final ProgressStatusCallback callback;
    final MeasurementViewListener listener;
    private final JProgressBar progressBar = new JProgressBar(0, 100);
    private JLabel infoLabel;
    private JButton cancel;

    public MeasurementProgressDialog(Component parent, boolean modal, MeasurementViewListener listener) {
        super(JOptionPane.getFrameForComponent(parent), Resources.getString(MeasurementProgressDialog.class, (String)"title"), modal);
        this.listener = listener;
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        FormBuilder builder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows("fill:50dlu:grow, 3dlu, pref, 3dlu, pref", new Object[0]);
        builder.border((Border)Paddings.DIALOG);
        this.infoLabel = new JLabel();
        builder.add((Component)this.infoLabel).xyw(1, 1, 3);
        builder.add(Resources.getString(((Object)((Object)this)).getClass(), (String)"progress"), new Object[0]).xy(1, 3);
        builder.add((Component)this.progressBar).xy(3, 3);
        this.progressBar.setIndeterminate(true);
        this.cancel = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"cancel"));
        this.cancel.setEnabled(false);
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MeasurementProgressDialog.this.fireCancel();
            }
        });
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton((JComponent)this.cancel).build();
        builder.add((Component)buttons).xyw(1, 5, 3);
        this.getContentPane().add(builder.build());
        this.pack();
        this.setLocationRelativeTo(parent);
        this.callback = new ProgressStatusCallback(){

            @Override
            public void progressChanged(final int progressValue) {
                LOGGER.info("The progress has changed, progress: {}", (Object)progressValue);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MeasurementProgressDialog.this.progressBar.setValue(progressValue);
                    }
                });
            }

            @Override
            public void actionFinished() {
                LOGGER.info("ActionFinish was called. Close the dialog.");
                MeasurementProgressDialog.this.fireClose();
            }

            @Override
            public void textChanged(final String text) {
                LOGGER.info("The text has changed, text: {}", (Object)text);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MeasurementProgressDialog.this.infoLabel.setText(text);
                    }
                });
            }
        };
    }

    public void startAction() {
        LOGGER.info("Start measurement.");
        try {
            if (this.listener != null) {
                this.listener.startMeasurement(this.continueMeasurementHolder, this.callback);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Start measurement failed.", (Throwable)ex);
        }
        this.cancel.setEnabled(true);
        this.setVisible(true);
    }

    private void fireCancel() {
        LOGGER.info("Cancel the measurement, set the continueMeasurementHolder to false.");
        this.continueMeasurementHolder.set(false);
        if (this.listener != null) {
            this.listener.stopMeasurement(this.continueMeasurementHolder, this.callback);
        }
    }

    private void fireClose() {
        LOGGER.info("Close the dialog.");
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                if (this.listener != null) {
                    this.listener.stopMeasurement(this.continueMeasurementHolder, this.callback);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Wait for termination of worker was interrupted.", (Throwable)ex);
            }
            this.setVisible(false);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("Close the dialog from AWT thread.");
                    try {
                        if (MeasurementProgressDialog.this.listener != null) {
                            MeasurementProgressDialog.this.listener.stopMeasurement(MeasurementProgressDialog.this.continueMeasurementHolder, MeasurementProgressDialog.this.callback);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Wait for termination of worker was interrupted.", (Throwable)ex);
                    }
                    MeasurementProgressDialog.this.setVisible(false);
                }
            });
        }
    }

    public int getResult() {
        return this.result;
    }

    public void stop() {
        LOGGER.info("Stop the measurement.");
        this.fireCancel();
    }
}

