/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.view;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.adapter.SingleListSelectionAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TablePopupMenuInstaller;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringConverter;
import org.bidib.wizard.client.common.table.AbstractEmptyTable;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.model.locolist.LocoListModel;
import org.bidib.wizard.mvc.common.view.table.CustomBooleanCellEditor;
import org.bidib.wizard.mvc.common.view.table.CustomBooleanCellRenderer;
import org.bidib.wizard.mvc.locolist.controller.listener.LocoTableControllerListener;
import org.bidib.wizard.mvc.locolist.model.LocoTableModel;
import org.bidib.wizard.mvc.locolist.view.JSparklinesBarChartTableCellRenderer;
import org.bidib.wizard.mvc.locolist.view.LocoLightRenderer;
import org.bidib.wizard.mvc.locolist.view.LocoListBeanModel;
import org.bidib.wizard.mvc.locolist.view.LocoListMenu;
import org.bidib.wizard.mvc.locolist.view.LocoTableTableModel;
import org.bidib.wizard.mvc.locolist.view.MultiCheckWithLightRenderer;
import org.jfree.chart.plot.PlotOrientation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoTableView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoTableView.class);
    private final DockKey DOCKKEY = new DockKey("LocoTableView");
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:150dlu:grow";
    private final JButton queryLocoListButton = new JButton(Resources.getString(this.getClass(), (String)"queryLocoList"));
    private final JComponent contentPanel;
    private final LocoListBeanModel locoListBeanModel;
    private final JTextField locoAddress;
    private InputValidationDocument addressDocument;
    private ValueModel addressValueModel;
    private final SelectionInList<LocoListModel> locoSelection;
    private final LocoTableControllerListener locoTableController;

    public LocoTableView(LocoTableControllerListener locoTableController, LocoTableModel locoTableModel, String dockKey) {
        this.locoTableController = locoTableController;
        this.locoListBeanModel = new LocoListBeanModel();
        LOGGER.info("Create LocoTableView with dockKey name: {}", (Object)dockKey);
        this.DOCKKEY.setName(dockKey);
        this.DOCKKEY.setFloatEnabled(true);
        this.DOCKKEY.setAutoHideEnabled(false);
        LOGGER.info("Create new LocoTableView");
        this.locoSelection = new SelectionInList(locoTableModel.getLocoListModel());
        final LocoTableTableModel tableModel = new LocoTableTableModel(this.locoSelection);
        final AbstractEmptyTable locoTable = new AbstractEmptyTable((TableModel)((Object)tableModel), Resources.getString(this.getClass(), (String)"empty_table")){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(300, 50);
            }
        };
        locoTable.adjustRowHeight();
        locoTable.setSelectionModel((ListSelectionModel)new SingleListSelectionAdapter(this.locoSelection.getSelectionIndexHolder()));
        TableColumnModel tcm = locoTable.getColumnModel();
        tcm.getColumn(3).setCellEditor(new CustomBooleanCellEditor("/icons/locolist/arrow_right.png", "/icons/locolist/arrow_left.png"));
        tcm.getColumn(3).setCellRenderer(new CustomBooleanCellRenderer("/icons/locolist/arrow_right.png", "/icons/locolist/arrow_left.png"));
        JSparklinesBarChartTableCellRenderer renderer = new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, (Double)-127.0, 127.0, new Color(51, 153, 255).darker(), Color.GREEN.darker());
        renderer.showAbsValue(true);
        renderer.showNumberAndChart(true, 40);
        tcm.getColumn(2).setCellRenderer(renderer);
        TableColumn tc = tcm.getColumn(0);
        tc.setMinWidth(50);
        tc.setMaxWidth(60);
        tc.setPreferredWidth(60);
        tc = tcm.getColumn(2);
        tc.setMinWidth(100);
        tc.setPreferredWidth(150);
        tc = tcm.getColumn(3);
        tc.setMinWidth(50);
        tc.setMaxWidth(60);
        tc.setPreferredWidth(60);
        tc = tcm.getColumn(4);
        tc.setMinWidth(70);
        tc.setMaxWidth(70);
        tc.setPreferredWidth(70);
        LocoLightRenderer locoLightRenderer = new LocoLightRenderer(16);
        tcm.getColumn(5).setCellRenderer(locoLightRenderer);
        tc = tcm.getColumn(5);
        tc.setMinWidth(40);
        tc.setMaxWidth(60);
        tc.setPreferredWidth(40);
        MultiCheckWithLightRenderer multiCheckRenderer = new MultiCheckWithLightRenderer(15);
        tc = tcm.getColumn(6);
        tc.setCellRenderer(multiCheckRenderer);
        tc.setPreferredWidth(90);
        MultiCheckWithLightRenderer multiCheckRendererFull = new MultiCheckWithLightRenderer(255);
        tc = tcm.getColumn(7);
        tc.setCellRenderer(multiCheckRendererFull);
        tc.setPreferredWidth(160);
        tc = tcm.getColumn(8);
        tc.setCellRenderer(multiCheckRendererFull);
        tc.setPreferredWidth(160);
        tc = tcm.getColumn(9);
        tc.setCellRenderer(multiCheckRendererFull);
        tc.setPreferredWidth(160);
        final SortableTableModel sortableTableModel = (SortableTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)locoTable.getModel(), SortableTableModel.class);
        sortableTableModel.setColumnSortable(0, true);
        sortableTableModel.sortColumn(0, true, true);
        boolean debugDialog = false;
        FormBuilder dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows("p, 3dlu, fill:pref:grow", new Object[0]).panel((JPanel)(debugDialog ? new FormDebugPanel() : new JPanel(new BorderLayout())));
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.queryLocoListButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocoTableView.this.fireQueryLocoList();
            }
        });
        PropertyAdapter queryLocoListButtonEnabled = new PropertyAdapter((Object)locoTableModel, "csNodeSelected", true);
        PropertyConnector.connect((Object)queryLocoListButtonEnabled, (String)"value", (Object)this.queryLocoListButton, (String)"enabled");
        SelectionInList csQueryTypeSelection = new SelectionInList((Object[])CsQueryTypeEnum.values());
        PropertyAdapter csQueryTypeModel = new PropertyAdapter((Object)this.locoListBeanModel, "csQueryType", true);
        ComboBoxAdapter comboBoxAdapterCsQueryType = new ComboBoxAdapter((ListModel)csQueryTypeSelection, (ValueModel)csQueryTypeModel);
        JComboBox<Object> comboCsQueryType = new JComboBox<Object>();
        comboCsQueryType.setModel((ComboBoxModel<Object>)comboBoxAdapterCsQueryType);
        comboCsQueryType.setRenderer(new CsQueryTypeCellRenderer());
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"csQueryType"), new Object[0]).xy(1, 1);
        dialogBuilder.add(comboCsQueryType).xy(3, 1);
        JPanel locoListActionButtons = new ButtonBarBuilder().addButton((JComponent)this.queryLocoListButton).build();
        dialogBuilder.add((Component)locoListActionButtons).xy(5, 1);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"address"), new Object[0]).xy(7, 1);
        this.addressValueModel = new PropertyAdapter((Object)this.locoListBeanModel, "address", true);
        ConverterValueModel addressConverterModel = new ConverterValueModel(this.addressValueModel, (BindingConverter)new StringConverter((Format)new DecimalFormat("#")));
        this.locoAddress = new JTextField();
        this.addressDocument = new InputValidationDocument(5, "0123456789");
        this.locoAddress.setDocument((Document)this.addressDocument);
        this.locoAddress.setColumns(5);
        Bindings.bind((JTextField)this.locoAddress, (ValueModel)addressConverterModel, (boolean)false);
        dialogBuilder.add((Component)this.locoAddress).xy(9, 1);
        final DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)locoTable));
        locoTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (SwingUtilities.isEventDispatchThread()) {
                    overlayTable.setOverlayVisible(locoTable.getModel().getRowCount() == 0);
                } else {
                    SwingUtilities.invokeLater(() -> overlayTable.setOverlayVisible(locoTable.getModel().getRowCount() == 0));
                }
            }
        });
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + locoTable.getEmptyTableText() + ":f:gray}")));
        overlayTable.setOverlayVisible(locoTable.getModel().getRowCount() == 0);
        dialogBuilder.add((Component)overlayTable).xyw(1, 3, 11);
        JPanel contentPanelTemp = dialogBuilder.build();
        this.contentPanel = contentPanelTemp;
        final LocoListMenu locoTableMenu = new LocoListMenu(this.contentPanel, locoTableController, locoTable, tableModel, locoTableModel);
        TablePopupMenuInstaller installer = new TablePopupMenuInstaller((JTable)locoTable){

            protected JPopupMenu createPopupMenu() {
                return locoTableMenu;
            }

            protected void customizeMenuItems(JTable table, JPopupMenu popup, int clickingRow, int clickingColumn) {
                LOGGER.info("Customize the popup menu: {}", (Object)popup);
                if (clickingRow > -1 && table.getSelectedRow() != clickingRow) {
                    table.setRowSelectionInterval(clickingRow, clickingRow);
                }
                if (table.getSelectedRow() > -1) {
                    locoTableMenu.enableLocoMenuItems(true);
                } else {
                    locoTableMenu.enableLocoMenuItems(false);
                }
                super.customizeMenuItems(table, popup, clickingRow, clickingColumn);
            }
        };
        locoTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                LocoListModel locoModel;
                if (me.getClickCount() == 2 && (locoModel = LocoTableView.this.getSelectedRow(locoTable, sortableTableModel, tableModel)) != null) {
                    LocoTableView.this.fireOpenLocoDialog(locoModel);
                }
            }
        });
    }

    public DockKey getDockKey() {
        return this.DOCKKEY;
    }

    public Component getComponent() {
        return this.contentPanel;
    }

    private LocoListModel getSelectedRow(AbstractEmptyTable locoTable, SortableTableModel sortableTableModel, LocoTableTableModel locoTableTableModel) {
        int selectedRow = locoTable.getSelectedRow();
        if ((selectedRow = sortableTableModel.getActualRowAt(selectedRow)) > -1) {
            LocoListModel locoModel = (LocoListModel)locoTableTableModel.getListModel().getElementAt(selectedRow);
            return locoModel;
        }
        return null;
    }

    private void fireOpenLocoDialog(LocoListModel locoModel) {
        this.locoTableController.openLocoDialog(locoModel);
    }

    private void fireQueryLocoList() {
        if (this.locoTableController != null) {
            Integer address = this.locoListBeanModel.getAddress();
            CsQueryTypeEnum csQueryType = this.locoListBeanModel.getCsQueryType();
            LOGGER.info("Current selected csQueryType: {}, address: {}", (Object)csQueryType, (Object)address);
            this.locoTableController.queryCommandStationList(csQueryType, address);
        }
    }

    private class CsQueryTypeCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private Map<String, String> labelMap = new HashMap<String, String>();

        public CsQueryTypeCellRenderer() {
            for (CsQueryTypeEnum addressTypeEnum : CsQueryTypeEnum.values()) {
                String label = Resources.getString(CsQueryTypeEnum.class, (String)addressTypeEnum.getKey());
                this.labelMap.put(addressTypeEnum.getKey(), label);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof CsQueryTypeEnum) {
                CsQueryTypeEnum addressTypeEnum = (CsQueryTypeEnum)value;
                renderer.setText(this.labelMap.get(addressTypeEnum.getKey()));
            } else {
                renderer.setText(null);
            }
            return renderer;
        }
    }
}

