/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import com.vlsolutions.swing.docking.DockingDesktop;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.bidib2.BiDiB;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.simulation.SimulatorRegistry;
import org.bidib.jbidibc.simulation.nodes.Simulation;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.CommandStationNodeInterface;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.RfBasisNodeInterface;
import org.bidib.wizard.api.model.event.CheckForWizardUpdatesEvent;
import org.bidib.wizard.api.utils.NodeUtils;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.event.BidibConnectionEvent;
import org.bidib.wizard.client.common.event.MainControllerBoosterOnEvent;
import org.bidib.wizard.client.common.event.MainControllerEvent;
import org.bidib.wizard.client.common.event.MenuEvent;
import org.bidib.wizard.client.common.mvc.firmware.controller.FirmwareArchiveValidationController;
import org.bidib.wizard.client.common.view.DefaultBusyFrame;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.common.service.SettingsService;
import org.bidib.wizard.config.BackupControllerFactory;
import org.bidib.wizard.config.ComparisonControllerFactory;
import org.bidib.wizard.config.DccAdvControllerFactory;
import org.bidib.wizard.config.DebugConsoleControllerFactory;
import org.bidib.wizard.config.DebugInterfaceControllerFactory;
import org.bidib.wizard.config.FeedbackPositionControllerFactory;
import org.bidib.wizard.config.LocoControllerFactory;
import org.bidib.wizard.config.LocoTableControllerFactory;
import org.bidib.wizard.config.NetDebugControllerFactory;
import org.bidib.wizard.config.SimulationControllerFactory;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.dcca.client.controller.DccAdvController;
import org.bidib.wizard.dialog.AboutDialog;
import org.bidib.wizard.discovery.service.ZeroConfService;
import org.bidib.wizard.firmwarerepo.client.controller.FirmwareRepoController;
import org.bidib.wizard.localhost.client.controller.LocalHostClientController;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.bidib.wizard.mvc.backup.controller.BackupController;
import org.bidib.wizard.mvc.booster.controller.BoosterTableController;
import org.bidib.wizard.mvc.common.DialogRegistry;
import org.bidib.wizard.mvc.comparison.controller.ComparisonController;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.bidib.wizard.mvc.debug.controller.DebugInterfaceController;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.locolist.controller.LocoTableController;
import org.bidib.wizard.mvc.logger.controller.LogPanelController;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.main.controller.exception.CloseAbortedException;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.MainView;
import org.bidib.wizard.mvc.main.view.component.BoosterOnConfirmDialog;
import org.bidib.wizard.mvc.main.view.menu.listener.MainMenuListener;
import org.bidib.wizard.mvc.netdebug.controller.NetDebugController;
import org.bidib.wizard.mvc.nodedebug.controller.DebugConsoleController;
import org.bidib.wizard.mvc.ping.controller.PingTableController;
import org.bidib.wizard.mvc.position.controller.FeedbackPositionController;
import org.bidib.wizard.mvc.preferences.controller.PreferencesController;
import org.bidib.wizard.mvc.worklist.controller.WorkListController;
import org.bidib.wizard.nodes.client.controller.NodesClientController;
import org.bidib.wizard.nodescript.client.controller.NodeScriptController;
import org.bidib.wizard.script.client.controller.ScriptClientController;
import org.bidib.wizard.simulation.client.controller.SimulationController;
import org.bidib.wizard.tracer.client.controller.TracerClientController;
import org.bidib.wizard.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;

public class DefaultMainMenuListener
implements MainMenuListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMainMenuListener.class);
    private final MainView viewSupplier;
    private final DockingDesktop dockingDesktop;
    private final MainModel mainModel;
    private final SettingsService settingsService;
    private final ApplicationContext applicationContext;
    private final LocoTableControllerFactory locoTableControllerFactory;
    private static final String WORKING_DIR_LOGFILES_COLLECT_KEY = "logfilesCollect";
    private static final String WORKING_DIR_SIMULATION_KEY = "simulation";
    private static final String SUFFIX_JSON = "json";
    private static final String WORKING_DIR_COMPARISON_KEY = "comparison";
    private static final String SUFFIX_XML = "xml";

    public DefaultMainMenuListener(MainView viewSupplier, DockingDesktop dockingDesktop, MainModel mainModel, SettingsService settingsService, ApplicationContext applicationContext, LocoTableControllerFactory locoTableControllerFactory) {
        this.viewSupplier = viewSupplier;
        this.dockingDesktop = dockingDesktop;
        this.mainModel = mainModel;
        this.settingsService = settingsService;
        this.applicationContext = applicationContext;
        this.locoTableControllerFactory = locoTableControllerFactory;
    }

    @Override
    public void about() {
        new AboutDialog((Component)this.viewSupplier.getFrame());
    }

    @Override
    public void exit() {
        this.applicationContext.publishEvent((Object)new MainControllerEvent(MainControllerEvent.Action.stop));
    }

    @Override
    public void preferences() {
        PreferencesController preferencesController = (PreferencesController)this.applicationContext.getBean(PreferencesController.class);
        try {
            preferencesController.start();
        }
        catch (Exception ex) {
            LOGGER.warn("Start preferences controller failed.", (Throwable)ex);
        }
    }

    @Override
    public void connect() {
        LOGGER.info("Let the mainController open the connection.");
        this.applicationContext.publishEvent((Object)new BidibConnectionEvent("main", BidibConnectionEvent.Action.connect));
    }

    @Override
    public void disconnect() {
        LOGGER.info("Let the mainController close the connection.");
        try {
            this.applicationContext.publishEvent((Object)new BidibConnectionEvent("main", BidibConnectionEvent.Action.disconnect));
        }
        catch (CloseAbortedException ex) {
            LOGGER.warn("Close connection was aborted.");
        }
    }

    @Override
    public void listenNetBidib() {
        LOGGER.info("Let the mainController listen for incoming netBidib connections.");
        this.applicationContext.publishEvent((Object)new MainControllerEvent(MainControllerEvent.Action.listenNetBidib));
    }

    @Override
    public void allBoosterOff() {
        LOGGER.info("Switch all boosters off!");
        this.applicationContext.publishEvent((Object)new MainControllerEvent(MainControllerEvent.Action.allBoosterOff));
    }

    @Override
    public void allBoosterOn() {
        LOGGER.info("Switch all boosters on!");
        int result = 2;
        CommandStationStatus requestedCommandStationState = CommandStationStatus.GO;
        if (!this.settingsService.getWizardSettings().isAllBoosterOnDoNotConfirmSwitch()) {
            BoosterOnConfirmDialog allBoosterOnConfirmDialog = new BoosterOnConfirmDialog((JFrame)JOptionPane.getFrameForComponent((Component)this.viewSupplier.getFrame()), this.settingsService);
            result = allBoosterOnConfirmDialog.getResult();
            requestedCommandStationState = allBoosterOnConfirmDialog.getCommandStationStatus();
        } else {
            result = this.settingsService.getWizardSettings().getAllBoosterOnSavedAction();
            requestedCommandStationState = this.settingsService.getWizardSettings().getAllBoosterOnRequestedCommandStationState();
            LOGGER.info("Fetched action for all booster on from preferences: {}", (Object)result);
        }
        if (2 == result) {
            LOGGER.info("User cancelled allBoosterOnConfirmDialog.");
            return;
        }
        this.applicationContext.publishEvent((Object)new MainControllerBoosterOnEvent(result == 3, requestedCommandStationState));
    }

    @Override
    public void checkForUpdates() {
        LOGGER.info("Check for updates.");
        this.applicationContext.publishEvent((Object)new CheckForWizardUpdatesEvent());
    }

    @Override
    public void collectLogFiles() {
        LOGGER.info("Collect the logfiles.");
        final String logFilePath = this.settingsService.getMiscSettings().getLogFilePath();
        if (StringUtils.isNotBlank((CharSequence)logFilePath)) {
            final File logfile = new File(new File(logFilePath), "BiDiBWizard2.log");
            if (logfile.exists()) {
                LOGGER.info("Found logfile to copy: {}", (Object)logfile);
                final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
                String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_LOGFILES_COLLECT_KEY);
                FileFilter[] ff = null;
                FileDialog dialog = new FileDialog((Component)this.viewSupplier.getFrame(), 1, storedWorkingDirectory, null, ff){

                    public void approve(String selectedFile) {
                        File file = new File(selectedFile);
                        if (file != null && file.isDirectory()) {
                            String zipFilePath = file.getPath();
                            LOGGER.info("Copy the logfiles to directory: {}", (Object)zipFilePath);
                            try {
                                File targetWizardLog = new File(file, "BiDiBWizard2.log");
                                FileUtils.silentlyDeleteFile(targetWizardLog, 200L);
                                FileUtils.copyFile(logfile, targetWizardLog, new CopyOption[0]);
                                File logfileRXTX = new File(new File(logFilePath), "BiDiBWizard2-RXTX.log");
                                File targetWizardRXTXLog = null;
                                if (logfileRXTX.exists()) {
                                    targetWizardRXTXLog = new File(file, "BiDiBWizard2-RXTX.log");
                                    FileUtils.silentlyDeleteFile(targetWizardRXTXLog, 200L);
                                    FileUtils.copyFile(logfileRXTX, targetWizardRXTXLog, new CopyOption[0]);
                                }
                                File logfileRXTX_NET = new File(new File(logFilePath), "BiDiBWizard2-RXTX-NET.log");
                                File targetWizardRXTX_NETLog = null;
                                if (logfileRXTX_NET.exists()) {
                                    targetWizardRXTX_NETLog = new File(file, "BiDiBWizard2-RXTX-NET.log");
                                    FileUtils.silentlyDeleteFile(targetWizardRXTX_NETLog, 200L);
                                    FileUtils.copyFile(logfileRXTX_NET, targetWizardRXTX_NETLog, new CopyOption[0]);
                                }
                                File logfileRAW = new File(new File(logFilePath), "BiDiBWizard2-RAW.log");
                                File targetWizardRAWLog = null;
                                if (logfileRAW.exists()) {
                                    targetWizardRAWLog = new File(file, "BiDiBWizard2-RAW.log");
                                    FileUtils.silentlyDeleteFile(targetWizardRAWLog, 200L);
                                    FileUtils.copyFile(logfileRAW, targetWizardRAWLog, new CopyOption[0]);
                                }
                                File logfileSIM = new File(new File(logFilePath), "BiDiBWizard2-SIM.log");
                                File targetWizardSIMLog = null;
                                if (logfileSIM.exists()) {
                                    targetWizardSIMLog = new File(file, "BiDiBWizard2-SIM.log");
                                    FileUtils.silentlyDeleteFile(targetWizardSIMLog, 200L);
                                    FileUtils.copyFile(logfileSIM, targetWizardSIMLog, new CopyOption[0]);
                                }
                                File logfileMDNS = new File(new File(logFilePath), "BiDiBWizard2-MDNS.log");
                                File targetWizardMDNSLog = null;
                                if (logfileMDNS.exists()) {
                                    targetWizardMDNSLog = new File(file, "BiDiBWizard2-MDNS.log");
                                    FileUtils.silentlyDeleteFile(targetWizardMDNSLog, 200L);
                                    FileUtils.copyFile(logfileMDNS, targetWizardMDNSLog, new CopyOption[0]);
                                }
                                File logfileZ21 = new File(new File(logFilePath), "BiDiBWizard2-Z21.log");
                                File targetWizardZ21Log = null;
                                if (logfileZ21.exists()) {
                                    targetWizardZ21Log = new File(file, "BiDiBWizard2-Z21.log");
                                    FileUtils.silentlyDeleteFile(targetWizardZ21Log, 200L);
                                    FileUtils.copyFile(logfileZ21, targetWizardZ21Log, new CopyOption[0]);
                                }
                                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmSS");
                                File zipFile = new File(file, "BiDiBWizard2-logs-" + sdf.format(new Date()) + ".zip");
                                LOGGER.info("Zip the logfiles to file: {}", (Object)zipFile);
                                FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
                                ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                                ZipEntry zipEntry = new ZipEntry(targetWizardLog.getName());
                                zipOutputStream.putNextEntry(zipEntry);
                                org.apache.commons.io.FileUtils.copyFile((File)targetWizardLog, (OutputStream)zipOutputStream);
                                zipOutputStream.closeEntry();
                                FileUtils.silentlyDeleteFile(targetWizardLog, null);
                                if (targetWizardRXTXLog != null) {
                                    zipEntry = new ZipEntry(targetWizardRXTXLog.getName());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    org.apache.commons.io.FileUtils.copyFile((File)targetWizardRXTXLog, (OutputStream)zipOutputStream);
                                    zipOutputStream.closeEntry();
                                    FileUtils.silentlyDeleteFile(targetWizardRXTXLog, null);
                                }
                                if (targetWizardRXTX_NETLog != null) {
                                    zipEntry = new ZipEntry(targetWizardRXTX_NETLog.getName());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    org.apache.commons.io.FileUtils.copyFile((File)targetWizardRXTX_NETLog, (OutputStream)zipOutputStream);
                                    zipOutputStream.closeEntry();
                                    FileUtils.silentlyDeleteFile(targetWizardRXTX_NETLog, null);
                                }
                                if (targetWizardRAWLog != null) {
                                    zipEntry = new ZipEntry(targetWizardRAWLog.getName());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    org.apache.commons.io.FileUtils.copyFile((File)targetWizardRAWLog, (OutputStream)zipOutputStream);
                                    zipOutputStream.closeEntry();
                                    FileUtils.silentlyDeleteFile(targetWizardRAWLog, null);
                                }
                                if (targetWizardSIMLog != null) {
                                    zipEntry = new ZipEntry(targetWizardSIMLog.getName());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    org.apache.commons.io.FileUtils.copyFile((File)targetWizardSIMLog, (OutputStream)zipOutputStream);
                                    zipOutputStream.closeEntry();
                                    FileUtils.silentlyDeleteFile(targetWizardSIMLog, null);
                                }
                                if (targetWizardMDNSLog != null) {
                                    zipEntry = new ZipEntry(targetWizardMDNSLog.getName());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    org.apache.commons.io.FileUtils.copyFile((File)targetWizardMDNSLog, (OutputStream)zipOutputStream);
                                    zipOutputStream.closeEntry();
                                    FileUtils.silentlyDeleteFile(targetWizardMDNSLog, null);
                                }
                                if (targetWizardZ21Log != null) {
                                    zipEntry = new ZipEntry(targetWizardZ21Log.getName());
                                    zipOutputStream.putNextEntry(zipEntry);
                                    org.apache.commons.io.FileUtils.copyFile((File)targetWizardZ21Log, (OutputStream)zipOutputStream);
                                    zipOutputStream.closeEntry();
                                    FileUtils.silentlyDeleteFile(targetWizardZ21Log, null);
                                }
                                zipOutputStream.close();
                                fileOutputStream.close();
                                String workingDir = Paths.get(selectedFile, new String[0]).getParent() != null ? Paths.get(selectedFile, new String[0]).getParent().toString() : Paths.get(selectedFile, new String[0]).toString();
                                LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                                wizardSettings.setWorkingDirectory(DefaultMainMenuListener.WORKING_DIR_LOGFILES_COLLECT_KEY, workingDir);
                                LOGGER.info("Open folder: {}", (Object)file);
                                Desktop.getDesktop().open(file);
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Copy logfile to backup location failed.", (Throwable)ex);
                                JOptionPane.showMessageDialog((Component)DefaultMainMenuListener.this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"copy-logfiles-failed", (Object[])new Object[]{ex.getLocalizedMessage()}), Resources.getString(DefaultMainMenuListener.class, (String)"title-error"), 0);
                            }
                        }
                    }
                };
                dialog.setApproveButtonText(Resources.getString(DefaultMainMenuListener.class, (String)"save-under"));
                dialog.showDialog();
            } else {
                JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"copy-logfiles-not-found", (Object[])new Object[]{logFilePath}), Resources.getString(DefaultMainMenuListener.class, (String)"title-error"), 0);
            }
        } else {
            LOGGER.warn("No logFilePath available.");
        }
    }

    @Override
    public void showRxTxLoggerView() {
        LOGGER.info("Open the RXTX log panel.");
        LogPanelController logPanelController = (LogPanelController)this.applicationContext.getBean(LogPanelController.class);
        logPanelController.start();
    }

    @Override
    public void showTracerClient() {
        LOGGER.info("Open the tracer client view.");
        TracerClientController tracerClientController = (TracerClientController)this.applicationContext.getBean(TracerClientController.class);
        tracerClientController.start();
    }

    @Override
    public void boosterTable() {
        LOGGER.info("Open the booster table.");
        BoosterTableController boosterTableController = (BoosterTableController)this.applicationContext.getBean(BoosterTableController.class);
        boosterTableController.start();
    }

    @Override
    public void feedbackPositionTable() {
        LOGGER.info("Open the feedbackPosition table.");
        FeedbackPositionControllerFactory feedbackPositionControllerFactory = (FeedbackPositionControllerFactory)this.applicationContext.getBean(FeedbackPositionControllerFactory.class);
        FeedbackPositionController feedbackPositionController = feedbackPositionControllerFactory.createController(this.dockingDesktop, this.mainModel);
        feedbackPositionController.start();
    }

    @Override
    public void pingTable() {
        LOGGER.info("Open the ping table.");
        PingTableController pingTableController = (PingTableController)this.applicationContext.getBean(PingTableController.class);
        pingTableController.start();
    }

    @Override
    public void console() {
        LOGGER.info("Open the console.");
        ConsoleController.ensureConsoleVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void locoTable() {
        LOGGER.info("Open the loco table.");
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null && selectedNode.getCommandStationNode() != null) {
            CommandStationNodeInterface node = selectedNode.getCommandStationNode();
            LOGGER.info("Open the loco table for node: {}", (Object)node);
            DefaultBusyFrame.setWaitCursor((Component)this.viewSupplier.getFrame());
            try {
                MainControllerInterface mainController = (MainControllerInterface)this.applicationContext.getBean(MainControllerInterface.class);
                LocoTableController locoTableController = this.locoTableControllerFactory.createLocoTableController(selectedNode, this.viewSupplier.getDesktop(), (JFrame)this.viewSupplier.getFrame(), this.applicationContext);
                locoTableController.start(mainController);
                locoTableController.queryLocoList();
            }
            catch (Exception ex) {
                LOGGER.warn("Open loco table failed.", (Throwable)ex);
                JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), "Open loco table failed.", "Open loco table", 0);
            }
            finally {
                DefaultBusyFrame.setDefaultCursor((Component)this.viewSupplier.getFrame());
            }
        }
    }

    @Override
    public void nodeScriptView() {
        LOGGER.info("Open the nodeScript editor.");
        NodeScriptController nodeScriptController = (NodeScriptController)this.applicationContext.getBean(NodeScriptController.class);
        nodeScriptController.showView(this.dockingDesktop, (NodeSelectionProvider)this.mainModel);
    }

    @Override
    public void debugInterface() {
        LOGGER.info("Open the debug interface panel.");
        DebugInterfaceControllerFactory debugInterfaceControllerFactory = (DebugInterfaceControllerFactory)this.applicationContext.getBean(DebugInterfaceControllerFactory.class);
        DebugInterfaceController debugInterfaceController = debugInterfaceControllerFactory.createController(this.dockingDesktop, this.settingsService);
        debugInterfaceController.start();
    }

    @Override
    public void netDebug() {
        LOGGER.info("Open the netDebug panel.");
        NetDebugControllerFactory netDebugControllerFactory = (NetDebugControllerFactory)this.applicationContext.getBean(NetDebugControllerFactory.class);
        NetDebugController netDebugController = netDebugControllerFactory.createController(this.dockingDesktop);
        netDebugController.start();
    }

    @Override
    public void debugConsole() {
        LOGGER.info("Open the debug console panel.");
        DebugConsoleControllerFactory debugConsoleControllerFactory = (DebugConsoleControllerFactory)this.applicationContext.getBean(DebugConsoleControllerFactory.class);
        DebugConsoleController debugConsoleController = debugConsoleControllerFactory.createController();
        debugConsoleController.start();
    }

    @Override
    public void saveNodeTreeForSimulation() {
        LOGGER.info("Save the node tree for simulation.");
        try {
            SimulationControllerFactory simulationControllerFactory = (SimulationControllerFactory)this.applicationContext.getBean(SimulationControllerFactory.class);
            SimulationController simulationController = simulationControllerFactory.createController(this.dockingDesktop);
            final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
            String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_SIMULATION_KEY);
            final Simulation simulation = simulationController.exportNodeTreeToSimulation();
            FileNameExtensionFilter ff = new FileNameExtensionFilter("Simulation", SUFFIX_XML, SUFFIX_JSON);
            FileDialog dialog = new FileDialog((Component)this.viewSupplier.getFrame(), 1, storedWorkingDirectory, null, new FileFilter[]{ff}){

                public void approve(String fileName) {
                    LOGGER.info("Save the simulation to file: {}", (Object)fileName);
                    Object selectedFile = fileName;
                    if (!FilenameUtils.isExtension((String)fileName, (String)DefaultMainMenuListener.SUFFIX_XML) && !FilenameUtils.isExtension((String)fileName, (String)DefaultMainMenuListener.SUFFIX_JSON)) {
                        LOGGER.info("Add default extension 'xml'.");
                        selectedFile = fileName + ".xml";
                    }
                    try {
                        File file = new File((String)selectedFile);
                        if (FilenameUtils.isExtension((String)fileName, (String)DefaultMainMenuListener.SUFFIX_JSON)) {
                            SimulatorRegistry.saveSimulationConfigurationJson((Simulation)simulation, (File)file);
                        } else {
                            SimulatorRegistry.saveSimulationConfiguration((Simulation)simulation, (File)file);
                        }
                        String workingDir = Paths.get((String)selectedFile, new String[0]).getParent().toString();
                        LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                        wizardSettings.setWorkingDirectory(DefaultMainMenuListener.WORKING_DIR_SIMULATION_KEY, workingDir);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Save simulation to file failed: {}", selectedFile, (Object)ex);
                        JOptionPane.showMessageDialog((Component)DefaultMainMenuListener.this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-simulation.failed", (Object[])new Object[]{ex.getLocalizedMessage()}), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-simulation.title"), 0);
                    }
                }
            };
            dialog.showDialog();
        }
        catch (Exception ex) {
            LOGGER.warn("Save node tree for simulation failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-simulation.failed"), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-simulation.title"), 0);
        }
    }

    @Override
    public void backupAllNodes() {
        LOGGER.info("Backup all nodes.");
        try {
            BackupControllerFactory backupControllerFactory = (BackupControllerFactory)this.applicationContext.getBean(BackupControllerFactory.class);
            BackupController backupController = backupControllerFactory.createController(this.dockingDesktop, this.mainModel);
            backupController.start();
        }
        catch (Exception ex) {
            LOGGER.warn("Backup node tree failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"backup-all-nodes.failed"), Resources.getString(DefaultMainMenuListener.class, (String)"backup-all-nodes.title"), 0);
        }
    }

    @Override
    public void dccAdv() {
        LOGGER.info("Open the DCC-A panel.");
        DccAdvControllerFactory dccAdvControllerFactory = (DccAdvControllerFactory)this.applicationContext.getBean(DccAdvControllerFactory.class);
        DccAdvController dccAdvController = dccAdvControllerFactory.createController(this.mainModel.getSelectedNode(), this.dockingDesktop);
        dccAdvController.start();
    }

    @Override
    public void showNodeScriptWizard() {
        LOGGER.info("Open the nodeScript wizard.");
        NodeScriptController nodeScriptController = (NodeScriptController)this.applicationContext.getBean(NodeScriptController.class);
        nodeScriptController.showWizard(this.dockingDesktop, (NodeSelectionProvider)this.mainModel);
    }

    @Override
    public void showFirmwareRepo() {
        LOGGER.info("Open the firmware repo view.");
        FirmwareRepoController firmwareRepoController = (FirmwareRepoController)this.applicationContext.getBean(FirmwareRepoController.class);
        firmwareRepoController.start(false);
    }

    @Override
    public void showNodesClient() {
        LOGGER.info("Open the nodes client view.");
        NodesClientController nodesClientController = (NodesClientController)this.applicationContext.getBean(NodesClientController.class);
        nodesClientController.start();
    }

    @Override
    public void showScriptClient() {
        LOGGER.info("Open the script client view.");
        ScriptClientController scriptClientController = (ScriptClientController)this.applicationContext.getBean(ScriptClientController.class);
        scriptClientController.start();
    }

    @Override
    public void showLocalHostClient() {
        LOGGER.info("Open the localHost client view.");
        LocalHostClientController localHostClientController = (LocalHostClientController)this.applicationContext.getBean(LocalHostClientController.class);
        localHostClientController.start();
    }

    @Override
    public void discoverySingleListServices() {
        try {
            ZeroConfService bonjourService = (ZeroConfService)this.applicationContext.getBean(ZeroConfService.class);
            bonjourService.listServices("_bidib._tcp.local.");
        }
        catch (Exception ex) {
            LOGGER.warn("List services in bonjour service failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), "List services in bonjour service failed:\n" + ex.getMessage(), "Bonjour Developer", 0);
        }
    }

    @Override
    public void showLocoDialog() {
        LOGGER.info("Open the loco controller dialog.");
        CommandStationNodeInterface node = NodeUtils.findFirstCommandStationNode((Iterable)this.mainModel.getNodeProvider().getNodes());
        if (node != null) {
            LocoControllerFactory locoControllerFactory = (LocoControllerFactory)this.applicationContext.getBean(LocoControllerFactory.class);
            DialogRegistry dialogRegistry = (DialogRegistry)this.applicationContext.getBean(DialogRegistry.class);
            LocoController locoController = locoControllerFactory.createLocoController(node, (JFrame)this.viewSupplier.getFrame(), this.mainModel.getNodeProvider(), dialogRegistry);
            AddressData initialAddress = null;
            locoController.start(initialAddress, null, null);
        }
    }

    @Override
    public void showCarDialog() {
        LOGGER.info("Open the car controller dialog.");
        RfBasisNodeInterface node = NodeUtils.findFirstRfBasisMasterNode((Collection)this.mainModel.getNodeProvider().getNodes());
        if (node != null) {
            LocoControllerFactory locoControllerFactory = (LocoControllerFactory)this.applicationContext.getBean(LocoControllerFactory.class);
            DialogRegistry dialogRegistry = (DialogRegistry)this.applicationContext.getBean(DialogRegistry.class);
            LocoController locoController = locoControllerFactory.createLocoController(node.getNode().getCommandStationNode(), (JFrame)this.viewSupplier.getFrame(), this.mainModel.getNodeProvider(), dialogRegistry);
            AddressData initialAddress = null;
            locoController.start(initialAddress, null, null);
        } else {
            JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"open-car-dialog.failed-no-basis"), Resources.getString(DefaultMainMenuListener.class, (String)"open-car-dialog.title"), 0);
        }
    }

    @EventListener
    public void handleMenuEvent(MenuEvent event) {
        LOGGER.info("Handle the menu event: {}", (Object)event);
        SwingUtilities.invokeLater(() -> {
            switch (event.getAction()) {
                case nodeScriptWizard: {
                    this.showNodeScriptWizard();
                    break;
                }
                case boosterTable: {
                    this.boosterTable();
                    break;
                }
                case rxtxView: {
                    this.showRxTxLoggerView();
                    break;
                }
                default: {
                    LOGGER.warn("Unhandled MenuEvent detected: {}", (Object)event);
                }
            }
        });
    }

    @Override
    public void showWorkItemList() {
        LOGGER.info("Open the workList view.");
        WorkListController workListController = (WorkListController)this.applicationContext.getBean(WorkListController.class);
        workListController.start();
    }

    @Override
    public void saveNodeTreeForComparison() {
        LOGGER.info("Save the node tree for comparison.");
        try {
            ComparisonControllerFactory comparisonControllerFactory = (ComparisonControllerFactory)this.applicationContext.getBean(ComparisonControllerFactory.class);
            ComparisonController comparisonController = comparisonControllerFactory.createController(this.dockingDesktop);
            final WizardSettingsInterface wizardSettings = this.settingsService.getWizardSettings();
            String storedWorkingDirectory = wizardSettings.getWorkingDirectory(WORKING_DIR_COMPARISON_KEY);
            final BiDiB bidib = comparisonController.exportNodeTreeToComparison();
            FileNameExtensionFilter ff = new FileNameExtensionFilter("Comparison", SUFFIX_XML);
            FileDialog dialog = new FileDialog((Component)this.viewSupplier.getFrame(), 1, storedWorkingDirectory, null, SUFFIX_XML, new FileFilter[]{ff}){

                public void approve(String fileName) {
                    LOGGER.info("Save the comparison data to file: {}", (Object)fileName);
                    Object selectedFile = fileName;
                    if (!FilenameUtils.isExtension((String)fileName, (String)DefaultMainMenuListener.SUFFIX_XML)) {
                        LOGGER.info("Add default extension 'xml'.");
                        selectedFile = fileName + ".xml";
                    }
                    try {
                        File file = new File((String)selectedFile);
                        BidibFactory.saveBiDiB((BiDiB)bidib, (File)file, (boolean)false);
                        String workingDir = Paths.get((String)selectedFile, new String[0]).getParent().toString();
                        LOGGER.info("Save current workingDir: {}", (Object)workingDir);
                        wizardSettings.setWorkingDirectory(DefaultMainMenuListener.WORKING_DIR_COMPARISON_KEY, workingDir);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Save comparison data to file failed: {}", selectedFile, (Object)ex);
                        JOptionPane.showMessageDialog((Component)DefaultMainMenuListener.this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-comparison.failed", (Object[])new Object[]{ex.getLocalizedMessage()}), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-comparison.title"), 0);
                    }
                }
            };
            dialog.showDialog();
        }
        catch (Exception ex) {
            LOGGER.warn("Save node tree for comparison failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.viewSupplier.getFrame(), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-comparison.failed"), Resources.getString(DefaultMainMenuListener.class, (String)"save-nodes-for-comparison.title"), 0);
        }
    }

    @Override
    public void showFirmwareArchiveValidationView() {
        LOGGER.info("Open the FirmwareArchiveValidation view.");
        FirmwareArchiveValidationController firmwareArchiveValidationController = (FirmwareArchiveValidationController)this.applicationContext.getBean(FirmwareArchiveValidationController.class);
        firmwareArchiveValidationController.start();
    }
}

