/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.collections4.MapUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.jbidibc.messages.enums.IoBehaviourSwitchEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.jbidibc.messages.port.BytePortConfigValue;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.SwitchingNodeInterface;
import org.bidib.wizard.api.model.listener.DefaultNodeListListener;
import org.bidib.wizard.api.model.listener.NodeListListener;
import org.bidib.wizard.api.model.listener.SwitchPortListener;
import org.bidib.wizard.api.script.Scripting;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.PortListUtils;
import org.bidib.wizard.common.labels.BidibLabelUtils;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.script.DefaultScriptContext;
import org.bidib.wizard.common.script.common.WaitCommand;
import org.bidib.wizard.common.script.engine.ScriptEngine;
import org.bidib.wizard.common.script.switching.PortScripting;
import org.bidib.wizard.common.script.switching.SwitchPortCommand;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.PortTypeAware;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.main.controller.wrapper.NodePortWrapper;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.SwitchPortTableModel;
import org.bidib.wizard.mvc.main.model.listener.SwitchPortModelListener;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.panel.SwitchPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class SwitchPortPanelController
implements PortScripting {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPortPanelController.class);
    private final MainModel mainModel;
    private final Map<NodeInterface, NodePortWrapper> testToggleRegistry = new LinkedHashMap<NodeInterface, NodePortWrapper>();
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private ConsoleService consoleService;
    private SwitchPortListPanel switchPortListPanel;
    private final Subject<PortConfigChangeEvent> portConfigChangeEventSubject;
    private CompositeDisposable compDisp;

    public SwitchPortPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
        this.compDisp = new CompositeDisposable();
        this.portConfigChangeEventSubject = PublishSubject.create().toSerialized();
    }

    public SwitchPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        final SwitchPortTableModel tableModel = new SwitchPortTableModel(this.mainModel);
        tableModel.setPortListener(new SwitchPortModelListener(){

            public void labelChanged(SwitchPort port, String label) {
                LOGGER.info("Set the label for port: {}, label: {}", (Object)port, (Object)label);
                port.setLabel(label);
                try {
                    NodeLabels nodeLabels = SwitchPortPanelController.this.getNodeLabels();
                    BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.switchPort, (int)port.getId(), (String)port.getLabel());
                    SwitchPortPanelController.this.saveLabels();
                }
                catch (InvalidConfigurationException ex) {
                    LOGGER.warn("Save switch port labels failed.", (Throwable)ex);
                    String labelPath = ex.getReason();
                    JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
                }
            }

            public void configChanged(SwitchPort port, PortConfigKeys ... portConfigKeys) {
                LOGGER.info("The port config value are changed for port: {}", (Object)port);
                LinkedHashMap<Byte, BytePortConfigValue> values = new LinkedHashMap<Byte, BytePortConfigValue>();
                List switchPorts = SwitchPortPanelController.this.mainModel.getSelectedNode().getSwitchPorts();
                SwitchPort switchPort = (SwitchPort)PortListUtils.findPortByPortNumber((List)switchPorts, (int)port.getId());
                block7: for (PortConfigKeys key : portConfigKeys) {
                    if (!switchPort.isPortConfigKeySupported(key)) {
                        LOGGER.info("Unsupported port config key detected: {}", (Object)key);
                        continue;
                    }
                    switch (key) {
                        case BIDIB_PCFG_SWITCH_CTRL: {
                            IoBehaviourSwitchEnum ioBehaviour = port.getOutputBehaviour();
                            if (ioBehaviour == null || ioBehaviour == IoBehaviourSwitchEnum.UNKNOWN) continue block7;
                            values.put(BidibLibrary.BIDIB_PCFG_SWITCH_CTRL, new BytePortConfigValue(Byte.valueOf(ioBehaviour.getType())));
                            continue block7;
                        }
                        case BIDIB_PCFG_TICKS: {
                            Integer switchOffTime = port.getSwitchOffTime();
                            if (switchOffTime == null) continue block7;
                            values.put((byte)11, new BytePortConfigValue(ByteUtils.getLowByte((Integer)switchOffTime)));
                            continue block7;
                        }
                        case BIDIB_PCFG_LOAD_TYPE: {
                            LoadTypeEnum loadType = port.getLoadType();
                            if (loadType == null || loadType == LoadTypeEnum.UNKNOWN) continue block7;
                            values.put(BidibLibrary.BIDIB_PCFG_LOAD_TYPE, new BytePortConfigValue(Byte.valueOf(loadType.getType())));
                            continue block7;
                        }
                        default: {
                            LOGGER.warn("Unsupported port config key detected: {}", (Object)key);
                        }
                    }
                }
                if (MapUtils.isNotEmpty(values)) {
                    try {
                        SwitchPortPanelController.this.switchingNodeService.setPortConfig("main", SwitchPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), (Port)port, null, values);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Set the switchPort parameters failed.", (Throwable)ex);
                        SwitchPortPanelController.this.mainModel.setNodeHasError(SwitchPortPanelController.this.mainModel.getSelectedNode(), true);
                    }
                } else {
                    LOGGER.info("No config values to save available.");
                }
            }

            @Override
            public void testButtonPressed(SwitchPort port, SwitchPortStatus requestedStatus) {
                LOGGER.info("The test button was pressed for port: {}, requestedStatus: {}", (Object)port, (Object)requestedStatus);
                NodeInterface node = SwitchPortPanelController.this.mainModel.getSelectedNode();
                if (SwitchPortStatus.TEST != port.getStatus()) {
                    SwitchPortPanelController.this.stopTestToggleTask(node, (Port<?>)port);
                    SwitchPortPanelController.this.switchingNodeService.setPortStatus("main", node.getSwitchingNode(), (Port)port);
                } else {
                    SwitchPortPanelController.this.addTestToggleTask(node, (Port<?>)port);
                }
            }

            public void changePortType(LcOutputType portType, Port<? extends BidibStatus> port) {
                LOGGER.info("The port type will change to: {}, port: {}", (Object)portType, port);
                HashMap values = new HashMap();
                SwitchPortPanelController.this.switchingNodeService.setPortConfig("main", SwitchPortPanelController.this.mainModel.getSelectedNode().getSwitchingNode(), port, portType, values);
            }
        });
        this.switchPortListPanel = new SwitchPortListPanel(this, tableModel, this.mainModel, tabVisibilityListener, this.portConfigChangeEventSubject);
        this.switchPortListPanel.setPortListener(new SwitchPortListener(){

            public Class<?> getPortClass() {
                return SwitchPort.class;
            }

            public void labelChanged(SwitchPort port, String label) {
                LOGGER.info("The label has been changed by nodeScript, port: {}, label: {}", (Object)port, (Object)label);
                NodeLabels nodeLabels = SwitchPortPanelController.this.getNodeLabels();
                BidibLabelUtils.replaceLabel((NodeLabels)nodeLabels, (WizardLabelFactory.LabelTypes)WizardLabelFactory.LabelTypes.switchPort, (int)port.getId(), (String)port.getLabel());
                SwitchPortPanelController.this.saveLabels();
            }

            public void statusChanged(NodeInterface node, SwitchPort port) {
                LOGGER.info("Status of switch port has changed, port: {}, status: {}", (Object)port, (Object)port.getStatus());
                SwingUtilities.invokeLater(() -> tableModel.notifyPortStatusChanged(port));
            }

            public void configChanged(NodeInterface node, SwitchPort port) {
                SwingUtilities.invokeLater(() -> SwitchPortPanelController.this.handlePortConfigChanged(node, tableModel, port));
            }

            public void testButtonPressed(NodeInterface node, SwitchPort port, SwitchPortStatus newStatus) {
            }
        });
        this.mainModel.addNodeListListener((NodeListListener)new DefaultNodeListListener(){

            public void nodeWillChange(NodeInterface node) {
                LOGGER.info("The selected node will change!");
                try {
                    LinkedList<NodeInterface> nodes = new LinkedList<NodeInterface>();
                    for (NodeInterface currentNode : SwitchPortPanelController.this.testToggleRegistry.keySet()) {
                        nodes.add(currentNode);
                    }
                    LOGGER.info("Found nodes to stop the test toggle task: {}", nodes);
                    for (NodeInterface currentNode : nodes) {
                        SwitchPortPanelController.this.stopTestToggleTask(currentNode, null);
                    }
                    LOGGER.info("Stop the test toggle task passed for nodes: {}", nodes);
                }
                catch (Exception ex) {
                    LOGGER.warn("Stop test toggle tasks failed.", (Throwable)ex);
                }
            }

            public void nodeChanged(NodeInterface node) {
                super.nodeChanged(node);
                LOGGER.info("The selected node has been changed: {}", (Object)node);
                SwitchPortPanelController.this.compDisp.dispose();
                SwitchPortPanelController.this.compDisp.clear();
                SwitchPortPanelController.this.compDisp = new CompositeDisposable();
                if (node != null) {
                    SwitchPortPanelController.this.addSwitchPortModelListener(node);
                }
            }
        });
        NodeInterface selectedNode = this.mainModel.getSelectedNode();
        if (selectedNode != null) {
            this.addSwitchPortModelListener(selectedNode);
        }
        return this.switchPortListPanel;
    }

    private void handlePortConfigChanged(NodeInterface node, SwitchPortTableModel tableModel, SwitchPort port) {
        this.switchPortListPanel.portTableLayoutChanged(node);
        tableModel.notifyPortConfigChanged(port);
    }

    public void addTestToggleTask(NodeInterface node, Port<?> port) {
        LOGGER.info("Add test toggle task for node: {}, port: {}", (Object)node, port);
        NodePortWrapper nodePortWrapper = this.testToggleRegistry.remove(node);
        ScriptEngine scriptEngine = null;
        if (nodePortWrapper != null) {
            scriptEngine = nodePortWrapper.removePort(port);
        }
        if (scriptEngine != null) {
            LOGGER.info("Found a node scripting engine in the registry: {}", scriptEngine);
            try {
                scriptEngine.stopScript(Long.valueOf(2000L));
            }
            catch (Exception ex) {
                LOGGER.warn("Stop script failed.", (Throwable)ex);
            }
        }
        DefaultScriptContext context = new DefaultScriptContext();
        context.register("selectedNode", (Object)node);
        context.register("mainModel", (Object)this.mainModel);
        scriptEngine = new ScriptEngine((Scripting)this, (ApplicationContext)context);
        LinkedList<Object> scriptCommands = new LinkedList<Object>();
        SwitchPortCommand spc = new SwitchPortCommand(this.consoleService);
        spc.parse("switch " + port.getId() + " ON");
        scriptCommands.add(spc);
        WaitCommand wc = new WaitCommand(this.consoleService);
        wc.parse("wait 2000");
        scriptCommands.add(wc);
        spc = new SwitchPortCommand(this.consoleService);
        spc.parse("switch " + port.getId() + " OFF");
        scriptCommands.add(spc);
        wc = new WaitCommand(this.consoleService);
        wc.parse("wait 2000");
        scriptCommands.add(wc);
        LOGGER.info("Prepared list of commands: {}", scriptCommands);
        scriptEngine.setScriptCommands(scriptCommands);
        scriptEngine.setScriptRepeating(true);
        if (nodePortWrapper == null) {
            LOGGER.info("Create new NodePortWrapper for node: {}", (Object)node);
            nodePortWrapper = new NodePortWrapper(node);
        }
        LOGGER.info("Put script engine in registry for node: {}", (Object)node);
        nodePortWrapper.addPort(port, (ScriptEngine<PortScripting>)scriptEngine);
        this.testToggleRegistry.put(node, nodePortWrapper);
        scriptEngine.startScript();
    }

    public void stopTestToggleTask(NodeInterface node, Port<?> port) {
        LOGGER.info("Stop test toggle task for node: {}, port: {}", (Object)node, port);
        NodePortWrapper nodePortWrapper = this.testToggleRegistry.get(node);
        if (nodePortWrapper != null) {
            HashSet toRemove = new HashSet();
            if (port != null) {
                toRemove.add(port);
            } else {
                toRemove.addAll(nodePortWrapper.getKeySet());
            }
            for (Port port2 : toRemove) {
                ScriptEngine<PortScripting> engine = nodePortWrapper.removePort(port2);
                if (engine != null) {
                    LOGGER.info("Found a node scripting engine in the registry: {}", engine);
                    try {
                        engine.stopScript(Long.valueOf(2000L));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Stop script failed.", (Throwable)ex);
                    }
                    continue;
                }
                LOGGER.warn("No scripting engine found for node: {}", (Object)node);
            }
            if (nodePortWrapper.isEmpty()) {
                LOGGER.info("No more ports registered for node: {}", (Object)node);
                this.testToggleRegistry.remove(node);
            }
        }
    }

    public void sendPortStatusAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int port, BidibStatus portStatus) {
        LOGGER.info("Switch the port: {}, portStatus: {}", (Object)port, (Object)portStatus);
        try {
            SwitchingNodeInterface selectedNode = node != null ? node : this.mainModel.getSelectedNode().getSwitchingNode();
            SwitchPortStatus switchPortStatus = (SwitchPortStatus)portStatus;
            SwitchPort switchPort = new SwitchPort();
            switchPort.setId(port);
            switchPort.setStatus((BidibStatus)switchPortStatus);
            this.switchingNodeService.setPortStatus("main", selectedNode, (Port)switchPort);
        }
        catch (Exception ex) {
            LOGGER.warn("Switch port failed.", (Throwable)ex);
        }
    }

    public void sendPortValueAction(SwitchingNodeInterface node, LcOutputType lcOutputType, int port, int value) {
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save backlight labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.switchPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.switchPortListPanel.refreshView());
        }
    }

    private void addSwitchPortModelListener(NodeInterface selectedNode) {
        LOGGER.info("Add switch port model listener for node: {}", (Object)selectedNode);
        Disposable disp = this.portConfigChangeEventSubject.subscribe(evt -> {
            LOGGER.info("Received event: {}", evt);
            PortTypeAware port = evt.getPort();
            try {
                SwitchPort switchPort = new SwitchPort();
                switchPort.setId(port.getPortNumber().intValue());
                LOGGER.info("Prepared switch port: {}", (Object)switchPort);
                this.switchingNodeService.setPortConfig("main", selectedNode.getSwitchingNode(), (Port)switchPort, null, evt.getPortConfig());
            }
            catch (Exception ex) {
                LOGGER.warn("Set the switchport config failed.", (Throwable)ex);
                selectedNode.setNodeHasError(true);
                selectedNode.setReasonData("Set the switchport config failed.");
            }
        });
        this.compDisp.add(disp);
    }
}

