/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.StyleModel;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.AccessoryAspect;
import org.bidib.wizard.api.model.AccessoryAspectMacro;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroRef;
import org.bidib.wizard.client.common.view.listener.ButtonListener;
import org.bidib.wizard.mvc.common.view.table.DefaultTextCellEditor;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.AccessoryPortListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoryTableModel
extends DefaultTableModel
implements ButtonListener,
StyleModel,
ContextSensitiveTableModel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessoryTableModel.class);
    public static final int COLUMN_LABEL = 0;
    public static final int COLUMN_MACRO_REF = 1;
    public static final int COLUMN_ACCESSORY_ASPECT_INSTANCE = 2;
    private static final String[] COLUMN_NAMES = new String[]{Resources.getString(AccessoryTableModel.class, (String)"aspect"), Resources.getString(AccessoryTableModel.class, (String)"macro"), Resources.getString(AccessoryTableModel.class, (String)"test")};
    private final Collection<AccessoryPortListener> portListeners = new LinkedList<AccessoryPortListener>();
    private final MainModel model;
    private Accessory selectedAccessory;
    private final CellStyle defaultCellStyle = new CellStyle();
    private final CellStyle activeAspectCellStyle = new CellStyle();

    public AccessoryTableModel(MainModel model) {
        this.model = model;
        this.defaultCellStyle.setForeground(UIManager.getColor("Table.foreground"));
        this.defaultCellStyle.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        this.activeAspectCellStyle.setForeground(UIManager.getColor("Aspect.green"));
        this.activeAspectCellStyle.setSelectionForeground(UIManager.getColor("Aspect.green"));
        this.setColumnIdentifiers(COLUMN_NAMES);
    }

    public void addPortListener(AccessoryPortListener l) {
        this.portListeners.add(l);
    }

    public void setSelectedAccessory(Accessory selectedAccessory) {
        this.selectedAccessory = selectedAccessory;
    }

    public Accessory getSelectedAccessory() {
        return this.selectedAccessory;
    }

    public void addRow(AccessoryAspect accessoryAspect) {
        if (accessoryAspect != null) {
            Object[] rowData = new Object[COLUMN_NAMES.length];
            rowData[0] = accessoryAspect.toString();
            if (accessoryAspect instanceof AccessoryAspectMacro) {
                rowData[1] = ((AccessoryAspectMacro)accessoryAspect).getMacroRef();
            }
            rowData[2] = accessoryAspect;
            LOGGER.info("Add new row: {}", rowData);
            this.addRow(rowData);
        }
    }

    private void fireTestButtonPressed(int aspectId) {
        for (AccessoryPortListener l : this.portListeners) {
            l.testButtonPressed(this.selectedAccessory.getId(), aspectId);
        }
    }

    private void fireAspectLabelChanged(int aspectIndex) {
        for (AccessoryPortListener l : this.portListeners) {
            l.labelChanged(this.selectedAccessory.getId(), aspectIndex);
        }
    }

    public AccessoryAspect getAccessoryAspectInstance(int row) {
        AccessoryAspect result = (AccessoryAspect)super.getValueAt(row, 2);
        return result;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return AccessoryAspect.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        boolean isEditable = false;
        switch (column) {
            case 1: {
                Accessory accessory = this.selectedAccessory;
                if (accessory == null || !(isEditable = accessory.isMacroMapped())) break;
                try {
                    AccessoryAspect accessoryAspect = this.getAccessoryAspectInstance(row);
                    if (!(accessoryAspect instanceof AccessoryAspectMacro)) break;
                    isEditable = !((AccessoryAspectMacro)accessoryAspect).isImmutableAccessory();
                    LOGGER.info("The current aspect is immutable: {}", (Object)(!isEditable ? 1 : 0));
                }
                catch (Exception ex) {
                    LOGGER.warn("Check if aspect is immutable failed.", (Throwable)ex);
                }
                break;
            }
            case 2: {
                isEditable = true;
                break;
            }
            default: {
                isEditable = true;
            }
        }
        return isEditable;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        LOGGER.info("setValueAt, row: {}, column: {}, value: {}", new Object[]{row, column, value});
        switch (column) {
            case 0: {
                String label = StringUtils.trimToNull((String)((String)value));
                AccessoryAspect accessoryAspect = this.getAccessoryAspectInstance(row);
                if (accessoryAspect != null) {
                    accessoryAspect.setLabel(label);
                }
                LOGGER.info("Set label value in model: {}", (Object)label);
                super.setValueAt(label, row, column);
                this.fireAspectLabelChanged(row);
                break;
            }
            case 1: {
                if (value instanceof Macro) {
                    int macroId = ((Macro)value).getId();
                    LOGGER.info("Set the macroId: {}", (Object)macroId);
                    this.model.getSelectedAccessory().replaceAspectMacro(row, macroId);
                    AccessoryAspect accessoryAspect = this.getAccessoryAspectInstance(row);
                    if (accessoryAspect instanceof AccessoryAspectMacro) {
                        MacroRef macroRef = ((AccessoryAspectMacro)accessoryAspect).getMacroRef();
                        macroRef.setId(Integer.valueOf(macroId));
                        super.setValueAt(macroRef, row, column);
                        break;
                    }
                    this.fireTableCellUpdated(row, column);
                    break;
                }
                LOGGER.warn("Current value is not a macro: {}", value);
                MacroRef macroRef = (MacroRef)value;
                if (macroRef.getId() != null) {
                    int macroId = macroRef.getId();
                    LOGGER.info("Set the macroId: {}", (Object)macroId);
                    this.model.getSelectedAccessory().replaceAspectMacro(row, macroId);
                }
                super.setValueAt(value, row, column);
                break;
            }
            case 2: {
                break;
            }
            default: {
                super.setValueAt(value, row, column);
            }
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object value = null;
        switch (column) {
            case 0: {
                AccessoryAspect accessoryAspect = (AccessoryAspect)super.getValueAt(row, 2);
                String label = null;
                if (accessoryAspect != null) {
                    label = accessoryAspect.getLabel();
                }
                value = label;
                break;
            }
            case 1: 
            case 2: {
                value = super.getValueAt(row, column);
            }
        }
        LOGGER.debug("getValueAt, row: {}, column: {}, value: {}", new Object[]{row, column, value});
        return value;
    }

    public void buttonPressed(int row, int column, Object value) {
        LOGGER.info("The button was pressed, row: {}, column: {}", (Object)row, (Object)column);
        if (column == 2) {
            this.fireTestButtonPressed(row);
        }
    }

    public CellStyle getCellStyleAt(int rowIndex, int columnIndex) {
        Integer activeAspect;
        if (columnIndex == 0 && this.selectedAccessory != null && (activeAspect = this.selectedAccessory.getAccessoryState().getActiveAspect()) != null && activeAspect == rowIndex) {
            return this.activeAspectCellStyle;
        }
        return this.defaultCellStyle;
    }

    public boolean isCellStyleOn() {
        return true;
    }

    public EditorContext getEditorContextAt(int row, int column) {
        if (column == 0) {
            return DefaultTextCellEditor.CONTEXT;
        }
        return null;
    }

    public Class<?> getCellClassAt(int row, int column) {
        return this.getColumnClass(column);
    }

    public ConverterContext getConverterContextAt(int row, int column) {
        return null;
    }
}

