/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.component;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.MultilineLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.dialog.EscapeDialog;

public class NodeErrorsDialog
extends EscapeDialog {
    private static final long serialVersionUID = 1L;
    private static final String ENCODED_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private static final String ENCODED_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref";
    private JTextArea loggerArea;
    private final JButton closeButton = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"close"));
    private final JButton cancelButton = new JButton(Resources.getString(((Object)((Object)this)).getClass(), (String)"cancel"));
    private static final String NEWLINE = "\n";
    private MultilineLabel descriptionLabel;
    private Icon errorIcon = UIManager.getDefaults().getIcon("OptionPane.errorIcon");
    private int closeOption = 2;

    public NodeErrorsDialog(Frame frame, String title, boolean modal) {
        super(frame, StringUtils.isNotBlank((CharSequence)title) ? title : Resources.getString(NodeErrorsDialog.class, (String)"title"), modal);
        FormBuilder builder = null;
        boolean debug = false;
        if (debug) {
            FormDebugPanel panel = new FormDebugPanel();
            builder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            builder = FormBuilder.create().columns(ENCODED_COLUMN_SPECS, new Object[0]).rows(ENCODED_ROW_SPECS, new Object[0]).panel(new JPanel());
        }
        builder.border((Border)Paddings.DIALOG);
        builder.add((Component)new JLabel(this.errorIcon)).xy(1, 1);
        this.descriptionLabel = new MultilineLabel();
        builder.add((Component)this.descriptionLabel).xy(3, 1);
        this.loggerArea = new JTextArea(20, 60);
        this.loggerArea.setFont(UIManager.getDefaults().getFont("Label.font"));
        this.loggerArea.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(this.loggerArea);
        this.loggerArea.setEditable(false);
        builder.add((Component)scrollPane).xyw(1, 3, 3);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeErrorsDialog.this.close();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeErrorsDialog.this.cancel();
            }
        });
        this.cancelButton.setEnabled(false);
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(new JComponent[]{this.closeButton, this.cancelButton}).build();
        builder.add((Component)buttons).xyw(1, 5, 3);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)builder.build(), "Center");
    }

    private void close() {
        this.closeOption = 0;
        this.setVisible(false);
        this.dispose();
    }

    private void cancel() {
        this.closeOption = 2;
        this.setVisible(false);
        this.dispose();
    }

    public void setErrors(String description, List<String> errors) {
        this.loggerArea.setText(null);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            this.descriptionLabel.setText(description);
        }
        for (String logLine : errors) {
            this.loggerArea.append(logLine + NEWLINE);
        }
        this.loggerArea.setCaretPosition(this.loggerArea.getDocument().getLength());
    }

    public void showDialog() {
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void setCancelEnabled(boolean enabled) {
        if (this.cancelButton != null) {
            this.cancelButton.setEnabled(enabled);
        }
    }

    public void setCloseButtonText(String closeButtonText) {
        if (this.closeButton != null) {
            this.closeButton.setText(closeButtonText);
        }
    }

    public int getCloseOption() {
        return this.closeOption;
    }
}

