/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.grid.CellStyle;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.AccessoryAspectMacro;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroRef;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractStatusEmptyTable;
import org.bidib.wizard.client.common.view.renderer.MacroRefRenderer;
import org.bidib.wizard.client.common.view.renderer.MacroRenderer;
import org.bidib.wizard.client.common.view.slider.SliderRenderer;
import org.bidib.wizard.model.status.AccessoryAspectStatus;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.mvc.main.model.AccessoryTableModel;
import org.bidib.wizard.mvc.main.view.table.ComboBoxEditor;
import org.bidib.wizard.mvc.main.view.table.ComboBoxRenderer;
import org.bidib.wizard.mvc.main.view.table.ComboBoxWithButtonEditor;
import org.bidib.wizard.mvc.main.view.table.ComboBoxWithButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectTable
extends AbstractStatusEmptyTable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AspectTable.class);
    private final NodeSelectionProvider nodeSelectionProvider;
    private final AccessoryTableModel tableModel;

    public AspectTable(AccessoryTableModel tableModel, String emptyTableString, NodeSelectionProvider mainModel) {
        super((TableModel)tableModel, emptyTableString);
        this.tableModel = tableModel;
        this.nodeSelectionProvider = mainModel;
    }

    public void adjustRowHeight() {
        SliderRenderer sliderEditor = new SliderRenderer(0, 255, 10);
        int rowHeight = sliderEditor.getTableCellRendererComponent((JTable)((Object)this), (Object)Integer.valueOf((int)1), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().height + 6;
        LOGGER.info("Set row height: {}", (Object)rowHeight);
        this.setRowHeight(rowHeight);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor result = super.getCellEditor(row, column);
        switch (column) {
            case 1: {
                NodeInterface node = this.nodeSelectionProvider.getSelectedNode();
                Macro[] macros = node.getMacros().toArray(new Macro[0]);
                MacroRef[] macroRefs = new MacroRef[macros.length];
                int index = 0;
                for (Macro macro : macros) {
                    macroRefs[index] = new MacroRef(Integer.valueOf(macro.getId()));
                    ++index;
                }
                JComboBox<MacroRef> comboboxMacroRef = new JComboBox<MacroRef>(macroRefs);
                comboboxMacroRef.setRenderer((ListCellRenderer<MacroRef>)new MacroRefRenderer(macros));
                result = new ComboBoxEditor<MacroRef>(comboboxMacroRef){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                        Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
                        if (value instanceof MacroRef) {
                            MacroRef macroRef = (MacroRef)value;
                            JComboBox combo = (JComboBox)this.editorComponent;
                            for (int index = 0; index < combo.getItemCount(); ++index) {
                                MacroRef macro = (MacroRef)combo.getItemAt(index);
                                if (macro.getId() != macroRef.getId()) continue;
                                combo.setSelectedItem(macro);
                                break;
                            }
                        } else {
                            LOGGER.debug("Current value is not a MacroRef: {}", value);
                        }
                        return comp;
                    }
                };
                LOGGER.info("Prepared the MacroRef editor.");
                break;
            }
            case 2: {
                ComboBoxWithButtonEditor editor = new ComboBoxWithButtonEditor(this.getActions((BidibStatus)AccessoryAspectStatus.START), ">");
                editor.addButtonListener(this.tableModel);
                result = editor;
                break;
            }
        }
        return result;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer result = null;
        switch (column) {
            case 0: {
                result = new AccessoryLabelRenderer();
                break;
            }
            case 1: {
                NodeInterface node = this.nodeSelectionProvider.getSelectedNode();
                ComboBoxRenderer<Macro> macroRenderer = new ComboBoxRenderer<Macro>(node.getMacros().toArray(new Macro[0])){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (value instanceof MacroRef) {
                            MacroRef macroRef = (MacroRef)value;
                            for (int index = 0; index < this.getItemCount(); ++index) {
                                Macro macro = (Macro)this.getItemAt(index);
                                if (macro.getId() != macroRef.getId().intValue()) continue;
                                this.setSelectedItem(macro);
                                break;
                            }
                        } else {
                            LOGGER.debug("Current value is not a MacroRef: {}", value);
                        }
                        comp.setEnabled(true);
                        Object val = table.getModel().getValueAt(row, 2);
                        if (val instanceof AccessoryAspectMacro) {
                            AccessoryAspectMacro accessory = (AccessoryAspectMacro)val;
                            comp.setEnabled(!accessory.isImmutableAccessory());
                        }
                        return comp;
                    }
                };
                macroRenderer.setRenderer((ListCellRenderer<Macro>)new MacroRenderer());
                result = macroRenderer;
                break;
            }
            case 2: {
                result = new ComboBoxWithButtonRenderer<BidibStatus>(this.getActions((BidibStatus)AccessoryAspectStatus.START), ">");
                break;
            }
            default: {
                result = super.getCellRenderer(row, column);
            }
        }
        return result;
    }

    protected void customizeEditorComponent(int row, int column, Component paramComponent, CellStyle cellStyle) {
        super.customizeEditorComponent(row, column, paramComponent, cellStyle);
        if (column == 0) {
            paramComponent.setForeground(cellStyle.getForeground());
            return;
        }
    }

    private static final class AccessoryLabelRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private AccessoryLabelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                String textValue = Resources.getString(AccessoryTableModel.class, (String)"aspect") + "_" + row;
                LOGGER.debug("Set the default value: {}", (Object)textValue);
                this.setText(textValue);
            }
            return comp;
        }
    }
}

