/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jidesoft.grid.TableColumnChooser;
import io.reactivex.rxjava3.subjects.Subject;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.LightPortListener;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.model.listener.PortTableLayoutListener;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.client.common.view.menu.listener.PortListMenuListener;
import org.bidib.wizard.client.common.view.renderer.DmxChannelRenderer;
import org.bidib.wizard.client.common.view.renderer.PortAwareNumberRenderer;
import org.bidib.wizard.client.common.view.slider.ConfigXAwareSliderRenderer;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.model.status.LightPortStatus;
import org.bidib.wizard.mvc.main.controller.LightPortPanelController;
import org.bidib.wizard.mvc.main.model.LightPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.LightPortModelListener;
import org.bidib.wizard.mvc.main.view.panel.SimpleHierarchicalPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabComponentCreator;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityProvider;
import org.bidib.wizard.mvc.main.view.table.LightPortTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightPortListPanel
extends SimpleHierarchicalPortListPanel<LightPortTableModel, LightPortStatus, LightPort, LightPortListener, LightPortModelListener>
implements PortTableLayoutListener,
TabVisibilityProvider,
TabPanelProvider,
TabComponentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LightPortListPanel.class);
    private static final long serialVersionUID = 1L;
    private final MainModel mainModel;
    private final TabVisibilityListener tabVisibilityListener;
    private final LightPortPanelController controller;
    private boolean isDmxNode = true;

    public LightPortListPanel(LightPortPanelController controller, LightPortTableModel tableModel, MainModel mainModel, TabVisibilityListener tabVisibilityListener, Subject<PortConfigChangeEvent> portConfigChangeEventSubject) {
        super(tableModel, Resources.getString(LightPortListPanel.class, (String)"emptyTable"), portConfigChangeEventSubject, mainModel);
        this.controller = controller;
        this.mainModel = mainModel;
        this.tabVisibilityListener = tabVisibilityListener;
    }

    @Override
    protected AbstractPortHierarchicalTable<LightPort> createPortTable(LightPortTableModel tableModel, String emptyTableText) {
        return new LightPortTable(tableModel, emptyTableText);
    }

    @Override
    protected void createTable(LightPortTableModel tableModel, String emptyTableText, Subject<PortConfigChangeEvent> portConfigChangeEventSubject, NodeSelectionProvider nodeSelectionProvider) {
        super.createTable(tableModel, emptyTableText, portConfigChangeEventSubject, nodeSelectionProvider);
        PortListMenuListener portListMenuListener = this.createPortListMenuListener(this.table, nodeSelectionProvider, () -> this.controller);
        this.table.setPortListMenuListener(portListMenuListener);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LOGGER.trace("Component is resized: {}", (Object)e.getComponent());
                LightPortListPanel.this.table.repaint();
            }
        });
        tableModel.addPortTableLayoutListener(this);
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public Object getCreator() {
        return this;
    }

    public boolean equals(Object other) {
        TabComponentCreator creator;
        return other instanceof TabComponentCreator && (creator = (TabComponentCreator)other).getCreator() instanceof LightPortListPanel;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    protected void processListChanged() {
        super.processListChanged();
        this.tabVisibilityListener.setTabVisible(this, this.isTabVisible());
        NodeInterface node = this.mainModel.getSelectedNode();
        this.portTableLayoutChanged(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void portTableLayoutChanged(NodeInterface node) {
        boolean hasPortIdentifiers = false;
        if (node != null && ProductUtils.isLightControl((long)node.getUniqueId())) {
            hasPortIdentifiers = true;
        }
        ArrayList<LightPort> ports = new ArrayList<LightPort>();
        ports.addAll(this.getPorts());
        if (!hasPortIdentifiers) {
            ArrayList<LightPort> arrayList = ports;
            synchronized (arrayList) {
                for (LightPort port : ports) {
                    if (!port.isRemappingEnabled()) continue;
                    hasPortIdentifiers = true;
                    break;
                }
            }
        }
        boolean hasColorValue = false;
        boolean hasTransitionTime = false;
        boolean hasDmxMapping = false;
        if (CollectionUtils.isNotEmpty(ports)) {
            for (LightPort lightPort : ports) {
                if (lightPort.getRgbValue() != null) {
                    hasColorValue = true;
                }
                if (lightPort.getTransitionTime() != null) {
                    hasTransitionTime = true;
                }
                if (lightPort.getDmxMapping() == null) continue;
                hasDmxMapping = true;
            }
            try {
                LightPort lightPort = (LightPort)ports.get(0);
                if (lightPort != null) {
                    int dimmStretchMin = lightPort.getDimStretchMin();
                    int dimmStretchMax = lightPort.getDimStretchMax();
                    LOGGER.info("Set the values for dimmStretchMin: {}, dimmStretchMax: {}", (Object)dimmStretchMin, (Object)dimmStretchMax);
                    ConfigXAwareSliderRenderer sliderRendererDimmMin = (ConfigXAwareSliderRenderer)this.table.getColumnModel().getColumn(3).getCellRenderer();
                    ConfigXAwareSliderRenderer sliderRendererDimmMax = (ConfigXAwareSliderRenderer)this.table.getColumnModel().getColumn(4).getCellRenderer();
                    sliderRendererDimmMin.setMaxValue(dimmStretchMin);
                    sliderRendererDimmMax.setMaxValue(dimmStretchMax);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Get the dimm stretch values failed.", (Throwable)ex);
            }
        }
        LOGGER.info("hasColorValue: {}, hasPortIdentifiers: {}, hasTransitionTime: {}, hasDmxMapping: {}", new Object[]{hasColorValue, hasPortIdentifiers, hasTransitionTime, hasDmxMapping});
        int viewColumnIndex = 5;
        viewColumnIndex = this.table.setColumnVisible(5, viewColumnIndex, hasColorValue);
        viewColumnIndex = this.table.setColumnVisible(6, viewColumnIndex, hasTransitionTime);
        viewColumnIndex = this.table.setColumnVisible(7, viewColumnIndex, hasDmxMapping);
        this.table.setColumnVisible(8, viewColumnIndex, hasPortIdentifiers);
        if (TableColumnChooser.isVisibleColumn((JTable)this.table, (int)7)) {
            LOGGER.info("The DMX column is visible for node: {}", (Object)node);
            if (node != null) {
                boolean newNodeIsDmxNode = ProductUtils.isOneDMX((long)node.getUniqueId());
                if (newNodeIsDmxNode != this.isDmxNode) {
                    LOGGER.info("The DMX support of node has changed, newNodeIsDmxNode: {}", (Object)newNodeIsDmxNode);
                    this.isDmxNode = newNodeIsDmxNode;
                    TableColumn tcDmxMapping = this.table.getColumnModel().getColumn(7);
                    if (newNodeIsDmxNode) {
                        tcDmxMapping.setCellRenderer((TableCellRenderer)new DmxChannelRenderer());
                        tcDmxMapping.setHeaderValue(Resources.getString(LightPortTableModel.class, (String)"dmxMapping"));
                    } else {
                        tcDmxMapping.setCellRenderer((TableCellRenderer)new PortAwareNumberRenderer());
                        tcDmxMapping.setHeaderValue(Resources.getString(LightPortTableModel.class, (String)"channel"));
                    }
                    JTableHeader th = this.table.getTableHeader();
                    th.repaint();
                } else {
                    LOGGER.info("The DMX column is visible but the isDmxNode property has not changed: {}", (Object)this.isDmxNode);
                }
            }
        } else {
            LOGGER.info("The DMX column is not visible.");
        }
    }

    public Class<?> getPortClass() {
        return LightPort.class;
    }

    @Override
    public boolean isTabVisible() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            boolean isTabVisible = node.hasLightPorts();
            LOGGER.debug("Check if tab is visible: {}", (Object)isTabVisible);
            return isTabVisible;
        }
        return false;
    }

    @Override
    protected List<LightPort> getPorts() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            return node.getLightPorts();
        }
        return Collections.emptyList();
    }

    public void refreshView() {
        this.listChanged();
    }
}

