/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.bidib.wizard.client.common.view.listener.ButtonListener;

public class ComboBoxWithButtonEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private final Collection<ButtonListener> buttonListeners = new LinkedList<ButtonListener>();
    private final JPanel panel = new JPanel();
    private final JComboBox<Object> comboBox;
    private final JButton button;
    private int row = 0;
    private int column = 0;

    public ComboBoxWithButtonEditor(Object[] items, String buttonText) {
        this.comboBox = new JComboBox<Object>((Object[])items.clone());
        this.button = new JButton(buttonText);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBoxWithButtonEditor.this.fireEditingStopped();
                ComboBoxWithButtonEditor.this.fireButtonPressed();
            }
        });
        this.panel.setLayout(new GridBagLayout());
        this.panel.setFocusCycleRoot(true);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 2, 2);
        c.weightx = 1.0;
        this.panel.add(this.comboBox, c);
        c.anchor = 24;
        ++c.gridx;
        c.weightx = 0.0;
        this.panel.add((Component)this.button, c);
    }

    public void addButtonListener(ButtonListener l) {
        this.buttonListeners.add(l);
    }

    private void fireButtonPressed() {
        for (ButtonListener l : this.buttonListeners) {
            l.buttonPressed(this.row, this.column, this.getCellEditorValue());
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.comboBox.getSelectedItem();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.row = row;
        this.column = column;
        if (isSelected) {
            this.panel.setForeground(table.getSelectionForeground());
            this.panel.setBackground(table.getSelectionBackground());
        } else {
            this.panel.setForeground(table.getForeground());
            this.panel.setBackground(table.getBackground());
        }
        this.comboBox.setSelectedItem(value);
        return this.panel;
    }
}

