/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pt.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.mvc.common.view.panel.DisabledPanel;
import org.bidib.wizard.mvc.pt.model.PtMode;
import org.bidib.wizard.mvc.pt.model.PtProgrammerModel;
import org.bidib.wizard.mvc.pt.view.panel.DirectAccessProgBeanModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvWritePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CvWritePanel.class);
    private final JCheckBox[] checkBitValues = new JCheckBox[8];
    private final JRadioButton[] radioBitValues = new JRadioButton[8];
    private JPanel byteValuePanel;
    private JPanel bitValuePanel;
    private final PtProgrammerModel programmerModel;
    private final DirectAccessProgBeanModel cvModel;
    private CardLayout cardLayout;
    private boolean lockUpdate;
    private JPanel panel;
    private static final String ENCODED_COLUMN_SPECS_BYTE = "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 0:grow";
    private static final String ENCODED_ROW_SPECS_BYTE = "p";
    private static final String ENCODED_COLUMN_SPECS_BIT = "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 0:grow";
    private static final String ENCODED_ROW_SPECS_BIT = "p";

    public CvWritePanel(PtProgrammerModel model, DirectAccessProgBeanModel cvModel) {
        this.programmerModel = model;
        this.cvModel = cvModel;
    }

    public JPanel createPanel() {
        this.panel = new JPanel();
        this.panel.setOpaque(false);
        this.cardLayout = new CardLayout();
        this.panel.setLayout(this.cardLayout);
        this.panel.add((Component)this.prepareByteValuePanel(), "byte");
        this.panel.add((Component)this.prepareBitValuePanel(), "bit");
        this.cvModel.addPropertyChangeListener("mode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.debug("Operation has changed: {}", (Object)CvWritePanel.this.cvModel.getMode());
                switch (CvWritePanel.this.cvModel.getMode()) {
                    case BIT: {
                        CvWritePanel.this.programmerModel.clearCvValue();
                        CvWritePanel.this.cardLayout.show(CvWritePanel.this.panel, "bit");
                        CvWritePanel.this.radioBitValues[0].setSelected(true);
                        break;
                    }
                    default: {
                        CvWritePanel.this.programmerModel.clearCvValue();
                        CvWritePanel.this.cardLayout.show(CvWritePanel.this.panel, "byte");
                    }
                }
            }
        });
        return this.panel;
    }

    private JPanel prepareByteValuePanel() {
        FormBuilder pbuilder = FormBuilder.create().columns("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 0:grow", new Object[0]).rows("p", new Object[0]).panel(new JPanel());
        int column = 1;
        for (int bit = 7; bit >= 0; --bit) {
            this.checkBitValues[bit] = new JCheckBox(String.valueOf(bit), false);
            this.checkBitValues[bit].setContentAreaFilled(false);
            this.checkBitValues[bit].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (PtMode.BIT.equals((Object)CvWritePanel.this.cvModel.getMode())) {
                        return;
                    }
                    if (CvWritePanel.this.lockUpdate) {
                        LOGGER.info("The item state has changed but lockUpdate is set.");
                        return;
                    }
                    StringBuilder bitValue = new StringBuilder();
                    for (int bit = CvWritePanel.this.checkBitValues.length - 1; bit >= 0; --bit) {
                        bitValue.append(CvWritePanel.this.checkBitValues[bit].isSelected() ? (char)'1' : '0');
                    }
                    LOGGER.info("Prepared byte value: {}", (Object)bitValue);
                    try {
                        CvWritePanel.this.cvModel.setCvValue(Integer.parseInt(bitValue.toString(), 2));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Set CV value failed.", (Throwable)ex);
                    }
                }
            });
            pbuilder.add((Component)this.checkBitValues[bit]).xy(column, 1);
            column += 2;
        }
        this.byteValuePanel = pbuilder.getPanel();
        return this.byteValuePanel;
    }

    private JPanel prepareBitValuePanel() {
        FormBuilder pbuilder = FormBuilder.create().columns("p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 0:grow", new Object[0]).rows("p", new Object[0]).panel(new JPanel());
        ButtonGroup group = new ButtonGroup();
        int column = 1;
        for (int bit = 7; bit >= 0; --bit) {
            this.radioBitValues[bit] = new JRadioButton(String.valueOf(bit), false);
            this.radioBitValues[bit].setContentAreaFilled(false);
            group.add(this.radioBitValues[bit]);
            pbuilder.add((Component)this.radioBitValues[bit]).xy(column, 1);
            column += 2;
        }
        this.bitValuePanel = pbuilder.getPanel();
        return this.bitValuePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByteValue(Object cvValue) {
        LOGGER.info("Update the byte value: {}", cvValue);
        if (cvValue == null) {
            cvValue = "0";
        }
        try {
            String bitValue = Integer.toBinaryString(Integer.parseInt(cvValue.toString()));
            this.lockUpdate = true;
            for (int index = 0; index < this.checkBitValues.length; ++index) {
                if (index < bitValue.length()) {
                    this.checkBitValues[index].setSelected(bitValue.charAt(bitValue.length() - index - 1) == '1');
                    continue;
                }
                this.checkBitValues[index].setSelected(false);
            }
        }
        catch (NumberFormatException ex) {
            for (int index = 0; index < this.checkBitValues.length; ++index) {
                this.checkBitValues[index].setSelected(false);
            }
        }
        finally {
            this.lockUpdate = false;
        }
    }

    public int getSelectedBit() {
        byte val = 0;
        for (int bit = this.radioBitValues.length - 1; bit >= 0; --bit) {
            if (!this.radioBitValues[bit].isSelected()) continue;
            val = (byte)bit;
            break;
        }
        LOGGER.info("Prepared bitValue: {}", (Object)ByteUtils.byteToHex((byte)val));
        return ByteUtils.getInt((byte)val);
    }

    public void setEnabled(boolean enabled) {
        this.panel.setEnabled(enabled);
        if (enabled) {
            DisabledPanel.enable(this.bitValuePanel);
            DisabledPanel.enable(this.byteValuePanel);
        } else {
            DisabledPanel.disable(this.bitValuePanel);
            DisabledPanel.disable(this.byteValuePanel);
        }
    }
}

