package org.bidib.wizard.mvc.main.view.statusbar;

import java.awt.Component;

import javax.swing.LookAndFeel;

import com.jidesoft.status.StatusBar;
import com.jidesoft.status.StatusBarItem;
import com.jidesoft.swing.JideSwingUtilities;

public class WizardStatusBar extends StatusBar {

    private static final long serialVersionUID = 1L;

    @Override
    public void add(Component comp, Object constraints, int index) {
        super.add(comp, constraints, index);

        if (!(comp instanceof StatusBarItem)) {
            return;
        }

        StatusBarItem statusBarItem = (StatusBarItem) comp;
        if (!this.isChildrenOpaque()) {
            JideSwingUtilities.setOpaqueRecursively(statusBarItem, false);
        }

        LookAndFeel.installBorder(statusBarItem, "StatusBarItem.border");
    }

}
