package org.bidib.wizard.utils;

import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileUtilsTest {

    @Test
    public void isPathValidTest() {

        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertThat(FileUtils.isPathValid("Test|Name.txt")).isFalse();
        }

        Assertions.assertThat(FileUtils.isPathValid("TestName.txt")).isTrue();
    }

    @Test
    public void isFilenameValidTest() {
        Assertions.assertThat(FileUtils.isFilenameValid("TestName.txt")).isTrue();
        Assertions.assertThat(FileUtils.isFilenameValid("Test+Name.txt")).isTrue();
        Assertions.assertThat(FileUtils.isFilenameValid("Test4Name.txt")).isTrue();

        Assertions.assertThat(FileUtils.isFilenameValid("[1]TestName.txt")).isFalse();
        Assertions.assertThat(FileUtils.isFilenameValid("Test/Name")).isFalse();
        Assertions.assertThat(FileUtils.isFilenameValid("Test\\Name")).isFalse();
    }

    @Test
    public void escapeInvalidFilenameCharactersTest() {

        Assertions
            .assertThat(FileUtils.escapeInvalidFilenameCharacters("Test_Name.txt", "_")).isEqualTo("Test_Name.txt");

        Assertions
            .assertThat(FileUtils.escapeInvalidFilenameCharacters("Test|Name.txt", "_")).isEqualTo("Test_Name.txt");

        Assertions.assertThat(FileUtils.escapeInvalidFilenameCharacters("TestName.txt", "_")).isEqualTo("TestName.txt");

        Assertions
            .assertThat(FileUtils.escapeInvalidFilenameCharacters("Test/Name.txt", "_")).isEqualTo("Test_Name.txt");

        Assertions
            .assertThat(FileUtils.escapeInvalidFilenameCharacters("Test\\Name.txt", "_")).isEqualTo("Test_Name.txt");

        Assertions
            .assertThat(FileUtils.escapeInvalidFilenameCharacters("[1]Test_Name.txt", "_"))
            .isEqualTo("_1_Test_Name.txt");

    }
}
