/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.backup.model;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.statusbar.StatusBarPublisher;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.mvc.backup.model.NodeBackupModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupTableModel
extends Model {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BackupTableModel.class);
    public static final String PROPERTY_NODES = "nodes";
    public static final String PROPERTY_BACKUP_DIRECTORY = "backupDirectory";
    public static final String PROPERTY_BACKUP_ENABLED = "backupEnabled";
    private ArrayListModel<NodeBackupModel> nodeBackupList = new ArrayListModel();
    private File backupDirectory;
    private final PropertyChangeListener pcs = evt -> {
        switch (evt.getPropertyName()) {
            case "progress": {
                LOGGER.info("The progress has changed: {}, source: {}", evt.getNewValue(), evt.getSource());
                this.fireProgressChanged((NodeBackupModel)((Object)((Object)evt.getSource())));
                break;
            }
        }
    };

    public BackupTableModel(StatusBarPublisher<String, Integer> publisher) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProgressChanged(NodeBackupModel source) {
        int fireChangeIndex = -1;
        ArrayListModel<NodeBackupModel> arrayListModel = this.nodeBackupList;
        synchronized (arrayListModel) {
            for (NodeBackupModel nodeBackup : this.nodeBackupList) {
                int index;
                if (nodeBackup.getNode().getUniqueId() != source.getNode().getUniqueId()) continue;
                LOGGER.trace("Found nodeBackup to update: {}", (Object)nodeBackup);
                fireChangeIndex = index = this.nodeBackupList.indexOf((Object)nodeBackup);
                break;
            }
        }
        if (fireChangeIndex > -1) {
            this.nodeBackupList.fireContentsChanged(fireChangeIndex);
        }
    }

    public void addNode(NodeInterface node, WizardLabelWrapper wizardLabelWrapper) {
        SwingUtilities.invokeLater(() -> {
            ArrayListModel<NodeBackupModel> arrayListModel = this.nodeBackupList;
            synchronized (arrayListModel) {
                NodeBackupModel nodeBackup = new NodeBackupModel(node, wizardLabelWrapper);
                if (!this.nodeBackupList.contains((Object)nodeBackup)) {
                    LOGGER.info("Add nodeBackup to nodeBackup list: {}", (Object)node);
                    nodeBackup.addPropertyChangeListener(this.pcs);
                    this.nodeBackupList.add((Object)nodeBackup);
                }
            }
        });
    }

    public void removeNode(NodeInterface node) {
        SwingUtilities.invokeLater(() -> {
            ArrayListModel<NodeBackupModel> arrayListModel = this.nodeBackupList;
            synchronized (arrayListModel) {
                LOGGER.info("Remove node from nodeBackup list: {}", (Object)node);
                LinkedList<NodeBackupModel> oldValue = new LinkedList<NodeBackupModel>((Collection<NodeBackupModel>)this.nodeBackupList);
                int index = this.nodeBackupList.indexOf((Object)new NodeBackupModel(node, null));
                if (index > -1) {
                    NodeBackupModel removed = (NodeBackupModel)((Object)((Object)this.nodeBackupList.remove(index)));
                    if (removed != null) {
                        LOGGER.info("Removed node: {}", (Object)node);
                        removed.removePropertyChangeListener(this.pcs);
                    }
                    this.firePropertyChange(PROPERTY_NODES, oldValue, this.nodeBackupList);
                }
            }
        });
    }

    public ArrayListModel<NodeBackupModel> getNodeBackupListModel() {
        return this.nodeBackupList;
    }

    public List<NodeBackupModel> getNodes() {
        return Collections.unmodifiableList(this.nodeBackupList);
    }

    public File getBackupDirectory() {
        return this.backupDirectory;
    }

    public void setBackupDirectory(File backupDirectory) {
        File oldValue = this.backupDirectory;
        boolean oldBackupEnabled = this.isBackupEnabled();
        this.backupDirectory = backupDirectory;
        this.firePropertyChange(PROPERTY_BACKUP_DIRECTORY, oldValue, this.backupDirectory);
        this.firePropertyChange(PROPERTY_BACKUP_ENABLED, oldBackupEnabled, this.isBackupEnabled());
    }

    public boolean isBackupEnabled() {
        return this.backupDirectory != null && this.backupDirectory.exists();
    }
}

