/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.booster.model;

import com.jgoodies.binding.beans.Model;
import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.CurrentValue;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.event.NodeStatusEvent;
import org.bidib.wizard.client.common.uils.SwingUtils;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.model.status.BoosterStatus;
import org.bidib.wizard.model.status.CommandStationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterModel
extends Model {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterModel.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_BOOSTER_STATUS = "boosterStatus";
    public static final String PROPERTY_COMMANDSTATION_STATUS = "commandStationState";
    public static final String PROPERTY_BOOSTER_CURRENT = "boosterCurrent";
    public static final String PROPERTY_BOOSTER_VOLTAGE = "boosterVoltage";
    public static final String PROPERTY_BOOSTER_TEMPERATURE = "boosterTemperature";
    public static final String PROPERTY_BOOSTER_LABEL = "nodeLabel";
    private final NodeInterface booster;
    private final String uniqueId;
    private BoosterState state;
    private CommandStationState commandStationState;
    private CurrentValue current;
    private Integer voltage;
    private Integer temperature;
    private String nodeLabel;
    private long lastCurrentUpdate;
    private PropertyChangeListener propertyChangeListener;
    private final NodeLabels nodeLabels;
    private final PropertyChangeListener boosterListener;

    public BoosterModel(NodeInterface booster, WizardLabelWrapper wizardLabelWrapper, PropertyChangeListener boosterListener) {
        this.booster = booster;
        this.boosterListener = boosterListener;
        this.uniqueId = ByteUtils.getUniqueIdAsString((long)booster.getUniqueId());
        this.nodeLabels = wizardLabelWrapper != null ? wizardLabelWrapper.getWizardLabelFactory().loadLabels(Long.valueOf(booster.getUniqueId()), new String[0]) : null;
        LOGGER.debug("Create new BoosterModel for booster: {}", (Object)booster);
    }

    public void registerNode() {
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LOGGER.trace("Property has changed, name: {}, value: {}", (Object)evt.getPropertyName(), evt.getNewValue());
                switch (evt.getPropertyName()) {
                    case "userName": {
                        String nodeLabel = BoosterModel.this.prepareNodeLabel();
                        BoosterModel.this.setNodeLabel(nodeLabel);
                        PropertyChangeEvent evt1 = new PropertyChangeEvent((Object)BoosterModel.this, BoosterModel.PROPERTY_BOOSTER_LABEL, null, nodeLabel);
                        BoosterModel.this.boosterListener.propertyChange(evt1);
                        break;
                    }
                    case "features": {
                        LOGGER.info("The features of the node have changed.");
                        if (evt instanceof IndexedPropertyChangeEvent) {
                            IndexedPropertyChangeEvent indexedPropertyChangeEvent = (IndexedPropertyChangeEvent)evt;
                            if (FeatureEnum.FEATURE_BST_AMPERE.getNumber() != indexedPropertyChangeEvent.getIndex()) break;
                            SwingUtils.executeInEDT(() -> BoosterModel.this.fetchMaxBoosterCurrent());
                            break;
                        }
                        SwingUtils.executeInEDT(() -> BoosterModel.this.fetchMaxBoosterCurrent());
                        break;
                    }
                    case "nodeLoadStatus": {
                        LOGGER.info("The initial load of the booster node has finished or partially finished. Fetch the max booster current from the features and the booster state for node: {}", (Object)BoosterModel.this.booster);
                        if (BoosterModel.this.booster == null || NodeStatusEvent.StatusIdentifier.InitialLoadPending == BoosterModel.this.booster.getNodeLoadStatusIdentifier()) break;
                        SwingUtils.executeInEDT(() -> BoosterModel.this.fetchBoosterState());
                        break;
                    }
                }
            }
        };
        LOGGER.info("Add property change listener for booster: {}", (Object)this.booster);
        this.booster.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void freeNode() {
        LOGGER.info("Remove property change listener for booster: {}", (Object)this.booster);
        this.booster.removePropertyChangeListener(this.propertyChangeListener);
    }

    public NodeInterface getBooster() {
        return this.booster;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public byte[] getNodeAddress() {
        return this.booster.getNode().getAddr();
    }

    public void setNodeLabel(String nodeLabel) {
        String oldValue = this.nodeLabel;
        this.nodeLabel = nodeLabel;
        this.firePropertyChange(PROPERTY_BOOSTER_LABEL, oldValue, this.nodeLabel);
    }

    public String getNodeLabel() {
        BidibNodeNameUtils.NodeLabelData labelData = BidibNodeNameUtils.prepareLabel((NodeInterface)this.booster, (NodeLabels)this.nodeLabels, (boolean)false, (boolean)true);
        String userName = labelData.getNodeLabel();
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            return userName;
        }
        return this.nodeLabel;
    }

    private void fetchBoosterState() {
        LOGGER.info("Fetch the booster state for booster: {}", (Object)this.booster);
        this.fetchMaxBoosterCurrent();
        try {
            if (NodeUtils.hasBoosterFunctions((long)this.booster.getUniqueId()) && this.booster.getBoosterNode() != null) {
                BoosterStatus boosterStatus = this.booster.getBoosterNode().getBoosterStatus();
                LOGGER.info("Update the booster status: {}", (Object)boosterStatus);
                this.setState(boosterStatus != null ? boosterStatus.getBoosterState() : null);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get booster state of node failed.", (Throwable)ex);
        }
        try {
            if (NodeUtils.hasCommandStationFunctions((long)this.booster.getUniqueId()) && this.booster.getCommandStationNode() != null) {
                CommandStationStatus csStatus = this.booster.getCommandStationNode().getCommandStationStatus();
                LOGGER.info("Update the command station state: {}", (Object)csStatus);
                this.setCommandStationState(csStatus != null ? csStatus.getCommandStationState() : null);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get comamndStation state of node failed.", (Throwable)ex);
        }
    }

    protected void fetchMaxBoosterCurrent() {
        try {
            if (this.booster.getBoosterNode() != null) {
                this.booster.getBoosterNode().fetchMaxBoosterCurrent();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Get FEATURE_BST_AMPERE from node failed.", (Throwable)ex);
        }
    }

    public BoosterState getState() {
        return this.state;
    }

    public void setState(BoosterState state) {
        BoosterState oldValue = this.state;
        this.state = state;
        this.firePropertyChange(PROPERTY_BOOSTER_STATUS, oldValue, this.state);
    }

    public CommandStationState getCommandStationState() {
        return this.commandStationState;
    }

    public void setCommandStationState(CommandStationState commandStationState) {
        CommandStationState oldValue = this.commandStationState;
        this.commandStationState = commandStationState;
        this.firePropertyChange(PROPERTY_COMMANDSTATION_STATUS, oldValue, this.commandStationState);
    }

    public BoosterControl getBoosterControl() {
        if (NodeUtils.hasAccessoryFunctions((long)this.booster.getUniqueId()) && this.booster.getBoosterNode() != null) {
            return this.booster.getBoosterNode().getBoosterControl();
        }
        return null;
    }

    public Integer getMaxCurrent() {
        if (this.booster.getBoosterNode() != null) {
            return this.booster.getBoosterNode().getBoosterMaximumCurrent();
        }
        return null;
    }

    public CurrentValue getCurrent() {
        return this.current;
    }

    public void setCurrent(CurrentValue current) {
        CurrentValue oldValue = this.current;
        this.current = current;
        this.setLastCurrentUpdate(System.currentTimeMillis());
        this.firePropertyChange(PROPERTY_BOOSTER_CURRENT, oldValue, this.current);
    }

    public long getLastCurrentUpdate() {
        return this.lastCurrentUpdate;
    }

    public void setLastCurrentUpdate(long lastCurrentUpdate) {
        this.lastCurrentUpdate = lastCurrentUpdate;
    }

    public Integer getVoltage() {
        return this.voltage;
    }

    public void setVoltage(Integer voltage) {
        Integer oldValue = this.voltage;
        this.voltage = voltage;
        this.firePropertyChange(PROPERTY_BOOSTER_VOLTAGE, oldValue, this.voltage);
    }

    public Integer getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Integer temperature) {
        Integer oldValue = this.temperature;
        this.temperature = temperature;
        this.firePropertyChange(PROPERTY_BOOSTER_TEMPERATURE, oldValue, this.temperature);
    }

    public boolean equals(Object obj) {
        BoosterModel other;
        return obj instanceof BoosterModel && this.booster.equals((Object)(other = (BoosterModel)((Object)obj)).getBooster());
    }

    public int hashCode() {
        return this.booster.hashCode();
    }

    public String prepareNodeLabel() {
        String productString;
        String nodeLabel = this.booster.getLabel();
        if (StringUtils.isBlank((CharSequence)nodeLabel) && StringUtils.isNotBlank((CharSequence)(productString = this.booster.getNode().getStoredString(0)))) {
            nodeLabel = productString;
        }
        return nodeLabel;
    }
}

