/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.booster.view;

import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.utils.ImageUtils;

public class BoosterControlCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private Map<BoosterControl, ImageIcon> boosterControlIcons = new LinkedHashMap<BoosterControl, ImageIcon>();
    private Map<BoosterControl, String> boosterControlToolTips;

    public BoosterControlCellRenderer() {
        this.boosterControlIcons.put(BoosterControl.CONNECT, ImageUtils.createImageIcon(BoosterControlCellRenderer.class, (String)UIManager.getString("BoosterControl.connect.icon.name"), (int)16, (int)16));
        this.boosterControlIcons.put(BoosterControl.LOCAL, ImageUtils.createImageIcon(BoosterControlCellRenderer.class, (String)UIManager.getString("BoosterControl.local.icon.name"), (int)16, (int)16));
        this.boosterControlToolTips = new LinkedHashMap<BoosterControl, String>();
        this.boosterControlToolTips.put(BoosterControl.CONNECT, Resources.getString(BoosterControl.class, (String)"connect.tooltip"));
        this.boosterControlToolTips.put(BoosterControl.LOCAL, Resources.getString(BoosterControl.class, (String)"local.tooltip"));
        this.setHorizontalAlignment(10);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
        if (value instanceof BoosterControl) {
            BoosterControl boosterControl = (BoosterControl)value;
            Icon icon = this.boosterControlIcons.get(boosterControl);
            this.setIcon(icon);
            this.setToolTipText(this.boosterControlToolTips.get(boosterControl));
        } else {
            this.setIcon(null);
            this.setToolTipText(null);
        }
        return this;
    }
}

