/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.wizard;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.common.view.wizard.CancelAction;
import org.bidib.wizard.mvc.common.view.wizard.FinishAction;
import org.bidib.wizard.mvc.common.view.wizard.JWizardComponents;
import org.bidib.wizard.mvc.common.view.wizard.JWizardPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJWizardComponents
implements JWizardComponents {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJWizardComponents.class);
    private JButton backButton;
    private JButton nextButton;
    private JButton finishButton;
    private JButton cancelButton;
    private FinishAction finishAction;
    private CancelAction cancelAction;
    private List<JWizardPanel> panelList;
    private int currentIndex;
    private JPanel wizardPanelsContainer;
    private PropertyChangeSupport propertyChangeListeners;

    public DefaultJWizardComponents() {
        try {
            this.init();
        }
        catch (Exception e) {
            LOGGER.warn("Init wizard components failed.", (Throwable)e);
        }
    }

    @Override
    public void addWizardPanel(JWizardPanel panel) {
        panel.initPanel();
        this.getWizardPanelList().add(panel);
        this.wizardPanelsContainer.add((Component)panel.getPanel(), Integer.toString(this.getWizardPanelList().size() - 1));
    }

    @Override
    public void addWizardPanel(int index, JWizardPanel panel) {
        this.getWizardPanelList().add(index, panel);
        this.wizardPanelsContainer.add(panel.getPanel(), "" + index, index);
        if (index < this.getWizardPanelList().size() - 1) {
            for (int i = index + 1; i < this.getWizardPanelList().size(); ++i) {
                this.wizardPanelsContainer.add((Component)this.getWizardPanelList().get(i).getPanel(), Integer.toString(i));
            }
        }
    }

    @Override
    public void addWizardPanelAfter(JWizardPanel panelToBePlacedAfter, JWizardPanel panel) {
        this.addWizardPanel(this.getWizardPanelList().indexOf(panelToBePlacedAfter) + 1, panel);
    }

    @Override
    public void addWizardPanelBefore(JWizardPanel panelToBePlacedBefore, JWizardPanel panel) {
        this.addWizardPanel(this.getWizardPanelList().indexOf(panelToBePlacedBefore) - 1, panel);
    }

    @Override
    public void addWizardPanelAfterCurrent(JWizardPanel panel) {
        this.addWizardPanel(this.getCurrentIndex() + 1, panel);
    }

    @Override
    public JWizardPanel removeWizardPanel(JWizardPanel panel) {
        int index = this.getWizardPanelList().indexOf(panel);
        this.getWizardPanelList().remove(panel);
        this.wizardPanelsContainer.remove(panel.getPanel());
        for (int i = index; i < this.getWizardPanelList().size(); ++i) {
            this.wizardPanelsContainer.add((Component)this.getWizardPanelList().get(i).getPanel(), Integer.toString(i));
        }
        return panel;
    }

    @Override
    public JWizardPanel removeWizardPanel(int index) {
        this.wizardPanelsContainer.remove(index);
        JWizardPanel panel = this.getWizardPanelList().remove(index);
        for (int i = index; i < this.getWizardPanelList().size(); ++i) {
            this.wizardPanelsContainer.add((Component)this.getWizardPanelList().get(i).getPanel(), Integer.toString(i));
        }
        return panel;
    }

    @Override
    public JWizardPanel removeWizardPanelAfter(JWizardPanel panel) {
        return this.removeWizardPanel(this.getWizardPanelList().indexOf(panel) + 1);
    }

    @Override
    public JWizardPanel removeWizardPanelBefore(JWizardPanel panel) {
        return this.removeWizardPanel(this.getWizardPanelList().indexOf(panel) - 1);
    }

    @Override
    public JWizardPanel getWizardPanel(int index) {
        return this.getWizardPanelList().get(index);
    }

    @Override
    public int getIndexOfPanel(JWizardPanel panel) {
        return this.getWizardPanelList().indexOf(panel);
    }

    @Override
    public boolean onLastPanel() {
        return this.getCurrentIndex() == this.getWizardPanelList().size() - 1;
    }

    private void init() throws Exception {
        this.propertyChangeListeners = new PropertyChangeSupport(this);
        this.backButton = new JButton();
        this.nextButton = new JButton();
        this.finishButton = new JButton();
        this.cancelButton = new JButton();
        this.panelList = new ArrayList<JWizardPanel>();
        this.currentIndex = 0;
        this.wizardPanelsContainer = new JPanel();
        this.backButton.setText(Resources.getString(this.getClass(), (String)"L_BackButton"));
        this.backButton.setMnemonic(Resources.getString(this.getClass(), (String)"L_BackButtonMnem").charAt(0));
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJWizardComponents.this.backButton_actionPerformed(e);
            }
        });
        this.nextButton.setText(Resources.getString(this.getClass(), (String)"L_NextButton"));
        this.nextButton.setMnemonic(Resources.getString(this.getClass(), (String)"L_NextButtonMnem").charAt(0));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJWizardComponents.this.nextButton_actionPerformed(e);
            }
        });
        this.cancelButton.setText(Resources.getString(this.getClass(), (String)"L_CancelButton"));
        this.cancelButton.setMnemonic(Resources.getString(this.getClass(), (String)"L_CancelButtonMnem").charAt(0));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJWizardComponents.this.cancelButton_actionPerformed(e);
            }
        });
        this.finishButton.setText(Resources.getString(this.getClass(), (String)"L_FinishButton"));
        this.finishButton.setMnemonic(Resources.getString(this.getClass(), (String)"L_FinishButtonMnem").charAt(0));
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultJWizardComponents.this.finishButton_actionPerformed(e);
            }
        });
        this.wizardPanelsContainer.setLayout(new CardLayout());
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this.getCancelAction().performAction();
    }

    void finishButton_actionPerformed(ActionEvent e) {
        this.getFinishAction().performAction();
    }

    void nextButton_actionPerformed(ActionEvent e) {
        try {
            this.getCurrentPanel().next();
        }
        catch (Exception ex) {
            LOGGER.warn("Switch to next panel failed.", (Throwable)ex);
        }
    }

    void backButton_actionPerformed(ActionEvent e) {
        try {
            this.getCurrentPanel().back();
        }
        catch (Exception ex) {
            LOGGER.warn("Switch to previous panel failed.", (Throwable)ex);
        }
    }

    @Override
    public JWizardPanel getCurrentPanel() throws Exception {
        if (this.getWizardPanelList().get(this.currentIndex) != null) {
            return this.getWizardPanelList().get(this.currentIndex);
        }
        throw new Exception("No panels in panelList");
    }

    @Override
    public void updateComponents() {
        try {
            CardLayout cl = (CardLayout)this.wizardPanelsContainer.getLayout();
            cl.show(this.wizardPanelsContainer, "" + this.currentIndex);
            if (this.currentIndex == 0) {
                this.backButton.setEnabled(false);
            } else {
                this.backButton.setEnabled(true);
            }
            if (this.onLastPanel()) {
                this.nextButton.setEnabled(false);
                this.finishButton.setEnabled(true);
            } else {
                this.finishButton.setEnabled(false);
                this.nextButton.setEnabled(true);
            }
            this.getCurrentPanel().update();
            PropertyChangeEvent event = new PropertyChangeEvent(this, "currentPanel", null, this.getCurrentPanel());
            this.propertyChangeListeners.firePropertyChange(event);
        }
        catch (Exception ex) {
            LOGGER.warn("Update components on panel failed.", (Throwable)ex);
        }
    }

    @Override
    public List<JWizardPanel> getWizardPanelList() {
        return this.panelList;
    }

    @Override
    public void setWizardPanelList(List<JWizardPanel> panelList) {
        this.panelList.clear();
        this.panelList.addAll(panelList);
    }

    @Override
    public FinishAction getFinishAction() {
        return this.finishAction;
    }

    @Override
    public void setFinishAction(FinishAction aFinishAction) {
        this.finishAction = aFinishAction;
    }

    @Override
    public CancelAction getCancelAction() {
        return this.cancelAction;
    }

    @Override
    public void setCancelAction(CancelAction aCancelAction) {
        this.cancelAction = aCancelAction;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public void setCurrentIndex(int aCurrentIndex) {
        this.currentIndex = aCurrentIndex;
    }

    @Override
    public JPanel getWizardPanelsContainer() {
        return this.wizardPanelsContainer;
    }

    @Override
    public void setWizardPanelsContainer(JPanel aWizardPanelsContainer) {
        this.wizardPanelsContainer = aWizardPanelsContainer;
    }

    @Override
    public JButton getBackButton() {
        return this.backButton;
    }

    @Override
    public void setBackButton(JButton aBackButton) {
        this.backButton = aBackButton;
    }

    @Override
    public JButton getNextButton() {
        return this.nextButton;
    }

    @Override
    public void setNextButton(JButton aNextButton) {
        this.nextButton = aNextButton;
    }

    @Override
    public JButton getCancelButton() {
        return this.cancelButton;
    }

    @Override
    public void setCancelButton(JButton aCancelButton) {
        this.cancelButton = aCancelButton;
    }

    @Override
    public JButton getFinishButton() {
        return this.finishButton;
    }

    @Override
    public void setFinishButton(JButton button) {
        this.finishButton = button;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.removePropertyChangeListener(listener);
    }
}

